/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.calc;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.utils.AcaThirdDataGenHelper;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CalcResultListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(CalcResultListPlugin.class);
    private static final String DEL_OPTION = "deleteThirdData";
    private static final String INSERT_CALRESULT_ENTRY_SQL = "INSERT INTO t_aca_calcresultentry (FId,FEntryId,fseq,ftype,frelacostobjectid,frelaproducttype,fpdstartqty,fpdcurrqty,fpdsumqty,fyearpdsumqty,fpdendqty,fcurrcomqty,fsumcomqty,fyearsumcomqty) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "btn_thirdgen": {
                List<Long> ids = this.getSelectIds();
                if (ids.isEmpty() || ids.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u9700\u8981\u751f\u6210\u7b2c3\u9875\u7b7e\u7684\u884c\u6570\u636e\u3002", (String)"CalcResultListPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    return;
                }
                Set<String> orgSet = this.getOrgCostAccountPeriodData(ids);
                for (String orgStr : orgSet) {
                    Long periodId;
                    Long costaccountId;
                    String[] arr = orgStr.split("@");
                    Long orgId = Long.valueOf(arr[0]);
                    if (this.existsThirdData(orgId, costaccountId = Long.valueOf(arr[1]), periodId = Long.valueOf(arr[2]))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6838\u7b97\u7ec4\u7ec7+\u6210\u672c\u8d26\u7c3f+\u671f\u95f4\u201d\u5df2\u751f\u6210\u7b2c3\u9875\u7b7e\u6570\u636e\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210\u3002", (String)"CalcResultListPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    try {
                        AcaThirdDataGenHelper.genThirdData((Long)orgId, (Long)costaccountId, (Long)periodId);
                    }
                    catch (Exception ex) {
                        logger.error("\u751f\u6210\u7b2c3\u9875\u7b7e\u5931\u8d25", (Throwable)ex);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff01", (String)"CalcResultListPlugin_2", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"CalcResultListPlugin_3", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                break;
            }
            case "btn_thirddel": {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(DEL_OPTION, (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u5bf9\u5e94\u671f\u95f4\u8ba1\u7b97\u7ed3\u679c\u5355\u7684\u7b2c3\u4e2a\u9875\u7b7e\u6570\u636e\u5417\uff1f", (String)"CalcResultListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                break;
            }
            case "btn_updjoinproduct": {
                int lines = this.updateJointProductComLine();
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff0c\u6210\u529f\u751f\u6210%s\u6761\u8bb0\u5f55\u3002", (String)"CalcResultListPlugin_7", (String)"macc-aca-formplugin", (Object[])new Object[0]), lines));
            }
        }
    }

    private int updateJointProductComLine() {
        int lines = 0;
        DataSet ds = QueryServiceHelper.queryDataSet((String)"aca_calcresult", (String)"aca_calcresult", (String)"org,costaccount,period", null, null).distinct();
        ds = ds.groupBy(new String[]{"org", "costaccount"}).max("period").finish();
        for (Row row : ds) {
            Date periodBeginDate;
            Long prePeriodId;
            Long orgId = row.getLong("org");
            Long costaccountId = row.getLong("costaccount");
            Long periodId = row.getLong("period");
            DynamicObject dynCurrentPeriod = PeriodHelper.getCurrentPeriod((Long)costaccountId);
            if (dynCurrentPeriod != null) {
                periodId = dynCurrentPeriod.getLong("id");
            }
            if (CadEmptyUtils.isEmpty((Long)periodId) || CadEmptyUtils.isEmpty((Long)(prePeriodId = kd.macc.aca.algox.utils.PeriodHelper.getPrePeriodId((Object)periodId)))) continue;
            QFilter filter = new QFilter("org", "=", (Object)orgId);
            filter.and("costaccount", "=", (Object)costaccountId);
            filter.and("period", "=", (Object)prePeriodId);
            filter.and("costobject.productgroup", ">", (Object)0L);
            DataSet lastCostobjectDs = QueryServiceHelper.queryDataSet((String)"Calcresult", (String)"aca_calcresult", (String)"id,costobject,costobject.srcbillnumber orderno,costobject.productgroup productgroup", (QFilter[])filter.toArray(), null);
            HashSet costobjectIds = Sets.newHashSetWithExpectedSize((int)16);
            HashSet productgroupIds = Sets.newHashSetWithExpectedSize((int)16);
            HashSet orderNos = Sets.newHashSetWithExpectedSize((int)16);
            DataSet lastCostobjectCopyDs = lastCostobjectDs.copy();
            for (Row coRow : lastCostobjectCopyDs) {
                costobjectIds.add(coRow.getLong("costobject"));
                productgroupIds.add(coRow.getLong("productgroup"));
                orderNos.add(coRow.getString("orderno"));
            }
            if (costobjectIds.isEmpty()) continue;
            QFilter qFilter = new QFilter("org", "=", (Object)orgId);
            qFilter.and("costaccount", "=", (Object)costaccountId);
            qFilter.and("period", "=", (Object)prePeriodId);
            qFilter.and("costobject", "in", (Object)costobjectIds);
            qFilter.and("entryentity.relaproducttype", "in", (Object)new String[]{"A", "B"});
            if (QueryServiceHelper.exists((String)"aca_calcresult", (QFilter[])qFilter.toArray())) continue;
            QFilter relaFilter = new QFilter("org", "=", (Object)orgId);
            relaFilter.and("productgroup", "in", (Object)productgroupIds);
            relaFilter.and("srcbillnumber", "in", (Object)orderNos);
            relaFilter.and("producttype", "in", (Object)new String[]{"A", "B"});
            DataSet relaCostobjectDs = QueryServiceHelper.queryDataSet((String)"Calcresult", (String)"cad_costobject", (String)"id costobject,srcbillnumber,productgroup,producttype,material,bomversion,auxpty", (QFilter[])relaFilter.toArray(), null);
            relaCostobjectDs = lastCostobjectDs.join(relaCostobjectDs).on("productgroup", "productgroup").on("orderno", "srcbillnumber").select(new String[]{"id", "costobject maincostobject"}, new String[]{"costobject", "producttype", "material", "bomversion", "auxpty"}).finish();
            HashSet relaCostobjectIds = Sets.newHashSetWithExpectedSize((int)16);
            DataSet relaCostobjectCopyDs = relaCostobjectDs.copy();
            for (Row sideRow : relaCostobjectCopyDs) {
                relaCostobjectIds.add(sideRow.getLong("costobject"));
            }
            if (relaCostobjectIds.isEmpty() || (periodBeginDate = kd.macc.aca.algox.utils.PeriodHelper.getPeriodBeginDate((Long)periodId)) == null) continue;
            QFilter planFilter = new QFilter("appnum", "=", (Object)"aca");
            planFilter.and("bizdate", "<", (Object)periodBeginDate);
            planFilter.and("billstatus", "=", (Object)"C");
            planFilter.and("accountorg", "=", (Object)orgId);
            planFilter.and("costobject", "in", (Object)relaCostobjectIds);
            DataSet planDs = QueryServiceHelper.queryDataSet((String)"plannedoutputbill", (String)"cad_plannedoutputbill", (String)"billno,costobject,qty planQty,0 finQty", (QFilter[])planFilter.toArray(), null);
            QFilter factFilter = new QFilter("appnum", "=", (Object)"aca");
            factFilter.and("bookdate", "<", (Object)periodBeginDate);
            factFilter.and("billstatus", "=", (Object)"C");
            factFilter.and("org", "=", (Object)orgId);
            factFilter.and("entryentity.costobject", "in", (Object)relaCostobjectIds);
            DataSet factDs = QueryServiceHelper.queryDataSet((String)"factnedoutputbill", (String)"cad_factnedoutputbill", (String)"billno,entryentity.costobject as costobject,0 planQty,entryentity.qty finQty", (QFilter[])factFilter.toArray(), null);
            DataSet resultDs = planDs.union(factDs);
            resultDs = resultDs.groupBy(new String[]{"costobject"}).sum("planQty").sum("finQty").finish();
            if ((resultDs = relaCostobjectDs.join(resultDs).on("costobject", "costobject").select(relaCostobjectDs.getRowMeta().getFieldNames(), new String[]{"planQty", "finQty"}).finish()).isEmpty()) continue;
            ArrayList<Object[]> entrys = new ArrayList<Object[]>();
            for (Row newRow : resultDs) {
                BigDecimal planQty = BigDecimalUtil.getOrZero((Object)newRow.getBigDecimal("planQty"));
                BigDecimal finQty = BigDecimalUtil.getOrZero((Object)newRow.getBigDecimal("finQty"));
                BigDecimal endQty = planQty.subtract(finQty);
                Object[] entry = new Object[]{newRow.getLong("id"), ID.genLongId(), 777, "finalResult", newRow.getLong("costobject"), newRow.getString("producttype"), BigDecimal.ZERO, planQty, planQty, planQty, endQty, finQty, finQty, finQty};
                entrys.add(entry);
                ++lines;
            }
            if (CollectionUtils.isEmpty(entrys)) continue;
            this.executeBatch(entrys);
        }
        return lines;
    }

    private void executeBatch(List<Object[]> entrys) {
        DB.executeBatch((DBRoute)DBRoute.of((String)"cal"), (String)INSERT_CALRESULT_ENTRY_SQL, entrys);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes && StringUtils.equals((CharSequence)DEL_OPTION, (CharSequence)e.getCallBackId())) {
            this.delCalResultConventry();
        }
    }

    private boolean delCalResultConventry() {
        List<Long> ids = this.getSelectIds();
        if (ids.isEmpty() || ids.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u9700\u8981\u5220\u9664\u7b2c3\u9875\u7b7e\u7684\u884c\u6570\u636e\u3002", (String)"CalcResultListPlugin_5", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return false;
        }
        Set<String> orgSet = this.getOrgCostAccountPeriodData(ids);
        for (String orgStr : orgSet) {
            Long periodId;
            Long costaccountId;
            String[] arr = orgStr.split("@");
            Long orgId = Long.valueOf(arr[0]);
            List<Long> thirdDataIds = this.getThirdDataIds(orgId, costaccountId = Long.valueOf(arr[1]), periodId = Long.valueOf(arr[2]));
            if (!CollectionUtils.isEmpty(thirdDataIds)) {
                this.doExecute(thirdDataIds);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\uff01", (String)"CalcResultListPlugin_3", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                continue;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u53ef\u4ee5\u5220\u9664\u3002", (String)"CalcResultListPlugin_6", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        }
        return true;
    }

    private void doExecute(List<Long> thirdDataIds) {
        DB.execute((DBRoute)DBRoute.of((String)"cal"), (String)("delete from t_aca_calcresultconventry where fid in " + CalcResultListPlugin.setToSql(thirdDataIds)));
    }

    private List<Long> getThirdDataIds(Long orgId, Long costaccountId, Long periodId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costaccountId);
        filter.and("period", "=", (Object)periodId);
        filter.and("convsubmatentryentity.id", ">=", (Object)0L);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"aca_calcresult", (String)"aca_calcresult", (String)"id", (QFilter[])filter.toArray(), null).distinct();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Row row : ds) {
            ids.add(row.getLong("id"));
        }
        return ids;
    }

    private boolean existsThirdData(Long orgId, Long costaccountId, Long periodId) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costaccount", "=", (Object)costaccountId);
        filter.and("period", "=", (Object)periodId);
        filter.and("convsubmatentryentity.id", ">=", (Object)0L);
        return QueryServiceHelper.exists((String)"aca_calcresult", (QFilter[])filter.toArray());
    }

    private Set<String> getOrgCostAccountPeriodData(List<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"aca_calcresult", (String)"aca_calcresult", (String)"org,costaccount,period", (QFilter[])filter.toArray(), null).distinct();
        HashSet orgSet = Sets.newHashSet();
        for (Row row : ds) {
            String key = String.format("%s@%s@%s", row.getLong("org"), row.getLong("costaccount"), row.getLong("period"));
            orgSet.add(key);
        }
        return orgSet;
    }

    protected List<Long> getSelectIds() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        ArrayList<Long> ids = new ArrayList<Long>(rows.size());
        for (int i = 0; i < rows.size(); ++i) {
            Long id = (Long)rows.get(i).getPrimaryKeyValue();
            if (ids.contains(id)) continue;
            ids.add(id);
        }
        return ids;
    }

    public static String setToSql(Collection<Long> ids) {
        StringBuilder sql = new StringBuilder();
        sql.append('(');
        for (Long id : ids) {
            sql.append(id).append(',');
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(')');
        return sql.toString();
    }
}

