/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.calc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.aca.formplugin.base.BaseOrgAndCostAccountListPlugin;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class EwipEnterList
extends BaseOrgAndCostAccountListPlugin {
    private static final String COSTACCOUNT = "costaccount";
    private static final String PERIOD = "period";
    private static final String ORG_FIELD = "org";

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("costcenter.number ASC, billno ASC");
    }

    @Override
    protected List<ComboItem> getCostAccountComboItemListBy(List<Object> orgId) {
        DynamicObjectCollection ccs;
        QFilter filter = null;
        if (!CadEmptyUtils.isEmpty(orgId)) {
            ArrayList lOrgIds = new ArrayList();
            orgId.forEach(id -> lOrgIds.add(Long.valueOf(id.toString())));
            filter = new QFilter("calorg", "in", lOrgIds);
        } else {
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            filter = new QFilter("calorg", "in", (Object)orgIds);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(orgId)) {
            filter.and("id", "not in", this.getCostAccountNotCurrentAppId(Long.valueOf(orgId.get(0).toString())));
        }
        if (CollectionUtils.isEmpty((Collection)(ccs = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,name", (QFilter[])new QFilter[]{filter, statusFilter, enableFilter}, (String)"ismainaccount desc,number asc")))) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ccs.forEach(cc -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(cc.getString("name")));
            item.setValue(cc.getString("id"));
            if (!acctItems.contains(item)) {
                acctItems.add(item);
            }
        });
        return acctItems;
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName = args.getFieldName();
        if (fieldName.startsWith(COSTACCOUNT)) {
            List<Object> orgCache = this.getOrgCache();
            if (!CadEmptyUtils.isEmpty(orgCache)) {
                List costAccountIds;
                long orgId = Long.parseLong(String.valueOf(orgCache.get(0)));
                QFilter filter = new QFilter("calorg", "=", (Object)orgId);
                QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                QFilter statusFilter = new QFilter("status", "=", (Object)"C");
                if (!CadEmptyUtils.isEmpty((Long)orgId)) {
                    filter.and("id", "not in", this.getCostAccountNotCurrentAppId(orgId));
                }
                if (!CadEmptyUtils.isEmpty((List)(costAccountIds = QueryServiceHelper.queryPrimaryKeys((String)"cal_bd_costaccount", (QFilter[])new QFilter[]{filter, statusFilter, enableFilter}, null, (int)-1)))) {
                    QFilter idQFilter = new QFilter("id", "in", (Object)costAccountIds);
                    args.getQfilters().add(idQFilter);
                }
            }
        } else if (fieldName.startsWith(PERIOD)) {
            String costAccoutId = this.getPageCache().get(COSTACCOUNT);
            if (!CadEmptyUtils.isEmpty((String)costAccoutId)) {
                DynamicObject sysCtrlEntity = this.getPeriodSetDynamicObject(Long.valueOf(costAccoutId));
                if (sysCtrlEntity != null) {
                    Long startPeriod = sysCtrlEntity.getLong("startperiod");
                    QFilter idQf = new QFilter("id", ">=", (Object)startPeriod);
                    idQf.and("periodtype", "=", (Object)sysCtrlEntity.getLong("periodtype"));
                    args.getQfilters().add(new QFilter("isadjustperiod", "=", (Object)false));
                    args.getQfilters().add(idQf);
                }
            } else {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            }
        }
    }

    private List<Long> getCostAccountNotCurrentAppId(Long orgId) {
        ArrayList<Long> costAccountId = new ArrayList<Long>(10);
        QFilter orgFilter = new QFilter(ORG_FIELD, "=", (Object)orgId);
        QFilter useFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        useFilter.or(new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE));
        DynamicObjectCollection startStdCosts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"appnum,entryentity.costaccount costaccount", (QFilter[])new QFilter[]{orgFilter, useFilter});
        String appId = this.getView().getFormShowParameter().getAppId();
        for (DynamicObject startStdCost : startStdCosts) {
            if (appId == null || appId.equals(startStdCost.getString("appnum"))) continue;
            costAccountId.add(startStdCost.getLong(COSTACCOUNT));
        }
        return costAccountId;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemkey = evt.getItemKey();
        if ("tblnew".equals(itemkey)) {
            List orgList;
            String orgId = this.getPageCache().get(ORG_FIELD);
            if (!StringUtils.isEmpty((Object)orgId) && !CadEmptyUtils.isEmpty((List)(orgList = (List)SerializationUtils.fromJsonString((String)orgId, List.class)))) {
                orgId = (String)orgList.get(0);
            }
            if (StringUtils.isEmpty((Object)orgId) || "0".equals(orgId) || !OrgUnitServiceHelper.checkOrgFunction((Long)Long.parseLong(orgId), (String)"10")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u9009\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"EwipEnterList_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().setCustomParam("costaccountId", (Object)this.getPageCache().get(COSTACCOUNT));
        e.getParameter().setCustomParam(PERIOD, (Object)this.getPageCache().get(PERIOD));
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "exportlist": {
                break;
            }
            case "exportlist_expt": {
                break;
            }
            case "exportlistbyselectfields": {
                break;
            }
            case "exportdetails": {
                break;
            }
            case "refresh": {
                break;
            }
            case "close": {
                break;
            }
            case "modify": {
                break;
            }
            case "new": {
                String costAccountId = this.getPageCache().get(COSTACCOUNT);
                if (!CadEmptyUtils.isEmpty((String)costAccountId)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"EwipEnterList_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            default: {
                this.checkCostAccountInit(args);
            }
        }
    }

    private void checkCostAccountInit(BeforeDoOperationEventArgs args) {
        String orgId = this.getPageCache().get(ORG_FIELD);
        String costAccountId = this.getPageCache().get(COSTACCOUNT);
        if (CadEmptyUtils.isEmpty((String)orgId) || CadEmptyUtils.isEmpty((String)costAccountId)) {
            return;
        }
    }
}

