/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.calc;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.common.constants.WipInitSubItem;
import kd.macc.cad.common.constants.DutyIdConstants;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.helper.ElementHelper;
import kd.macc.cad.common.helper.ElementRelationHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.MatHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class EwipEnterPlugin
extends AbstractBillPlugIn
implements RowClickEventListener {
    private static final String MATTYPE = "001";
    private static final String MATCOST = "002";
    private static final List<String> CAN_EDIT_SUB_ENTRY_ENTITY_TYPES = new ArrayList<String>(10){
        {
            this.add(EwipEnterPlugin.MATTYPE);
            this.add(EwipEnterPlugin.MATCOST);
        }
    };

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid subentryentity = (EntryGrid)this.getView().getControl("subentryentity");
        subentryentity.addRowClickListener((RowClickEventListener)this);
        BasedataEdit manuOrgEdit = (BasedataEdit)this.getControl("manuorg");
        manuOrgEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org != null) {
                ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter filterParameter = param.getListFilterParameter();
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                List manuOrgIds = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                filters.add(new QFilter("id", "in", (Object)manuOrgIds));
                filterParameter.setQFilters(filters);
            }
        });
        BasedataEdit costAccountEdit = (BasedataEdit)this.getControl("costaccount");
        costAccountEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            Object orgId = this.getModel().getDataEntity().getDynamicObject("org").getPkValue();
            String curAppNum = AppIdHelper.getCurAppNum((IFormView)this.getView());
            QFilter costAccountIdFilter = StartCostHelper.getEnableQfilterByOrg((Long)((Long)orgId), null, (String)curAppNum);
            filterParameter.getQFilters().add(costAccountIdFilter);
        });
        BasedataEdit costCenterEdit = (BasedataEdit)this.getControl("costcenter");
        costCenterEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject acctOrg = this.getModel().getDataEntity().getDynamicObject("org");
            if (acctOrg != null) {
                filters.add(new QFilter("accountorg", "=", acctOrg.getPkValue()));
            }
            filters.add(new QFilter("orgduty", "=", (Object)DutyIdConstants.BASIC_PRODUCT_ID));
            filterParameter.setQFilters(filters);
        });
        BasedataEdit costObjectEdit = (BasedataEdit)this.getControl("costobject");
        costObjectEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject costCenter = this.getModel().getDataEntity().getDynamicObject("costcenter");
            if (costCenter == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u6210\u672c\u4e2d\u5fc3\u3002", (String)"EwipEnterPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject acctOrg = this.getModel().getDataEntity().getDynamicObject("org");
            if (acctOrg != null) {
                filters.add(new QFilter("org", "=", acctOrg.getPkValue()));
            }
            filters.add(new QFilter("costcenter", "=", costCenter.getPkValue()));
            filters.add(new QFilter("producttype", "=", (Object)"C"));
            filterParameter.setQFilters(filters);
        });
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener(evt -> {
            DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"EwipEnterPlugin_2", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)costAccountObj.getLong("id")));
            qFilters.add(new QFilter("isadjustperiod", "=", (Object)false));
        });
        Set<Long> selectedSubElementIds = this.getSelectedSubElementIds();
        DynamicObject costobjectDyn = this.getModel().getDataEntity().getDynamicObject("costobject");
        if (costobjectDyn != null && costobjectDyn.getBoolean("isoutsource")) {
            selectedSubElementIds.clear();
        }
        ElementHelper.elementAndSubEleF7Setting((IDataModel)this.getModel(), (AbstractBillPlugIn)this, selectedSubElementIds);
        this.subMatVersionF7Setting();
    }

    private Set<Long> getSelectedSubElementIds() {
        HashSet<Long> selectedSubElementIds = new HashSet<Long>(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int index = 0; index < entryEntity.size(); ++index) {
            DynamicObject rowObject = (DynamicObject)entryEntity.get(index);
            DynamicObject subElement = rowObject.getDynamicObject("subelement");
            if (subElement == null) continue;
            selectedSubElementIds.add((Long)subElement.getPkValue());
        }
        return selectedSubElementIds;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            if (OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"))) {
                BasedataEdit manuOrg = (BasedataEdit)this.getControl("manuorg");
                manuOrg.setMustInput(true);
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"manuorg"});
            }
        }
        CurrencyHelper.setCurrency((IDataModel)this.getModel(), (IFormView)this.getView());
        this.setCostAccountFromList();
        this.setProductDetailInfo();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"initamt"});
        this.changManuorgStatus();
        this.changeSonEntryEnable();
    }

    private void updateSubItemInfo(boolean isUpdateAmt) {
        int subIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
        if (this.getPageCache().get("subIndex") != null) {
            subIndex = Integer.parseInt(this.getPageCache().get("subIndex"));
        }
        DynamicObjectCollection subEntrys = this.getModel().getEntryEntity("subentryentity");
        DynamicObject subObj = (DynamicObject)subEntrys.get(subIndex);
        BigDecimal totalAmt = BigDecimal.ZERO;
        subEntrys.beginInit();
        if (isUpdateAmt) {
            subObj.set("subamount", (Object)totalAmt);
        }
        subEntrys.endInit();
        this.getView().updateView("subentryentity");
    }

    private void calcWipInitSubItemAmt(List<WipInitSubItem> subitems, String propertyName, BigDecimal adjAmt) {
        if (adjAmt == null) {
            adjAmt = BigDecimal.ZERO;
        }
        if (subitems.size() == 1) {
            this.setSubitemRadio(subitems, BigDecimal.ONE);
        } else if (adjAmt.compareTo(BigDecimal.ZERO) == 0) {
            this.setSubitemRadio(subitems, BigDecimal.ZERO);
        } else {
            BigDecimal dAmt;
            BigDecimal totalAmt = BigDecimal.ZERO;
            BigDecimal absMaxAmt = null;
            for (WipInitSubItem subitem : subitems) {
                dAmt = null;
                dAmt = "subamount".equals(propertyName) ? subitem.getSamount() : ("matyearinputamt".equals(propertyName) ? subitem.getSyearinamt() : subitem.getSyearcomamt());
                totalAmt = totalAmt.add(dAmt);
                if (absMaxAmt != null && dAmt.abs().compareTo(absMaxAmt) <= 0) continue;
                absMaxAmt = dAmt;
            }
            if (totalAmt.compareTo(BigDecimal.ZERO) == 0) {
                totalAmt = absMaxAmt;
            }
            if (totalAmt == null || totalAmt.compareTo(BigDecimal.ZERO) == 0) {
                BigDecimal radio = BigDecimal.ONE.divide(new BigDecimal(subitems.size()), 10, RoundingMode.HALF_UP);
                this.setSubitemRadio(subitems, radio);
            } else {
                for (WipInitSubItem subitem : subitems) {
                    dAmt = null;
                    dAmt = "subamount".equals(propertyName) ? subitem.getSamount() : ("matyearinputamt".equals(propertyName) ? subitem.getSyearinamt() : subitem.getSyearcomamt());
                    subitem.setRadio(dAmt.divide(totalAmt, 10, RoundingMode.HALF_UP));
                }
            }
        }
        BigDecimal diffAmt = adjAmt;
        WipInitSubItem maxSubItem = null;
        int precise = this.getCurrencyPrecision();
        for (WipInitSubItem subitem : subitems) {
            if (maxSubItem == null || maxSubItem.getRadio().compareTo(subitem.getRadio()) < 0) {
                maxSubItem = subitem;
            }
            if ("subamount".equals(propertyName)) {
                subitem.setSamount(subitem.getRadio().multiply(adjAmt).setScale(precise, RoundingMode.HALF_UP));
                diffAmt = diffAmt.subtract(subitem.getSamount());
                continue;
            }
            if ("matyearinputamt".equals(propertyName)) {
                subitem.setSyearinamt(subitem.getRadio().multiply(adjAmt).setScale(precise, RoundingMode.HALF_UP));
                diffAmt = diffAmt.subtract(subitem.getSyearinamt());
                continue;
            }
            subitem.setSyearcomamt(subitem.getRadio().multiply(adjAmt).setScale(precise, RoundingMode.HALF_UP));
            diffAmt = diffAmt.subtract(subitem.getSyearcomamt());
        }
        if (diffAmt.compareTo(BigDecimal.ZERO) != 0 && maxSubItem != null) {
            if ("subamount".equals(propertyName)) {
                maxSubItem.setSamount(maxSubItem.getSamount().add(diffAmt));
            } else if ("matyearinputamt".equals(propertyName)) {
                maxSubItem.setSyearinamt(maxSubItem.getSamount().add(diffAmt));
            } else {
                maxSubItem.setSyearcomamt(maxSubItem.getSamount().add(diffAmt));
            }
        }
    }

    private void setSubitemRadio(List<WipInitSubItem> subitems, BigDecimal radio) {
        for (WipInitSubItem subitem : subitems) {
            subitem.setRadio(radio);
        }
    }

    private int getCurrencyPrecision() {
        DynamicObject currency = this.getModel().getDataEntity().getDynamicObject("currency");
        if (currency == null) {
            return 2;
        }
        return currency.getInt("amtprecision");
    }

    private void setCostAccountFromList() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String costAccountId = (String)fsp.getCustomParam("costaccountId");
        String periodId = (String)fsp.getCustomParam("period");
        if (!CadEmptyUtils.isEmpty((String)costAccountId)) {
            this.getModel().setValue("costaccount", (Object)costAccountId);
        }
        if (!CadEmptyUtils.isEmpty((String)periodId)) {
            this.getModel().setValue("period", (Object)periodId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (propertyName) {
            case "costaccount": {
                CurrencyHelper.setCurrency((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "period": {
                CurrencyHelper.setCurrency((IDataModel)this.getModel(), (IFormView)this.getView());
                break;
            }
            case "element": {
                this.getModel().beginInit();
                this.setDefaultSubElement(changeSet[0]);
                this.getModel().endInit();
                this.clearSubEntryEntity(changeSet[0]);
                this.getView().updateView("entryentity");
                break;
            }
            case "subelement": {
                this.getModel().beginInit();
                ElementHelper.setElement((PropertyChangedArgs)e, (IFormView)this.getView());
                this.getModel().endInit();
                this.getView().updateView("entryentity");
                break;
            }
            case "submateriel": {
                this.setSubBaseUnit(changeSet[0]);
                this.changeSonEntryEnable(rowIndex);
                if (this.getPageCache().get("isFromSubMatVersionChanged") != null) {
                    return;
                }
                this.clearSubMatVersion();
                break;
            }
            case "submatversion": {
                this.setSubMat();
                break;
            }
            case "costobject": {
                this.setProductDetailInfo();
                break;
            }
            case "org": {
                this.changManuorgStatus();
                break;
            }
            case "ssubelement": {
                DynamicObject subEle = (DynamicObject)this.getView().getModel().getValue("ssubelement", rowIndex);
                if (subEle == null) {
                    return;
                }
                long subElementId = subEle.getLong("id");
                QFilter qfSubElement = new QFilter("subelement", "=", (Object)subElementId);
                DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{qfSubElement});
                if (dySubElement != null) {
                    this.getView().getModel().setValue("selement", (Object)dySubElement.getLong("element"), rowIndex);
                }
                this.updateSubItemInfo(false);
                break;
            }
            case "samount": 
            case "syearinamt": 
            case "syearcomamt": {
                this.updateSubItemInfo(true);
                break;
            }
            case "subamount": {
                this.setAfterSubAmount(rowIndex);
                break;
            }
        }
    }

    private void setAfterSubAmount(int index) {
        DynamicObjectCollection subentryentity;
        int entryindex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        DynamicObject entryObj = (DynamicObject)entrys.get(entryindex);
        if (entryObj != null && !CadEmptyUtils.isEmpty((DynamicObjectCollection)(subentryentity = entryObj.getDynamicObjectCollection("subentryentity")))) {
            BigDecimal totalAmt = BigDecimal.ZERO;
            for (DynamicObject dyn : subentryentity) {
                BigDecimal subamount = BigDecimalUtil.getOrZero((Object)dyn.getBigDecimal("subamount"));
                totalAmt = totalAmt.add(subamount);
            }
            this.getModel().setValue("amount", (Object)totalAmt, entryindex);
        }
    }

    private void setSubMat() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
        DynamicObject subMatVersionObj = (DynamicObject)this.getModel().getValue("submatversion", entryCurrentRowIndex);
        if (subMatVersionObj == null) {
            return;
        }
        DynamicObject material = subMatVersionObj.getDynamicObject("material");
        if (material == null) {
            return;
        }
        this.getPageCache().put("isFromSubMatVersionChanged", "true");
        this.getModel().setValue("submateriel", (Object)material, entryCurrentRowIndex);
        this.getPageCache().remove("isFromSubMatVersionChanged");
        this.getView().updateView("submateriel", entryCurrentRowIndex);
    }

    private void clearSubMatVersion() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
        this.getModel().beginInit();
        this.getModel().setValue("submatversion", null, entryCurrentRowIndex);
        this.getModel().endInit();
        this.getView().updateView("submatversion", entryCurrentRowIndex);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "close": {
                break;
            }
            default: {
                this.checkCostAccountInit(args);
            }
        }
        if ("save".equals(operateKey)) {
            this.setElementBySubElementForElementEmptyRow();
            return;
        }
        if ("newsubentry".equals(operateKey)) {
            this.disableEditSubEntry(args);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "newsubentry": {
                this.changeSonEntryEnable();
                break;
            }
            case "subitemdeleteentry": {
                this.updateSubItemInfo(true);
                break;
            }
            case "audit": {
                this.getView().invokeOperation("refresh", OperateOption.create());
                break;
            }
        }
    }

    private void checkCostAccountInit(BeforeDoOperationEventArgs args) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (CadEmptyUtils.isEmpty((DynamicObject)org) || CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
            return;
        }
    }

    private void disableEditSubEntry(BeforeDoOperationEventArgs args) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
        DynamicObject subElement = entryRowEntity.getDynamicObject("subelement");
        if (subElement == null || subElement != null && !CAN_EDIT_SUB_ENTRY_ENTITY_TYPES.contains(subElement.getString("type"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u4fe1\u606f\u00b7\u6210\u672c\u5b50\u8981\u7d20\u4e0d\u662f\u7269\u6599\u6216\u8005\u7269\u6599\u8d39\u7528\u5c5e\u6027\uff0c\u4e0d\u80fd\u7f16\u8f91\u5b50\u7269\u6599\u4fe1\u606f\u3002", (String)"EwipEnterPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void setElementBySubElementForElementEmptyRow() {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        HashSet<Long> subElementIdsForElementEmptyRow = new HashSet<Long>(16);
        HashMap<Long, Integer> subElementIdAndRowIndexMap = new HashMap<Long, Integer>(16);
        for (DynamicObject row : entryEntity) {
            DynamicObject subElement = row.getDynamicObject("subelement");
            DynamicObject element = row.getDynamicObject("element");
            if (element != null || subElement == null) continue;
            Long subElementId = (Long)subElement.getPkValue();
            int rowIndex = row.getInt("seq");
            subElementIdsForElementEmptyRow.add(subElementId);
            subElementIdAndRowIndexMap.put(subElementId, rowIndex);
        }
        Map subElementIdAndElementIdMap = new HashMap(16);
        if (subElementIdsForElementEmptyRow.size() > 0) {
            subElementIdAndElementIdMap = ElementRelationHelper.getSubElementIdAndElementIdMap(subElementIdsForElementEmptyRow);
            for (Map.Entry entrySet : subElementIdAndRowIndexMap.entrySet()) {
                this.getModel().setValue("element", subElementIdAndElementIdMap.get(entrySet.getKey()), (Integer)entrySet.getValue() - 1);
            }
        }
    }

    private void setProductDetailInfo() {
        DynamicObject costObject = this.getModel().getDataEntity().getDynamicObject("costobject");
        if (CadEmptyUtils.isEmpty((DynamicObject)costObject)) {
            return;
        }
        DynamicObject material = costObject.getDynamicObject("material");
        Map matBaseUnit = MatHelper.getMatBaseUnit(Collections.singleton((Long)material.getPkValue()));
        if (matBaseUnit != null && matBaseUnit.size() > 0) {
            this.getModel().setValue("baseunit", matBaseUnit.get(material.getPkValue()));
        }
        this.getModel().setValue("auxpty", (Object)costObject.getLong("auxpty.id"));
        this.getModel().setValue("assignedproduct", (Object)material);
        this.getModel().setDataChanged(false);
    }

    private void setSubBaseUnit(ChangeData changeData) {
        DynamicObject row = changeData.getDataEntity();
        if (CadEmptyUtils.isEmpty((DynamicObject)row)) {
            return;
        }
        DynamicObject baseUnit = row.getDynamicObject("submateriel.baseunit");
        row.set("subbaseunit", (Object)baseUnit);
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
        this.getView().updateView("subbaseunit", entryCurrentRowIndex);
    }

    private void clearSubEntryEntity(ChangeData changeData) {
        String newValueType;
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
        if (newValue == null || oldValue == null) {
            return;
        }
        String oldValueType = oldValue.getString("type");
        if (!oldValueType.equals(newValueType = newValue.getString("type"))) {
            changeData.getDataEntity().getDynamicObjectCollection("subentryentity").clear();
            this.getView().updateView("subentryentity");
        }
    }

    private void setDefaultSubElement(ChangeData changeData) {
        DynamicObject row = changeData.getDataEntity();
        DynamicObject element = row.getDynamicObject("element");
        if (CadEmptyUtils.isEmpty((DynamicObject)element)) {
            return;
        }
        QFilter elementIdFilter = new QFilter("element", "=", element.getPkValue());
        DynamicObjectCollection defaultSubElement = ElementRelationHelper.getDefaultSubElement((QFilter)elementIdFilter);
        Set<Long> selectedSubElementIds = this.getSelectedSubElementIds();
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)defaultSubElement) || selectedSubElementIds.contains(((DynamicObject)defaultSubElement.get(0)).getLong("subElementId"))) {
            row.set("subelement", null);
            return;
        }
        int rowIndex = changeData.getRowIndex();
        this.getModel().setValue("subelement", ((DynamicObject)defaultSubElement.get(0)).get("subElementId"), rowIndex);
    }

    private void subMatVersionF7Setting() {
        BasedataEdit subMatVersionEdit = (BasedataEdit)this.getControl("submatversion");
        subMatVersionEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
            DynamicObject subMaterial = (DynamicObject)this.getModel().getValue("submateriel", entryCurrentRowIndex);
            if (subMaterial != null) {
                Object subMatId = subMaterial.getPkValue();
                QFilter subMatIdFilter = new QFilter("material", "=", subMatId);
                List versionIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_bomversion", (QFilter[])new QFilter[]{subMatIdFilter}, null, (int)-1);
                QFilter versionIdsFilter = new QFilter("id", "in", (Object)versionIds);
                filterParameter.getQFilters().add(versionIdsFilter);
            }
        });
    }

    private void changManuorgStatus() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)accountorg.getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if ("entryentity".equals(entryGrid.getEntryKey())) {
            this.changeSonEntryEnable();
        }
    }

    private void changeSonEntryEnable() {
        int rowCount = this.getModel().getEntryRowCount("subentryentity");
        if (rowCount >= 0) {
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject material = (DynamicObject)this.getModel().getValue("submateriel", i);
                Boolean isenablematerialversion = false;
                Boolean isuseauxptyFlag = false;
                if (material != null) {
                    isenablematerialversion = material.getBoolean("isenablematerialversion");
                    isuseauxptyFlag = material.getBoolean("isuseauxpty");
                }
                this.getView().setEnable(isenablematerialversion, i, new String[]{"submatversion"});
                this.getView().setEnable(isuseauxptyFlag, i, new String[]{"subauxpty"});
            }
        }
    }

    private void changeSonEntryEnable(int rowIndex) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("submateriel", rowIndex);
        Boolean isenablematerialversion = false;
        Boolean isuseauxptyFlag = false;
        if (material != null) {
            isenablematerialversion = material.getBoolean("isenablematerialversion");
            isuseauxptyFlag = material.getBoolean("isuseauxpty");
        }
        this.getView().setEnable(isenablematerialversion, rowIndex, new String[]{"submatversion"});
        this.getView().setEnable(isuseauxptyFlag, rowIndex, new String[]{"subauxpty"});
    }
}

