/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.calc;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.aca.algox.costtranfer.FinishCostTranFerImportHelper;
import kd.macc.aca.formplugin.base.BaseOrgAndCostAccountListPlugin;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class FinishCostTranFerListPlugin
extends BaseOrgAndCostAccountListPlugin {
    private static String CALLBACKKEY_DELETE = "callbackkey_delete";
    private static final Log logger = LogFactory.getLog(FinishCostTranFerListPlugin.class);
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List<Object> orgCache = this.getOrgCache();
        String org = "";
        if (!CadEmptyUtils.isEmpty(orgCache)) {
            org = (String)orgCache.get(0);
        }
        if (CadEmptyUtils.isEmpty((String)org) && AppIdHelper.isMacc((IFormView)this.getView())) {
            e.getQFilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "searchup": {
                boolean flag = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"cal", (String)"cal_costrecord_subentity", (String)"47150e89000000ac");
                if (!flag) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u201d\u7684\u201c\u67e5\u770b\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"FinishCostTranFerListPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    return;
                }
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection rows = billList.getSelectedRows();
                if (rows.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4e0a\u67e5\u7684\u5b8c\u5de5\u6210\u672c\u7ed3\u8f6c\u5355\u3002", (String)"FinishCostTranFerListPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    return;
                }
                Object[] primaryKeyValues = rows.getPrimaryKeyValues();
                DynamicObject[] load = BusinessDataServiceHelper.load((String)"aca_finishcosttranfer", (String)"sourcecalid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
                List<Object> sourcecalid = Arrays.stream(load).map(o -> o.getLong("sourcecalid")).collect(Collectors.toList());
                this.showSearchUpBillOrBillList("cal_costrecord_subentity", sourcecalid);
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        switch (evt.getOperateKey()) {
            case "importdatabyhand": {
                if (!evt.getOperationResult().isSuccess()) break;
                boolean flag = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"cal", (String)"cal_costrecord_subentity", (String)"47150e89000000ac");
                if (!flag) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u201d\u7684\u201c\u67e5\u770b\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"FinishCostTranFerListPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.importData(true);
                break;
            }
            case "generatevoucher": {
                if (evt.getOperationResult().isSuccess()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u51ed\u8bc1\u751f\u6210\u5931\u8d25\uff0c\u9519\u8bef\u8be6\u60c5\u8bf7\u67e5\u770b\u51ed\u8bc1\u751f\u6210\u62a5\u544a\u3002", (String)"FinishCostTranFerListPlugin_3", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void importData(boolean isCheckExists) {
        boolean exists;
        List<Object> orgCache = this.getOrgCache();
        String org = "";
        if (!CadEmptyUtils.isEmpty(orgCache)) {
            org = (String)orgCache.get(0);
        }
        String costaccount = this.getPageCache().get("costaccount");
        String period = this.getPageCache().get("period");
        if (CadEmptyUtils.isEmpty((String)costaccount) || CadEmptyUtils.isEmpty((String)period) || CadEmptyUtils.isEmpty((String)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u6216\u8005\u671f\u95f4\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u6210\u672c\u8d26\u7c3f\u548c\u671f\u95f4\u8fdb\u884c\u5f15\u5165\u64cd\u4f5c\u3002", (String)"FinishCostTranFerListPlugin_4", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return;
        }
        Long orgId = Long.valueOf(org);
        Long costaccountId = Long.valueOf(costaccount);
        Long periodId = Long.valueOf(period);
        if (isCheckExists && (exists = this.getIsHasImportData(costaccountId, periodId))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u91cd\u65b0\u5f15\u5165\u4f1a\u8986\u76d6\u5f53\u524d\u671f\u95f4\u4e0a\u6b21\u5f15\u5165\u6570\u636e\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u6267\u884c\u5f15\u5165\uff1f", (String)"FinishCostTranFerListPlugin_6", (String)"macc-aca-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(CALLBACKKEY_DELETE, (IFormPlugin)this));
            return;
        }
        try {
            StringBuilder infoMsg = new StringBuilder();
            FinishCostTranFerImportHelper.finishCostTranFerImport((Long)orgId, (Long)costaccountId, (Long)periodId, (StringBuilder)infoMsg);
            this.writeLog(infoMsg.toString());
            this.getView().invokeOperation("refresh");
            this.getView().showMessage(infoMsg.toString());
        }
        catch (Exception e) {
            logger.error("\u5b8c\u5de5\u5165\u5e93\u6210\u672c\u7ed3\u8f6c\u5355\u5f15\u5165\u5931\u8d25", (Throwable)e);
            this.writeLog(e.getMessage());
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002%s", (String)"FinishCostTranFerListPlugin_15", (String)"macc-aca-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private boolean getIsHasImportData(Long costaccountId, Long periodId) {
        QFilter filter = new QFilter("costaccount", "=", (Object)costaccountId);
        filter.and("period", "=", (Object)periodId);
        return QueryServiceHelper.exists((String)"aca_finishcosttranfer", (QFilter[])filter.toArray());
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("org")) {
            args.getQfilters().add(new QFilter("id", "in", (Object)ImportServiceHelper.getHasPermOrgIdsByOrgViewType((String)"10")));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        switch (callBackId) {
            case "callbackkey_delete": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                this.importData(false);
                break;
            }
        }
    }

    private void writeLog(String info) {
        String opType = ResManager.loadKDString((String)"\u5f15\u5165\u6570\u636e", (String)"FinishCostTranFerListPlugin_16", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)info, (String)"aca_finishcosttranfer", (String)this.getView().getFormShowParameter().getAppId());
    }

    private void showSearchUpBillOrBillList(String entityName, List<Object> ids) {
        IFormView view = this.getView();
        if (CadEmptyUtils.isEmpty(ids)) {
            return;
        }
        if (ids.size() == 1) {
            BillShowParameter bill = new BillShowParameter();
            bill.setFormId(entityName);
            OpenStyle style = new OpenStyle();
            style.setShowType(ShowType.MainNewTabPage);
            bill.setOpenStyle(style);
            bill.setPkId(ids.get(0));
            bill.setHasRight(true);
            bill.setBillStatus(BillOperationStatus.VIEW);
            view.showForm((FormShowParameter)bill);
        } else {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId(entityName);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setHasRight(true);
            ArrayList<String> orgIds = new ArrayList<String>();
            orgIds.add("");
            parameter.setCustomParam("useorgIdFilter", orgIds);
            parameter.setCustomParam("source", (Object)"CalHandleExpCostPlugin");
            String useOrg = this.getPageCache().get("org");
            if (useOrg != null) {
                List orgList = JSON.parseArray((String)useOrg, String.class);
                useOrg = (String)orgList.get(0);
            }
            parameter.setCustomParam("calorg", (Object)useOrg);
            parameter.setCustomParam("costaccount", (Object)this.getPageCache().get("costaccount"));
            QFilter qFilter = new QFilter("id", "in", ids);
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            listFilterParameter.setQFilters(Collections.singletonList(qFilter));
            parameter.setListFilterParameter(listFilterParameter);
            view.showForm((FormShowParameter)parameter);
        }
    }
}

