/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.calc;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.aca.algox.constants.TerminalCalcCheck;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.aca.algox.utils.TaskHelper;
import kd.macc.cad.common.enums.AcaMutexEnum;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.AcaMutexHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;

public class TerminalCalcEndEditPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(TerminalCalcEndEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"checkresult", "calcreport", "btncalcbill", "btncalcdetcomp"});
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initData(this.getView());
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "checkresult": {
                this.openCheckResultList();
                break;
            }
            case "calcreport": {
                this.openReportResult("calcReportId");
                break;
            }
            case "btncalcbill": {
                this.openRpt("aca_calcresultnew");
                break;
            }
            case "btncalcdetcomp": {
                this.openRpt("aca_finishstockcostrpt");
            }
        }
    }

    private void openCheckResultList() {
        BillShowParameter lsp = new BillShowParameter();
        lsp.setFormId("aca_calcreport");
        JSONObject custparamJs = new JSONObject();
        String checkResultId = this.getPageCache().get("checkResultId");
        if (CadEmptyUtils.isEmpty((String)checkResultId)) {
            return;
        }
        custparamJs.accumulate("checkResultId", (Object)checkResultId);
        lsp.setCustomParam("custparam", (Object)custparamJs.toString());
        lsp.setCaption(ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\u62a5\u544a", (String)"TerminalCalcEndEditPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void openReportResult(String key) {
        String custparam = (String)this.getView().getFormShowParameter().getCustomParam("calcrecordid");
        BillShowParameter lsp = new BillShowParameter();
        lsp.setFormId("aca_calcreport");
        lsp.setCustomParam("calcrecordid", (Object)custparam);
        lsp.setCaption(ResManager.loadKDString((String)"\u8ba1\u7b97\u62a5\u544a", (String)"TerminalCalcEndEditPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void openRpt(String formId) {
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filterInfo = queryParam.getFilter();
        String custparam = (String)this.getView().getFormShowParameter().getCustomParam("custparam");
        if (!CadEmptyUtils.isEmpty((String)custparam)) {
            JSONObject calcParamJs = JSONObject.fromObject((Object)custparam);
            if (calcParamJs.size() < 2) {
                return;
            }
            Long orgId = this.getOrgId(calcParamJs);
            if (CadEmptyUtils.isEmpty((Long)orgId)) {
                return;
            }
            if (!"aca_calcresultnew".equals(formId)) {
                filterInfo.addFilterItem("costaccount", (Object)calcParamJs.getLong("costAccountId"), "=");
                filterInfo.addFilterItem("period", (Object)calcParamJs.getLong("periodId"), "=");
                filterInfo.addFilterItem("fperiod", (Object)calcParamJs.getLong("periodId"), "=");
                if (calcParamJs.get("manuorgId") != null && calcParamJs.get("manuorgId") != JSONNull.getInstance() && calcParamJs.getLong("manuorgId") > 0L) {
                    filterInfo.addFilterItem("manuorg", (Object)calcParamJs.getLong("manuorgId"), "=");
                }
            }
        }
        showParameter.setCustomParam("custparam", (Object)custparam);
        if (!"aca_calcresultnew".equals(formId)) {
            showParameter.setQueryParam(queryParam);
        }
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void initData(IFormView view) {
        String srcCalcJsonStr;
        JSONObject calcSrcParamJs;
        String custparam = (String)view.getFormShowParameter().getCustomParam("custparam");
        if (CadEmptyUtils.isEmpty((String)custparam)) {
            return;
        }
        JSONObject calcParamJs = JSONObject.fromObject((Object)custparam);
        if (calcParamJs.size() < 2) {
            return;
        }
        Label labtime = (Label)this.getView().getControl("labtime");
        Label labTimeText = (Label)this.getView().getControl("labtimetext");
        Long time = calcParamJs.getLong("time");
        if (time < 60L) {
            labtime.setText(String.valueOf(time));
            labTimeText.setText(ResManager.loadKDString((String)"\u79d2", (String)"TerminalCalcEndEditPlugin_2", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        } else if (time >= 60L) {
            labtime.setText(String.valueOf(time / 60L));
            labTimeText.setText(ResManager.loadKDString((String)"\u5206\u949f", (String)"TerminalCalcEndEditPlugin_3", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        } else {
            labtime.setText(String.valueOf(time / 3600L));
            labTimeText.setText(ResManager.loadKDString((String)"\u5c0f\u65f6", (String)"TerminalCalcEndEditPlugin_4", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        }
        int checkFailCount = calcParamJs.getInt("checkFailCount");
        int successCcCount = calcParamJs.getInt("successCcCount");
        if (checkFailCount == 0 && successCcCount > 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"panelfail"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"panelsuccess"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"panelfail"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"panelsuccess"});
            Label labfail = (Label)this.getView().getControl("labfail");
            if (checkFailCount > 0) {
                labfail.setText(ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c\u8bf7\u67e5\u770b\u5408\u6cd5\u6027\u68c0\u67e5\u62a5\u544a\u3002", (String)"TerminalCalcEndEditPlugin_5", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            } else {
                labfail.setText(ResManager.loadKDString((String)"\u8ba1\u7b97\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u8ba1\u7b97\u62a5\u544a\u3002", (String)"TerminalCalcEndEditPlugin_6", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            }
        }
        Long orgId = this.getOrgId(calcParamJs);
        this.getModel().setValue("org", (Object)orgId);
        this.getModel().setValue("period", (Object)calcParamJs.getLong("periodId"));
        this.getModel().setValue("costaccount", (Object)calcParamJs.getLong("costAccountId"));
        if (calcParamJs.containsKey((Object)"calSchemeId")) {
            this.getModel().setValue("calscheme", (Object)calcParamJs.getLong("calSchemeId"));
        }
        this.getPageCache().put("checkResultId", calcParamJs.getString("checkResultId"));
        this.getPageCache().put("calcReportId", calcParamJs.getString("calcReportId"));
        if (checkFailCount == 0 && successCcCount > 0 && calcParamJs.containsKey((Object)"srcCalcJsonStr") && (calcSrcParamJs = JSONObject.fromObject((Object)(srcCalcJsonStr = calcParamJs.getString("srcCalcJsonStr")))).containsKey((Object)"calcsize") && calcSrcParamJs.getInt("calcsize") > 1) {
            int currCalcIndex;
            int calcsize = calcSrcParamJs.getInt("calcsize");
            int n = currCalcIndex = calcSrcParamJs.containsKey((Object)"currCalcIndex") ? calcSrcParamJs.getInt("currCalcIndex") : 1;
            if (currCalcIndex < calcsize) {
                calcSrcParamJs.remove("currCalcIndex");
                calcSrcParamJs.remove("taskRecordId");
                calcSrcParamJs.remove("calcReportId");
                calcSrcParamJs.remove("appNum");
                calcSrcParamJs.accumulate("currCalcIndex", currCalcIndex + 1);
                String orgName = "";
                DynamicObject orgDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
                if (orgDyn != null) {
                    orgName = orgDyn.getString("name");
                }
                this.calcTerminal(calcSrcParamJs.toString(), calcParamJs.getLong("costAccountId"), orgName);
                return;
            }
        }
        if (checkFailCount == 0 && successCcCount > 0 && calcParamJs.containsKey((Object)"calcReduct") && "true".equals(calcParamJs.getString("calcReduct"))) {
            this.calcReduct(orgId, calcParamJs.getLong("costAccountId"), calcParamJs.getLong("manuorgId"), calcParamJs.getLong("periodId"), calcParamJs.getLong("currencyId"));
        }
    }

    private Long getOrgId(JSONObject calcParamJs) {
        try {
            return calcParamJs.getLong("orgId");
        }
        catch (Exception ex) {
            logger.error("\u83b7\u53d6orgId\u4e3a\u7a7a");
            return 0L;
        }
    }

    private void calcTerminal(String calcParam, Long costAccountId, String orgName) {
        try {
            String lockErrStr = AcaMutexHelper.requireMutex((AcaMutexEnum)AcaMutexEnum.CALC_CALCULATE, (long)costAccountId);
            if (StringUtils.isNotEmpty((String)lockErrStr)) {
                this.getView().showErrorNotification(String.format(lockErrStr, orgName));
                return;
            }
            if (CadEmptyUtils.isEmpty((String)calcParam)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u6838\u7b97\u8303\u56f4\uff0c\u4e0d\u80fd\u7ee7\u7eed\u671f\u672b\u6210\u672c\u7ed3\u7b97\u3002", (String)"TerminalCalcEndEditPlugin_12", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                return;
            }
            TaskHelper.startTask((IFormView)this.getView(), (IDataModel)this.getModel(), (Long)TerminalCalcCheck.CALCTASKID, (String)calcParam, (String)"2");
        }
        catch (Exception e) {
            AcaMutexHelper.releaseMutex((AcaMutexEnum)AcaMutexEnum.CALC_CALCULATE, (long)costAccountId);
            throw new KDBizException(e.getMessage());
        }
    }

    private void calcReduct(Long orgId, Long costAccountId, Long manuorgId, Long periodId, Long currencyId) {
        JSONObject recoveryParam = this.getCostRecoveryParam(orgId, costAccountId, manuorgId, periodId, currencyId);
        if (recoveryParam == null) {
            return;
        }
        DynamicObject costParam = TerminalCalcEndEditPlugin.getCostParam(orgId, costAccountId, "aca");
        if (costParam == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u201c\u6210\u672c\u8d26\u7c3f\u201d\u6ca1\u6709\u7ef4\u62a4\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u5148\u5728\u201c\u6210\u672c\u53c2\u6570>\u6210\u672c\u6838\u7b97\u53c2\u6570\u201d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"TerminalCalcEndEditPlugin_8", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return;
        }
        String calRange = costParam.getString("restorecalcrange");
        String calDimenSion = costParam.getString("restoredimension");
        recoveryParam.accumulate("calRange", (Object)calRange);
        recoveryParam.accumulate("calDimension", (Object)calDimenSion);
        List permOrgIds = OrgHelper.getHasPermAccountOrgIdsByPermItem((String)"sca_factcostreduction", (String)this.getView().getFormShowParameter().getAppId(), (String)"4730fc9f000025ae");
        if (!permOrgIds.contains(orgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TerminalCalcEndEditPlugin_9", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return;
        }
        String costAccStr = String.valueOf(costAccountId);
        try {
            boolean mutexFlag;
            String lockErrAcct = AcaMutexHelper.requireMutex((AcaMutexEnum)AcaMutexEnum.CALC_COSTREDC, (long)costAccountId);
            if (StringUtils.isNotEmpty((String)lockErrAcct)) {
                this.getView().showErrorNotification(lockErrAcct);
                return;
            }
            if (SysParamEnum.RESTOREDIMENSION_ORGANDMANUORG.getValue().equals(calDimenSion)) {
                ArrayList<Long> manuOrgs = new ArrayList<Long>();
                if (!AcaAlgoxEmptyOrZeroUtils.isEmpty((Long)manuorgId)) {
                    manuOrgs.add(manuorgId);
                } else {
                    manuOrgs.addAll(ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)"sca_factcostreduction", (String)"4730fc9f000025ae", (String)this.getView().getFormShowParameter().getAppId()));
                }
                recoveryParam.accumulate("manuOrgId", manuOrgs.get(0));
                recoveryParam.accumulate("calcManuOrgIds", manuOrgs);
                costAccStr = costAccStr + manuOrgs.get(0);
            }
            if (!(mutexFlag = MutexHelper.require((String)"sca_factcostreduction", (Object)costAccStr.hashCode(), (String)"reductcalc", (boolean)true, (StringBuilder)new StringBuilder()))) {
                String accountName = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccountId)}).getString("name");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u201c%s\u201d\u6b63\u5728\u8fdb\u884c\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"TerminalCalcEndEditPlugin_10", (String)"macc-aca-formplugin", (Object[])new Object[0]), accountName));
                AcaMutexHelper.releaseMutex((AcaMutexEnum)AcaMutexEnum.CALC_COSTREDC, (long)costAccountId);
                return;
            }
            TaskHelper.startCostReductTask((IFormView)this.getView(), (Long)1157876764429562880L, (String)recoveryParam.toString());
        }
        catch (Exception ex) {
            logger.error("\u8ba1\u7b97\u5b8c\u6210\u6267\u884c\u6210\u672c\u8fd8\u539f\u62a5\u9519\uff1a", (Throwable)ex);
            AcaMutexHelper.releaseMutex((AcaMutexEnum)AcaMutexEnum.CALC_COSTREDC, (long)costAccountId);
            MutexHelper.release((String)"sca_factcostreduction", (String)"reductcalc", (String)String.valueOf(costAccStr.hashCode()));
        }
    }

    private JSONObject getCostRecoveryParam(Long orgId, Long costAccountId, Long manuorgId, Long periodId, Long currencyId) {
        if (orgId == null || costAccountId == null || periodId == null) {
            return null;
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.accumulate("calOrgId", (Object)orgId);
        jsonObj.accumulate("costAccountId", (Object)costAccountId);
        jsonObj.accumulate("periodId", (Object)periodId);
        jsonObj.accumulate("currency", (Object)currencyId);
        jsonObj.accumulate("taskId", 0);
        jsonObj.accumulate("usePreConstr", false);
        jsonObj.accumulate("checkMaterial", false);
        jsonObj.accumulate("checkConfigId", 1386108939132735488L);
        jsonObj.accumulate("periodIsCurrent", true);
        HashSet<Long> allOrgIds = new HashSet<Long>(16);
        HashSet<Long> allCostAccounts = new HashSet<Long>(16);
        allOrgIds.add(orgId);
        allCostAccounts.add(costAccountId);
        jsonObj.accumulate("relationCalOrgIds", allOrgIds);
        jsonObj.accumulate("relationCostAccountIds", allCostAccounts);
        JSONObject relaOrgCostAccountMap = new JSONObject();
        relaOrgCostAccountMap.accumulate(String.valueOf(orgId), (Object)costAccountId);
        jsonObj.accumulate("relaOrgCostAccountMap", (Object)relaOrgCostAccountMap);
        jsonObj.accumulate("appnum", (Object)"aca");
        return jsonObj;
    }

    public static DynamicObject getCostParam(Long orgId, Long costaccountId, String appNum) {
        Map params;
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and(new QFilter("costaccount", "=", (Object)costaccountId));
        qFilter.and(new QFilter("tab", "=", (Object)"costaccounttabpage"));
        if (!StringUtils.isEmpty((String)appNum)) {
            qFilter.and(new QFilter("appnum", "=", (Object)appNum));
        }
        if ((params = BusinessDataServiceHelper.loadFromCache((String)"cad_sysparam", (QFilter[])qFilter.toArray())).size() > 0) {
            return (DynamicObject)params.values().iterator().next();
        }
        return null;
    }
}

