/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.card;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.BindingContext;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.formplugin.card.BaseCostCardPlugin;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class TotalCostCardPlugin
extends BaseCostCardPlugin
implements BeforeF7SelectListener {
    protected static final Log logger = LogFactory.getLog(TotalCostCardPlugin.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (name) {
            case "period": {
                DynamicObject parentData = this.getView().getParentView().getModel().getDataEntity();
                DynamicObject org = parentData.getDynamicObject("org");
                if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"TotalCostCardPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObject acct = parentData.getDynamicObject("costaccount");
                if (CadEmptyUtils.isEmpty((DynamicObject)acct)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"TotalCostCardPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                listShowParameter.getListFilterParameter().getQFilters().add(StartCostHelper.getUsePeriodFilter((Long)org.getLong("id"), (Long)acct.getLong("id")));
            }
        }
    }

    protected DataSet queryData() {
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        List<QFilter> filters = this.getOrgFilter();
        if (!CadEmptyUtils.isEmpty((DynamicObject)period)) {
            filters.add(new QFilter("period", "=", period.getPkValue()));
        }
        filters.add(new QFilter("entryentity.element", ">", (Object)0L));
        filters.add(new QFilter("entryentity.pdcurramount", ">", (Object)0L));
        String selectFields = "entryentity.pdcurramount amount,entryentity.element element";
        return QueryServiceHelper.queryDataSet((String)"TotalCostCardPlugin.queryData", (String)"aca_calcresult", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject parentData = this.getView().getParentView().getModel().getDataEntity();
        DynamicObject org = parentData.getDynamicObject("org");
        DynamicObject costAccount = parentData.getDynamicObject("costaccount");
        if (!CadEmptyUtils.isEmpty((DynamicObject)costAccount) && !CadEmptyUtils.isEmpty((DynamicObject)org)) {
            this.getModel().setValue("period", (Object)TotalCostCardPlugin.getLastPeriod(org.getPkValue(), costAccount.getPkValue()));
            this.getView().updateView("period");
        }
        this.query();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "period": {
                this.query();
            }
        }
    }

    private void query() {
        DataSet dataSet = this.queryData();
        dataSet = dataSet.groupBy(new String[]{"element"}).sum("amount").finish();
        ArrayList<Row> dataList = new ArrayList<Row>(10);
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (Row row : dataSet) {
            sumAmount = sumAmount.add(this.getNotEmptyBigdecimal(row.getBigDecimal("amount")));
            dataList.add(row);
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(16);
        String elementId = "";
        BigDecimal value = new BigDecimal(0);
        BigDecimal otherValue = new BigDecimal(0);
        block29: for (Row row : dataList) {
            elementId = row.getLong("element") == null ? "" : row.getLong("element").toString();
            value = this.getNotEmptyBigdecimal(row.getBigDecimal("amount"));
            switch (elementId) {
                case "773126985240072192": {
                    map.put("MATERIAL_ID", value);
                    continue block29;
                }
                case "773141433937984512": {
                    map.put("MATERIALFEE_ID", value);
                    continue block29;
                }
                case "773177371976173568": {
                    map.put("MFGFEE_ID", value);
                    continue block29;
                }
                case "773173188837423104": {
                    map.put("RESOURCE_ID", value);
                    continue block29;
                }
                case "773173574319126528": {
                    map.put("OUTWORK_ID", value);
                    continue block29;
                }
            }
            otherValue = otherValue.add(value);
            map.put("OTHER", otherValue);
        }
        ArrayList<ItemValue> itemList = new ArrayList<ItemValue>(10);
        block30: for (Map.Entry entry : map.entrySet()) {
            switch ((String)entry.getKey()) {
                case "MATERIAL_ID": {
                    itemList.add(new ItemValue(ResManager.loadKDString((String)"\u7269\u6599", (String)"TotalCostCardPlugin_2", (String)"macc-aca-formplugin", (Object[])new Object[0]), (Number)entry.getValue(), "#40A9FF"));
                    continue block30;
                }
                case "MATERIALFEE_ID": {
                    itemList.add(new ItemValue(ResManager.loadKDString((String)"\u7269\u6599\u8d39\u7528", (String)"TotalCostCardPlugin_3", (String)"macc-aca-formplugin", (Object[])new Object[0]), (Number)entry.getValue(), "#73D13D"));
                    continue block30;
                }
                case "MFGFEE_ID": {
                    itemList.add(new ItemValue(ResManager.loadKDString((String)"\u5236\u9020\u8d39\u7528", (String)"TotalCostCardPlugin_4", (String)"macc-aca-formplugin", (Object[])new Object[0]), (Number)entry.getValue(), "#FFA940"));
                    continue block30;
                }
                case "RESOURCE_ID": {
                    itemList.add(new ItemValue(ResManager.loadKDString((String)"\u8d44\u6e90", (String)"TotalCostCardPlugin_5", (String)"macc-aca-formplugin", (Object[])new Object[0]), (Number)entry.getValue(), "#6682F5"));
                    continue block30;
                }
                case "OUTWORK_ID": {
                    itemList.add(new ItemValue(ResManager.loadKDString((String)"\u5916\u534f\u52a0\u5de5", (String)"TotalCostCardPlugin_6", (String)"macc-aca-formplugin", (Object[])new Object[0]), (Number)entry.getValue(), "#45DAD1"));
                    continue block30;
                }
            }
            itemList.add(new ItemValue(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"TotalCostCardPlugin_7", (String)"macc-aca-formplugin", (Object[])new Object[0]), (Number)entry.getValue(), "#FFC53D"));
        }
        this.drawpie("piechartap", itemList, "");
    }

    protected void drawpie(String chartAp, List<ItemValue> items, String chartName) {
        if (CadEmptyUtils.isEmpty(items)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{chartAp});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{chartAp});
        PieChart pieChart = (PieChart)this.getControl(chartAp);
        pieChart.clearData();
        PieSeries series = pieChart.createPieSeries(chartName);
        series.setData(items.toArray(new ItemValue[0]));
        series.setCenter("40%", "30%");
        pieChart.setShowTitle(false);
        pieChart.setShowLegend(true);
        pieChart.setLegendVertical(true);
        Label label = new Label();
        label.setFormatter("{b}:{c}({d}%)");
        label.setPosition(Position.left);
        label.setShow(true);
        series.setLabel(label);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("color", "#7F93BC");
        map.put("fontSize", 20);
        map.put("fontWeight", "lighter");
        pieChart.setTitlePropValue("textStyle", map);
        map = new HashMap();
        HashMap<String, Boolean> normalMap = new HashMap<String, Boolean>();
        map.put("normal", normalMap);
        normalMap.put("show", Boolean.FALSE);
        series.setPropValue("labelLine", map);
        series.setRadius("100");
        pieChart.setLegendPropValue("right", (Object)"50");
        pieChart.setLegendPropValue("top", (Object)"80");
        pieChart.setLegendPropValue("itemWidth", (Object)10);
        pieChart.setLegendPropValue("itemHeight", (Object)10);
        pieChart.bindData((BindingContext)null);
    }

    public static Long getLastPeriod(Object org, Object costAccount) {
        QFilter orgQF = new QFilter("org", "=", org);
        QFilter costaccountQF = new QFilter("entry.costaccount", "=", costAccount);
        DynamicObjectCollection res = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id, entry.currentperiod.number AS number", (QFilter[])new QFilter[]{orgQF, costaccountQF});
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)res)) {
            return null;
        }
        String number = ((DynamicObject)res.get(0)).getString("number");
        if (CadEmptyUtils.isEmpty((String)number)) {
            return null;
        }
        String lastNumber = number;
        if (number.endsWith("01")) {
            String yearNum = number.substring(0, 4);
            long year = Long.parseLong(yearNum) - 1L;
            lastNumber = String.valueOf(year).concat("12");
        } else {
            lastNumber = String.valueOf(Long.parseLong(number) - 1L);
        }
        QFilter qfNumber = new QFilter("number", "=", (Object)lastNumber);
        DynamicObject query = QueryServiceHelper.queryOne((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{qfNumber});
        return query == null ? null : Long.valueOf(query.getLong("id"));
    }

    protected List<QFilter> getOrgFilter() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        try {
            DynamicObject parentData = this.getView().getParentView().getModel().getDataEntity();
            DynamicObject org = parentData.getDynamicObject("org");
            if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
                filters.add(new QFilter("org", "=", org.getPkValue()));
            } else {
                filters.add(new QFilter("org", "=", (Object)-1L));
            }
            DynamicObject acct = parentData.getDynamicObject("costaccount");
            if (!CadEmptyUtils.isEmpty((DynamicObject)acct)) {
                filters.add(new QFilter("costaccount", "=", acct.getPkValue()));
            } else {
                filters.add(new QFilter("costaccount", "=", (Object)-1L));
            }
            DynamicObject cc = parentData.getDynamicObject("costcenter");
            if (!CadEmptyUtils.isEmpty((DynamicObject)cc)) {
                filters.add(new QFilter("costcenter", "=", cc.getPkValue()));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return filters;
    }
}

