/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.closeaccount;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.aca.algox.utils.AcaMutexHelper;
import kd.macc.aca.business.invocation.closeaccount.AcaCloseAccountBiz;
import kd.macc.aca.common.closeaccount.AcaCloseAccountParam;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PermissionHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang3.StringUtils;

public class AcaCloseAccountPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(AcaCloseAccountPlugin.class);
    private static final String BTN_CLOSE_ACCOUNT = "btn_closeaccount";
    private static final String BTN_UN_CLOSE_ACCOUNT = "btn_uncloseaccount";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbarAp = (Toolbar)this.getControl("toolbarap");
        toolbarAp.addItemClickListener((ItemClickListener)this);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectedRowIndexs = entryGrid.getSelectRows();
        switch (itemKey) {
            case "btn_closeaccount": {
                if (selectedRowIndexs.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c", (String)"AcaCloseAccountPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                this.isHasPermission(evt, "/O6GR+6VXPQ2");
                break;
            }
            case "btn_uncloseaccount": {
                if (selectedRowIndexs.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9009\u4e2d\u884c", (String)"AcaCloseAccountPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                this.isHasPermission(evt, "/O6GVID5/Q7Z");
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_closeaccount": {
                this.closeAccount();
                break;
            }
            case "btn_uncloseaccount": {
                this.undoCloseAccount();
                break;
            }
            case "btn_refresh": {
                this.initData();
                break;
            }
        }
    }

    private void isHasPermission(BeforeItemClickEvent evt, String permItem) {
        List orgPermission = PermissionHelper.getUserPermOrgs((Long)RequestContext.get().getCurrUserId(), (String)"sca_closeaccount", (String)permItem);
        if (orgPermission == null) {
            return;
        }
        if (orgPermission.size() == 0 || !orgPermission.contains(RequestContext.get().getOrgId())) {
            evt.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f88\u62b1\u6b49\uff01\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AcaCloseAccountPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        }
    }

    private void closeAccount() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectedRowIndexs = entryGrid.getSelectRows();
        List<AcaCloseAccountParam> params = this.buildCloseAccountParams(selectedRowIndexs);
        for (AcaCloseAccountParam param : params) {
            String errorInfo = AcaMutexHelper.checkAllocCalcMutex((String)String.valueOf(param.getCostAccount()));
            if (!StringUtils.isNotBlank((CharSequence)errorInfo)) continue;
            this.getView().showErrorNotification(errorInfo);
            return;
        }
        AcaCloseAccountBiz closeAccountBiz = new AcaCloseAccountBiz(params);
        Map resultMap = closeAccountBiz.doCloseAccount();
        this.updateEntryResult(selectedRowIndexs, resultMap, true);
    }

    private void undoCloseAccount() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectedRowIndexs = entryGrid.getSelectRows();
        List<AcaCloseAccountParam> acaCloseAccountParams = this.buildCloseAccountParams(selectedRowIndexs);
        AcaCloseAccountBiz acaCloseAccountBiz = new AcaCloseAccountBiz(acaCloseAccountParams);
        Map resultMap = acaCloseAccountBiz.undoCloseAccount();
        this.updateEntryResult(selectedRowIndexs, resultMap, false);
    }

    private void updateEntryResult(int[] selectedRowIndexs, Map<String, String> resultMap, boolean isClose) {
        String successResult = "A";
        String failResult = "B";
        if (!isClose) {
            successResult = "C";
            failResult = "D";
        }
        for (int i = 0; i < selectedRowIndexs.length; ++i) {
            DynamicObject calorg = (DynamicObject)this.getModel().getValue("calorg", selectedRowIndexs[i]);
            DynamicObject manuorg = (DynamicObject)this.getModel().getValue("manuorg", selectedRowIndexs[i]);
            DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount", selectedRowIndexs[i]);
            String key = calorg.getString("id") + "&" + manuorg.getString("id") + "&" + costaccount.getString("id");
            if (resultMap.containsKey(key)) {
                this.getModel().setValue("result", (Object)failResult, selectedRowIndexs[i]);
                this.getModel().setValue("log", (Object)resultMap.get(key), selectedRowIndexs[i]);
                continue;
            }
            if (isClose) {
                this.getModel().setValue("closeperiod", this.getModel().getValue("currentperiod", selectedRowIndexs[i]), selectedRowIndexs[i]);
            } else {
                this.getModel().setValue("closeperiod", null, selectedRowIndexs[i]);
            }
            this.getModel().setValue("result", (Object)successResult, selectedRowIndexs[i]);
            this.getModel().setValue("log", null, selectedRowIndexs[i]);
        }
    }

    private List<AcaCloseAccountParam> buildCloseAccountParams(int[] selectedRowIndexs) {
        ArrayList<AcaCloseAccountParam> params = new ArrayList<AcaCloseAccountParam>(selectedRowIndexs.length);
        for (int i = 0; i < selectedRowIndexs.length; ++i) {
            AcaCloseAccountParam acaCloseAccountParam = new AcaCloseAccountParam();
            DynamicObject calorg = (DynamicObject)this.getModel().getValue("calorg", selectedRowIndexs[i]);
            acaCloseAccountParam.setCalOrg(calorg != null ? Long.valueOf(calorg.getLong("id")) : null);
            acaCloseAccountParam.setCalOrgName(calorg != null ? calorg.getString("name") : null);
            DynamicObject manuorg = (DynamicObject)this.getModel().getValue("manuorg", selectedRowIndexs[i]);
            acaCloseAccountParam.setManuOrg(manuorg != null ? Long.valueOf(manuorg.getLong("id")) : null);
            acaCloseAccountParam.setManuOrgName(manuorg != null ? manuorg.getString("name") : null);
            DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount", selectedRowIndexs[i]);
            acaCloseAccountParam.setCostAccount(costaccount != null ? Long.valueOf(costaccount.getLong("id")) : null);
            acaCloseAccountParam.setCostAccountName(costaccount != null ? costaccount.getString("name") : null);
            DynamicObject currentperiod = (DynamicObject)this.getModel().getValue("currentperiod", selectedRowIndexs[i]);
            acaCloseAccountParam.setClosePeriod(currentperiod != null ? Long.valueOf(currentperiod.getLong("id")) : null);
            params.add(acaCloseAccountParam);
        }
        return params;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.validateBeforeOpenForm()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u672a\u542f\u7528\u591a\u5de5\u5382\u6838\u7b97\uff0c\u4e0d\u9700\u8981\u5904\u7406\u6210\u672c\u5173\u8d26\u3002", (String)"AcaCloseAccountPlugin_2", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        this.initData();
    }

    private boolean validateBeforeOpenForm() {
        String appId;
        boolean flag = true;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)(appId = this.getView().getFormShowParameter().getAppId()), (String)"aca_closeaccount", (String)"47150e89000000ac");
        if (rs.hasAllOrgPerm()) {
            return false;
        }
        List hasPermOrgs = rs.getHasPermOrgs();
        if (CadEmptyUtils.isEmpty((List)hasPermOrgs)) {
            return true;
        }
        List orgList = OrgUnitServiceHelper.filterOrgDuty((List)hasPermOrgs, (String)"10");
        if (CadEmptyUtils.isEmpty((List)orgList)) {
            return true;
        }
        Set<Long> acctIdSet = this.getCostAcctIdSet(orgList, this.getView().getFormShowParameter().getAppId());
        for (Long costAcctId : acctIdSet) {
            boolean enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)costAcctId);
            if (!enableMulFactory) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private Set<Long> getCostAcctIdSet(List<Long> orgList, String appNum) {
        String fields = "entryentity.costaccount.id id,entryentity.costaccount.name name";
        QFilter orgFilter = new QFilter("org", "in", orgList);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appNum);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, enable, appNumQF};
        DynamicObjectCollection col = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])filters, null);
        return col.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
    }

    private void initData() {
        Long currAcctOrg = RequestContext.get().getOrgId();
        this.getModel().setValue("org", (Object)currAcctOrg);
        List<Long> permOrgIds = this.getAllPermOrgs();
        if (CadEmptyUtils.isEmpty(permOrgIds)) {
            return;
        }
        List orgList = OrgUnitServiceHelper.filterOrgDuty(permOrgIds, (String)"10");
        if (CadEmptyUtils.isEmpty((List)orgList)) {
            return;
        }
        Iterator orgListIterator = orgList.iterator();
        while (orgListIterator.hasNext()) {
            boolean flag;
            Long orgId = (Long)orgListIterator.next();
            if (orgId == null || (flag = OrgHelper.isOrgEnableMultiFactory((Long)orgId))) continue;
            orgListIterator.remove();
        }
        if (CadEmptyUtils.isEmpty((List)orgList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5f00\u542f\u591a\u5de5\u5382\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"AcaCloseAccountPlugin_3", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return;
        }
        long startTime = System.currentTimeMillis();
        DataSet costAccountDs = this.getStartCostAccountDs(orgList, this.getView().getFormShowParameter().getAppId());
        long ds1EndTime = System.currentTimeMillis();
        logger.info(String.format("\u83b7\u53d6\u7b2c\u4e00\u4e2aDataSet\u8017\u65f6(\u6beb\u79d2)\uff1a%d", ds1EndTime - startTime));
        DataSet curPeriodDs = this.getCostAccountCurPeriod(orgList);
        long ds2EndTime = System.currentTimeMillis();
        logger.info(String.format("\u83b7\u53d6\u7b2c\u4e8c\u4e2aDataSet\u8017\u65f6(\u6beb\u79d2)\uff1a%d", ds2EndTime - ds1EndTime));
        DataSet produceOrgDs = this.getProduceOrgDs(orgList);
        long ds3EndTime = System.currentTimeMillis();
        logger.info(String.format("\u83b7\u53d6\u7b2c\u4e09\u4e2aDataSet\u8017\u65f6(\u6beb\u79d2)\uff1a%d", ds3EndTime - ds2EndTime));
        DataSet closeAccountTabDs = this.getCloseAccountTabDs(orgList);
        long ds4EndTime = System.currentTimeMillis();
        logger.info(String.format("\u83b7\u53d6\u7b2c\u56db\u4e2aDataSet\u8017\u65f6(\u6beb\u79d2)\uff1a%d", ds4EndTime - ds3EndTime));
        DataSet orgCostAccCurPeriodDs = costAccountDs.join(curPeriodDs).on("calorg", "calorg").on("costaccount", "costaccount").select(costAccountDs.getRowMeta().getFieldNames(), new String[]{"currentperiod"}).finish();
        DataSet tempDs = orgCostAccCurPeriodDs.join(produceOrgDs).on("calorg", "calorg").select(orgCostAccCurPeriodDs.getRowMeta().getFieldNames(), new String[]{"manuorg", "manuorgnum"}).finish();
        DataSet resultDs = tempDs.leftJoin(closeAccountTabDs).on("calorg", "calorg").on("manuorg", "manuorg").on("costaccount", "costaccount").select(tempDs.getRowMeta().getFieldNames(), new String[]{"closeperiod"}).finish().orderBy(new String[]{"org.number asc", "entryentity.costaccount.number asc", "manuorgnum asc"});
        long dsJoinEndTime = System.currentTimeMillis();
        logger.info(String.format("DataSet\u5173\u8054\u8017\u65f6(\u6beb\u79d2)\uff1a%d", dsJoinEndTime - ds4EndTime));
        this.initListData(resultDs);
        long endTime = System.currentTimeMillis();
        logger.info(String.format("\u5217\u8868\u6570\u636e\u521d\u59cb\u5316\u8017\u65f6(\u6beb\u79d2)\uff1a%d", endTime - dsJoinEndTime));
    }

    private void initListData(DataSet dataSet) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        Iterator ite = dataSet.iterator();
        int i = 0;
        while (ite.hasNext()) {
            Row row = (Row)ite.next();
            vs.set("calorg", (Object)row.getLong("calorg"), i);
            vs.set("manuorg", (Object)row.getLong("manuorg"), i);
            vs.set("costaccount", (Object)row.getLong("costaccount"), i);
            vs.set("currentperiod", (Object)row.getLong("currentperiod"), i);
            vs.set("closeperiod", (Object)row.getLong("closeperiod"), i);
            ++i;
        }
        if (vs.getCount() > 0) {
            this.getModel().deleteEntryData("entryentity");
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
        }
    }

    private List<Long> getAllPermOrgs() {
        String appId;
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)(appId = this.getView().getFormShowParameter().getAppId()), (String)"aca_closeaccount", (String)"47150e89000000ac");
        if (rs.hasAllOrgPerm()) {
            List permCalOrgIds = OrgUnitServiceHelper.getAllOrg((String)"10");
            return permCalOrgIds;
        }
        return rs.getHasPermOrgs();
    }

    public DataSet getStartCostAccountDs(List<Long> orgList, String appNum) {
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appNum);
        QFilter orgFilter = new QFilter("org", "in", orgList);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{appNumQF, orgFilter, isEnabledFilter, isInitFilter, enable};
        return QueryServiceHelper.queryDataSet((String)"AcaCloseAccountPlugin.getStartCostAccountDs", (String)"sca_startstdcost", (String)"org as calorg,org.number,entryentity.costaccount as costaccount,entryentity.costaccount.number", (QFilter[])filters, null);
    }

    private DataSet getCostAccountCurPeriod(List<Long> orgList) {
        QFilter orgFilter = new QFilter("org", "in", orgList);
        QFilter[] filters = new QFilter[]{orgFilter};
        String selectedFields = "org as calorg,entry.costaccount as costaccount,entry.currentperiod as currentperiod";
        return QueryServiceHelper.queryDataSet((String)"AcaCloseAccountPlugin.getCostAccountCurPeriod", (String)"cal_sysctrlentity", (String)selectedFields, (QFilter[])filters, null);
    }

    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    private DataSet getProduceOrgDs(List<Long> orgList) {
        DataSet produceOrgDs = null;
        for (int i = 0; i < orgList.size(); ++i) {
            Long orgId = orgList.get(i);
            List hasPerm = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            boolean isProduce = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"04");
            List productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)orgId, (boolean)isProduce);
            if (hasPerm != null && hasPerm.size() > 0) {
                productOrgs.retainAll(hasPerm);
            }
            if (CadEmptyUtils.isEmpty((List)productOrgs)) continue;
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AcaCloseAccountPlugin.getProduceOrgDs", (String)"bos_org", (String)(orgId + " as calorg,id as manuorg,number as manuorgnum"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)productOrgs)}, null);
            produceOrgDs = produceOrgDs == null ? dataSet : produceOrgDs.union(dataSet);
        }
        return produceOrgDs;
    }

    private DataSet getCloseAccountTabDs(List<Long> orgList) {
        QFilter orgFilter = new QFilter("calorg", "in", orgList);
        return QueryServiceHelper.queryDataSet((String)"AcaCloseAccountPlugin.getCloseAccountTabDs", (String)"aca_closeaccounttable", (String)"calorg,manuorg,costaccount,closeperiod", (QFilter[])orgFilter.toArray(), null);
    }
}

