/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.equivalent;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.aca.formplugin.base.BaseOrgAndCostAccountListPlugin;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class EquivalentListPlugin
extends BaseOrgAndCostAccountListPlugin {
    private FilterContainerInitArgs filterContainerInitArgs = null;
    private static final Log logger = LogFactory.getLog(EquivalentListPlugin.class);

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        this.filterContainerInitArgs = args;
        for (FilterColumn filterColumn : commonFilterColumns) {
            String fieldName = filterColumn.getFieldName();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String useOrg = this.getPageCache().get("org");
            if (useOrg != null) {
                List orgList = JSON.parseArray((String)useOrg, String.class);
                useOrg = (String)orgList.get(0);
            }
            if (fieldName.startsWith("manuorg.")) {
                String filterFlag = this.getPageCache().get("filterFlag");
                if (StringUtils.isNotEmpty((CharSequence)useOrg) && ("yes".equals(filterFlag) || !StringUtils.isNotEmpty((CharSequence)filterFlag))) {
                    List manuOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.parseLong(useOrg), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                    ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
                    if (!CollectionUtils.isEmpty((Collection)manuOrg)) {
                        logger.info("\u751f\u4ea7\u7ec4\u7ec7 " + manuOrg);
                        DynamicObject[] loadData = BusinessDataServiceHelper.load((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)manuOrg)});
                        for (int i = 0; i < loadData.length; ++i) {
                            ComboItem comboItem = new ComboItem();
                            comboItem.setCaption(new LocaleString(loadData[i].getString("name")));
                            comboItem.setValue(String.valueOf(loadData[i].getPkValue()));
                            comboItems.add(comboItem);
                        }
                        commonFilterColumn.setComboItems(comboItems);
                    } else {
                        commonFilterColumn.setComboItems(comboItems);
                        commonFilterColumn.setDefaultValue("");
                    }
                    this.getPageCache().put("filterFlag", "no");
                }
            }
            if (!fieldName.startsWith("costaccount.")) continue;
            this.resetCostAccount(commonFilterColumn, useOrg);
        }
    }

    protected void resetCostAccount(CommonFilterColumn commonFilterColumn, String orgId) {
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        if (StringUtils.isNotEmpty((CharSequence)orgId)) {
            List<ComboItem> comboItems = this.getCostAccountComboItemListBy(Collections.singletonList(orgId));
            if (CollectionUtils.isEmpty(comboItems)) {
                return;
            }
            commonFilterColumn.setComboItems(comboItems);
            ComboItem item = comboItems.get(0);
            String defVal = this.getCustomParam("costaccount");
            if (CadEmptyUtils.isEmpty((String)defVal)) {
                defVal = item.getValue();
            }
            commonFilterColumn.setDefaultValue(defVal);
            this.getPageCache().put("costaccount", defVal);
        }
    }

    @Override
    protected List<ComboItem> getCostAccountComboItemListBy(List<Object> orgId) {
        DynamicObjectCollection ccs;
        QFilter filter = null;
        if (!CadEmptyUtils.isEmpty(orgId)) {
            ArrayList lOrgIds = new ArrayList();
            orgId.forEach(id -> lOrgIds.add(Long.valueOf(id.toString())));
            filter = new QFilter("calorg", "in", lOrgIds);
        } else {
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            filter = new QFilter("calorg", "in", (Object)orgIds);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(orgId)) {
            filter.and(StartCostHelper.getEnabledCostAccountIdsFilter(orgId, (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView())));
        }
        if (CollectionUtils.isEmpty((Collection)(ccs = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,name", (QFilter[])new QFilter[]{filter, statusFilter, enableFilter}, (String)"ismainaccount desc,number asc")))) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ccs.forEach(cc -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(cc.getString("name")));
            item.setValue(cc.getString("id"));
            if (!acctItems.contains(item)) {
                acctItems.add(item);
            }
        });
        return acctItems;
    }

    public void setFilter(SetFilterEvent e) {
        List<Object> orgCache = this.getOrgCache();
        if (CadEmptyUtils.isEmpty(orgCache)) {
            List qFilters = e.getQFilters();
            qFilters.add(new QFilter("org", "=", (Object)0L));
        }
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        if (filterValues.containsKey("customfilter")) {
            List customfilter = (List)filterValues.get("customfilter");
            if (customfilter == null || customfilter.isEmpty()) {
                return;
            }
            for (int i = 0; i < customfilter.size(); ++i) {
                Map filter = (Map)customfilter.get(i);
                List listValue = (List)filter.get("Value");
                List listFieldName = (List)filter.get("FieldName");
                block9: for (int j = 0; j < listFieldName.size(); ++j) {
                    String fieldName;
                    switch (fieldName = (String)listFieldName.get(j)) {
                        case "manuorg.id": {
                            this.getPageCache().put("manuorgMine", (String)listValue.get(j));
                            this.getPageCache().put("filterFlag", "yes");
                            this.filterContainerInit(this.filterContainerInitArgs);
                            continue block9;
                        }
                        case "costaccount.id": {
                            this.getPageCache().put("costaccountMine", (String)listValue.get(j));
                        }
                    }
                }
            }
        }
    }

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"tblnew"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemkey = evt.getItemKey();
        if ("tblnew".equals(itemkey) && StringUtils.isEmpty((CharSequence)this.getPageCache().get(this.ORG_FIELD))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\u4e0d\u80fd\u6267\u884c\u65b0\u589e\u64cd\u4f5c\u3002", (String)"EquivalentListPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("org")) {
            args.getQfilters().add(new QFilter("id", "in", (Object)ImportServiceHelper.getHasPermOrgIdsByOrgViewType((String)"10")));
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if ("copy".equals(operateKey)) {
            this.getView().getPageCache().put("copy", "copy");
        } else {
            this.getView().getPageCache().put("copy", null);
        }
        switch (operateKey) {
            case "new": {
                boolean flag = PermissionServiceHelper.hasNewPermission((long)RequestContext.get().getCurrUserId(), (String)"aca", (String)"aca_equivalent");
                if (flag) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u7ea6\u5f53\u7cfb\u6570\u5904\u7406\u201d\u7684\u201c\u65b0\u589e\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"EquivalentListPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }
}

