/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.feealloc;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.alloc.AcaMatAllocHelper;
import kd.macc.aca.algox.alloc.output.AllocResult;
import kd.macc.aca.algox.enums.ScaAllocEnum;
import kd.macc.aca.algox.utils.CostaccountHelper;
import kd.macc.aca.algox.utils.MatCostHelper;
import kd.macc.cad.common.enums.BgParamEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ElementHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MatAllocateEditPlugin
extends AbstractBillPlugIn {
    public void initialize() {
        super.initialize();
        if ("eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5f52\u96c6", (String)"MatAllocateEditPlugin_18", (String)"macc-aca-formplugin", (Object[])new Object[0])));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain", "advcontoolbarap"});
        this.addClickListeners(new String[]{"costdriver"});
        BasedataEdit entryCostObject = (BasedataEdit)this.getControl("costobejctentry");
        entryCostObject.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                List filters = MatAllocateEditPlugin.this.getEntryCostObjectFilters();
                if (Boolean.TRUE.equals(MatAllocateEditPlugin.this.getModel().getValue("isreturnitem"))) {
                    if (AcaMatAllocHelper.getIsReworkAllocSelf()) {
                        filters.add(new QFilter("material", "=", (Object)MatAllocateEditPlugin.this.getPkVal("material")));
                    }
                } else {
                    filters.add(new QFilter("material", "!=", (Object)MatAllocateEditPlugin.this.getPkVal("material")));
                }
                filters.add(new QFilter("costcenter", "=", (Object)MatAllocateEditPlugin.this.getPkVal("costcenter")));
                filters.add(new QFilter("producttype", "=", (Object)"C"));
                List qFilters = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
                qFilters.addAll(filters);
            }
        });
        BasedataEdit costDriver = (BasedataEdit)this.getControl("costdriver");
        costDriver.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(new QFilter("status", "=", (Object)"C"));
                filters.add(new QFilter("allocclass", "=", (Object)"COSTOBJECT"));
                filters.add(new QFilter("appnum", "=", (Object)MatAllocateEditPlugin.this.getView().getFormShowParameter().getAppId()));
                List qFilters = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
                qFilters.addAll(filters);
            }
        });
        BasedataEdit element = (BasedataEdit)this.getControl("elemententry");
        element.addBeforeF7SelectListener(t -> {
            List qFilters = ((ListShowParameter)t.getFormShowParameter()).getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("type", "in", (Object)new String[]{"001"}));
        });
        BasedataEdit subelement = (BasedataEdit)this.getControl("subelemententry");
        subelement.addBeforeF7SelectListener(t -> {
            DynamicObject elementDyn = (DynamicObject)this.getModel().getValue("elemententry");
            List qFilters = ((ListShowParameter)t.getFormShowParameter()).getListFilterParameter().getQFilters();
            if (elementDyn != null) {
                qFilters.add(new QFilter("id", "in", this.getSubElement(elementDyn.getLong("id"))));
            }
            qFilters.add(new QFilter("type", "in", (Object)new String[]{"001"}));
        });
    }

    public Set<Long> getSubElement(long elementId) {
        HashSet<Long> subElementIds = new HashSet<Long>();
        QFilter qfElement = new QFilter("element", "=", (Object)elementId);
        DynamicObjectCollection elementDetail = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement.id", (QFilter[])new QFilter[]{qfElement});
        if (elementDetail.size() == 0) {
            return subElementIds;
        }
        for (DynamicObject ele : elementDetail) {
            subElementIds.add(ele.getLong("subelement.id"));
        }
        return subElementIds;
    }

    private List<QFilter> getEntryCostObjectFilters() {
        ArrayList costObjectIds = new ArrayList();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        entrys.forEach(s -> {
            if (s.getDynamicObject("costobejctentry") != null) {
                costObjectIds.add(s.getDynamicObject("costobejctentry").getLong("id"));
            }
        });
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("id", "not in", costObjectIds));
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        filters.add(new QFilter("bizstatus", "=", (Object)"A"));
        return filters;
    }

    public void beforeBindData(EventObject e) {
        DynamicObjectCollection dynObjCols;
        long baseunitId;
        DynamicObject materialDyn;
        super.beforeBindData(e);
        DynamicObject baseunitDyn = this.getModel().getDataEntity().getDynamicObject("baseunit");
        if (baseunitDyn == null && (materialDyn = this.getModel().getDataEntity().getDynamicObject("material")) != null && (baseunitId = materialDyn.getLong("baseunit.id")) != 0L) {
            this.getModel().setValue("baseunit", (Object)baseunitId);
            this.getModel().setDataChanged(false);
            this.updateBaseunit(this.getModel().getDataEntity().getLong("id"), baseunitId);
        }
        if ((dynObjCols = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity")) != null && dynObjCols.size() < 500) {
            for (DynamicObject dyn : dynObjCols) {
                DynamicObject costobject = dyn.getDynamicObject("costobejctentry");
                if (costobject == null) continue;
                dyn.set("costobjectmat", (Object)costobject.getDynamicObject("material"));
                dyn.set("costobjectauxpty", (Object)costobject.getDynamicObject("auxpty"));
                this.getModel().setDataChanged(false);
            }
        }
        if (!CadBgParamUtils.getBgParamBoolean((BgParamEnum)BgParamEnum.DIRECT_MAT_ALLOC).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"collconfig", "srcbilltype", "nsrcauditdate"});
        }
    }

    private void updateBaseunit(long fid, long baseunitId) {
        MainEntityType mt = EntityMetadataCache.getDataEntityType((String)"sca_matalloc");
        String updateSql = "update %s set fbaseunitid=? where fid = ?";
        ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(1);
        SqlParameter[] params = new SqlParameter[]{new SqlParameter("baseunitid", -5, (Object)baseunitId), new SqlParameter("id", -5, (Object)fid)};
        paramsList.add(params);
        String sql = String.format(updateSql, mt.getAlias());
        DB.executeBatch((DBRoute)new DBRoute("cal"), (String)sql, paramsList);
    }

    public void afterBindData(EventObject e) {
        String costdriverId;
        super.afterBindData(e);
        this.disableFields();
        this.changManuorgStatus();
        this.showProductNum();
        DynamicObject costobject = this.getModel().getDataEntity().getDynamicObject("costobject");
        if (costobject != null) {
            return;
        }
        DynamicObject costdriver = this.getModel().getDataEntity().getDynamicObject("costdriver");
        String newstd = this.getPageCache().get("newDriverId");
        String newstdName = this.getPageCache().get("newDriverName");
        if (costdriver == null && CadEmptyUtils.isEmpty((String)newstd)) {
            String tips = ResManager.loadKDString((String)"\u5206\u914d\u6807\u51c6\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u5206\u914d\u6807\u51c6\u3002", (String)"MatAllocateEditPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(tips);
            return;
        }
        String string = costdriverId = costdriver == null ? "" : costdriver.getString("id");
        if (kd.bos.util.StringUtils.isNotEmpty((String)newstd) && !costdriverId.equals(newstd) && kd.bos.util.StringUtils.isNotEmpty((String)newstdName)) {
            this.getPageCache().remove("newDriverId");
            this.getPageCache().remove("newDriverName");
            String tips = String.format(ResManager.loadKDString((String)"\u6240\u9009\u5206\u914d\u6807\u51c6%s\u6ca1\u6709\u5bf9\u5e94\u7684\u5206\u914d\u6807\u51c6\u503c\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u8fdb\u884c\u4fee\u6539\u5206\u914d\u6807\u51c6\u3002", (String)"MatAllocateEditPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]), newstdName);
            this.getView().showErrorNotification(tips);
            return;
        }
        String newAllocdim = this.getPageCache().get("newAllocdim");
        String allocdim = this.getModel().getDataEntity().getString("allocdim");
        if (kd.bos.util.StringUtils.isNotEmpty((String)newAllocdim) && !newAllocdim.equals(allocdim)) {
            this.getPageCache().remove("newAllocdim");
            if (this.getModel().getDataEntity().getDynamicObjectCollection("entryentity").isEmpty()) {
                String tips = ResManager.loadKDString((String)"\u6240\u9009\u5206\u914d\u6807\u51c6\u548c\u5206\u914d\u7ef4\u5ea6\u6ca1\u6709\u5bf9\u5e94\u7684\u5206\u914d\u6807\u51c6\u503c\uff0c\u8bf7\u786e\u8ba4\u5206\u914d\u7ef4\u5ea6\u3002", (String)"MatAllocateEditPlugin_20", (String)"macc-aca-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(tips);
            }
        }
    }

    private void showProductNum() {
        DynamicObject obj;
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        DynamicObject costcenter = (DynamicObject)this.getModel().getValue("costcenter");
        if (accountorg != null && costcenter != null && (obj = CostObjectHelper.getRuleBy((Object)accountorg.getLong("id"), (Object)costcenter.getLong("id"))) != null && "SO".equals(obj.getString("biztype"))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"product"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"productnum"});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"product"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"productnum"});
    }

    private void disableFields() {
        DynamicObject mainData = this.getModel().getDataEntity();
        String allocStatus = mainData.getString("allocstatus");
        boolean isConfirm = "2".equals(allocStatus);
        this.getView().setEnable(Boolean.valueOf(!isConfirm), new String[]{"contentpanelflex", "bar_confirm"});
        this.getView().setVisible(Boolean.valueOf(!isConfirm), new String[]{"bar_allocate"});
        boolean isCommonMat = this.isCommonMaterial();
        this.getView().setEnable(Boolean.valueOf(isCommonMat), new String[]{"costdriver", "entryentity"});
        if (!CostaccountHelper.getCostElementByCostAccount((long)mainData.getLong("costaccount.id")) || !"2".equals(allocStatus)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"subentryentity"});
        }
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String tips = null;
        switch (e.getItemKey()) {
            case "add_row": {
                if (this.isCommonMaterial()) break;
                tips = ResManager.loadKDString((String)"\u4e0d\u80fd\u589e\u884c\u3002\u4e0d\u662f\u5171\u8017\u6750\u6599\u3002", (String)"MatAllocateEditPlugin_2", (String)"macc-aca-formplugin", (Object[])new Object[0]);
                break;
            }
            case "del_row": {
                if (this.isCommonMaterial()) break;
                tips = ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u884c\u3002\u4e0d\u662f\u5171\u8017\u6750\u6599\u3002", (String)"MatAllocateEditPlugin_3", (String)"macc-aca-formplugin", (Object[])new Object[0]);
                break;
            }
            case "bar_confirm": {
                String useType = (String)this.getModel().getValue("usetype");
                boolean isDirMat = ScaAllocEnum.USETYPE_DRIECT.getValue().equals(useType);
                if (isDirMat || this.check(ResManager.loadKDString((String)"\u4e0d\u80fd\u786e\u8ba4\u3002", (String)"MatAllocateEditPlugin_4", (String)"macc-aca-formplugin", (Object[])new Object[0]), true, true)) break;
                e.setCancel(true);
            }
        }
        if (kd.bos.util.StringUtils.isNotEmpty(tips)) {
            this.getView().showTipNotification(tips);
            e.setCancel(true);
        }
    }

    private boolean isCommonMaterial() {
        DynamicObject costObject = (DynamicObject)this.getModel().getValue("costobject");
        return costObject == null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "op_confirm": {
                if (!this.getModel().getDataChanged()) break;
                this.getModel().setValue("alloctype", (Object)ScaAllocEnum.ALLOCTYPE_MANUAL.getValue());
                break;
            }
            case "op_allocate": {
                this.manualAlloc();
                e.setCancel(true);
                break;
            }
        }
    }

    private boolean check(String opTypeErr, boolean checkAllocValue, boolean checkSubelement) {
        DynamicObject costdriver = this.getModel().getDataEntity().getDynamicObject("costdriver");
        if (costdriver == null) {
            String str = String.format(ResManager.loadKDString((String)"%s\u5206\u914d\u6807\u51c6\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u5206\u914d\u6807\u51c6\u3002", (String)"MatAllocateEditPlugin_15", (String)"macc-aca-formplugin", (Object[])new Object[0]), opTypeErr);
            this.getView().showErrorNotification(str);
            return false;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entrys)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u7b26\u5408\u7684\u5206\u914d\u6807\u51c6\u503c\u3002", (String)"MatAllocateEditPlugin_16", (String)"macc-aca-formplugin", (Object[])new Object[0]), opTypeErr));
            return false;
        }
        for (DynamicObject row : entrys) {
            if (row.getDynamicObject("costobejctentry") == null) {
                String str = String.format(ResManager.loadKDString((String)"%s\u5b58\u5728\u5206\u914d\u660e\u7ec6\u884c\u7684\u6240\u5c5e\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"MatAllocateEditPlugin_17", (String)"macc-aca-formplugin", (Object[])new Object[0]), opTypeErr);
                this.getView().showErrorNotification(str);
                return false;
            }
            if (checkSubelement && row.getDynamicObject("subelemententry") == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u5206\u914d\u660e\u7ec6\u884c\u7684\u6210\u672c\u5b50\u8981\u7d20\u4e3a\u7a7a\u3002", (String)"MatAllocateEditPlugin_7", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!checkAllocValue || !CadEmptyUtils.isEmpty((BigDecimal)row.getBigDecimal("allocvalue"))) continue;
            String str = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5206\u914d\u660e\u7ec6\u884c\u7684\u5206\u914d\u6807\u51c6\u503c\u4e3a\u7a7a\u6216\u8005\u4e3a0\u3002", (String)"MatAllocateEditPlugin_8", (String)"macc-aca-formplugin", (Object[])new Object[0]), opTypeErr);
            this.getView().showErrorNotification(str);
            return false;
        }
        return true;
    }

    private void manualAlloc() {
        String useType = (String)this.getModel().getValue("usetype");
        boolean isDirMat = ScaAllocEnum.USETYPE_DRIECT.getValue().equals(useType);
        if (isDirMat) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u627e\u5230\u6240\u5c5e\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff0c\u65e0\u9700\u518d\u6b21\u5206\u914d\u3002", (String)"MatAllocateEditPlugin_9", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.check(ResManager.loadKDString((String)"\u4e0d\u80fd\u5206\u914d\u3002", (String)"MatAllocateEditPlugin_10", (String)"macc-aca-formplugin", (Object[])new Object[0]), false, false)) {
            return;
        }
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject row : entrys) {
            if (!CadEmptyUtils.isEmpty((BigDecimal)row.getBigDecimal("allocvalue"))) continue;
            String tips = ResManager.loadKDString((String)"\u5b58\u5728\u5206\u914d\u660e\u7ec6\u884c\u7684\u5206\u914d\u6807\u51c6\u503c\u4e3a\u7a7a\u6216\u8005\u4e3a0\uff0c\u4e0d\u80fd\u8fdb\u884c\u5206\u914d\u3002\u786e\u8ba4\u5220\u9664\u6570\u636e\u518d\u8fdb\u884c\u5206\u914d\uff1f", (String)"MatAllocateEditPlugin_11", (String)"macc-aca-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(tips, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("manualAlloc"));
            return;
        }
        int amtPrecision = this.getModel().getDataEntity().getDynamicObject("currency").getInt("amtprecision");
        BigDecimal useAmount = this.getModel().getDataEntity().getBigDecimal("useamount");
        BigDecimal useQty = this.getModel().getDataEntity().getBigDecimal("useqty");
        int matUnitPrecision = 0;
        DynamicObject materialDyn = this.getModel().getDataEntity().getDynamicObject("material");
        if (materialDyn == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u8fdb\u884c\u624b\u5de5\u5206\u914d\u3002", (String)"MatAllocateEditPlugin_19", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return;
        }
        if (materialDyn.getDynamicObject("baseunit") != null) {
            matUnitPrecision = materialDyn.getDynamicObject("baseunit").getInt("precision");
        }
        DynamicObject mainItem = this.getModel().getDataEntity();
        this.getModel().beginInit();
        BigDecimal totalAllocVal = BigDecimal.ZERO;
        BigDecimal maxVal = null;
        for (DynamicObject row : entrys) {
            BigDecimal val = row.getBigDecimal("allocvalue");
            if (maxVal == null || maxVal.compareTo(val) < 0) {
                maxVal = val;
            }
            totalAllocVal = totalAllocVal.add(val);
        }
        if (totalAllocVal.compareTo(BigDecimal.ZERO) <= 0) {
            String str = ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff0c\u5206\u914d\u6807\u51c6\u503c\u603b\u548c\u4e0d\u80fd\u5c0f\u4e8e\u6216\u7b49\u4e8e0\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u3002", (String)"MatAllocateEditPlugin_23", (String)"macc-aca-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(str);
            return;
        }
        int maxIndex = -1;
        int index = 0;
        BigDecimal maxQty = BigDecimal.ZERO;
        BigDecimal maxAmount = BigDecimal.ZERO;
        BigDecimal amountDiff = useAmount;
        BigDecimal qtyDiff = useQty;
        Long materialId = materialDyn.getLong("id");
        HashSet<Long> materials = new HashSet<Long>();
        materials.add(materialId);
        Long orgId = this.getModel().getDataEntity().getLong("org.id");
        Map matSubEleMap = ElementHelper.getDefSubEles((Long)orgId, new HashSet(materials));
        Long[] matEleArr = (Long[])matSubEleMap.get(materialId);
        for (DynamicObject entry : entrys) {
            DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
            if (subentryentity != null) {
                subentryentity.clear();
            }
            BigDecimal rate = entry.getBigDecimal("allocvalue").divide(totalAllocVal, 12, 4);
            BigDecimal qty = useQty.multiply(rate).setScale(matUnitPrecision, 4);
            BigDecimal amount = useAmount.multiply(rate).setScale(amtPrecision, 4);
            entry.set("qty", (Object)qty);
            entry.set("amount", (Object)amount);
            if (entry.getBigDecimal("allocvalue").compareTo(maxVal) == 0) {
                maxIndex = index;
                maxQty = qty;
                maxAmount = amount;
            }
            qtyDiff = qtyDiff.subtract(qty);
            amountDiff = amountDiff.subtract(amount);
            ++index;
            if (matEleArr == null || entry.getDynamicObject("subelemententry") != null && entry.getDynamicObject("elemententry") != null) continue;
            entry.set("subelemententry_id", (Object)matEleArr[1]);
            entry.set("elemententry_id", (Object)matEleArr[0]);
        }
        if (maxIndex >= 0) {
            this.getModel().setValue("qty", (Object)maxQty.add(qtyDiff), maxIndex);
            this.getModel().setValue("amount", (Object)maxAmount.add(amountDiff), maxIndex);
        }
        mainItem.set("alloctype", (Object)ScaAllocEnum.ALLOCTYPE_MANUAL.getValue());
        mainItem.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_ALLOC.getValue());
        mainItem.set("allocatedate", (Object)new Date());
        mainItem.set("alloctor", (Object)RequestContext.get().getCurrUserId());
        mainItem.set("usetype", (Object)ScaAllocEnum.USETYPE_PUBLIC.getValue());
        this.getModel().endInit();
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainItem});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u6210\u529f\u3002", (String)"MatAllocateEditPlugin_13", (String)"macc-aca-formplugin", (Object[])new Object[0]));
        this.getView().invokeOperation("refresh");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) {
            return;
        }
        switch (e.getOperateKey()) {
            case "op_confirm": 
            case "op_unconfirm": {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        int index = e.getChangeSet()[0].getRowIndex();
        String tips = ResManager.loadKDString((String)"\u8c03\u6574\u5206\u914d\u6807\u51c6\u6216\u5206\u914d\u7ef4\u5ea6\u65f6\u4f1a\u91cd\u65b0\u5206\u914d\u3002\u786e\u8ba4\u8c03\u6574\uff1f", (String)"MatAllocateEditPlugin_21", (String)"macc-aca-formplugin", (Object[])new Object[0]);
        switch (e.getProperty().getName()) {
            case "costdriver": {
                if (newValue == null) {
                    this.cleanAllocValue();
                    return;
                }
                String id = ((DynamicObject)newValue).getString("id");
                if (StringUtils.equals((CharSequence)id, (CharSequence)this.getPageCache().get("oldDriverId"))) {
                    return;
                }
                this.getView().showConfirm(tips, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("allocConfim"));
                this.getPageCache().put("newDriverName", ((DynamicObject)newValue).getString("name"));
                this.getPageCache().put("newDriverId", id);
                break;
            }
            case "allocdim": {
                if (newValue == null) {
                    return;
                }
                this.getView().showConfirm(tips, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("allocConfim"));
                this.getPageCache().put("newAllocdim", newValue.toString());
                break;
            }
            case "qty": {
                BigDecimal qty = (BigDecimal)newValue;
                this.getModel().setValue("amount", (Object)qty.multiply((BigDecimal)this.getModel().getValue("price", index)));
                break;
            }
            case "amount": {
                DynamicObject currency = this.getModel().getDataEntity().getDynamicObject("currency");
                int priceprecision = currency.getInt("priceprecision");
                BigDecimal amount = (BigDecimal)newValue;
                BigDecimal quantity = (BigDecimal)this.getModel().getValue("qty");
                this.getModel().setValue("price", (Object)(quantity.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : amount.divide(quantity, priceprecision, 4)));
                break;
            }
            case "elemententry": {
                if ("false".equals(this.getPageCache().get("isRemove"))) {
                    this.getModel().setValue("subelemententry", null, index);
                    this.getPageCache().put("isRemove", "true");
                }
                if (newValue != null) break;
                this.getModel().setValue("subelemententry", null, index);
                break;
            }
            case "subelemententry": {
                this.writeBackElement((DynamicObject)newValue, index);
                break;
            }
            case "costobejctentry": {
                if (newValue == null) {
                    this.getModel().setValue("costobjectmat", null, index);
                    this.getModel().setValue("costobjectauxpty", null, index);
                    break;
                }
                DynamicObject costobject = (DynamicObject)newValue;
                this.getModel().setValue("costobjectmat", (Object)costobject.getDynamicObject("material"), index);
                this.getModel().setValue("costobjectauxpty", (Object)costobject.getDynamicObject("auxpty"), index);
                break;
            }
            case "org": {
                this.changManuorgStatus();
            }
        }
    }

    private void writeBackElement(DynamicObject subEle, int rowIndex) {
        if (subEle == null || this.getModel().getValue("elemententry") != null) {
            return;
        }
        long subElementId = subEle.getLong("id");
        QFilter qfSubElement = new QFilter("subelement", "=", (Object)subElementId);
        DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{qfSubElement});
        if (dySubElement != null) {
            this.getModel().setValue("elemententry", (Object)dySubElement.getLong("element"), rowIndex);
            this.getPageCache().put("isRemove", "false");
        }
    }

    private void cleanAllocValue() {
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < rowCount; ++i) {
            this.getModel().setValue("allocvalue", null, i);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if ("allocConfim".equals(e.getCallBackId()) && "yes".equalsIgnoreCase(e.getResultValue())) {
            DynamicObject mainData = this.getModel().getDataEntity();
            AllocResult result = AcaMatAllocHelper.doAlloc((DynamicObject)mainData);
            if (result.isReportContainError()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u5206\u914d\u62a5\u544a\u3002", (String)"MatAllocateEditPlugin_22", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            }
            this.getView().invokeOperation("refresh");
        } else if ("manualAlloc".equals(e.getCallBackId()) && "yes".equalsIgnoreCase(e.getResultValue())) {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
            ArrayList removeEntrys = Lists.newArrayList();
            for (DynamicObject row : entrys) {
                if (!CadEmptyUtils.isEmpty((BigDecimal)row.getBigDecimal("allocvalue"))) continue;
                removeEntrys.add(row);
            }
            entrys.removeAll((Collection)removeEntrys);
            this.manualAlloc();
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        Long typeId = this.getModel().getDataEntity().getLong("matcostinfo");
        BigDecimal amount = MatCostHelper.getMatStdPrice((Long)typeId);
        int index = this.getModel().getEntryRowCount("entryentity") - 1;
        if (index > -1) {
            this.getModel().setValue("price", (Object)amount, index);
        }
    }

    private long getPkVal(String field) {
        DynamicObject mainItem = this.getModel().getDataEntity();
        DynamicObject item = mainItem.getDynamicObject(field);
        return Optional.ofNullable(item).map(s -> s.getLong("id")).orElse(0L);
    }

    private void setEleSubEntry() {
        DynamicObjectCollection entries = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entries) {
            DynamicObjectCollection subEntries = entry.getDynamicObjectCollection("subentryentity");
            DynamicObject subEntry = subEntries.addNew();
            subEntry.set("element", entry.get("elemententry"));
            subEntry.set("subelement", entry.get("subelemententry"));
            subEntry.set("standardcost", entry.get("price"));
            subEntry.set("standardamt", entry.get("amount"));
        }
    }

    private void changManuorgStatus() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)accountorg.getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }
}

