/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.init;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.algox.utils.CostaccountHelper;
import kd.macc.aca.common.constants.WipInitSubItem;
import kd.macc.aca.common.helper.AcaCostAccountHelper;
import kd.macc.aca.common.helper.AcaWipCostInitHelper;
import kd.macc.cad.common.constants.CommonConstant;
import kd.macc.cad.common.constants.DutyIdConstants;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.helper.ElementHelper;
import kd.macc.cad.common.helper.ElementRelationHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.MatHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class WipCostInitEditPlugin
extends AbstractBillPlugIn
implements RowClickEventListener {
    private static final String MATTYPE = "001";
    private static final String MATCOST = "002";
    private static final List<String> CAN_EDIT_SUB_ENTRY_ENTITY_TYPES = new ArrayList<String>(10){
        {
            this.add(WipCostInitEditPlugin.MATTYPE);
            this.add(WipCostInitEditPlugin.MATCOST);
        }
    };

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid subentryentity = (EntryGrid)this.getView().getControl("subentryentity");
        subentryentity.addRowClickListener((RowClickEventListener)this);
        BasedataEdit manuOrgEdit = (BasedataEdit)this.getControl("manuorg");
        manuOrgEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org != null) {
                ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter filterParameter = param.getListFilterParameter();
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                List manuOrgIds = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                filters.add(new QFilter("id", "in", (Object)manuOrgIds));
                filterParameter.setQFilters(filters);
            }
        });
        BasedataEdit costAccountEdit = (BasedataEdit)this.getControl("costaccount");
        costAccountEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            Object orgId = this.getModel().getDataEntity().getDynamicObject("org").getPkValue();
            String curAppNum = AppIdHelper.getCurAppNum((IFormView)this.getView());
            QFilter costAccountIdFilter = StartCostHelper.getEnableQfilterByOrg((Long)((Long)orgId), (Boolean)Boolean.FALSE, (String)curAppNum);
            filterParameter.getQFilters().add(costAccountIdFilter);
        });
        BasedataEdit costCenterEdit = (BasedataEdit)this.getControl("costcenter");
        costCenterEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject acctOrg = this.getModel().getDataEntity().getDynamicObject("org");
            if (acctOrg != null) {
                filters.add(new QFilter("accountorg", "=", acctOrg.getPkValue()));
            }
            filters.add(new QFilter("orgduty", "=", (Object)DutyIdConstants.BASIC_PRODUCT_ID));
            filterParameter.setQFilters(filters);
        });
        BasedataEdit costObjectEdit = (BasedataEdit)this.getControl("costobject");
        costObjectEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject costCenter = this.getModel().getDataEntity().getDynamicObject("costcenter");
            if (costCenter == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u6210\u672c\u4e2d\u5fc3\u3002", (String)"WipCostInitEditPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                return;
            }
            filters.add(new QFilter("costcenter", "=", costCenter.getPkValue()));
            filters.add(new QFilter("producttype", "=", (Object)"C"));
            Set usedCostObjectId = AcaWipCostInitHelper.getUsedCostObject((Long)costCenter.getLong("id"));
            if (!CadEmptyUtils.isEmpty((Set)usedCostObjectId)) {
                filters.add(new QFilter("id", "not in", (Object)usedCostObjectId));
            }
            filterParameter.setQFilters(filters);
        });
        Set<Long> selectedSubElementIds = this.getSelectedSubElementIds();
        DynamicObject costobjectDyn = this.getModel().getDataEntity().getDynamicObject("costobject");
        if (costobjectDyn != null && costobjectDyn.getBoolean("isoutsource")) {
            selectedSubElementIds.clear();
        }
        ElementHelper.elementAndSubEleF7Setting((IDataModel)this.getModel(), (AbstractBillPlugIn)this, selectedSubElementIds);
        this.subMatVersionF7Setting();
        BasedataEdit sSubElementCtrl = (BasedataEdit)this.getControl("ssubelement");
        sSubElementCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = showParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObjectCollection entries = this.getModel().getEntryEntity("subitemdetail");
            if (entries != null && !entries.isEmpty()) {
                int index = this.getModel().getEntryCurrentRowIndex("subitemdetail");
                HashSet<Long> subElementIdSet = new HashSet<Long>(16);
                int i = 0;
                for (DynamicObject entrie : entries) {
                    if (i == index) continue;
                    subElementIdSet.add((Long)((DynamicObject)entrie.get("ssubelement")).getPkValue());
                    ++i;
                }
                qList.add(new QFilter("id", "not in", subElementIdSet));
            }
        });
    }

    private Set<Long> getSelectedSubElementIds() {
        HashSet<Long> selectedSubElementIds = new HashSet<Long>(16);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int index = 0; index < entryEntity.size(); ++index) {
            DynamicObject rowObject = (DynamicObject)entryEntity.get(index);
            DynamicObject subElement = rowObject.getDynamicObject("subelement");
            if (subElement == null) continue;
            selectedSubElementIds.add((Long)subElement.getPkValue());
        }
        return selectedSubElementIds;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            if (OrgHelper.isOrgEnableMultiFactory((Long)org.getLong("id"))) {
                BasedataEdit manuOrg = (BasedataEdit)this.getControl("manuorg");
                manuOrg.setMustInput(true);
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"manuorg"});
            }
        }
        CurrencyHelper.setCurrency((IDataModel)this.getModel(), (IFormView)this.getView());
        this.setCostAccountFromList();
        this.setProductDetailInfo();
        this.bindElementInfo();
        this.disableBill();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"initamt"});
        this.changManuorgStatus();
        this.changeSonEntryEnable();
        this.setViewSubItem();
    }

    private void setViewSubItem() {
        boolean isViewSubItem = false;
        Long costaccountId = this.getModel().getDataEntity().getLong("costaccount.id");
        if (!CadEmptyUtils.isEmpty((Long)costaccountId)) {
            isViewSubItem = CostaccountHelper.getCostElementByCostAccount((long)costaccountId);
        }
        if (isViewSubItem) {
            this.showSubItemView(0);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"subitementryadvconap"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"subitementryadvconap"});
        }
    }

    private void showSubItemView(int selectRow) {
        Long costaccountId = this.getModel().getDataEntity().getLong("costaccount.id");
        if (CadEmptyUtils.isEmpty((Long)costaccountId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"subitementryadvconap"});
            return;
        }
        boolean isViewSubItem = CostaccountHelper.getCostElementByCostAccount((long)costaccountId);
        if (!isViewSubItem) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"subitementryadvconap"});
            return;
        }
        DynamicObjectCollection subEntrys = this.getModel().getEntryEntity("subentryentity");
        if (subEntrys == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"subitementryadvconap"});
            return;
        }
        if (subEntrys.size() <= selectRow) {
            this.enableSubItemView();
            return;
        }
        this.getPageCache().put("subIndex", String.valueOf(selectRow));
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"subitementryadvconap"});
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"subitemdel", "subitemadd"});
        DynamicObjectCollection subitemdetail = this.getModel().getDataEntity(true).getDynamicObjectCollection("subitemdetail");
        subitemdetail.clear();
        DynamicObject selectdyn = (DynamicObject)subEntrys.get(selectRow);
        String json = selectdyn.getString("subitemjson_tag");
        List subitems = null;
        if (!StringUtils.isEmpty((Object)json)) {
            subitems = JSON.parseArray((String)json, WipInitSubItem.class);
            subitemdetail.beginInit();
            int i = 0;
            for (WipInitSubItem subitem : subitems) {
                DynamicObject dyn = subitemdetail.addNew();
                dyn.set("selement_id", (Object)subitem.getSelement());
                dyn.set("seq", (Object)i++);
                dyn.set("ssubelement_id", (Object)subitem.getSsubelement());
                dyn.set("samount", (Object)subitem.getSamount());
                dyn.set("syearinamt", (Object)subitem.getSyearinamt());
                dyn.set("syearcomamt", (Object)subitem.getSyearcomamt());
            }
            subitemdetail.endInit();
            BusinessDataServiceHelper.loadRefence((Object[])subitemdetail.toArray((Object[])new DynamicObject[0]), (IDataEntityType)subitemdetail.getDynamicObjectType());
        }
        this.getView().updateView("subitemdetail");
    }

    private void enableSubItemView() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"subitemdel", "subitemadd"});
        DynamicObjectCollection subitemdetail = this.getModel().getDataEntity(true).getDynamicObjectCollection("subitemdetail");
        subitemdetail.clear();
        this.getView().updateView("subitemdetail");
    }

    private void updateSubItemInfo(boolean isUpdateAmt) {
        int subIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
        if (this.getPageCache().get("subIndex") != null) {
            subIndex = Integer.parseInt(this.getPageCache().get("subIndex"));
        }
        DynamicObjectCollection subEntrys = this.getModel().getEntryEntity("subentryentity");
        DynamicObject subObj = (DynamicObject)subEntrys.get(subIndex);
        BigDecimal totalAmt = BigDecimal.ZERO;
        BigDecimal inTotalAmt = BigDecimal.ZERO;
        BigDecimal comTotalAmt = BigDecimal.ZERO;
        ArrayList<WipInitSubItem> subItems = new ArrayList<WipInitSubItem>(10);
        DynamicObjectCollection subitemdetail = this.getModel().getEntryEntity("subitemdetail");
        for (DynamicObject dyn : subitemdetail) {
            WipInitSubItem subItem = new WipInitSubItem();
            subItem.setSelement(Long.valueOf(dyn.getLong("selement.id")));
            subItem.setSsubelement(Long.valueOf(dyn.getLong("ssubelement.id")));
            subItem.setSamount(dyn.getBigDecimal("samount"));
            subItem.setSyearinamt(dyn.getBigDecimal("syearinamt"));
            subItem.setSyearcomamt(dyn.getBigDecimal("syearcomamt"));
            totalAmt = totalAmt.add(subItem.getSamount());
            inTotalAmt = inTotalAmt.add(subItem.getSyearinamt());
            comTotalAmt = comTotalAmt.add(subItem.getSyearcomamt());
            subItems.add(subItem);
        }
        subEntrys.beginInit();
        subObj.set("subitemjson_tag", (Object)JSONObject.toJSONString(subItems));
        if (isUpdateAmt) {
            subObj.set("subamount", (Object)totalAmt);
            subObj.set("matyearinputamt", (Object)inTotalAmt);
            subObj.set("matyearfinishamt", (Object)comTotalAmt);
        } else {
            this.updateSubItemAmt("subamount");
            this.updateSubItemAmt("matyearinputamt");
            this.updateSubItemAmt("matyearfinishamt");
        }
        subEntrys.endInit();
        this.getView().updateView("subentryentity");
    }

    private void updateSubItemAmt(String propertyName) {
        int subIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
        DynamicObjectCollection subEntrys = this.getModel().getEntryEntity("subentryentity");
        DynamicObject subObj = (DynamicObject)subEntrys.get(subIndex);
        BigDecimal amt = subObj.getBigDecimal(propertyName);
        String subitemjson = subObj.getString("subitemjson_tag");
        if (!StringUtils.isEmpty((Object)subitemjson)) {
            List subitems = null;
            if (!StringUtils.isEmpty((Object)subitemjson)) {
                subitems = JSON.parseArray((String)subitemjson, WipInitSubItem.class);
            }
            if (!CadEmptyUtils.isEmpty(subitems)) {
                this.calcWipInitSubItemAmt(subitems, propertyName, amt);
                subObj.set("subitemjson_tag", (Object)JSON.toJSONString((Object)subitems));
                this.showSubItemView(subIndex);
            }
        }
    }

    private void calcWipInitSubItemAmt(List<WipInitSubItem> subitems, String propertyName, BigDecimal adjAmt) {
        if (adjAmt == null) {
            adjAmt = BigDecimal.ZERO;
        }
        if (subitems.size() == 1) {
            this.setSubitemRadio(subitems, BigDecimal.ONE);
        } else if (adjAmt.compareTo(BigDecimal.ZERO) == 0) {
            this.setSubitemRadio(subitems, BigDecimal.ZERO);
        } else {
            BigDecimal dAmt;
            BigDecimal totalAmt = BigDecimal.ZERO;
            BigDecimal absMaxAmt = null;
            for (WipInitSubItem subitem : subitems) {
                dAmt = null;
                dAmt = "subamount".equals(propertyName) ? subitem.getSamount() : ("matyearinputamt".equals(propertyName) ? subitem.getSyearinamt() : subitem.getSyearcomamt());
                totalAmt = totalAmt.add(dAmt);
                if (absMaxAmt != null && dAmt.abs().compareTo(absMaxAmt) <= 0) continue;
                absMaxAmt = dAmt;
            }
            if (totalAmt.compareTo(BigDecimal.ZERO) == 0) {
                totalAmt = absMaxAmt;
            }
            if (totalAmt != null && totalAmt.compareTo(BigDecimal.ZERO) == 0) {
                BigDecimal radio = BigDecimal.ONE.divide(new BigDecimal(subitems.size()), 10, RoundingMode.HALF_UP);
                this.setSubitemRadio(subitems, radio);
            } else {
                for (WipInitSubItem subitem : subitems) {
                    dAmt = null;
                    dAmt = "subamount".equals(propertyName) ? subitem.getSamount() : ("matyearinputamt".equals(propertyName) ? subitem.getSyearinamt() : subitem.getSyearcomamt());
                    subitem.setRadio(dAmt.divide(totalAmt, 10, RoundingMode.HALF_UP));
                }
            }
        }
        BigDecimal diffAmt = adjAmt;
        WipInitSubItem maxSubItem = null;
        int precise = this.getCurrencyPrecision();
        for (WipInitSubItem subitem : subitems) {
            if (maxSubItem == null || maxSubItem.getRadio().compareTo(subitem.getRadio()) < 0) {
                maxSubItem = subitem;
            }
            if ("subamount".equals(propertyName)) {
                subitem.setSamount(subitem.getRadio().multiply(adjAmt).setScale(precise, RoundingMode.HALF_UP));
                diffAmt = diffAmt.subtract(subitem.getSamount());
                continue;
            }
            if ("matyearinputamt".equals(propertyName)) {
                subitem.setSyearinamt(subitem.getRadio().multiply(adjAmt).setScale(precise, RoundingMode.HALF_UP));
                diffAmt = diffAmt.subtract(subitem.getSyearinamt());
                continue;
            }
            subitem.setSyearcomamt(subitem.getRadio().multiply(adjAmt).setScale(precise, RoundingMode.HALF_UP));
            diffAmt = diffAmt.subtract(subitem.getSyearcomamt());
        }
        if (diffAmt.compareTo(BigDecimal.ZERO) != 0 && maxSubItem != null) {
            if ("subamount".equals(propertyName)) {
                maxSubItem.setSamount(maxSubItem.getSamount().add(diffAmt));
            } else if ("matyearinputamt".equals(propertyName)) {
                maxSubItem.setSyearinamt(maxSubItem.getSamount().add(diffAmt));
            } else {
                maxSubItem.setSyearcomamt(maxSubItem.getSamount().add(diffAmt));
            }
        }
    }

    private void setSubitemRadio(List<WipInitSubItem> subitems, BigDecimal radio) {
        for (WipInitSubItem subitem : subitems) {
            subitem.setRadio(radio);
        }
    }

    private int getCurrencyPrecision() {
        DynamicObject currency = this.getModel().getDataEntity().getDynamicObject("currency");
        if (currency == null) {
            return 2;
        }
        return currency.getInt("amtprecision");
    }

    private void disableBill() {
        long costAccountId;
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)status) && AcaCostAccountHelper.isInited((long)(costAccountId = this.getModel().getDataEntity().getDynamicObject("costaccount").getLong("id")), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"fs_costinfo"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"fs_submatinfo"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"fs_baseinfo"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_del"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit"});
        }
    }

    private void bindElementInfo() {
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.ADDNEW.equals((Object)os)) {
            return;
        }
        DynamicObject costType = BusinessDataServiceHelper.loadSingle((Object)CommonConstant.ACA_COST_TYPE_ID, (String)"cad_costtype");
        if (costType == null) {
            return;
        }
        long elementTypeId = costType.getLong("elementtype.id");
        HashSet<Long> elementIds = new HashSet<Long>();
        QFilter qfElementType = new QFilter("elementtype", "=", (Object)elementTypeId);
        QFilter qfEable = new QFilter("enable", "=", (Object)true);
        QFilter qfStatus = new QFilter("status", "=", (Object)"C");
        DynamicObjectCollection element = QueryServiceHelper.query((String)"cad_element", (String)"id", (QFilter[])new QFilter[]{qfElementType, qfEable, qfStatus});
        for (DynamicObject ele : element) {
            elementIds.add(ele.getLong("id"));
        }
        QFilter qfDefaultValue = new QFilter("defaultvalue", "=", (Object)true);
        DynamicObjectCollection subElements = QueryServiceHelper.query((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{qfDefaultValue, qfEable, qfStatus});
        HashSet<Long> subIds = new HashSet<Long>();
        for (DynamicObject sub : subElements) {
            subIds.add(sub.getLong("id"));
        }
        QFilter qfElement = new QFilter("element", "in", elementIds);
        QFilter qfSubElement = new QFilter("subelement", "in", subIds);
        DynamicObjectCollection elementDetail = QueryServiceHelper.query((String)"cad_elementdetail", (String)"element.id,subelement.id", (QFilter[])new QFilter[]{qfElement, qfSubElement, qfElementType}, (String)"element.number");
        if (elementDetail.size() == 0) {
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        HashSet<Long> subEle = new HashSet<Long>();
        for (DynamicObject ele : elementDetail) {
            if (subEle.contains(ele.getLong("subelement.id"))) continue;
            subEle.add(ele.getLong("subelement.id"));
            int index = this.getModel().createNewEntryRow("entryentity");
            this.getModel().beginInit();
            this.getModel().setValue("element", (Object)ele.getLong("element.id"), index);
            this.getModel().setValue("subelement", (Object)ele.getLong("subelement.id"), index);
            this.getModel().endInit();
            this.getModel().setDataChanged(false);
        }
        this.getView().updateView("entryentity");
    }

    private void setCostAccountFromList() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String costAccountId = (String)fsp.getCustomParam("costaccountId");
        if (!CadEmptyUtils.isEmpty((String)costAccountId)) {
            this.getModel().setValue("costaccount", (Object)costAccountId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (propertyName) {
            case "costaccount": {
                CurrencyHelper.setCurrency((IDataModel)this.getModel(), (IFormView)this.getView());
                this.setViewSubItem();
                break;
            }
            case "element": {
                this.getModel().beginInit();
                this.setDefaultSubElement(changeSet[0]);
                this.getModel().endInit();
                this.clearSubEntryEntity(changeSet[0]);
                this.getView().updateView("entryentity");
                break;
            }
            case "subelement": {
                this.getModel().beginInit();
                ElementHelper.setElement((PropertyChangedArgs)e, (IFormView)this.getView());
                this.getModel().endInit();
                this.getView().updateView("entryentity");
                break;
            }
            case "submateriel": {
                this.setSubBaseUnit(changeSet[0]);
                this.changeSonEntryEnable(rowIndex);
                if (this.getPageCache().get("isFromSubMatVersionChanged") != null) {
                    return;
                }
                this.clearSubMatVersion();
                break;
            }
            case "submatversion": {
                this.setSubMat();
                break;
            }
            case "costobject": {
                this.setProductDetailInfo();
                break;
            }
            case "amount": {
                this.setInitAmount();
                break;
            }
            case "org": {
                this.changManuorgStatus();
                break;
            }
            case "ssubelement": {
                DynamicObject subEle = (DynamicObject)this.getView().getModel().getValue("ssubelement", rowIndex);
                if (subEle == null) {
                    return;
                }
                long subElementId = subEle.getLong("id");
                QFilter qfSubElement = new QFilter("subelement", "=", (Object)subElementId);
                DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{qfSubElement});
                if (dySubElement != null) {
                    this.getView().getModel().setValue("selement", (Object)dySubElement.getLong("element"), rowIndex);
                }
                this.updateSubItemInfo(false);
                break;
            }
            case "samount": 
            case "syearinamt": 
            case "syearcomamt": {
                this.updateSubItemInfo(true);
                break;
            }
            case "subamount": 
            case "matyearinputamt": 
            case "matyearfinishamt": {
                this.updateSubItemAmt(propertyName);
            }
        }
    }

    private void setInitAmount() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            BigDecimal amount = dynamicObject.getBigDecimal("amount");
            totalAmount = totalAmount.add(amount);
        }
        this.getModel().setValue("initamt", (Object)totalAmount);
    }

    private void setSubMat() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
        DynamicObject subMatVersionObj = (DynamicObject)this.getModel().getValue("submatversion", entryCurrentRowIndex);
        if (subMatVersionObj == null) {
            return;
        }
        DynamicObject material = subMatVersionObj.getDynamicObject("material");
        if (material == null) {
            return;
        }
        this.getPageCache().put("isFromSubMatVersionChanged", "true");
        this.getModel().setValue("submateriel", (Object)material, entryCurrentRowIndex);
        this.getPageCache().remove("isFromSubMatVersionChanged");
        this.getView().updateView("submateriel", entryCurrentRowIndex);
    }

    private void clearSubMatVersion() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
        this.getModel().beginInit();
        this.getModel().setValue("submatversion", null, entryCurrentRowIndex);
        this.getModel().endInit();
        this.getView().updateView("submatversion", entryCurrentRowIndex);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        switch (operateKey = source.getOperateKey()) {
            case "close": {
                break;
            }
            default: {
                this.checkCostAccountInit(args);
            }
        }
        if ("save".equals(operateKey)) {
            this.setElementBySubElementForElementEmptyRow();
            return;
        }
        if ("submit".equals(operateKey)) {
            this.clearEmptyAmountRow();
            return;
        }
        if ("newsubentry".equals(operateKey)) {
            this.disableEditSubEntry(args);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "newsubentry": {
                this.changeSonEntryEnable();
                break;
            }
            case "subitemdeleteentry": {
                this.updateSubItemInfo(true);
                break;
            }
            case "audit": {
                this.getView().invokeOperation("refresh", OperateOption.create());
                break;
            }
        }
    }

    private void checkCostAccountInit(BeforeDoOperationEventArgs args) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (CadEmptyUtils.isEmpty((DynamicObject)org) || CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
            return;
        }
        if (AcaCostAccountHelper.isInited((long)costAccount.getLong("id"), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u8d26\u7c3f\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u5f53\u524d\u64cd\u4f5c\u3002", (String)"WipCostInitEditPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void clearEmptyAmountRow() {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        ArrayList<Integer> rowsForRemove = new ArrayList<Integer>(10);
        for (DynamicObject row : entryEntity) {
            BigDecimal amount = BigDecimalUtil.getOrZero((Object)row.getBigDecimal("amount"));
            BigDecimal yearInputAmount = BigDecimalUtil.getOrZero((Object)row.getBigDecimal("yearinputamt"));
            BigDecimal yearFinishAmount = BigDecimalUtil.getOrZero((Object)row.getBigDecimal("yearfinishamt"));
            if (amount.compareTo(BigDecimal.ZERO) != 0 || yearInputAmount.compareTo(BigDecimal.ZERO) != 0 || yearFinishAmount.compareTo(BigDecimal.ZERO) != 0) continue;
            rowsForRemove.add(row.getInt("seq") - 1);
        }
        if (!CadEmptyUtils.isEmpty(rowsForRemove)) {
            int[] rowIndexForRemove = new int[rowsForRemove.size()];
            for (int index = 0; index < rowsForRemove.size(); ++index) {
                rowIndexForRemove[index] = (Integer)rowsForRemove.get(index);
            }
            this.getModel().deleteEntryRows("entryentity", rowIndexForRemove);
        }
    }

    private void disableEditSubEntry(BeforeDoOperationEventArgs args) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
        DynamicObject subElement = entryRowEntity.getDynamicObject("subelement");
        if (subElement == null || subElement != null && !CAN_EDIT_SUB_ENTRY_ENTITY_TYPES.contains(subElement.getString("type"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u4fe1\u606f\u00b7\u6210\u672c\u5b50\u8981\u7d20\u4e0d\u662f\u7269\u6599\u6216\u8005\u7269\u6599\u8d39\u7528\u5c5e\u6027\uff0c\u4e0d\u80fd\u7f16\u8f91\u5b50\u7269\u6599\u4fe1\u606f\u3002", (String)"WipCostInitEditPlugin_2", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void setElementBySubElementForElementEmptyRow() {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        HashSet<Long> subElementIdsForElementEmptyRow = new HashSet<Long>(16);
        HashMap<Long, Integer> subElementIdAndRowIndexMap = new HashMap<Long, Integer>(16);
        for (DynamicObject row : entryEntity) {
            DynamicObject subElement = row.getDynamicObject("subelement");
            DynamicObject element = row.getDynamicObject("element");
            if (element != null || subElement == null) continue;
            Long subElementId = (Long)subElement.getPkValue();
            int rowIndex = row.getInt("seq");
            subElementIdsForElementEmptyRow.add(subElementId);
            subElementIdAndRowIndexMap.put(subElementId, rowIndex);
        }
        Map subElementIdAndElementIdMap = new HashMap(16);
        if (subElementIdsForElementEmptyRow.size() > 0) {
            subElementIdAndElementIdMap = ElementRelationHelper.getSubElementIdAndElementIdMap(subElementIdsForElementEmptyRow);
            for (Map.Entry entrySet : subElementIdAndRowIndexMap.entrySet()) {
                this.getModel().setValue("element", subElementIdAndElementIdMap.get(entrySet.getKey()), (Integer)entrySet.getValue() - 1);
            }
        }
    }

    private void setProductDetailInfo() {
        DynamicObject costObject = this.getModel().getDataEntity().getDynamicObject("costobject");
        if (CadEmptyUtils.isEmpty((DynamicObject)costObject)) {
            return;
        }
        DynamicObject material = costObject.getDynamicObject("material");
        Map matBaseUnit = MatHelper.getMatBaseUnit(Collections.singleton((Long)material.getPkValue()));
        if (matBaseUnit != null && matBaseUnit.size() > 0) {
            this.getModel().setValue("baseunit", matBaseUnit.get(material.getPkValue()));
        }
        this.getModel().setValue("auxpty", (Object)costObject.getLong("auxpty.id"));
        this.getModel().setValue("assignedproduct", (Object)material);
        this.getModel().setDataChanged(false);
    }

    private void setSubBaseUnit(ChangeData changeData) {
        DynamicObject row = changeData.getDataEntity();
        if (CadEmptyUtils.isEmpty((DynamicObject)row)) {
            return;
        }
        DynamicObject baseUnit = row.getDynamicObject("submateriel.baseunit");
        row.set("subbaseunit", (Object)baseUnit);
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
        this.getView().updateView("subbaseunit", entryCurrentRowIndex);
    }

    private void clearSubEntryEntity(ChangeData changeData) {
        String newValueType;
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
        if (newValue == null || oldValue == null) {
            return;
        }
        String oldValueType = oldValue.getString("type");
        if (!oldValueType.equals(newValueType = newValue.getString("type"))) {
            changeData.getDataEntity().getDynamicObjectCollection("subentryentity").clear();
            this.getView().updateView("subentryentity");
        }
    }

    private void setDefaultSubElement(ChangeData changeData) {
        DynamicObject row = changeData.getDataEntity();
        DynamicObject element = row.getDynamicObject("element");
        if (CadEmptyUtils.isEmpty((DynamicObject)element)) {
            return;
        }
        QFilter elementIdFilter = new QFilter("element", "=", element.getPkValue());
        DynamicObjectCollection defaultSubElement = ElementRelationHelper.getDefaultSubElement((QFilter)elementIdFilter);
        Set<Long> selectedSubElementIds = this.getSelectedSubElementIds();
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)defaultSubElement) || selectedSubElementIds.contains(((DynamicObject)defaultSubElement.get(0)).getLong("subElementId"))) {
            row.set("subelement", null);
            return;
        }
        int rowIndex = changeData.getRowIndex();
        this.getModel().setValue("subelement", ((DynamicObject)defaultSubElement.get(0)).get("subElementId"), rowIndex);
    }

    private void subMatVersionF7Setting() {
        BasedataEdit subMatVersionEdit = (BasedataEdit)this.getControl("submatversion");
        subMatVersionEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
            DynamicObject subMaterial = (DynamicObject)this.getModel().getValue("submateriel", entryCurrentRowIndex);
            if (subMaterial != null) {
                Object subMatId = subMaterial.getPkValue();
                QFilter subMatIdFilter = new QFilter("material", "=", subMatId);
                List versionIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_bomversion", (QFilter[])new QFilter[]{subMatIdFilter}, null, (int)-1);
                QFilter versionIdsFilter = new QFilter("id", "in", (Object)versionIds);
                filterParameter.getQFilters().add(versionIdsFilter);
            }
        });
    }

    private void changManuorgStatus() {
        DynamicObject accountorg = (DynamicObject)this.getModel().getValue("org");
        if (accountorg != null && OrgHelper.isOrgEnableMultiFactory((Long)((Long)accountorg.getPkValue()))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manuorg"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manuorg"});
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if ("entryentity".equals(entryGrid.getEntryKey())) {
            this.changeSonEntryEnable();
        } else if ("subentryentity".equals(entryGrid.getEntryKey())) {
            this.showSubItemView(evt.getRow());
        }
    }

    private void changeSonEntryEnable() {
        int rowCount = this.getModel().getEntryRowCount("subentryentity");
        if (rowCount >= 0) {
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject material = (DynamicObject)this.getModel().getValue("submateriel", i);
                Boolean isenablematerialversion = false;
                Boolean isuseauxptyFlag = false;
                if (material != null) {
                    Boolean isuseauxpty;
                    isenablematerialversion = material.getBoolean("isenablematerialversion");
                    isuseauxptyFlag = isuseauxpty = Boolean.valueOf(material.getBoolean("isuseauxpty"));
                }
                this.getView().setEnable(isenablematerialversion, i, new String[]{"submatversion"});
                this.getView().setEnable(isuseauxptyFlag, i, new String[]{"subauxpty"});
            }
            this.showSubItemView(0);
        }
    }

    private void changeSonEntryEnable(int rowIndex) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("submateriel", rowIndex);
        Boolean isenablematerialversion = false;
        Boolean isuseauxptyFlag = false;
        if (material != null) {
            isenablematerialversion = material.getBoolean("isenablematerialversion");
            isuseauxptyFlag = material.getBoolean("isuseauxpty");
        }
        this.getView().setEnable(isenablematerialversion, rowIndex, new String[]{"submatversion"});
        this.getView().setEnable(isuseauxptyFlag, rowIndex, new String[]{"subauxpty"});
    }
}

