/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.realtime;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.macc.aca.formplugin.base.BaseOrgAndCostAccountListPlugin;
import kd.macc.cad.common.enums.AcaMutexEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.AcaMutexHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import net.sf.json.JSONObject;

public class RealTimeCalcLogListPlugin
extends BaseOrgAndCostAccountListPlugin {
    private static final String closeBack_Date = "dateModify";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "recalcbytime": {
                List<Object> orgCache = this.getOrgCache();
                if (CadEmptyUtils.isEmpty(orgCache)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"RealTimeCalcLogListPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    return;
                }
                String costAccount = this.getPageCache().get("costaccount");
                if (CadEmptyUtils.isEmpty((String)costAccount)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"RealTimeCalcLogListPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showDateSelectPage(costAccount);
            }
        }
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        List<Object> orgIdList;
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("costaccount") && !CadEmptyUtils.isEmpty(orgIdList = this.getOrgCache())) {
            QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnabledFilter(orgIdList, (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            args.getQfilters().clear();
            args.getQfilters().add(enabledCostAccountIdsFilter);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
    }

    private void showDateSelectPage(String costAccount) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("aca_realtimecalcdate");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("costaccount", (Object)costAccount);
        fsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), closeBack_Date));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "dateModify": {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (returnData == null) {
                    return;
                }
                List<Object> orgCache = this.getOrgCache();
                if (CadEmptyUtils.isEmpty(orgCache)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"RealTimeCalcLogListPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    return;
                }
                String costAccount = this.getPageCache().get("costaccount");
                if (CadEmptyUtils.isEmpty((String)costAccount)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"RealTimeCalcLogListPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    return;
                }
                String lockErrStr = AcaMutexHelper.requireMutex((AcaMutexEnum)AcaMutexEnum.REALTIME_CALCULATE, (long)Long.parseLong(costAccount));
                if (StringUtils.isNotEmpty((String)lockErrStr)) {
                    this.getView().showErrorNotification(lockErrStr);
                    return;
                }
                Date startDate = (Date)returnData.get("startDate");
                Date endDate = (Date)returnData.get("endDate");
                JSONObject params = new JSONObject();
                params.accumulate("orgId", orgCache.get(0));
                params.accumulate("costAccountId", Long.parseLong(costAccount));
                params.accumulate("type", (Object)"1");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                if (startDate != null) {
                    params.accumulate("startDate", (Object)simpleDateFormat.format(startDate));
                }
                if (endDate != null) {
                    params.accumulate("endDate", (Object)simpleDateFormat.format(endDate));
                }
                ThreadPools.executeOnce((String)"RealTimeCalcLogListPlugin.recalcbytime", () -> DispatchServiceHelper.invokeBizService((String)"macc", (String)"aca", (String)"RealTimeCalcService", (String)"actRealTimeCalc", (Object[])new Object[]{SerializationUtils.toJsonString((Object)params)}));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540e\u53f0\u91cd\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u91cd\u7b97\u7ed3\u679c\u3002", (String)"RealTimeCalcLogListPlugin_3", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }
}

