/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.realtime;

import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.aca.formplugin.base.BaseOrgAndCostAccountListPlugin;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class RealTimeMfgFeeRateListPlugin
extends BaseOrgAndCostAccountListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn;
            String fieldName;
            List<Object> orgCache = this.getOrgCache();
            String orgId = null;
            if (CadEmptyUtils.isEmpty(orgCache)) {
                long currentOrgId = RequestContext.getOrCreate().getOrgId();
                boolean isAccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
                if (isAccount) {
                    orgId = String.valueOf(currentOrgId);
                }
            } else {
                orgId = (String)orgCache.get(0);
            }
            if (!(fieldName = (commonFilterColumn = (CommonFilterColumn)filterColumn).getFieldName()).startsWith("costcenter.")) continue;
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            List<ComboItem> comboItems = this.getCostCenterComboItemListBy(orgId);
            if (CollectionUtils.isEmpty(comboItems)) continue;
            commonFilterColumn.setComboItems(comboItems);
        }
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        List<Object> orgIdList;
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("costcenter")) {
            Long orgId;
            List<Object> orgIdList2 = this.getOrgCache();
            if (!CadEmptyUtils.isEmpty(orgIdList2) && !CadEmptyUtils.isEmpty((Long)(orgId = Long.valueOf(String.valueOf(orgIdList2.get(0)))))) {
                QFilter filter = new QFilter("accountorg", "=", (Object)orgId);
                filter.and("enable", "=", (Object)Boolean.TRUE);
                filter.and("orgduty", "=", (Object)4L);
                args.getQfilters().add(filter);
            }
        } else if (fieldName.startsWith("costaccount") && !CadEmptyUtils.isEmpty(orgIdList = this.getOrgCache())) {
            QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnabledFilter(orgIdList, (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
            args.getQfilters().clear();
            args.getQfilters().add(enabledCostAccountIdsFilter);
        }
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs e) {
        super.filterContainerSearchClick(e);
        Map filterValues = e.getSearchClickEvent().getFilterValues();
        List customfilter = (List)filterValues.get("customfilter");
        if (customfilter == null || customfilter.isEmpty()) {
            return;
        }
        String costcenterPageCache = null;
        for (int i = 0; i < customfilter.size(); ++i) {
            List vals;
            Map map = (Map)customfilter.get(i);
            List names = (List)map.get("FieldName");
            if (!"costcenter.id".equals(String.valueOf(names.get(0))) || (vals = (List)map.get("Value")) == null || vals.isEmpty()) continue;
            costcenterPageCache = String.valueOf(vals.get(0));
        }
        if (costcenterPageCache != null) {
            this.getPageCache().put("costcenter", costcenterPageCache);
        }
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter bsp = e.getParameter();
        String costCenter = this.getPageCache().get("costcenter");
        bsp.setCustomParam("costcenter", (Object)costCenter);
    }
}

