/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.wipcostcheck;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.algox.enums.TerminalWipMatEnum;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CheckSettingEditPlugin
extends AbstractFormPlugin
implements ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button confirm = (Button)this.getView().getControl("btnok");
        confirm.addClickListener((ClickListener)this);
        BasedataEdit calOrgBase = (BasedataEdit)this.getControl("org");
        calOrgBase.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getHasPermOrgIdsByOrgViewType((String)"10");
            qFilters.add(new QFilter("id", "in", (Object)hasPermOrgIdsByOrgViewType));
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object calOrgData = this.getModel().getValue("org");
        IFormView parentView = this.getView().getParentView();
        if (calOrgData == null && parentView != null) {
            String useOrg = parentView.getPageCache().get("org");
            if (useOrg != null) {
                List orgList = JSON.parseArray((String)useOrg, String.class);
                useOrg = (String)orgList.get(0);
            }
            if (StringUtils.isNotEmpty((CharSequence)useOrg)) {
                this.getModel().setValue("org", (Object)useOrg);
                Object[] orgDatas = BusinessDataServiceHelper.load((String)"aca_checksetting", (String)"org,checktype,checkcal", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(useOrg))});
                if (!CadEmptyUtils.isEmpty((Object[])orgDatas)) {
                    Object orgData = orgDatas[0];
                    this.getModel().setValue("checktype", orgData.get("checktype"));
                    this.getModel().setValue("checkcal", orgData.get("checkcal"));
                }
            }
            this.getView().updateView("org");
            this.getView().updateView("checktype");
            this.getView().updateView("checkcal");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("btnok")) {
            this.saveData(false);
        }
    }

    private void saveData(Boolean callBack) {
        Object saveData;
        Long orgId;
        Throwable throwable;
        TXHandle tx;
        Object checkcal;
        Object checktype;
        HashMap<String, String> opFlag;
        block23: {
            block24: {
                block25: {
                    Map.Entry<Long, Long> entry;
                    opFlag = new HashMap<String, String>();
                    DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                    checktype = this.getModel().getValue("checktype");
                    checkcal = this.getModel().getValue("checkcal");
                    if (org == null || checktype == null || checkcal == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u6216\u76d8\u70b9\u65b9\u5f0f\u6216\u76d8\u70b9\u5206\u914d\u7b97\u6cd5\u672a\u586b\u5199\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CheckSettingEditPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    tx = TX.required();
                    throwable = null;
                    orgId = (Long)org.getPkValue();
                    QFilter qFilter = new QFilter("org", "=", (Object)orgId);
                    Object[] load = BusinessDataServiceHelper.load((String)"aca_checksetting", (String)"org,checktype,checkcal", (QFilter[])new QFilter[]{qFilter});
                    if (CadEmptyUtils.isEmpty((Object[])load)) {
                        saveData = BusinessDataServiceHelper.newDynamicObject((String)"aca_checksetting");
                        break block23;
                    }
                    saveData = load[0];
                    if (callBack.booleanValue() || checktype.equals(saveData.getString("checktype"))) break block23;
                    Map<Long, Long> costAccountAndPeriodMap = this.getCostAccountAndPeriod(orgId);
                    Boolean exists = false;
                    Iterator<Map.Entry<Long, Long>> iterator = costAccountAndPeriodMap.entrySet().iterator();
                    while (iterator.hasNext() && !(exists = this.checkExtisData(orgId, entry = iterator.next())).booleanValue()) {
                    }
                    if (!exists.booleanValue()) break block23;
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u76d8\u70b9\u65b9\u5f0f\uff0c\u5c06\u6e05\u9664\u8be5\u7ec4\u7ec7\u672c\u671f\u7684\u6240\u6709\u671f\u672b\u6750\u6599\u5728\u4ea7\u76d8\u70b9\u7684\u6570\u636e\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u5207\u6362\u3002", (String)"CheckSettingEditPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("changechecktype", (IFormPlugin)this));
                    if (tx == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block24;
                }
                tx.close();
            }
            return;
        }
        try {
            try {
                saveData.set("org", (Object)orgId);
                saveData.set("checktype", checktype);
                saveData.set("checkcal", checkcal);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saveData});
                int deleteNum = 0;
                if (callBack.booleanValue()) {
                    Map<Long, Long> costAccountAndPeriodMap = this.getCostAccountAndPeriod(orgId);
                    for (Map.Entry<Long, Long> entry : costAccountAndPeriodMap.entrySet()) {
                        int num = this.deleteData(orgId, entry);
                        deleteNum += num;
                    }
                }
                String addtips = "";
                if (deleteNum > 0) {
                    addtips = String.format(ResManager.loadKDString((String)"\u5220\u9664\u5728\u4ea7\u6750\u6599\u76d8\u70b9\u6570\u636e%s\u6761\u3002", (String)"CheckSettingEditPlugin_2", (String)"macc-aca-formplugin", (Object[])new Object[0]), deleteNum);
                }
                opFlag.put("tips", String.format(ResManager.loadKDString((String)"\u76d8\u70b9\u8bbe\u7f6e\u4fdd\u5b58\u6210\u529f\u3002%s", (String)"CheckSettingEditPlugin_3", (String)"macc-aca-formplugin", (Object[])new Object[0]), addtips));
                this.getView().returnDataToParent(opFlag);
                this.getView().close();
            }
            catch (Exception e) {
                tx.markRollback();
                opFlag.put("tips", String.format(ResManager.loadKDString((String)"\u76d8\u70b9\u8bbe\u7f6e\u4fdd\u5b58\u5931\u8d25\u3002%s", (String)"CheckSettingEditPlugin_4", (String)"macc-aca-formplugin", (Object[])new Object[0]), e.getMessage()));
                this.getView().returnDataToParent(opFlag);
                this.getView().close();
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private Boolean checkExtisData(Long orgId, Map.Entry<Long, Long> entry) {
        Long account = entry.getKey();
        Long period = entry.getValue();
        if (CadEmptyUtils.isEmpty((Long)account) || CadEmptyUtils.isEmpty((Long)period)) {
            return false;
        }
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQf = new QFilter("costaccount", "=", (Object)account);
        QFilter periodQf = new QFilter("period", "=", (Object)period);
        QFilter[] qFilters = new QFilter[]{orgQf, costaccountQf, periodQf};
        return QueryServiceHelper.exists((String)"aca_terminalwipmatcheck", (QFilter[])qFilters);
    }

    private int deleteData(Long orgId, Map.Entry<Long, Long> entry) {
        Long account = entry.getKey();
        Long period = entry.getValue();
        if (CadEmptyUtils.isEmpty((Long)account) || CadEmptyUtils.isEmpty((Long)period)) {
            return 0;
        }
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQf = new QFilter("costaccount", "=", (Object)account);
        QFilter periodQf = new QFilter("period", "=", (Object)period);
        QFilter[] qFilters = new QFilter[]{orgQf, costaccountQf, periodQf};
        int delete = DeleteServiceHelper.delete((String)"aca_terminalwipmatcheck", (QFilter[])qFilters);
        DeleteServiceHelper.delete((String)"aca_terminalwipmatallco", (QFilter[])qFilters);
        return delete;
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        MessageBoxResult result = evt.getResult();
        if ("changechecktype".equals(evt.getCallBackId()) && MessageBoxResult.Yes.equals((Object)result)) {
            this.saveData(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("org".equals(proName)) {
            if (newValue != null) {
                Object[] orgDatas = BusinessDataServiceHelper.load((String)"aca_checksetting", (String)"org,checktype,checkcal", (QFilter[])new QFilter[]{new QFilter("org", "=", ((DynamicObject)newValue).getPkValue())});
                if (!CadEmptyUtils.isEmpty((Object[])orgDatas)) {
                    Object orgData = orgDatas[0];
                    this.getModel().setValue("checktype", orgData.get("checktype"));
                    this.getModel().setValue("checkcal", orgData.get("checkcal"));
                } else {
                    this.getModel().setValue("checktype", (Object)"qty");
                    this.getModel().setValue("checkcal", (Object)TerminalWipMatEnum.CHECKCAL_EQUIVALENT.getValue());
                }
            } else {
                this.getModel().setValue("checktype", (Object)"qty");
                this.getModel().setValue("checkcal", (Object)TerminalWipMatEnum.CHECKCAL_EQUIVALENT.getValue());
            }
            this.getView().updateView("org");
            this.getView().updateView("checktype");
            this.getView().updateView("checkcal");
        }
    }

    protected Map<Long, Long> getCostAccountAndPeriod(Long orgId) {
        QFilter filter = null;
        if (!CadEmptyUtils.isEmpty((Long)orgId)) {
            filter = new QFilter("calorg", "=", (Object)orgId);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty((Long)orgId) && filter != null) {
            filter.and(StartCostHelper.getEnabledCostAccountIdsFilter((Long)orgId, (String)this.getView().getFormShowParameter().getAppId()));
        }
        HashMap<Long, Long> costAccountAndPeriodMap = new HashMap<Long, Long>();
        List cal_bd_costaccount = QueryServiceHelper.queryPrimaryKeys((String)"cal_bd_costaccount", (QFilter[])new QFilter[]{filter, statusFilter, enableFilter}, null, (int)-1);
        if (CollectionUtils.isEmpty((Collection)cal_bd_costaccount)) {
            return costAccountAndPeriodMap;
        }
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "in", (Object)cal_bd_costaccount);
        QFilter isInitFilter = new QFilter("entry.isenabled", "=", (Object)Character.valueOf('1'));
        DataSet cal_sysctrlentity = QueryServiceHelper.queryDataSet((String)"", (String)"cal_sysctrlentity", (String)"entry.currentperiod as currentperiod,entry.costaccount as costaccount", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, isInitFilter}, null);
        while (cal_sysctrlentity.hasNext()) {
            Row row = cal_sysctrlentity.next();
            Long costaccount = row.getLong("costaccount");
            Long currentperiod = row.getLong("currentperiod");
            costAccountAndPeriodMap.put(costaccount, currentperiod);
        }
        return costAccountAndPeriodMap;
    }
}

