/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.formplugin.wipcostcheck;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.aca.algox.enums.TerminalWipMatEnum;
import kd.macc.aca.business.wipcostcheck.TerminalWipMatAllocService;
import kd.macc.aca.business.wipcostcheck.TerminalWipMatCheckService;
import kd.macc.aca.formplugin.base.BaseOrgAndCostAccountListPlugin;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class TerminalWipMatCheckListPlugin
extends BaseOrgAndCostAccountListPlugin {
    private static List<ComboItem> costCenterComboItemListBy;

    public void setFilter(SetFilterEvent e) {
        List qFilters;
        Object formBill = this.getView().getFormShowParameter().getCustomParam("formBill");
        List<Object> orgCache = this.getOrgCache();
        if (CadEmptyUtils.isEmpty(orgCache) && formBill == null) {
            qFilters = e.getQFilters();
            qFilters.add(new QFilter("org", "=", (Object)0L));
        }
        if ("aca_terminalwipmatrpt".equals(formBill)) {
            Object costaccount;
            qFilters = e.getQFilters();
            Object org = this.getView().getFormShowParameter().getCustomParam("org");
            if (org != null) {
                qFilters.add(new QFilter("org", "=", org));
            }
            if ((costaccount = this.getView().getFormShowParameter().getCustomParam("costaccount")) != null) {
                qFilters.add(new QFilter("costaccount", "=", costaccount));
            }
            qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            String fieldName = filterColumn.getFieldName();
            if (!fieldName.startsWith("costcenter.")) continue;
            String useOrg = this.getPageCache().get("org");
            if (useOrg != null) {
                List orgList = JSON.parseArray((String)useOrg, String.class);
                useOrg = (String)orgList.get(0);
            }
            if (StringUtils.isNotEmpty((CharSequence)useOrg)) {
                costCenterComboItemListBy = this.getCostCenterComboItemListBy(useOrg);
                if (CollectionUtils.isEmpty(costCenterComboItemListBy)) {
                    ((CommonFilterColumn)filterColumn).setComboItems(new ArrayList());
                    this.getPageCache().put("costCenterFlag", "N");
                    continue;
                }
                ((CommonFilterColumn)filterColumn).setComboItems(costCenterComboItemListBy);
                this.getPageCache().put("costCenterFlag", "Y");
                continue;
            }
            ((CommonFilterColumn)filterColumn).setComboItems(new ArrayList());
            this.getPageCache().put("costCenterFlag", "N");
        }
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs e) {
        super.filterContainerSearchClick(e);
        Map filterValues = e.getSearchClickEvent().getFilterValues();
        List customfilter = (List)filterValues.get("customfilter");
        if (customfilter == null || customfilter.isEmpty()) {
            return;
        }
        for (int i = 0; i < customfilter.size(); ++i) {
            Set costCenterIdsSet;
            Map map = (Map)customfilter.get(i);
            List names = (List)map.get("FieldName");
            if (!"costcenter.id".equals(String.valueOf(names.get(0)))) continue;
            List vals = (List)map.get("Value");
            if (vals == null || vals.isEmpty()) {
                this.getPageCache().put("costcenter", "");
                continue;
            }
            String costcenter = this.getPageCache().get("costCenterFlag");
            if ("N".equals(costcenter)) {
                vals.clear();
                vals.add("");
            } else if ("Y".equals(costcenter) && !CadEmptyUtils.isEmpty(costCenterComboItemListBy) && !(costCenterIdsSet = costCenterComboItemListBy.stream().map(o -> o.getValue()).collect(Collectors.toSet())).contains(vals.get(0))) {
                vals.clear();
                vals.add("");
            }
            String val = String.valueOf(vals.get(0));
            this.getPageCache().put("costcenter", val);
        }
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("org")) {
            args.getQfilters().add(new QFilter("id", "in", (Object)ImportServiceHelper.getHasPermOrgIdsByOrgViewType((String)"10")));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String operationKey;
        super.beforeItemClick(evt);
        switch (operationKey = evt.getOperationKey()) {
            case "alloc": 
            case "importbyhand": {
                String useOrg = this.getPageCache().get("org");
                if (useOrg != null) {
                    List orgList = JSON.parseArray((String)useOrg, String.class);
                    useOrg = (String)orgList.get(0);
                }
                String costaccount = this.getPageCache().get("costaccount");
                if (!CadEmptyUtils.isEmpty((String)useOrg) && !StringUtils.isEmpty((CharSequence)costaccount)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u6216\u8005\u6210\u672c\u8d26\u7c3f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TerminalWipMatCheckListPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemkey;
        switch (itemkey = evt.getItemKey()) {
            case "checkSetting": {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("aca_checksetting");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "checkSetting"));
                this.getView().showForm(formShowParameter);
                break;
            }
            case "importmftstock": 
            case "bar_alloc": {
                Long costaccountId;
                String useOrg = this.getPageCache().get("org");
                if (useOrg != null) {
                    List orgList = JSON.parseArray((String)useOrg, String.class);
                    useOrg = (String)orgList.get(0);
                }
                String costaccount = this.getPageCache().get("costaccount");
                if (CadEmptyUtils.isEmpty((String)useOrg) || StringUtils.isEmpty((CharSequence)costaccount)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u6216\u8005\u6210\u672c\u8d26\u7c3f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TerminalWipMatCheckListPlugin_0", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long orgId = Long.parseLong(useOrg);
                DynamicObject currPeriodAndDate = this.getCurrPeriodAndDate(orgId, costaccountId = Long.valueOf(Long.parseLong(costaccount)));
                if (currPeriodAndDate == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u7ec4\u7ec7\u4e0b\u6210\u672c\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TerminalWipMatCheckListPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long currentperiod = currPeriodAndDate.getLong("currentperiod");
                Date enddate = currPeriodAndDate.getDate("enddate");
                String costcenter = this.getPageCache().get("costcenter");
                Long costcenterId = StringUtils.isEmpty((CharSequence)costcenter) ? null : Long.valueOf(Long.parseLong(costcenter));
                String tips = "";
                if ("importmftstock".equals(itemkey)) {
                    Boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)orgId, (String)"aca", (String)"aca_terminalwipmatcheck", (String)"2BF6M+0B1PSO") == 1;
                    if (!hasPerm.booleanValue()) {
                        return;
                    }
                    if (!this.checkimportmftstock(orgId, costaccountId, currentperiod).booleanValue()) {
                        return;
                    }
                    tips = new TerminalWipMatCheckService().importDataByHand(orgId, costaccountId, enddate, costcenterId, false);
                } else {
                    Boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)orgId, (String)"aca", (String)"aca_terminalwipmatcheck", (String)"2BF6NNZGAIZ7") == 1;
                    if (!hasPerm.booleanValue()) {
                        return;
                    }
                    BillList billList = (BillList)this.getControl("billlistap");
                    ListSelectedRowCollection rows = billList.getSelectedRows();
                    Tuple<Set<Long>, Set<Long>> selectIdAndEntryIds = this.getSelectIds(rows);
                    OperationResult allocOp = OperationServiceHelper.executeOperate((String)"alloc", (String)"aca_terminalwipmatcheck", (Object[])((Set)selectIdAndEntryIds.item1).toArray());
                    List successPkIds = allocOp.getSuccessPkIds();
                    if (successPkIds.size() > 0) {
                        TerminalWipMatAllocService terminalWipMatAllocService = new TerminalWipMatAllocService();
                        tips = terminalWipMatAllocService.doTerminalWipMatAlloc(successPkIds, orgId, costaccountId, costcenterId, currPeriodAndDate, (Set)selectIdAndEntryIds.item2);
                    }
                    tips = tips + this.generateValidateErrMessage(allocOp);
                }
                this.getView().invokeOperation("refresh");
                if (StringUtils.isEmpty((CharSequence)tips)) break;
                this.getView().showMessage(tips);
                break;
            }
            case "assignquery": {
                String orgStr = this.getPageCache().get("org");
                if (orgStr == null) {
                    return;
                }
                List orgList = JSON.parseArray((String)orgStr, String.class);
                if (CadEmptyUtils.isEmpty((List)orgList)) {
                    return;
                }
                Long org = Long.parseLong((String)orgList.get(0));
                Boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)org, (String)"aca", (String)"aca_terminalwipmatcheck", (String)"2BF6P7X=5LHZ") == 1;
                if (!hasPerm.booleanValue()) {
                    return;
                }
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection rows = billList.getSelectedRows();
                if (CadEmptyUtils.isEmpty((ListSelectedRowCollection)rows)) {
                    return;
                }
                Tuple<Set<Long>, Set<Long>> selectIdAndEntryIds = this.getSelectIds(rows);
                QFilter entryIdQf = new QFilter("entryentity.id", "in", selectIdAndEntryIds.item2);
                QFilter allocstatusQf = new QFilter("entryentity.allocstatus", "=", (Object)TerminalWipMatEnum.ALLOCSTATUS_UNALLOC.getValue());
                boolean exists = QueryServiceHelper.exists((String)"aca_terminalwipmatcheck", (QFilter[])new QFilter[]{entryIdQf, allocstatusQf});
                if (exists) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5206\u914d\u7684\u6570\u636e\u3002", (String)"TerminalWipMatCheckListPlugin_2", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                    return;
                }
                ReportShowParameter reportShowParameter = new ReportShowParameter();
                ReportQueryParam queryParam = new ReportQueryParam();
                reportShowParameter.setFormId("aca_terminalwipmatrpt");
                OpenStyle style = new OpenStyle();
                style.setShowType(ShowType.MainNewTabPage);
                reportShowParameter.setOpenStyle(style);
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("entryids", selectIdAndEntryIds.item2);
                customParams.put("org", org);
                customParams.put("costaccount", this.getPageCache().get("costaccount"));
                reportShowParameter.setCustomParams(customParams);
                queryParam.getCustomParam().put("entryids", selectIdAndEntryIds.item2);
                reportShowParameter.setQueryParam(queryParam);
                reportShowParameter.setHasRight(true);
                this.getView().showForm((FormShowParameter)reportShowParameter);
            }
        }
    }

    @Override
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        List orgList;
        BillShowParameter bsp = e.getParameter();
        String acctOrg = this.getPageCache().get(this.ORG_FIELD);
        String costaccount = this.getPageCache().get("costaccount");
        String costcenter = this.getPageCache().get("costcenter");
        if (CadEmptyUtils.isEmpty((String)acctOrg)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"TerminalWipMatCheckListPlugin_3", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if (CadEmptyUtils.isEmpty((String)costaccount)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"TerminalWipMatCheckListPlugin_4", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        bsp.setCustomParam(this.ORG_FIELD, (Object)acctOrg);
        if (!kd.bos.util.StringUtils.isEmpty((String)acctOrg) && (orgList = (List)SerializationUtils.fromJsonString((String)acctOrg, List.class)) != null && !orgList.isEmpty()) {
            bsp.setCustomParam("orgId", orgList.get(0));
        }
        bsp.setCustomParam("costaccount", (Object)costaccount);
        bsp.setCustomParam("costcenter", (Object)costcenter);
    }

    protected Tuple<Set<Long>, Set<Long>> getSelectIds(ListSelectedRowCollection rows) {
        HashSet<Long> idSet = new HashSet<Long>();
        HashSet<Long> entryIdSet = new HashSet<Long>();
        for (int i = 0; i < rows.size(); ++i) {
            Long id = (Long)rows.get(i).getPrimaryKeyValue();
            Long entryId = (Long)rows.get(i).getEntryPrimaryKeyValue();
            idSet.add(id);
            entryIdSet.add(entryId);
        }
        return new Tuple(idSet, entryIdSet);
    }

    private Boolean checkimportmftstock(Long orgId, Long costaccountId, Long currPeriodEndDate) {
        if (currPeriodEndDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u7ec4\u7ec7\u4e0b\u6210\u672c\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TerminalWipMatCheckListPlugin_1", (String)"macc-aca-formplugin", (Object[])new Object[0]));
            return false;
        }
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQf = new QFilter("costaccount", "=", (Object)costaccountId);
        String costcenter = this.getPageCache().get("costcenter");
        if (!StringUtils.isEmpty((CharSequence)costcenter)) {
            orgQf.and(new QFilter("costcenter", "=", (Object)Long.parseLong(costcenter)));
        }
        QFilter bookdateQf = new QFilter("period", "=", (Object)currPeriodEndDate);
        boolean exists = QueryServiceHelper.exists((String)"aca_terminalwipmatcheck", (QFilter[])new QFilter[]{orgQf, costaccountQf, bookdateQf});
        if (exists) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6267\u884c\u7cfb\u7edf\u6570\u636e\u5f15\u5165\uff0c\u4f1a\u6e05\u7a7a\u5df2\u5b58\u5728\u7684\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TerminalWipMatCheckListPlugin_5", (String)"macc-aca-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener("callbackkey_delete", (IFormPlugin)this));
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        switch (callBackId) {
            case "callbackkey_delete": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                String useOrg = this.getPageCache().get("org");
                if (useOrg != null) {
                    List orgList = JSON.parseArray((String)useOrg, String.class);
                    useOrg = (String)orgList.get(0);
                }
                String costaccount = this.getPageCache().get("costaccount");
                Long orgId = Long.parseLong(useOrg);
                Long costaccountId = Long.parseLong(costaccount);
                String costcenter = this.getPageCache().get("costcenter");
                Long costcenterId = StringUtils.isEmpty((CharSequence)costcenter) ? null : Long.valueOf(Long.parseLong(costcenter));
                DynamicObject currPeriodAndDate = this.getCurrPeriodAndDate(orgId, costaccountId);
                Date currPeriodEndDate = currPeriodAndDate.getDate("enddate");
                String tips = new TerminalWipMatCheckService().importDataByHand(orgId, costaccountId, currPeriodEndDate, costcenterId, true);
                this.getView().invokeOperation("refresh");
                if (StringUtils.isEmpty((CharSequence)tips)) break;
                this.getView().showMessage(tips);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"checkSetting")) {
            HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            if (returnData.get("tips") == null) {
                return;
            }
            this.getView().showSuccessNotification((String)returnData.get("tips"));
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if ("copy".equals(operateKey)) {
            this.getView().getPageCache().put("copy", "copy");
        } else {
            this.getView().getPageCache().put("copy", null);
        }
        switch (operateKey) {
            case "new": {
                boolean flag = PermissionServiceHelper.hasNewPermission((long)RequestContext.get().getCurrUserId(), (String)"aca", (String)"aca_equivalent");
                if (flag) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5728\u4ea7\u6750\u6599\u76d8\u70b9\u201d\u7684\u201c\u65b0\u589e\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"TerminalWipMatCheckListPlugin_6", (String)"macc-aca-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    private DynamicObject getCurrPeriodAndDate(Long orgId, Long costAccountId) {
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        QFilter isInitFilter = new QFilter("entry.isenabled", "=", (Object)Character.valueOf('1'));
        DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod as currentperiod,entry.currentperiod.begindate as begindate,entry.currentperiod.enddate as enddate", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, isInitFilter});
        return res;
    }

    private String generateValidateErrMessage(OperationResult res) {
        List validateErrors = res.getValidateResult().getValidateErrors();
        StringBuilder tip = new StringBuilder();
        for (ValidateResult validateRes : validateErrors) {
            List allErrorInfo = validateRes.getAllErrorInfo();
            for (OperateErrorInfo errorInfo : allErrorInfo) {
                String message = errorInfo.getMessage();
                tip.append(message).append("\r\n");
            }
        }
        return tip.toString();
    }
}

