/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class AcaCostAccountHelper {
    public static QFilter getInitCostAccountIdsFilter(Long orgId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)"aca");
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{orgFilter, qfAppNum, isInitFilter, isEnabledFilter};
        DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filters);
        if (costAccountIds != null && costAccountIds.size() > 0) {
            Set costAccountIdList = costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toSet());
            return new QFilter("id", "in", costAccountIdList);
        }
        return new QFilter("id", "=", (Object)0L);
    }

    public static Long getCostAccountByAccoutOrgId(Long orgId) {
        DynamicObjectCollection coll = AcaCostAccountHelper.getCostAccountCollection(orgId + "");
        if (coll.size() > 0) {
            return ((DynamicObject)coll.get(0)).getLong("id");
        }
        return 0L;
    }

    public static DynamicObjectCollection getCostAccountCollection(String orgId) {
        String fields = "entryentity.costaccount.id id,entryentity.costaccount.name name";
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        QFilter appNumQF = new QFilter("appnum", "=", (Object)"aca");
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, enable, appNumQF};
        return QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])filters, (String)"billno desc");
    }

    public static DynamicObjectCollection getUnInitCostAccountCollection(String orgId) {
        String fields = "entryentity.costaccount.id id,entryentity.costaccount.name name";
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.FALSE);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        QFilter appNumQF = new QFilter("appnum", "=", (Object)"aca");
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, enable, appNumQF};
        return QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])filters);
    }

    public static List<ComboItem> getCostAccountItems(String orgId) {
        return AcaCostAccountHelper.getComboItems(AcaCostAccountHelper.getCostAccountCollection(orgId));
    }

    private static List<ComboItem> getComboItems(DynamicObjectCollection dObjectCollec) {
        ArrayList<ComboItem> costAccountItems = new ArrayList<ComboItem>();
        for (DynamicObject dy : dObjectCollec) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(dy.getString("name")));
            item.setValue(dy.getString("id"));
            if (costAccountItems.contains(item)) continue;
            costAccountItems.add(item);
        }
        return costAccountItems;
    }

    public static Long getCurrentPeriodByCostAccountId(String costAccountId) {
        QFilter costAccount = new QFilter("entry.costaccount", "=", (Object)Long.parseLong(costAccountId));
        DynamicObject sysCtrlEntity = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"id, entry.currentperiod currentperiod", (QFilter[])new QFilter[]{costAccount});
        if (sysCtrlEntity != null) {
            return sysCtrlEntity.getLong("currentperiod");
        }
        return null;
    }

    public static Date getCurrentPeriodStartDateByCostAccountId(long costAccountId) {
        Long currentPeriodId;
        QFilter costAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        DynamicObject sysCtrlEntity = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"id, entry.currentperiod currentperiod", (QFilter[])new QFilter[]{costAccount});
        if (sysCtrlEntity != null && !CadEmptyUtils.isEmpty((Long)(currentPeriodId = Long.valueOf(sysCtrlEntity.getLong("currentperiod"))))) {
            return QueryServiceHelper.queryOne((String)"bd_period", (String)"begindate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currentPeriodId)}).getDate("begindate");
        }
        return null;
    }

    public static boolean isInited(long costAccountId, String appNum) {
        QFilter costAccountFilter = new QFilter("entryentity.costaccount", "=", (Object)costAccountId);
        QFilter appNumFilter = new QFilter("appNum", "=", (Object)appNum);
        QFilter initFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        return QueryServiceHelper.exists((String)"sca_startstdcost", (QFilter[])new QFilter[]{costAccountFilter, appNumFilter, initFilter});
    }

    public static DynamicObjectCollection getEndInitCostAccountCollection(Long orgId) {
        String fields = "entryentity.costaccount.id id,entryentity.costaccount.name name";
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        QFilter appNumQF = new QFilter("appnum", "=", (Object)"aca");
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, enable, appNumQF};
        return QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])filters);
    }

    public static Long getCostAccountsByOrgId(Long orgId, String appId) {
        if (CadEmptyUtils.isEmpty((Long)orgId)) {
            return 0L;
        }
        QFilter orgQf = new QFilter("calorg", "=", (Object)orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        orgQf.and(StartCostHelper.getEnabledCostAccountIdsFilter((Long)orgId, (String)appId));
        DynamicObjectCollection ccs = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,name", (QFilter[])new QFilter[]{orgQf, statusFilter, enableFilter}, (String)"ismainaccount desc,number asc");
        if (ccs == null || ccs.size() == 0) {
            return 0L;
        }
        return ((DynamicObject)ccs.get(0)).getLong("id");
    }

    public static Long getCostAccountByAccoutOrg(Long accountOrgId, String appnum) {
        List useActualCostAccountIds = CostAccountHelper.getOrgUseStdCostAccount((Long)accountOrgId, (String)"aca");
        if (useActualCostAccountIds.size() == 0) {
            return 0L;
        }
        if (useActualCostAccountIds.size() == 1) {
            return (Long)useActualCostAccountIds.get(0);
        }
        Long mainCostAccountId = CostAccountHelper.getMainCostAccount((Long)accountOrgId, (String)appnum);
        if (CadEmptyUtils.isEmpty((Long)mainCostAccountId)) {
            return 0L;
        }
        for (Long costAccount : useActualCostAccountIds) {
            if (!costAccount.equals(mainCostAccountId)) continue;
            return costAccount;
        }
        return 0L;
    }
}

