/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.common.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.aca.common.enums.AcaAllocEnum;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MfgFeeBillToAllocHelper {
    public static void generateAlloc(List<Object> mfgFeeBillIdList) {
        if (CadEmptyUtils.isEmpty(mfgFeeBillIdList)) {
            return;
        }
        MainEntityType mfgFeeBillType = EntityMetadataCache.getDataEntityType((String)"aca_mfgfeebill");
        List partArrIds = Lists.partition(mfgFeeBillIdList, (int)5000);
        for (List list : partArrIds) {
            DynamicObject[] mfgFeeBillArr = BusinessDataServiceHelper.load((Object[])list.toArray(), (DynamicObjectType)mfgFeeBillType);
            MfgFeeBillToAllocHelper.toAlloc(mfgFeeBillArr);
            for (DynamicObject bill : mfgFeeBillArr) {
                bill.set("auditor", (Object)RequestContext.get().getCurrUserId());
                bill.set("auditdate", (Object)new Date());
            }
            SaveServiceHelper.save((DynamicObject[])mfgFeeBillArr);
        }
    }

    public static void toAlloc(DynamicObject[] mfgFeeBillArr) {
        ArrayList<DynamicObject> allocBillList = new ArrayList<DynamicObject>();
        for (DynamicObject bizBill : mfgFeeBillArr) {
            if (!"C".equals(bizBill.getString("billstatus"))) continue;
            String allocMold = bizBill.getString("allocmold");
            if ("C".equals(allocMold)) {
                MfgFeeBillToAllocHelper.toAllocForCCO(bizBill, allocBillList);
                continue;
            }
            MfgFeeBillToAllocHelper.toAllocForCCC(bizBill, allocBillList);
        }
        if (!CadEmptyUtils.isEmpty(allocBillList)) {
            ArrayList<DynamicObject> ccList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> coList = new ArrayList<DynamicObject>();
            for (DynamicObject allocBill : allocBillList) {
                String entityName = allocBill.getDynamicObjectType().getName();
                if ("aca_mfgfeealloccc".equals(entityName)) {
                    ccList.add(allocBill);
                    continue;
                }
                if (!"aca_mfgfeeallocco".equals(entityName)) continue;
                coList.add(allocBill);
            }
            if (!CadEmptyUtils.isEmpty(ccList)) {
                SaveServiceHelper.save((DynamicObject[])ccList.toArray(new DynamicObject[0]));
            }
            if (!CadEmptyUtils.isEmpty(coList)) {
                SaveServiceHelper.save((DynamicObject[])coList.toArray(new DynamicObject[0]));
            }
        }
    }

    private static void toAllocForCCC(DynamicObject bizBill, List<DynamicObject> allocBillList) {
        DynamicObjectCollection mfgFeeBillEntryRows = bizBill.getDynamicObjectCollection("mfgfeebillentry");
        DynamicObject alloc = BusinessDataServiceHelper.newDynamicObject((String)"aca_mfgfeealloccc");
        MfgFeeBillToAllocHelper.fillEntity(bizBill, alloc);
        alloc.set("costcenter", (Object)bizBill.getDynamicObject("costcenter"));
        allocBillList.add(alloc);
        if (mfgFeeBillEntryRows == null || mfgFeeBillEntryRows.isEmpty()) {
            return;
        }
        if (mfgFeeBillEntryRows.size() > 1) {
            for (int i = 0; i < mfgFeeBillEntryRows.size(); ++i) {
                DynamicObject mfgFeeBillEntryRow = (DynamicObject)mfgFeeBillEntryRows.get(i);
                MfgFeeBillToAllocHelper.fillEntryEntityForCCC(alloc, mfgFeeBillEntryRow);
            }
        } else if (mfgFeeBillEntryRows.size() == 1) {
            DynamicObject mfgFeeBillEntryRow = (DynamicObject)mfgFeeBillEntryRows.get(0);
            String BenefCostCenterType = mfgFeeBillEntryRow.getString("benefcostcenter.orgduty.number");
            if ("4".equals(BenefCostCenterType)) {
                MfgFeeBillToAllocHelper.toAllocForCCO(bizBill, allocBillList);
            } else {
                alloc.set("usetype", (Object)AcaAllocEnum.USETYPE_DRIECT.getValue());
                MfgFeeBillToAllocHelper.fillEntryEntityForCCC(alloc, mfgFeeBillEntryRow);
                if (((DynamicObject)mfgFeeBillEntryRows.get(0)).getString("benefcostcenter") != null) {
                    MfgFeeBillToAllocHelper.fillDirectUse(bizBill, alloc);
                }
            }
        }
    }

    private static void toAllocForCCO(DynamicObject bizBill, List<DynamicObject> allocBillList) {
        DynamicObject alloc = BusinessDataServiceHelper.newDynamicObject((String)"aca_mfgfeeallocco");
        MfgFeeBillToAllocHelper.fillEntity(bizBill, alloc);
        alloc.set("source", (Object)"A");
        alloc.set("productgroup", (Object)bizBill.getString("productgroup.id"));
        alloc.set("benefcostcenter", (Object)bizBill.getDynamicObject("costcenter"));
        DynamicObjectCollection mfgFeeBillRntryRows = bizBill.getDynamicObjectCollection("mfgfeebillentry");
        for (int i = 0; i < mfgFeeBillRntryRows.size(); ++i) {
            DynamicObject mfgFeeBillEntryRow = (DynamicObject)mfgFeeBillRntryRows.get(i);
            MfgFeeBillToAllocHelper.fillEntryEntityForCCO(alloc, mfgFeeBillEntryRow);
        }
        if (mfgFeeBillRntryRows.size() == 1 && ((DynamicObject)mfgFeeBillRntryRows.get(0)).get("costobject") != null) {
            MfgFeeBillToAllocHelper.fillDirectUse(bizBill, alloc);
        }
        allocBillList.add(alloc);
    }

    private static void fillDirectUse(DynamicObject bizBill, DynamicObject alloc) {
        alloc.set("allocstatus", (Object)AcaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
        alloc.set("alloctype", (Object)AcaAllocEnum.ALLOCTYP_AUTO.getValue());
        alloc.set("usetype", (Object)AcaAllocEnum.USETYPE_DRIECT.getValue());
        alloc.set("allocor", (Object)RequestContext.get().getCurrUserId());
        bizBill.set("auditdate", (Object)new Date());
        alloc.set("alloctime", (Object)bizBill.getDate("auditdate"));
        DynamicObjectCollection allocEntry = alloc.getDynamicObjectCollection("entryentity");
        ((DynamicObject)allocEntry.get(0)).set("allocamt", bizBill.get("totalamount"));
    }

    private static void fillEntryEntityForCCO(DynamicObject alloc, DynamicObject mfgFeeBillEntryRow) {
        DynamicObjectCollection allocEntry = alloc.getDynamicObjectCollection("entryentity");
        DynamicObject allocEntryRow = allocEntry.addNew();
        allocEntryRow.set("seq", mfgFeeBillEntryRow.get("seq"));
        allocEntryRow.set("element", (Object)mfgFeeBillEntryRow.getDynamicObject("element"));
        allocEntryRow.set("subelement", (Object)mfgFeeBillEntryRow.getDynamicObject("subelement"));
        allocEntryRow.set("material", mfgFeeBillEntryRow.get("costobject.material"));
        allocEntryRow.set("auxpty", mfgFeeBillEntryRow.get("costobject.auxpty"));
        allocEntryRow.set("costobject", mfgFeeBillEntryRow.get("costobject"));
    }

    private static void fillEntryEntityForCCC(DynamicObject alloc, DynamicObject mfgFeeBillEntryRow) {
        DynamicObjectCollection allocEntry = alloc.getDynamicObjectCollection("entryentity");
        DynamicObject allocEntryRow = allocEntry.addNew();
        allocEntryRow.set("seq", mfgFeeBillEntryRow.get("seq"));
        allocEntryRow.set("element", (Object)mfgFeeBillEntryRow.getDynamicObject("element"));
        allocEntryRow.set("subelement", (Object)mfgFeeBillEntryRow.getDynamicObject("subelement"));
        allocEntryRow.set("benefcostcenter", mfgFeeBillEntryRow.get("benefcostcenter"));
    }

    private static void fillEntity(DynamicObject bizBill, DynamicObject alloc) {
        String billno = bizBill.getString("billno") + "_1";
        alloc.set("billno", (Object)billno);
        alloc.set("allocmold", (Object)bizBill.getString("allocmold"));
        alloc.set("org", (Object)bizBill.getDynamicObject("org"));
        alloc.set("costaccount", (Object)bizBill.getDynamicObject("costaccount"));
        alloc.set("period", (Object)bizBill.getDynamicObject("period"));
        alloc.set("expenseitem", (Object)bizBill.getDynamicObject("expenseitem"));
        alloc.set("currency", (Object)bizBill.getDynamicObject("currency"));
        alloc.set("bizdate", (Object)bizBill.getDate("bizdate"));
        alloc.set("amount", (Object)bizBill.getBigDecimal("totalamount"));
        alloc.set("creator", (Object)bizBill.getDynamicObject("creator"));
        alloc.set("createtime", (Object)bizBill.getDate("createtime"));
        alloc.set("billstatus", (Object)"C");
        alloc.set("allocstatus", (Object)AcaAllocEnum.ALLOCSTATUS_UNALLOC.getValue());
        alloc.set("srcbillid", (Object)bizBill.getLong("id"));
        alloc.set("usetype", (Object)AcaAllocEnum.USETYPE_PUBLIC.getValue());
        alloc.set("remark", (Object)ResManager.loadKDString((String)"\u7531\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5355\u751f\u6210", (String)"MfgFeeBillToAllocHelper_0", (String)"macc-aca-common", (Object[])new Object[0]));
    }
}

