/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.login.utils.JSONUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.common.constants.WipAdjustConstants;
import kd.macc.aca.common.constants.WipAdjustSubItem;
import kd.macc.cad.common.helper.CalcKeycolHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class WipAdjustHelper {
    public static boolean isExistCostObject(String adjustType, Long orgId, Long costCenterId, Long costAccountId, Long periodId, Long costObjectId, String billNo) {
        QFilter qf = new QFilter("org", "=", (Object)orgId);
        qf.and("adjusttype", "=", (Object)adjustType);
        qf.and("costcenter", "=", (Object)costCenterId);
        qf.and("costaccount", "=", (Object)costAccountId);
        qf.and("period", "=", (Object)periodId);
        qf.and("costobject", "=", (Object)costObjectId);
        qf.and("billno", "!=", (Object)billNo);
        return QueryServiceHelper.exists((String)"aca_wipadjustbill", (QFilter[])new QFilter[]{qf});
    }

    public static Map<String, Object> getCostObjectRelInfo(long costObjctId, DynamicObject model, String adjustType, boolean isCostElementByCostAccount) {
        boolean isEnd;
        HashMap<String, Object> mapInfo = new HashMap<String, Object>(16);
        Long orgId = model.getDynamicObject("org").getLong("id");
        Long costAccountId = model.getDynamicObject("costaccount").getLong("id");
        Long periodId = model.getDynamicObject("period").getLong("id");
        Long costCenterId = model.getDynamicObject("costcenter").getLong("id");
        boolean bl = isEnd = "END".equalsIgnoreCase(adjustType);
        if (!isEnd) {
            DynamicObject prePeriod = PeriodHelper.getPreviousPeriod((Object)periodId);
            if (prePeriod == null) {
                return mapInfo;
            }
            periodId = prePeriod.getLong("id");
        }
        Set calcKeys = CalcKeycolHelper.getCostaccountKeyCols((Long)orgId, (Long)costAccountId, (String)"aca");
        calcKeys.remove("material");
        calcKeys.remove("auxpty");
        String selectFields = "id, org, costcenter, costaccount, period, costobject, entryentity.id entryid, entryentity.type AS type, entryentity.element AS element, entryentity.subelement AS subelement, entryentity.subelement.type AS subelementType, entryentity.submaterial AS submaterial, entryentity.submatversion AS submatversion, entryentity.subauxpty AS subauxpty, entryentity.calckeycol AS calckeycol,entryentity.endadjqty AS endadjqty, entryentity.endadjamt AS endadjamt, entryentity.outsourcetype AS outsourcetype, entryentity.pdendqty AS pdendqty, entryentity.pdendamount AS pdendamount, entryentity.submaterial.baseunit AS baseunit";
        StringBuilder extBuilder = new StringBuilder();
        extBuilder.append(selectFields);
        for (String calcKey : calcKeys) {
            extBuilder.append(String.format(",entryentity.calckeycol.%s %s", calcKey, calcKey));
        }
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("costaccount", "=", (Object)costAccountId), new QFilter("period", "=", (Object)periodId), new QFilter("costobject", "=", (Object)costObjctId), new QFilter("costcenter", "=", (Object)costCenterId), new QFilter("entryentity.relaproducttype", "=", (Object)"C")};
        String algoKey = "kd.macc.aca.formplugin.wipadjust.WipAdjustBillEditPlugin.setCostObjectRelInfo";
        DataSet calcResults = QueryServiceHelper.queryDataSet((String)algoKey, (String)"aca_calcresult", (String)extBuilder.toString(), (QFilter[])filters, null);
        if (calcResults.hasNext()) {
            Map<String, Map<Long, WipAdjustSubItem>> subitemListMap = null;
            if (isCostElementByCostAccount) {
                subitemListMap = WipAdjustHelper.getSubItemJsonMap(filters);
            }
            DataSet finalResult = calcResults.copy().select(new String[]{"type", "endadjqty", "pdendqty"}).filter("type = 'finalResult'");
            Iterator finalResultIterator = finalResult.iterator();
            Row rowResult = (Row)finalResultIterator.next();
            mapInfo.put("endadjqty", rowResult.get("endadjqty"));
            mapInfo.put("pdendqty", rowResult.get("pdendqty"));
            DataSet detailResult = calcResults.copy().select(new String[]{"type", "element", "subelement", "outsourcetype", "endadjamt", "pdendamount"}).filter("type != 'finalResult'").groupBy(new String[]{"element", "subelement", "outsourcetype"}).sum("endadjamt").sum("pdendamount").finish();
            Iterator detailResultIterator = detailResult.iterator();
            HashMap<String, Object> detailInfo = new HashMap<String, Object>(16);
            ArrayList<HashMap<String, Object>> detailList = new ArrayList<HashMap<String, Object>>(10);
            HashSet<String> subelementSet = new HashSet<String>(16);
            while (detailResultIterator.hasNext()) {
                detailInfo = new HashMap(16);
                Row row = (Row)detailResultIterator.next();
                if (row.getLong("subelement") == 0L) continue;
                detailInfo.put("element", row.get("element"));
                detailInfo.put("subelement", row.get("subelement"));
                detailInfo.put("endadjamt", row.get("endadjamt"));
                detailInfo.put("pdendamount", row.get("pdendamount"));
                detailInfo.put("outsourcetype", row.get("outsourcetype"));
                detailList.add(detailInfo);
                subelementSet.add(String.format("%s@%s", row.getLong("subelement"), row.get("outsourcetype")));
            }
            mapInfo.put("detailInfo", detailList);
            mapInfo.put("subelementSet", subelementSet);
            ArrayList<String> subMaterialFields = new ArrayList<String>(Arrays.asList("type", "element", "subelement", "outsourcetype", "submaterial", "submatversion", "subauxpty", "calckeycol", "endadjqty", "pdendqty", "endadjamt", "pdendamount", "baseunit", "subelementType"));
            subMaterialFields.addAll(calcKeys);
            DataSet subResult = calcResults.copy().select(subMaterialFields.toArray(new String[0])).filter("type != 'finalResult'");
            Iterator subResultIterator = subResult.iterator();
            HashMap subMap = new HashMap(16);
            HashMap<String, Object> subInfo = new HashMap<String, Object>(16);
            HashSet<String> subSubelementSet = new HashSet<String>(16);
            while (subResultIterator.hasNext()) {
                Row row = (Row)subResultIterator.next();
                if (row.getLong("subelement") == 0L || row.getLong("submaterial") == 0L || !WipAdjustConstants.MAT_SUBELE_TYPES.contains(row.getString("subelementType"))) continue;
                String keyStr = String.format("%s@%s", row.getString("subelement"), row.getString("outsourcetype"));
                ArrayList<HashMap<String, Object>> val = (ArrayList<HashMap<String, Object>>)subMap.get(keyStr);
                if (val == null) {
                    val = new ArrayList<HashMap<String, Object>>(10);
                }
                String subItemKey = String.format("%s@%s@%s@%s@%s@%s", row.getString("subelement"), row.getString("submaterial"), row.getString("submatversion"), row.getString("subauxpty"), row.getString("outsourcetype"), row.getString("calckeycol"));
                subInfo = new HashMap(16);
                subInfo.put("submaterial", row.get("submaterial"));
                subInfo.put("submatversion", row.get("submatversion"));
                subInfo.put("subauxpty", row.get("subauxpty"));
                subInfo.put("calckeycol", row.get("calckeycol"));
                subInfo.put("endadjqty", row.get("endadjqty"));
                subInfo.put("pdendqty", row.get("pdendqty"));
                subInfo.put("subelement", row.get("subelement"));
                subInfo.put("endadjamt", row.get("endadjamt"));
                subInfo.put("pdendamount", row.get("pdendamount"));
                subInfo.put("baseunit", row.get("baseunit"));
                for (String calcKey : calcKeys) {
                    subInfo.put(calcKey, row.get(calcKey));
                }
                subInfo.put("subitemjson", WipAdjustHelper.getSubItemJson(subitemListMap, subItemKey, row));
                val.add(subInfo);
                subSubelementSet.add(subItemKey);
                subMap.put(keyStr, val);
            }
            mapInfo.put("subSubelementSet", subSubelementSet);
            mapInfo.put("subMap", subMap);
        }
        return mapInfo;
    }

    private static Map<String, Map<Long, WipAdjustSubItem>> getSubItemJsonMap(QFilter[] filters) {
        HashMap<String, Map<Long, WipAdjustSubItem>> subitemListMap = new HashMap<String, Map<Long, WipAdjustSubItem>>(10);
        String subitemSelectFields = " entryentity.subelement AS subelement,entryentity.outsourcetype AS outsourcetype,entryentity.submaterial AS submaterial,entryentity.submatversion AS submatversion,entryentity.subauxpty AS subauxpty,entryentity.calckeycol AS calckeycol,entryentity.subdetail.selement selement,entryentity.subdetail.ssubelement ssubelement,entryentity.subdetail.spdendamt spdendamt,entryentity.subdetail.spdendadjamt spdendadjamt";
        DataSet calcSubItemResults = QueryServiceHelper.queryDataSet((String)"calcresult", (String)"aca_calcresult", (String)subitemSelectFields, (QFilter[])filters, null);
        for (Row row : calcSubItemResults) {
            String key = String.format("%s@%s@%s@%s@%s@%s", row.getString("subelement"), row.getString("submaterial"), row.getString("submatversion"), row.getString("subauxpty"), row.getString("outsourcetype"), row.getString("calckeycol"));
            Map submap = subitemListMap.computeIfAbsent(key, t -> new HashMap(10));
            Long selement = row.getLong("selement");
            Long ssubelement = row.getLong("ssubelement");
            BigDecimal spdendamt = row.getBigDecimal("spdendamt");
            BigDecimal spdendadjamt = row.getBigDecimal("spdendadjamt");
            WipAdjustSubItem item = submap.computeIfAbsent(ssubelement, t -> new WipAdjustSubItem());
            item.setSelement(selement);
            item.setSsubelement(ssubelement);
            if (item.getSwipamt() != null) {
                item.setSwipamt(item.getSwipamt().add(spdendamt));
            } else {
                item.setSwipamt(spdendamt);
            }
            if (item.getSadjustamt() != null) {
                item.setSadjustamt(item.getSadjustamt().add(spdendadjamt));
            } else {
                item.setSadjustamt(spdendadjamt);
            }
            item.setDatatype("sysImport");
        }
        return subitemListMap;
    }

    private static String getSubItemJson(Map<String, Map<Long, WipAdjustSubItem>> subitemListMap, String key, Row row) {
        if (subitemListMap == null) {
            return null;
        }
        ArrayList<WipAdjustSubItem> subitems = new ArrayList<WipAdjustSubItem>(10);
        Map<Long, WipAdjustSubItem> map = subitemListMap.get(key);
        if (map == null) {
            WipAdjustSubItem subitem = new WipAdjustSubItem();
            subitem.setSelement(row.getLong("element"));
            subitem.setSsubelement(row.getLong("subelement"));
            subitem.setSwipamt(row.getBigDecimal("pdendamount"));
            subitem.setSadjustamt(row.getBigDecimal("endadjamt"));
            if (subitem.getSwipamt() == null) {
                subitem.setSwipamt(BigDecimal.ZERO);
            }
            if (subitem.getSadjustamt() == null) {
                subitem.setSadjustamt(BigDecimal.ZERO);
            }
            subitems.add(subitem);
        } else {
            for (Map.Entry entry : map.entrySet()) {
                subitems.add((WipAdjustSubItem)entry.getValue());
            }
        }
        WipAdjustHelper.wipAdjustSubItemAutoRevise(subitems, row.getBigDecimal("pdendamount"), row.getBigDecimal("endadjamt"));
        WipAdjustHelper.calcSubitemAfterAdjAmt(subitems);
        try {
            return JSONUtils.toString(subitems);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void wipAdjustSubItemAutoRevise(List<WipAdjustSubItem> subitems, BigDecimal pdendamount, BigDecimal endadjamt) {
        if (pdendamount == null) {
            pdendamount = BigDecimal.ZERO;
        }
        if (endadjamt == null) {
            endadjamt = BigDecimal.ZERO;
        }
        BigDecimal totalEndAmt = BigDecimal.ZERO;
        WipAdjustSubItem maxSubitem = null;
        BigDecimal totalAdjAmt = BigDecimal.ZERO;
        WipAdjustSubItem maxAdjSubitem = null;
        for (WipAdjustSubItem subitem : subitems) {
            totalEndAmt = totalEndAmt.add(subitem.getSwipamt());
            totalAdjAmt = totalAdjAmt.add(subitem.getSadjustamt());
            if (maxSubitem == null || maxSubitem.getSwipamt().compareTo(subitem.getSwipamt()) < 0) {
                maxSubitem = subitem;
            }
            if (maxAdjSubitem != null && maxAdjSubitem.getSadjustamt().compareTo(subitem.getSwipamt()) >= 0) continue;
            maxAdjSubitem = subitem;
        }
        if (totalEndAmt.compareTo(pdendamount) != 0) {
            totalEndAmt = pdendamount.subtract(totalEndAmt);
            if (maxSubitem != null) {
                maxSubitem.setSwipamt(maxSubitem.getSwipamt().add(totalEndAmt));
            }
        }
        if (totalAdjAmt.compareTo(endadjamt) != 0) {
            totalAdjAmt = endadjamt.subtract(totalAdjAmt);
            if (maxAdjSubitem != null) {
                maxAdjSubitem.setSadjustamt(maxAdjSubitem.getSadjustamt().add(totalAdjAmt));
            }
        }
    }

    public static void calcAdjustSubItemAmt(List<WipAdjustSubItem> subitems, BigDecimal adjAmt, int precise) {
        if (CadEmptyUtils.isEmpty(subitems)) {
            return;
        }
        if (subitems.size() == 1) {
            WipAdjustHelper.setSubitemRadio(subitems, BigDecimal.ONE);
        } else if (adjAmt.compareTo(BigDecimal.ZERO) == 0) {
            WipAdjustHelper.setSubitemRadio(subitems, BigDecimal.ZERO);
        } else {
            BigDecimal dAmt;
            String type = "0";
            for (WipAdjustSubItem subitem : subitems) {
                if (subitem.getSadjustamt().compareTo(BigDecimal.ZERO) == 0) continue;
                type = "1";
            }
            BigDecimal totalAmt = BigDecimal.ZERO;
            BigDecimal absMaxAmt = null;
            for (WipAdjustSubItem subitem : subitems) {
                dAmt = null;
                dAmt = "1".equals(type) ? subitem.getSadjustamt() : subitem.getSwipamt();
                totalAmt = totalAmt.add(dAmt);
                if (absMaxAmt != null && dAmt.abs().compareTo(absMaxAmt) <= 0) continue;
                absMaxAmt = dAmt;
            }
            if (totalAmt.compareTo(BigDecimal.ZERO) == 0) {
                totalAmt = absMaxAmt;
            }
            if (totalAmt != null && totalAmt.compareTo(BigDecimal.ZERO) == 0) {
                BigDecimal radio = BigDecimal.ONE.divide(new BigDecimal(subitems.size()), 10, RoundingMode.HALF_UP);
                WipAdjustHelper.setSubitemRadio(subitems, radio);
            } else {
                for (WipAdjustSubItem subitem : subitems) {
                    dAmt = null;
                    dAmt = "1".equals(type) ? subitem.getSadjustamt() : subitem.getSwipamt();
                    subitem.setRadio(dAmt.divide(totalAmt, 10, RoundingMode.HALF_UP));
                }
            }
        }
        BigDecimal diffAmt = adjAmt;
        WipAdjustSubItem maxSubItem = null;
        for (WipAdjustSubItem subitem : subitems) {
            if (maxSubItem == null || maxSubItem.getRadio().compareTo(subitem.getRadio()) < 0) {
                maxSubItem = subitem;
            }
            subitem.setSadjustamt(subitem.getRadio().multiply(adjAmt).setScale(precise, RoundingMode.HALF_UP));
            diffAmt = diffAmt.subtract(subitem.getSadjustamt());
        }
        if (diffAmt.compareTo(BigDecimal.ZERO) != 0 && maxSubItem != null) {
            maxSubItem.setSadjustamt(maxSubItem.getSadjustamt().add(diffAmt));
        }
        WipAdjustHelper.calcSubitemAfterAdjAmt(subitems);
    }

    private static void setSubitemRadio(List<WipAdjustSubItem> subitems, BigDecimal radio) {
        for (WipAdjustSubItem subitem : subitems) {
            subitem.setRadio(radio);
        }
    }

    private static void calcSubitemAfterAdjAmt(List<WipAdjustSubItem> subitems) {
        for (WipAdjustSubItem subitem : subitems) {
            subitem.calcAfterAdjustAmt();
        }
    }

    public static DynamicObjectCollection getCostAccount(Long orgId, String appId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appId);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{orgFilter, qfAppNum, isInitFilter};
        return QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filters);
    }

    public static Map<Long, DynamicObject> getIdAndAjustMap(Set<Long> costAdjustIds) {
        HashMap<Long, DynamicObject> idAndAjustMap = new HashMap<Long, DynamicObject>(16);
        DynamicObjectCollection ajustBills = WipAdjustHelper.getCostAdjustBills(costAdjustIds);
        for (DynamicObject obj : ajustBills) {
            idAndAjustMap.put(obj.getLong("id"), obj);
        }
        return idAndAjustMap;
    }

    public static DynamicObjectCollection getCostAdjustBills(Set<Long> costAdjustIds) {
        String fields = "id,billno,billstatus,isvoucher,vouchernum";
        QFilter filter = new QFilter("id", "in", costAdjustIds);
        return QueryServiceHelper.query((String)"cal_costadjust_subentity", (String)fields, (QFilter[])new QFilter[]{filter});
    }

    public static BigDecimal getOrZero(Object object) {
        if (object == null || !(object instanceof BigDecimal)) {
            return BigDecimal.ZERO;
        }
        return (BigDecimal)object;
    }
}

