/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.common.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class WipCostCheckHelper {
    private static final Log logger = LogFactory.getLog(WipCostCheckHelper.class);
    private static final String[] loadWipMatCheckQtyMapArr = new String[]{"0.0", "0.0"};

    public static HashMap<String, BigDecimal> loadWipMatCheckQtyMap(Long orgId, Long manuorgfId, Long costaccountId, Set<Long> costcenterfId, String checkType) {
        if (CadEmptyUtils.isEmpty((Long)orgId) || CadEmptyUtils.isEmpty((Long)costaccountId)) {
            logger.info("WipCostCheckService \u4f20\u5165\u53c2\u6570\u6838\u7b97\u7ec4\u7ec7\u6216\u8005\u6210\u672c\u8d26\u7c3f\u4e3a\u7a7a");
            return null;
        }
        DynamicObject sysCtrlPeriod = WipCostCheckHelper.getsysCtrlPeriod(orgId, costaccountId);
        if (sysCtrlPeriod == null) {
            logger.info("WipCostCheckService \u672a\u627e\u5230\u5f53\u524d\u671f\u95f4");
            return null;
        }
        Date begindate = sysCtrlPeriod.getDate("begindate");
        Date enddate = sysCtrlPeriod.getDate("enddate");
        if (begindate == null || enddate == null) {
            logger.info("WipCostCheckService \u5f53\u524d\u671f\u95f4\u5f00\u59cb\u548c\u7ed3\u675f\u65e5\u671f\u672a\u7ef4\u62a4");
            return null;
        }
        DataSet calcResult = WipCostCheckHelper.getCalcResult(orgId, costaccountId, costcenterfId, sysCtrlPeriod).addFields(loadWipMatCheckQtyMapArr, new String[]{"startchangenum", "allocqty"});
        DataSet wipAdjustBill = WipCostCheckHelper.getWipAdjustBill(orgId, manuorgfId, costaccountId, costcenterfId, sysCtrlPeriod);
        DataSet startDataSet = wipAdjustBill.filter("adjustType = 'START'").select("costcenter,adjustqty as startchangenum,amount,material,bomversion,auxpty").addFields(loadWipMatCheckQtyMapArr, new String[]{"startnum", "allocqty"});
        DataSet matAllocBill = WipCostCheckHelper.getMatAllocBill(orgId, manuorgfId, costaccountId, costcenterfId, sysCtrlPeriod).addFields(loadWipMatCheckQtyMapArr, new String[]{"startnum", "startchangenum"});
        String[] fieldNames = calcResult.getRowMeta().getFieldNames();
        String sql = "costcenter,material,bomversion,auxpty,startnum+startchangenum+allocqty as qty,amount";
        DataSet qtyDataSet = calcResult.union(new DataSet[]{startDataSet.select(fieldNames), matAllocBill.select(fieldNames)}).groupBy(new String[]{"costcenter", "material", "bomversion", "auxpty"}).sum("startnum").sum("startchangenum").sum("allocqty").sum("amount").finish().select(sql);
        HashMap<String, BigDecimal> matToQty = new HashMap<String, BigDecimal>();
        StringBuilder keyBuilder = new StringBuilder();
        String string = checkType = "amount".equals(checkType) ? "amount" : "qty";
        while (qtyDataSet.hasNext()) {
            Row row = qtyDataSet.next();
            Long costcenter = row.getLong("costcenter");
            Long material = row.getLong("material");
            Long bomversion = row.getLong("bomversion");
            Long auxpty = row.getLong("auxpty");
            keyBuilder.append(costcenter).append('@').append(material).append('@').append(bomversion).append('@').append(auxpty);
            matToQty.put(keyBuilder.toString(), row.getBigDecimal(checkType));
            keyBuilder.setLength(0);
        }
        return matToQty;
    }

    private static DataSet getMatAllocBill(Long orgId, Long manuorgfId, Long costaccountId, Set<Long> costcenterfId, DynamicObject sysCtrlPeriod) {
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQf = new QFilter("costaccount", "=", (Object)costaccountId);
        QFilter periodQf = new QFilter("period", "=", (Object)sysCtrlPeriod.getLong("currentperiod"));
        if (!CadEmptyUtils.isEmpty(costcenterfId)) {
            orgQf.and(new QFilter("costcenter", "in", costcenterfId));
        }
        if (!CadEmptyUtils.isEmpty((Long)manuorgfId)) {
            orgQf.and(new QFilter("manuorg", "=", (Object)manuorgfId));
        }
        QFilter statusQf = new QFilter("allocstatus", "=", (Object)"2");
        QFilter appNumQf = new QFilter("appnum", "=", (Object)"aca");
        String selectFile = "costcenter,costobject,useqty as allocqty, useamount as amount,material,matversion as bomversion,auxpty";
        DataSet aca_matalloc = QueryServiceHelper.queryDataSet((String)"getMatAllocBill", (String)"aca_matalloc", (String)selectFile, (QFilter[])new QFilter[]{orgQf, costaccountQf, periodQf, statusQf, appNumQf}, null);
        logger.info("getMatAllocBill {}", (Object)orgQf.and(costaccountQf).and(periodQf));
        return aca_matalloc;
    }

    private static DynamicObject getsysCtrlPeriod(Long orgId, Long costaccountId) {
        QFilter periodfilter = new QFilter("org", "=", (Object)orgId);
        periodfilter.and(new QFilter("entry.costaccount", "=", (Object)costaccountId));
        DynamicObjectCollection cal_sysctrlentity = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id,entry.currentperiod.id currentperiod,entry.currentperiod.begindate as begindate,entry.currentperiod.enddate as enddate", (QFilter[])periodfilter.toArray());
        if (cal_sysctrlentity.size() > 0) {
            return (DynamicObject)cal_sysctrlentity.get(0);
        }
        return null;
    }

    private static DataSet getCalcResult(Long orgId, Long costaccountId, Set<Long> costcenterfId, DynamicObject sysCtrlPeriod) {
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQf = new QFilter("costaccount", "=", (Object)costaccountId);
        long currentperiod = sysCtrlPeriod.getLong("currentperiod");
        DynamicObject previousPeriod = PeriodHelper.getPreviousPeriod((Object)currentperiod);
        Long prePeriodId = previousPeriod == null ? 0L : previousPeriod.getLong("id");
        QFilter periodQf = new QFilter("period", "=", (Object)prePeriodId);
        if (!CadEmptyUtils.isEmpty(costcenterfId)) {
            orgQf.and(new QFilter("costcenter", "in", costcenterfId));
        }
        QFilter typeQf = new QFilter("entryentity.type", "=", (Object)"detail");
        String selectFile = "costcenter,entryentity.pdendqty + entryentity.endadjqty as startnum, entryentity.pdendamount + entryentity.endadjamt  as amount,entryentity.submaterial as material,entryentity.submatversion as bomversion,entryentity.subauxpty as auxpty";
        DataSet cad_plannedoutputbill = QueryServiceHelper.queryDataSet((String)"getCalcResult", (String)"aca_calcresult", (String)selectFile, (QFilter[])new QFilter[]{orgQf, costaccountQf, periodQf, typeQf}, null);
        logger.info("getCalcResult {}", (Object)orgQf.and(costaccountQf).and(typeQf).and(periodQf));
        return cad_plannedoutputbill;
    }

    private static DataSet getWipAdjustBill(Long orgId, Long manuorgfId, Long costaccountId, Set<Long> costcenterfId, DynamicObject sysCtrlPeriod) {
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQf = new QFilter("costaccount", "=", (Object)costaccountId);
        QFilter periodQf = new QFilter("period", "=", (Object)sysCtrlPeriod.getLong("currentperiod"));
        if (!CadEmptyUtils.isEmpty(costcenterfId)) {
            orgQf.and(new QFilter("costcenter", "in", costcenterfId));
        }
        if (!CadEmptyUtils.isEmpty((Long)manuorgfId)) {
            orgQf.and(new QFilter("manuorg", "=", (Object)manuorgfId));
        }
        QFilter statusQf = new QFilter("billstatus", "=", (Object)"C");
        String selectFile = "manuorg ,costcenter,costobject,entryentity.subentryentity.submatadjqty as adjustqty,entryentity.subentryentity.submatadjamt as amount,adjustType,entryentity.subentryentity.submaterial as material,entryentity.subentryentity.version as bomversion,entryentity.subentryentity.auxpty as auxpty";
        DataSet wipAdjustBill = QueryServiceHelper.queryDataSet((String)"getWipAdjustBill", (String)"aca_wipadjustbill", (String)selectFile, (QFilter[])new QFilter[]{orgQf, costaccountQf, periodQf, statusQf}, null);
        logger.info("getWipAdjustBill {}", (Object)orgQf.and(costaccountQf).and(periodQf).and(statusQf));
        return wipAdjustBill;
    }
}

