/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.anal;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.macc.aca.algox.common.MatCalcParam;
import kd.macc.aca.algox.report.MatCalcAnalRptAlgoxService;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MatCalcAnalRptQueryPlugin
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam param, Object object) throws Throwable {
        FilterInfo filterInfo = param.getFilter();
        MatCalcParam matCalcParam = this.getMatCalcParam(filterInfo);
        DataSet dataSetResult = this.getService().getDataSetResult(matCalcParam);
        long currency = filterInfo.getLong("currency");
        if (!CadEmptyUtils.isEmpty((Long)currency)) {
            dataSetResult = dataSetResult.addField(String.valueOf(currency), "entrycurrency");
        }
        return dataSetResult;
    }

    private MatCalcParam getMatCalcParam(FilterInfo filterInfo) {
        MatCalcParam matCalcParam = new MatCalcParam();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        DynamicObject org = filterInfo.getDynamicObject("org");
        qFilters.add(new QFilter("org", "=", (Object)org.getLong("id")));
        DynamicObject costaccount = filterInfo.getDynamicObject("costaccount");
        qFilters.add(new QFilter("costaccount", "=", (Object)costaccount.getLong("id")));
        DynamicObject periodObj = filterInfo.getDynamicObject("period");
        qFilters.add(new QFilter("period", "=", (Object)periodObj.getLong("id")));
        DynamicObject costcenter = filterInfo.getDynamicObject("costcenter");
        if (costcenter != null) {
            qFilters.add(new QFilter("costcenter", "=", (Object)costcenter.getLong("id")));
        }
        matCalcParam.setBaseFilter(qFilters);
        DynamicObjectCollection costObjects = filterInfo.getDynamicObjectCollection("costobjects");
        if (costObjects != null) {
            List costObjectIds = costObjects.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            matCalcParam.setCostObjectIds(costObjectIds);
        }
        matCalcParam.setShowMatDetail(Boolean.valueOf(filterInfo.getBoolean("showmatdetail")));
        matCalcParam.setOnlyShowDiff(Boolean.valueOf(filterInfo.getBoolean("onlyshowdiff")));
        return matCalcParam;
    }

    private MatCalcAnalRptAlgoxService getService() {
        return new MatCalcAnalRptAlgoxService();
    }
}

