/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.anal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.aca.common.helper.AcaCostAccountHelper;
import kd.macc.aca.common.helper.PermItemCheckHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ReportUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class MfgcoCalcAnalRptPlugin
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static String[] CLEAR_STR_MFGCO_P = new String[]{"periodname"};
    private static String[] CLEAR_STR_MFGCO_C = new String[]{"costcenternumber"};
    private static String[] CLEAR_STR_MFGCO_N = new String[]{"costcentername"};
    private static String[] CLEAR_STR_MFGCO = new String[]{"costobject", "costobjectname"};
    private static String[] STR_MFGCO = new String[]{"element", "elementname", "subelement", "subelementname"};

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)"aca");
        BasedataEdit orgInput = (BasedataEdit)this.getControl("org");
        orgInput.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            QFilter qfId = new QFilter("id", "in", (Object)orgIds);
            filterParameter.getQFilters().add(qfId);
        });
        BasedataEdit costcenter = (BasedataEdit)this.getControl("costcenter");
        costcenter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgcoCalcAnalRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter showOrgDutyFilter = new QFilter("orgduty", "=", (Object)4L);
            QFilter calorgsFilter = new QFilter("accountorg", "=", (Object)org.getLong("id"));
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(showOrgDutyFilter);
            qFilters.add(calorgsFilter);
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgcoCalcAnalRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            Long acctOrgId = org.getLong("id");
            qFilters.add(StartCostHelper.getEnabledCostAccountIdsFilter((Long)acctOrgId, (String)"aca"));
        });
        BasedataEdit curPeriod = (BasedataEdit)this.getControl("period");
        curPeriod.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"MfgcoCalcAnalRptPlugin_1", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)org.getLong("id"), (Long)costAccountObj.getLong("id")));
            qFilters.add(new QFilter("isadjustperiod", "=", (Object)false));
        });
        BasedataEdit costobject = (BasedataEdit)this.getControl("costobjects");
        costobject.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"MfgcoCalcAnalRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            QFilter orgFilter = new QFilter("org", "=", org.get("id"));
            DynamicObject costcenterObj = this.getModel().getDataEntity().getDynamicObject("costcenter");
            if (costcenterObj != null) {
                orgFilter.and(new QFilter("costcenter", "=", costcenterObj.get("id")));
            }
            qFilters.add(orgFilter);
        });
        ReportList control = (ReportList)this.getControl("reportlistap");
        control.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent e) {
                Long costObjectId;
                ReportList rptList = (ReportList)e.getSource();
                FilterInfo filterInfo = rptList.getReportModel().getReportQueryParam().getFilter();
                DynamicObject row = rptList.getReportModel().getRowData(e.getRowIndex());
                String formId = "cad_mfgfeeallocco";
                DynamicObject org = filterInfo.getDynamicObject("org");
                DynamicObject costaccount = filterInfo.getDynamicObject("costaccount");
                DynamicObject period = filterInfo.getDynamicObject("period");
                String fieldName = e.getFieldName();
                Long orgId = org.getLong("id");
                QFilter filter = new QFilter("org", "=", (Object)orgId);
                Long costaccountId = costaccount.getLong("id");
                filter.and(new QFilter("costaccount", "=", (Object)costaccountId));
                Long periodId = period.getLong("id");
                filter.and(new QFilter("period", "=", (Object)periodId));
                filter.and(new QFilter("appnum", "=", (Object)"aca"));
                ListShowParameter showParameter = new ListShowParameter();
                QFilter otherFilter = new QFilter("appnum", "=", (Object)"aca");
                if ("costcenternumber".equals(fieldName)) {
                    Long costCenterId = row.getLong("costcenternumber.id");
                    otherFilter.and(new QFilter("entryentity.costobject.costcenter", "=", (Object)costCenterId));
                } else if ("costobject".equals(fieldName)) {
                    costObjectId = row.getLong("costobject.id");
                    otherFilter.and(new QFilter("entryentity.costobject", "=", (Object)costObjectId));
                } else if ("subelement".equals(fieldName)) {
                    costObjectId = row.getLong("costobject.id");
                    otherFilter.and(new QFilter("entryentity.costobject", "=", (Object)costObjectId));
                    Long sublementId = row.getLong("subelement.id");
                    otherFilter.and(new QFilter("subelement", "=", (Object)sublementId));
                }
                showParameter.setCustomParam("otherFilter", (Object)otherFilter.toSerializedString());
                List ids = QueryServiceHelper.queryPrimaryKeys((String)formId, (QFilter[])new QFilter[]{filter, otherFilter}, (String)"", (int)-1);
                LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
                Iterator iterator = ids.iterator();
                while (iterator.hasNext()) {
                    linkQueryPkIdCollection.addLinkQueryPkId(iterator.next());
                }
                showParameter.setBillFormId(formId);
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setShowFilter(false);
                showParameter.setShowQuickFilter(false);
                showParameter.getListFilterParameter().setFilter(filter);
                showParameter.setCustomParam("org", (Object)orgId);
                showParameter.setCustomParam("costaccount", (Object)costaccountId);
                showParameter.setCustomParam("period", (Object)periodId);
                showParameter.setCustomParam("source", (Object)"HyperLink");
                showParameter.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
                MfgcoCalcAnalRptPlugin.this.getView().showForm((FormShowParameter)showParameter);
            }
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setOrg();
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.setCostAccount();
            this.setPeriodAndCurrency();
        }
    }

    public void afterBindData(EventObject e) {
        ReportShowParameter showParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        if (customParams.get("org") == null) {
            return;
        }
        this.getModel().setValue("org", customParams.get("org"));
        this.getModel().setValue("costaccount", customParams.get("costaccount"));
        this.getModel().setValue("period", customParams.get("period"));
        this.getModel().setValue("showsubelement", customParams.get("showsubelement"));
        this.getModel().setValue("onlyshowdiff", customParams.get("onlyshowdiff"));
        DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
        this.getModel().setValue("currency", (Object)CurrencyHelper.getCurrency((DynamicObject)costAccountObj));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "org": {
                this.setOther();
                this.setCostAccount();
                break;
            }
            case "costaccount": {
                this.setPeriodAndCurrency();
                break;
            }
            case "costcenter": {
                this.getModel().setValue("costobject", null);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        ArrayList pros = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "period"});
        boolean isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)pros);
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"MfgcoCalcAnalRptPlugin_2", (String)"macc-aca-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"MfgcoCalcAnalRptPlugin_3", (String)"macc-aca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u8d39\u7528\u5206\u914d\u4e0e\u8ba1\u7b97\u5bf9\u8d26\u8868", (String)"MfgcoCalcAnalRptPlugin_4", (String)"macc-aca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"aca_mfgcocalcanalrpt", (IDataModel)this.getModel());
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        ReportUtils.clearFileNameValue((String[])CLEAR_STR_MFGCO_P, (DynamicObjectCollection)rowData, (String[])CLEAR_STR_MFGCO_P);
        ReportUtils.clearFileNameValue((String[])CLEAR_STR_MFGCO_C, (DynamicObjectCollection)rowData, (String[])CLEAR_STR_MFGCO_C);
        ReportUtils.clearFileNameValue((String[])CLEAR_STR_MFGCO_N, (DynamicObjectCollection)rowData, (String[])CLEAR_STR_MFGCO_N);
        ReportUtils.clearFileNameValue((String[])CLEAR_STR_MFGCO, (DynamicObjectCollection)rowData, (String[])CLEAR_STR_MFGCO);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        if (("exportexcel".equals(operateKey) || "syncexportexcel".equals(operateKey)) && !PermItemCheckHelper.isPerm((String)"aca_mfgcocalcanalrpt", (String)"47150e89000000ac", (Long)org.getLong("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u5f15\u51fa\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MfgcoCalcAnalRptPlugin_5", (String)"macc-aca-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        ArrayList<String> hideFields = new ArrayList<String>(Arrays.asList(STR_MFGCO));
        Boolean showMatDetail = this.getModel().getDataEntity().getBoolean("showsubelement");
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof ReportColumn)) continue;
            ReportColumn reportColumn = (ReportColumn)obj;
            String key = reportColumn.getFieldKey();
            if (showMatDetail.booleanValue() || !hideFields.contains(key)) continue;
            reportColumn.setHide(true);
        }
        this.getView().updateView("reportlistap");
    }

    private void setCostAccount() {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Long mainBookId = AcaCostAccountHelper.getCostAccountByAccoutOrg((Long)((DynamicObject)org).getLong("id"), (String)"aca");
        if (mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
        }
        this.getView().updateView("costaccount");
    }

    private void setPeriodAndCurrency() {
        DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
        if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
            this.getModel().setValue("period", null);
            this.getModel().setValue("currency", null);
        } else {
            Long costAccountId = costAccountObj.getLong("id");
            DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
            if (curPeriod != null) {
                this.getModel().setValue("period", (Object)curPeriod);
            }
            this.getModel().setValue("currency", (Object)CurrencyHelper.getCurrency((DynamicObject)costAccountObj));
        }
    }

    private void setOther() {
        this.getModel().setValue("costcenter", null);
        this.getModel().setValue("costaccount", null);
        this.getModel().setValue("period", null);
        this.getModel().setValue("currency", null);
        this.getModel().setValue("costobjects", null);
    }

    private void setOrg() {
        if (this.getModel().getValue("org") == null) {
            Long orgId = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
            if (!isAccounting) {
                return;
            }
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)"aca");
            if (orgIds.contains(orgId)) {
                this.getModel().setValue("org", (Object)orgId);
                this.getView().updateView("org");
            }
        }
    }
}

