/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.anal;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.macc.aca.algox.common.MatCalcParam;
import kd.macc.aca.algox.report.MfgcoCalcAnalRptAlgoxService;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MfgcoCalcAnalRptQueryPlugin
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        FilterInfo filterInfo = param.getFilter();
        MatCalcParam matCalcParam = this.getMfgcoCalcParam(filterInfo);
        DataSet dataSetResult = this.getService().getDataSetResult(matCalcParam);
        long currency = filterInfo.getLong("currency");
        if (!CadEmptyUtils.isEmpty((Long)currency)) {
            dataSetResult = dataSetResult.addField(String.valueOf(currency), "entrycurrency");
        }
        return dataSetResult;
    }

    private MatCalcParam getMfgcoCalcParam(FilterInfo filterInfo) {
        DynamicObjectCollection costObjects;
        MatCalcParam matCalcParam = new MatCalcParam();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        DynamicObject org = filterInfo.getDynamicObject("org");
        qFilters.add(new QFilter("org", "=", (Object)org.getLong("id")));
        DynamicObject costaccount = filterInfo.getDynamicObject("costaccount");
        qFilters.add(new QFilter("costaccount", "=", (Object)costaccount.getLong("id")));
        DynamicObject periodObj = filterInfo.getDynamicObject("period");
        qFilters.add(new QFilter("period", "=", (Object)periodObj.getLong("id")));
        matCalcParam.setBaseFilter(qFilters);
        DynamicObject costcenter = filterInfo.getDynamicObject("costcenter");
        if (costcenter != null) {
            matCalcParam.setCostCenterId(Long.valueOf(costcenter.getLong("id")));
        }
        if ((costObjects = filterInfo.getDynamicObjectCollection("costobjects")) != null) {
            List costObjectIds = costObjects.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            matCalcParam.setCostObjectIds(costObjectIds);
        }
        matCalcParam.setShowSubelement(Boolean.valueOf(filterInfo.getBoolean("showsubelement")));
        matCalcParam.setOnlyShowDiff(Boolean.valueOf(filterInfo.getBoolean("onlyshowdiff")));
        return matCalcParam;
    }

    private MfgcoCalcAnalRptAlgoxService getService() {
        return new MfgcoCalcAnalRptAlgoxService();
    }
}

