/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.anal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.aca.algox.utils.CostaccountHelper;
import kd.macc.aca.common.helper.AcaCostAccountHelper;
import kd.macc.aca.common.helper.MatBaseDataFilterHelper;
import kd.macc.aca.common.helper.PermItemCheckHelper;
import kd.macc.cad.common.constants.CommonConstant;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ReportUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class ProCostCmpAnalRptPlugin
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static String[] CLEAR_STR_PRODUCT = new String[]{"product", "baseunit", "auxpty", "version"};
    private static String[] CLEAR_STR_COSTOBJECT = new String[]{"costobject"};
    private static String[] COSTOBJECT_STR = new String[]{"costobject", "costobjectname", "srcbillnumber", "srcbillrow"};
    private static String[] ELE_STR = new String[]{"element", "elementname", "subelement", "subelementname"};
    private static String[] MAT_STR = new String[]{"submaterial", "submaterialname", "matmodelnum", "matbaseunit", "matauxpty", "matversion", "comuse", "price", "convqty", "convamt", "cmpcomuse", "cmpprice", "cmpconvqty", "cmpconvamt", "matqtydiff", "matamtdiff", "alldiff"};
    private static String[] UN_MAT_STR = new String[]{"convamtshow", "cmpconvamtshow", "alldiffshow"};

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"calcrecord"});
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = listShowParameter.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            List acctOrgs = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (CadEmptyUtils.isEmpty((List)acctOrgs)) {
                qFilters.add(QFilter.of((String)"1=0", (Object[])new Object[0]));
                return;
            }
            QFilter costAccountFilter = StartCostHelper.getIsinitCostAccountFilter((String)this.getView().getFormShowParameter().getAppId());
            if (costAccountFilter == null) {
                qFilters.add(QFilter.of((String)"1=0", (Object[])new Object[0]));
                return;
            }
            costAccountFilter.and(new QFilter("calorg", "in", (Object)acctOrgs));
            qFilters.add(costAccountFilter);
        });
        BasedataEdit costcenter = (BasedataEdit)this.getControl("costcenter");
        costcenter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"ProCostCmpAnalRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Long orgId = costAccountObj.getLong("calorg.id");
            QFilter showOrgDutyFilter = new QFilter("orgduty", "=", (Object)4L);
            QFilter calorgsFilter = new QFilter("accountorg", "=", (Object)orgId);
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(showOrgDutyFilter);
            qFilters.add(calorgsFilter);
        });
        BasedataEdit curPeriod = (BasedataEdit)this.getControl("period");
        curPeriod.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"ProCostCmpAnalRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Long orgId = costAccountObj.getLong("calorg.id");
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)orgId, (Long)costAccountObj.getLong("id")));
        });
        BasedataEdit products = (BasedataEdit)this.getControl("products");
        products.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"ProCostCmpAnalRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Long orgId = costAccountObj.getLong("calorg.id");
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(MatBaseDataFilterHelper.getBaseFilter(Collections.singletonList(orgId)));
        });
        BasedataEdit costType = (BasedataEdit)this.getControl("costtype");
        costType.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"ProCostCmpAnalRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject currencyObj = (DynamicObject)this.getModel().getValue("currency");
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            QFilter filter = new QFilter("id", "!=", (Object)CommonConstant.ACA_COST_TYPE_ID);
            filter.and(new QFilter("type", "=", (Object)"1"));
            filter.and(new QFilter("currency", "=", currencyObj.get("id")));
            filterParameter.setFilter(filter);
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "costaccount": {
                this.setPeriodAndCurrency();
                this.getModel().setValue("costcenter", null);
                this.getModel().setValue("products", null);
                this.getModel().setValue("costtype", null);
                this.setViewSubItem();
                break;
            }
            case "showmaterialdetail": {
                Boolean showMaterialDetail = (Boolean)this.getModel().getValue("showmaterialdetail");
                if (!showMaterialDetail.booleanValue()) break;
                this.getModel().setValue("showsubelement", (Object)Boolean.TRUE);
                Boolean viewsubitem = (Boolean)this.getModel().getValue("viewsubitem");
                if (!viewsubitem.booleanValue()) break;
                this.getModel().setValue("viewsubitem", (Object)Boolean.FALSE);
                break;
            }
            case "viewsubitem": {
                Boolean viewsubitem = (Boolean)this.getModel().getValue("viewsubitem");
                if (!viewsubitem.booleanValue()) break;
                this.getModel().setValue("showsubelement", (Object)Boolean.TRUE);
                Boolean showMaterialDetail = (Boolean)this.getModel().getValue("showmaterialdetail");
                if (!showMaterialDetail.booleanValue()) break;
                this.getModel().setValue("showmaterialdetail", (Object)Boolean.FALSE);
                break;
            }
            case "showsubelement": {
                Boolean showsubelement = (Boolean)this.getModel().getValue("showsubelement");
                if (showsubelement.booleanValue()) break;
                this.getModel().setValue("showmaterialdetail", (Object)Boolean.FALSE);
                this.getModel().setValue("viewsubitem", (Object)Boolean.FALSE);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.setCostAccount();
            this.setPeriodAndCurrency();
        }
        this.setViewSubItem();
    }

    private void setViewSubItem() {
        boolean viewSubitem = false;
        DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccountObj != null) {
            Long costAccountId = costAccountObj.getLong("id");
            viewSubitem = CostaccountHelper.getCostElementByCostAccount((long)costAccountId);
        }
        if (!viewSubitem) {
            this.getModel().getDataEntity().set("viewsubitem", (Object)false);
        }
        this.getView().setVisible(Boolean.valueOf(viewSubitem), new String[]{"viewsubitem"});
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        super.formatDisplayFilterField(evt);
        String str = evt.getFormatedFilterString();
        boolean viewsubitem = this.getModel().getDataEntity().getBoolean("viewsubitem");
        if (viewsubitem) {
            str = str.concat(ResManager.loadKDString((String)"; \u663e\u793a\u5206\u9879\u6570\u636e\uff1a\u662f", (String)"ProCostCmpAnalRptPlugin_5", (String)"macc-aca-report", (Object[])new Object[0]));
        }
        evt.setFormatedFilterString(str);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        ArrayList pros = Lists.newArrayList((Object[])new String[]{"costaccount", "period", "costtype"});
        boolean isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)pros);
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"ProCostCmpAnalRptPlugin_1", (String)"macc-aca-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
            return;
        }
        Long orgId = costAccount.getLong("calorg.id");
        if (("exportexcel".equals(operateKey) || "syncexportexcel".equals(operateKey)) && !PermItemCheckHelper.isPerm((String)"aca_procostcmpanlrpt", (String)"47150e89000000ac", (Long)orgId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u5f15\u51fa\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProCostCmpAnalRptPlugin_2", (String)"macc-aca-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"ProCostCmpAnalRptPlugin_3", (String)"macc-aca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u4ea7\u54c1\u5b9e\u9645/\u6807\u51c6\u6210\u672c\u5bf9\u6bd4\u5206\u6790", (String)"ProCostCmpAnalRptPlugin_4", (String)"macc-aca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"aca_procostcmpanlrpt", (IDataModel)this.getModel());
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        ReportUtils.clearFileNameValue((String[])CLEAR_STR_PRODUCT, (DynamicObjectCollection)rowData, (String[])CLEAR_STR_PRODUCT);
        ReportUtils.clearFileNameValue((String[])CLEAR_STR_COSTOBJECT, (DynamicObjectCollection)rowData, (String[])CLEAR_STR_COSTOBJECT);
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        ArrayList<String> costObjectHideFields = new ArrayList<String>(Arrays.asList(COSTOBJECT_STR));
        ArrayList<String> eleHideFields = new ArrayList<String>(Arrays.asList(ELE_STR));
        ArrayList<String> matHideFields = new ArrayList<String>(Arrays.asList(MAT_STR));
        ArrayList<String> unMatHideFields = new ArrayList<String>(Arrays.asList(UN_MAT_STR));
        Boolean showCostObject = this.getModel().getDataEntity().getBoolean("showcostobject");
        Boolean showSubelement = this.getModel().getDataEntity().getBoolean("showsubelement");
        Boolean showMaterialDetail = this.getModel().getDataEntity().getBoolean("showmaterialdetail");
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof ReportColumn) {
                ReportColumn reportColumn = (ReportColumn)obj;
                String key = reportColumn.getFieldKey();
                if (!showCostObject.booleanValue()) {
                    if (costObjectHideFields.contains(key)) {
                        reportColumn.setHide(true);
                    }
                } else if (costObjectHideFields.contains(key)) {
                    reportColumn.setHide(false);
                }
                if (!showSubelement.booleanValue() && eleHideFields.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (showMaterialDetail.booleanValue()) {
                    if (!unMatHideFields.contains(key)) continue;
                    reportColumn.setHide(true);
                    continue;
                }
                if (!matHideFields.contains(key)) continue;
                reportColumn.setHide(true);
                continue;
            }
            if (!(obj instanceof ReportColumnGroup)) continue;
            ReportColumnGroup reportColumnGroup = (ReportColumnGroup)obj;
            List reportColumns = reportColumnGroup.getChildren();
            for (int index = 0; index < reportColumns.size(); ++index) {
                Object column = reportColumns.get(index);
                if (!(column instanceof ReportColumn)) continue;
                ReportColumn col = (ReportColumn)column;
                String key = col.getFieldKey();
                if (showMaterialDetail.booleanValue() || !matHideFields.contains(key)) continue;
                col.setHide(true);
            }
        }
        this.getView().updateView("reportlistap");
    }

    public void click(EventObject evt) {
        TextEdit textEdit;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit && "calcrecord".equals(key = (textEdit = (TextEdit)source).getKey())) {
            this.showSelectPage(key);
        }
    }

    private void showSelectPage(String actionId) {
        List materialIds;
        DynamicObject costtype = this.getModel().getDataEntity().getDynamicObject("costtype");
        if (costtype == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6210\u672c\u7c7b\u578b\u201d\u3002", (String)"ProCostCmpAnalRptPlugin_6", (String)"macc-aca-report", (Object[])new Object[0]));
            return;
        }
        ArrayList mulmaterial = Lists.newArrayList();
        DynamicObjectCollection mulMaterial = this.getModel().getDataEntity().getDynamicObjectCollection("products");
        if (mulMaterial != null && mulMaterial.size() > 0 && !CadEmptyUtils.isEmpty(materialIds = mulMaterial.stream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()))) {
            mulmaterial.addAll(materialIds);
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("cad_stdcalcrecord_text");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("costTypeId", costtype.get("id"));
        fsp.setCustomParam("materialIds", (Object)mulmaterial);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (returnDataObj instanceof Map) {
            Map returnData = (Map)returnDataObj;
            String value = String.valueOf(returnData.get("content"));
            String operateType = String.valueOf(returnData.get("operateType"));
            if ("btnok".equals(operateType)) {
                value = value.replaceAll("\n", ",");
                this.getModel().setValue(actionId, (Object)value);
            }
        } else if (returnDataObj instanceof String) {
            String value = (String)returnDataObj;
            this.getModel().setValue(actionId, (Object)value);
        }
    }

    private void setCostAccount() {
        Long orgId = RequestContext.get().getOrgId();
        boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
        if (!isAccounting) {
            return;
        }
        List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (orgIds.contains(orgId)) {
            Long mainBookId = AcaCostAccountHelper.getCostAccountByAccoutOrg((Long)orgId, (String)"aca");
            if (mainBookId != 0L) {
                this.getModel().setValue("costaccount", (Object)mainBookId);
            } else {
                this.getModel().setValue("costaccount", null);
            }
            this.getView().updateView("costaccount");
        }
    }

    private void setPeriodAndCurrency() {
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
            this.getModel().setValue("period", null);
            this.getModel().setValue("currency", null);
        } else {
            this.getModel().setValue("currency", (Object)CurrencyHelper.getCurrency((DynamicObject)costAccount));
            Long costAccountId = costAccount.getLong("id");
            DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
            if (curPeriod == null) {
                this.getModel().setValue("period", null);
            } else {
                this.getModel().setValue("period", (Object)curPeriod);
            }
        }
    }
}

