/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.anal;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.macc.aca.algox.report.ProCostCmpAnalRptAlgoxService;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ProCostCmpAnalRptQueryPlugin
extends AbstractReportListDataPlugin {
    private Long cost_type_id = 0L;
    private String calRecordName;
    private Boolean showCostObject = Boolean.FALSE;
    private Boolean showSubelement = Boolean.FALSE;
    private Boolean showMaterialDetail = Boolean.FALSE;

    public DataSet query(ReportQueryParam param, Object object) throws Throwable {
        FilterInfo filterInfo = param.getFilter();
        List<QFilter> queryFilter = this.getQueryFilter(filterInfo);
        DataSet dataSetResult = this.getService().getDataSetResult(queryFilter, this.showCostObject, this.showSubelement, this.showMaterialDetail, this.cost_type_id, this.getViewSubitem(), this.calRecordName);
        long currency = filterInfo.getLong("currency");
        if (!CadEmptyUtils.isEmpty((Long)currency)) {
            dataSetResult = dataSetResult.addField(String.valueOf(currency), "entrycurrency");
        }
        return dataSetResult;
    }

    private boolean getViewSubitem() {
        return this.getQueryParam().getFilter().getBoolean("viewsubitem");
    }

    private ProCostCmpAnalRptAlgoxService getService() {
        return new ProCostCmpAnalRptAlgoxService();
    }

    private List<QFilter> getQueryFilter(FilterInfo filterInfo) {
        DynamicObject costType;
        DynamicObjectCollection products;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        DynamicObject costAccount = filterInfo.getDynamicObject("costaccount");
        qFilters.add(new QFilter("costaccount", "=", (Object)costAccount.getLong("id")));
        qFilters.add(new QFilter("org", "=", (Object)costAccount.getLong("calorg.id")));
        DynamicObject period = filterInfo.getDynamicObject("period");
        qFilters.add(new QFilter("period", "=", (Object)period.getLong("id")));
        DynamicObject costCenter = filterInfo.getDynamicObject("costcenter");
        if (costCenter != null) {
            qFilters.add(new QFilter("costcenter", "=", (Object)costCenter.getLong("id")));
        }
        if ((products = filterInfo.getDynamicObjectCollection("products")) != null) {
            List productIds = products.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            qFilters.add(new QFilter("entryentity.relacostobject.material", "in", productIds));
        }
        if ((costType = filterInfo.getDynamicObject("costtype")) != null) {
            this.cost_type_id = costType.getLong("id");
        }
        this.calRecordName = filterInfo.getString("calcrecord");
        this.showCostObject = filterInfo.getBoolean("showcostobject");
        this.showSubelement = filterInfo.getBoolean("showsubelement");
        this.showMaterialDetail = filterInfo.getBoolean("showmaterialdetail");
        return qFilters;
    }
}

