/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.calc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataHandle;
import kd.bplat.scmc.report.core.tpl.IFilter;
import kd.macc.aca.algox.utils.CostaccountHelper;
import kd.macc.aca.common.helper.MatBaseDataFilterHelper;
import kd.macc.aca.common.helper.PermItemCheckHelper;
import kd.macc.aca.report.calc.model.CalcResultParam;
import kd.macc.aca.report.calc.model.CalcResultRptConstants;
import kd.macc.aca.report.helper.ReportRptHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ReportUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import org.apache.commons.collections4.CollectionUtils;

public class CalcResultRptFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final String PERIOD = "fperiod";
    private static final String VIEWSUBITEM = "viewsubitem";
    private static final String FSUBMATERIAL = "fsubmaterial";
    private static final String FSUBELEMENT = "fsubelement";
    private static final List<String> FILTER_NOTCONTAIN_FIELDS = Arrays.asList("element", "submaterial", "subelement", "material.baseunit", "auxpty", "unit", "closestatus", "qcostobject", "submatmodelnum", "submatunit", "submatauxpty", "submatversion");

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            qFilters.add(new QFilter("id", "in", (Object)orgIds));
        });
        BasedataEdit costObject = (BasedataEdit)this.getControl("fcostobject");
        costObject.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject orgObj = this.getModel().getDataEntity().getDynamicObject("org");
            if (orgObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CalcResultRptFormPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            List<QFilter> costObjectFilter = this.getCostObjectFilter();
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.addAll(costObjectFilter);
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject orgObj = this.getModel().getDataEntity().getDynamicObject("org");
            if (orgObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CalcResultRptFormPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter costAccountFilter = this.getCostAccountFilter();
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = listShowParameter.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(costAccountFilter);
        });
        BasedataEdit calPeriod = (BasedataEdit)this.getControl(PERIOD);
        calPeriod.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costAccountObj = this.getModel().getDataEntity().getDynamicObject("costaccount");
            if (costAccountObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CalcResultRptFormPlugin_6", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter periodFilter = this.getPeriodFilter();
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(new QFilter("isadjustperiod", "=", (Object)false));
            if (periodFilter != null) {
                qFilters.add(periodFilter);
            }
        });
        BasedataEdit costCenter = (BasedataEdit)this.getControl("fcostcenter");
        costCenter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject orgObj = this.getModel().getDataEntity().getDynamicObject("org");
            if (orgObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CalcResultRptFormPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter[] costCenterFilter = this.getCostCenterFilter();
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = listShowParameter.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.addAll(Arrays.asList(costCenterFilter));
        });
        BasedataEdit products = (BasedataEdit)this.getControl("fmaterial");
        products.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject orgObj = this.getModel().getDataEntity().getDynamicObject("org");
            if (orgObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CalcResultRptFormPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Long orgId = orgObj.getLong("id");
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(MatBaseDataFilterHelper.getBaseFilter(Collections.singletonList(orgId)));
        });
        BasedataEdit fsubmaterial = (BasedataEdit)this.getControl(FSUBMATERIAL);
        fsubmaterial.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject orgObj = this.getModel().getDataEntity().getDynamicObject("org");
            if (orgObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CalcResultRptFormPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Long orgId = orgObj.getLong("id");
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(MatBaseDataFilterHelper.getBaseFilter(Collections.singletonList(orgId)));
        });
        BasedataEdit manuOrg = (BasedataEdit)this.getControl("fmanuorg");
        manuOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CalcResultRptFormPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        List manuOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)((Long)org.getPkValue()), (String)"aca_calcresultnew", (String)this.getView().getFormShowParameter().getAppId());
        if (CollectionUtils.isNotEmpty((Collection)manuOrg)) {
            QFilter filter = new QFilter("id", "in", (Object)manuOrg);
            listShowParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String openParamStr = (String)fsp.getCustomParam("custparam");
        if (CadEmptyUtils.isEmpty((String)openParamStr)) {
            this.setOrg();
            DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
            if (costAccount == null) {
                this.setCostAccount();
                this.setPeriodAndCurrency();
                this.setManuOrg();
            }
        }
    }

    private void showQty() {
        String showQtyCols = this.getModel().getDataEntity().getString("showqtycols");
        Set<String> showQtyCol = this.getSelectKeyHashSet(showQtyCols);
        ArrayList yearLjInProps = Lists.newArrayList((Object[])new String[]{"yearpdsumqty", "yearpdsumamount", "yeartotalcomqty", "yearsumcomuse", "yeartotalcomunitcost", "yeartotalcomamount"});
        boolean viewtotal = this.getModel().getDataEntity().getBoolean("viewtotal");
        if (viewtotal) {
            showQtyCol.addAll(yearLjInProps);
        } else {
            showQtyCol.removeAll(yearLjInProps);
        }
        StringBuilder sb = new StringBuilder();
        for (String field : showQtyCol) {
            sb.append(field).append(",");
        }
        this.getModel().setValue("showqtycols", (Object)sb.toString());
        this.getView().updateView("showqtycols");
    }

    private Set<String> getSelectKeyHashSet(String selectKey) {
        HashSet<String> selectSet = null;
        if (!StringUtils.isEmpty((String)selectKey)) {
            selectSet = new HashSet<String>(Arrays.asList(selectKey.split(",")));
            selectSet.remove("");
        } else {
            selectSet = new HashSet<String>(10);
        }
        return selectSet;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String openParamStr = (String)fsp.getCustomParam("custparam");
        this.showColSet(this.getModel().getDataEntity().getString("showkeycols"), false);
        if (!CadEmptyUtils.isEmpty((String)openParamStr)) {
            Object costAccount;
            JSONObject calcParamJs = JSON.parseObject((String)openParamStr);
            Object org = calcParamJs.get((Object)"orgId");
            if (org != null) {
                this.getModel().setValue("org", org);
            }
            if ((costAccount = calcParamJs.get((Object)"costAccountId")) != null) {
                this.getModel().setValue("costaccount", costAccount);
            }
            this.getView().updateView("org");
            this.getView().updateView("costaccount");
            this.setCurrencyAndPeriod(this.getModel().getDataEntity().getDynamicObject("costaccount"));
            this.getView().updateView("currency");
            this.getView().updateView(PERIOD);
            if (ReportRptHelper.getDefaultfilterScheme(this.getView()) == null) {
                this.showQty();
                this.setViewSubItem();
                ReportFilter filter = (ReportFilter)this.getControl("reportfilterap");
                filter.search();
                return;
            }
        }
        this.setViewSubItem();
        this.showQty();
    }

    private void setViewSubItem() {
        boolean viewSubitem = false;
        DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccountObj != null) {
            Long costAccountId = costAccountObj.getLong("id");
            viewSubitem = CostaccountHelper.getCostElementByCostAccount((long)costAccountId);
        }
        if (!viewSubitem) {
            this.getModel().getDataEntity().set(VIEWSUBITEM, (Object)false);
        }
        this.getView().setVisible(Boolean.valueOf(viewSubitem), new String[]{VIEWSUBITEM});
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        String closestatus;
        super.formatDisplayFilterField(evt);
        String str = evt.getFormatedFilterString();
        boolean viewsubitem = this.getModel().getDataEntity().getBoolean(VIEWSUBITEM);
        if (viewsubitem) {
            str = str.concat(ResManager.loadKDString((String)"; \u663e\u793a\u5206\u9879\u6570\u636e\uff1a\u662f", (String)"CalcResultRptFormPlugin_7", (String)"macc-aca-report", (Object[])new Object[0]));
        }
        if ("A".equals(closestatus = this.getModel().getDataEntity().getString("closestatus"))) {
            str = str.concat(ResManager.loadKDString((String)"; \u5173\u95ed\u72b6\u6001\uff1a\u5df2\u5173\u95ed", (String)"CalcResultRptFormPlugin_8", (String)"macc-aca-report", (Object[])new Object[0]));
        } else if ("B".equals(closestatus)) {
            str = str.concat(ResManager.loadKDString((String)"; \u5173\u95ed\u72b6\u6001\uff1a\u672a\u5173\u95ed", (String)"CalcResultRptFormPlugin_9", (String)"macc-aca-report", (Object[])new Object[0]));
        }
        evt.setFormatedFilterString(str);
    }

    private void setCostAccount() {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Long mainBookId = CostAccountHelper.getCostAccountByAccoutOrg((Long)((DynamicObject)org).getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
        if (mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
        }
        this.getView().updateView("costaccount");
    }

    private void setPeriodAndCurrency() {
        DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
        if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
            this.getModel().setValue(PERIOD, null);
            this.getModel().setValue("currency", null);
        } else {
            Long costAccountId = costAccountObj.getLong("id");
            DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
            if (curPeriod == null) {
                this.getModel().setValue(PERIOD, null);
                this.getModel().setValue("currency", null);
            } else {
                Long currentPeriodId = curPeriod.getLong("id");
                this.getModel().setValue(PERIOD, (Object)new Object[]{currentPeriodId});
                this.getModel().setValue("currency", (Object)CurrencyHelper.getCurrency((DynamicObject)costAccountObj));
            }
        }
    }

    private void setOrg() {
        if (this.getModel().getValue("org") == null) {
            Long orgId = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
            if (!isAccounting) {
                return;
            }
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (orgIds.contains(orgId)) {
                this.getModel().setValue("org", (Object)orgId);
                this.getView().updateView("org");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "org": {
                this.setCostAccount(newValue);
                this.getModel().setValue("fmanuorg", null);
                this.getModel().setValue("fcostobject", null);
                this.setManuOrg();
                this.setOther();
                this.setCostAccount();
                break;
            }
            case "costaccount": {
                this.setPeriodAndCurrency();
                this.setViewSubItem();
                break;
            }
            case "viewsubitem": {
                boolean viewsubitem = (Boolean)this.getModel().getValue(VIEWSUBITEM);
                if (!viewsubitem) break;
                ReportConf reportConf = ReportDataHandle.loadReportConf((String)this.getBillEntityId());
                if (reportConf == null) {
                    this.getModel().setValue(VIEWSUBITEM, (Object)true);
                    break;
                }
                Set<String> selectSet = ReportRptHelper.getSelectKeyHashSet(this.getModel().getDataEntity().getString("showkeycols"));
                List<String> confs = CalcResultRptFormPlugin.filterBigtableCols(reportConf, null);
                List<String> downKeys = this.getSelectDownCol(confs, "subelement");
                boolean isUpdateField = false;
                if (ReportRptHelper.containKeys(selectSet, downKeys)) {
                    selectSet.removeAll(downKeys);
                    isUpdateField = true;
                }
                if (!ReportRptHelper.containKeys(selectSet, CalcResultRptConstants.ELEMENT_FIELDS)) {
                    selectSet.addAll(CalcResultRptConstants.ELEMENT_FIELDS);
                    isUpdateField = true;
                }
                if (!isUpdateField) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u663e\u793a\u5206\u9879\u6570\u636e\u65f6\uff0c\u4f1a\u5c55\u793a\u5b50\u8981\u7d20\u7ef4\u5ea6\u5e76\u5173\u95ed\u5b50\u7269\u6599\u660e\u7ec6\u7684\u5c55\u793a", (String)"CalcResultRptFormPlugin_10", (String)"macc-aca-report", (Object[])new Object[0]));
                this.getModel().beginInit();
                this.setShowCol(selectSet);
                this.getModel().endInit();
                break;
            }
            case "showkeycols": {
                this.showColSet(newValue, true);
                break;
            }
            case "viewtotal": {
                this.showQty();
            }
        }
    }

    private void setShowCol(Set<String> selectSet) {
        StringBuilder sb = new StringBuilder();
        for (String field : selectSet) {
            sb.append(field).append(",");
        }
        this.getModel().setValue("showkeycols", (Object)sb.toString());
        this.getView().updateView("showkeycols");
    }

    private void showColSet(Object newValue, boolean isTip) {
        ReportConf reportConf;
        String selectKey = (String)newValue;
        Set<String> selectSet = ReportRptHelper.getSelectKeyHashSet(selectKey);
        boolean viewsubitem = (Boolean)this.getModel().getValue(VIEWSUBITEM);
        if (viewsubitem && (reportConf = ReportDataHandle.loadReportConf((String)this.getBillEntityId())) != null) {
            List<String> confs = CalcResultRptFormPlugin.filterBigtableCols(reportConf, null);
            List<String> downKeys = this.getSelectDownCol(confs, "subelement");
            boolean isUpdateViewItem = false;
            if (!ReportRptHelper.containKeys(selectSet, CalcResultRptConstants.ELEMENT_FIELDS)) {
                isUpdateViewItem = true;
            }
            if (ReportRptHelper.containKeys(selectSet, downKeys)) {
                isUpdateViewItem = true;
            }
            if (isUpdateViewItem) {
                if (isTip) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u5c55\u793a\u5b50\u8981\u7d20\u4fe1\u606f\u6216\u8005\u5c55\u793a\u5b50\u7269\u6599\u660e\u7ec6\u4fe1\u606f\uff0c\u5173\u95ed\u663e\u793a\u5206\u9879\u6570\u636e\u5f00\u5173\u3002", (String)"CalcResultRptFormPlugin_11", (String)"macc-aca-report", (Object[])new Object[0]));
                }
                this.getModel().beginInit();
                this.getModel().setValue(VIEWSUBITEM, (Object)false);
                this.getView().updateView(VIEWSUBITEM);
                this.getModel().endInit();
            }
        }
        if (selectSet.contains("closestatus")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"closestatus"});
        } else {
            String closestatus = this.getModel().getDataEntity().getString("closestatus");
            if ("A".equals(closestatus) || "B".equals(closestatus)) {
                this.getModel().beginInit();
                this.getModel().setValue("closestatus", (Object)"S");
                this.getModel().endInit();
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"closestatus"});
        }
        if (selectSet.contains("submaterial")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FSUBMATERIAL});
        } else {
            DynamicObjectCollection fsubmaterial = this.getModel().getDataEntity().getDynamicObjectCollection(FSUBMATERIAL);
            if (fsubmaterial != null && !fsubmaterial.isEmpty()) {
                this.getModel().beginInit();
                this.getModel().setValue(FSUBMATERIAL, null);
                this.getView().updateView(FSUBMATERIAL);
                this.getModel().endInit();
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FSUBMATERIAL});
        }
        if (selectSet.contains("element") || selectSet.contains("subelement")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FSUBELEMENT});
        } else {
            DynamicObjectCollection fsubelement = this.getModel().getDataEntity().getDynamicObjectCollection(FSUBELEMENT);
            if (fsubelement != null && !fsubelement.isEmpty()) {
                this.getModel().beginInit();
                this.getModel().setValue(FSUBELEMENT, null);
                this.getView().updateView(FSUBELEMENT);
                this.getModel().endInit();
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FSUBELEMENT});
        }
    }

    private List<String> getSelectDownCol(List<String> confs, String key) {
        ArrayList<String> downKeys = new ArrayList<String>(10);
        boolean isDown = false;
        for (String conf : confs) {
            if (isDown) {
                downKeys.add(conf);
                continue;
            }
            if (!conf.equals(key)) continue;
            isDown = true;
        }
        return downKeys;
    }

    public static List<String> filterBigtableCols(ReportConf conf, IFilter<BigTableColConf> filter) {
        List bigTableColConf = conf.getBigTableColConf();
        ArrayList<String> fsCol = new ArrayList<String>(10);
        for (BigTableColConf colConf : bigTableColConf) {
            if (filter == null) {
                fsCol.add(colConf.getCol());
                continue;
            }
            if (!filter.filter((Object)colConf)) continue;
            fsCol.add(colConf.getCol());
        }
        return fsCol;
    }

    private void setOther() {
        this.getModel().setValue("costaccount", null);
        this.getModel().setValue(PERIOD, null);
        this.getModel().setValue("currency", null);
    }

    private QFilter[] getCostCenterFilter() {
        QFilter orgdutyFilter = new QFilter("orgduty", "=", (Object)4L);
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (!CollectionUtils.isEmpty((Collection)orgIds)) {
                orgdutyFilter.and(new QFilter("accountorg", "in", (Object)orgIds));
            }
        } else {
            orgdutyFilter.and(new QFilter("accountorg", "=", org.getPkValue()));
        }
        orgdutyFilter.and("enable", "=", (Object)"1");
        return new QFilter[]{orgdutyFilter};
    }

    private List<QFilter> getCostObjectFilter() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        DynamicObjectCollection rows = (DynamicObjectCollection)this.getModel().getValue("fcostcenter");
        HashSet<Long> costCenterIds = new HashSet<Long>(16);
        for (DynamicObject row : rows) {
            DynamicObject costCenter = row.getDynamicObject("fbasedataid");
            costCenterIds.add((Long)costCenter.getPkValue());
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        if (org != null) {
            QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
            filters.add(orgFilter);
        } else {
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (!CollectionUtils.isEmpty((Collection)orgIds)) {
                filters.add(new QFilter("org", "in", (Object)orgIds));
            }
        }
        if (!CadEmptyUtils.isEmpty(costCenterIds)) {
            QFilter costCenterFilter = new QFilter("costcenter", "in", costCenterIds);
            filters.add(costCenterFilter);
        }
        return filters;
    }

    private QFilter getCostAccountFilter() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        List orgUseCostAccountIds = CostAccountHelper.getOrgStdCostAccount((Long)((Long)org.getPkValue()), (String)this.getView().getFormShowParameter().getAppId());
        return new QFilter("id", "in", (Object)orgUseCostAccountIds.toArray());
    }

    private QFilter getPeriodFilter() {
        DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null || costAccount == null) {
            return null;
        }
        long orgId = org.getLong("id");
        long costAccountId = costAccount.getLong("id");
        return StartCostHelper.getPeriodTypeFilter((String)"aca", (Long)orgId, (Long)costAccountId);
    }

    private void setCostAccount(Object org) {
        if (org == null) {
            return;
        }
        DynamicObject orgDO = (DynamicObject)org;
        Long mainBookId = OrgHelper.getCostAccountByAccoutOrg((Long)orgDO.getLong("id"));
        if (mainBookId != null && mainBookId != 0L) {
            boolean isnit = StartCostHelper.isInit((Long)mainBookId, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
            if (isnit) {
                this.getModel().setValue("costaccount", (Object)mainBookId);
            }
        } else {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue(PERIOD, null);
        }
    }

    private void setCurrencyAndPeriod(Object costAccount) {
        if (costAccount == null) {
            return;
        }
        DynamicObject costAccountDO = (DynamicObject)costAccount;
        Long currency = CalcRptHelper.getCurrency((DynamicObject)costAccountDO);
        this.getModel().setValue("currency", (Object)currency);
        this.setPeriod();
    }

    private void setPeriod() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        DynamicObject costaccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        if (org == null || costaccount == null) {
            return;
        }
        long orgId = org.getLong("id");
        long costAccountId = costaccount.getLong("id");
        Long currPeriod = CalcRptHelper.getCurrPeriod((Long)orgId, (Long)costAccountId);
        if (currPeriod != null && currPeriod != 0L) {
            this.getModel().setValue(PERIOD, (Object)new Object[]{currPeriod});
        }
    }

    private void setManuOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        boolean enableMultiFactory = false;
        if (org != null) {
            enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)((Long)org.getPkValue()));
        }
        if (!enableMultiFactory) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fmanuorg"});
        }
        BasedataEdit manuOrgEdit = (BasedataEdit)this.getControl("fmanuorg");
        manuOrgEdit.setMustInput(enableMultiFactory);
        this.getView().setEnable(Boolean.valueOf(enableMultiFactory), new String[]{"fmanuorg"});
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        boolean enableMultiFactory = false;
        if (org != null) {
            enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)((Long)org.getPkValue()));
        }
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof ReportColumn)) continue;
            ReportColumn reportColumn = (ReportColumn)obj;
            String key = reportColumn.getFieldKey();
            if (enableMultiFactory || !"manuorg".equals(key)) continue;
            reportColumn.setHide(true);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        ReportConf reportConf;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        DynamicObject currency = dataEntity.getDynamicObject("currency");
        MulBasedataDynamicObjectCollection periods = (MulBasedataDynamicObjectCollection)this.getModel().getValue(PERIOD);
        Set<String> selectSet = ReportRptHelper.getSelectKeyHashSet(this.getModel().getDataEntity().getString("showkeycols"));
        if (selectSet.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6c47\u603b\u4f9d\u636e\u3002", (String)"CalcResultRptFormPlugin_12", (String)"macc-aca-report", (Object[])new Object[0]));
            return false;
        }
        boolean viewItem = dataEntity.getBoolean(VIEWSUBITEM);
        if (viewItem && (reportConf = ReportDataHandle.loadReportConf((String)this.getBillEntityId())) != null) {
            List<String> confs = CalcResultRptFormPlugin.filterBigtableCols(reportConf, null);
            List<String> downKeys = this.getSelectDownCol(confs, "subelement");
            boolean isUpdateField = false;
            if (ReportRptHelper.containKeys(selectSet, downKeys)) {
                isUpdateField = true;
            }
            if (!ReportRptHelper.containKeys(selectSet, CalcResultRptConstants.ELEMENT_FIELDS)) {
                isUpdateField = true;
            }
            if (isUpdateField) {
                dataEntity.set(VIEWSUBITEM, (Object)false);
                this.getView().updateView(VIEWSUBITEM);
            }
        }
        if (!(CadEmptyUtils.isEmpty((DynamicObject)org) || CadEmptyUtils.isEmpty((DynamicObject)costAccount) || CadEmptyUtils.isEmpty((DynamicObject)currency) || CadEmptyUtils.isEmpty((DynamicObjectCollection)periods))) {
            CalcResultParam calcResultParam = this.buildCalcResultParam(dataEntity);
            this.getQueryParam().getCustomParam().put(CalcResultParam.class.getName(), calcResultParam);
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"CalcResultRptFormPlugin_3", (String)"macc-aca-report", (Object[])new Object[0]));
        return false;
    }

    private CalcResultParam buildCalcResultParam(DynamicObject dataEntity) {
        MulBasedataDynamicObjectCollection subelementCollection;
        MulBasedataDynamicObjectCollection submaterialCollection;
        MulBasedataDynamicObjectCollection materialCollection;
        MulBasedataDynamicObjectCollection costObjectCollection;
        MulBasedataDynamicObjectCollection costCenterCollection;
        MulBasedataDynamicObjectCollection manuOrgCollection;
        MulBasedataDynamicObjectCollection periods;
        DynamicObject currency;
        DynamicObject costAccount;
        CalcResultParam calcResultParam = new CalcResultParam();
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
            calcResultParam.setOrgId(org.getLong("id"));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObject)(costAccount = dataEntity.getDynamicObject("costaccount")))) {
            calcResultParam.setCostAccountId(costAccount.getLong("id"));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObject)(currency = dataEntity.getDynamicObject("currency")))) {
            calcResultParam.setCurrencyId(currency.getLong("id"));
            calcResultParam.setAmtPrecision(currency.getInt("amtprecision"));
            calcResultParam.setPricePrecision(currency.getInt("priceprecision"));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(periods = (MulBasedataDynamicObjectCollection)this.getModel().getValue(PERIOD)))) {
            calcResultParam.setPeriodIds(periods.stream().map(period -> period.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(manuOrgCollection = (MulBasedataDynamicObjectCollection)this.getModel().getValue("fmanuorg")))) {
            calcResultParam.setManuOrgIds(manuOrgCollection.stream().map(manuOrg -> manuOrg.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(costCenterCollection = (MulBasedataDynamicObjectCollection)this.getModel().getValue("fcostcenter")))) {
            calcResultParam.setCostCenterIds(costCenterCollection.stream().map(costCenter -> costCenter.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(costObjectCollection = (MulBasedataDynamicObjectCollection)this.getModel().getValue("fcostobject")))) {
            calcResultParam.setCostObjectIds(costObjectCollection.stream().map(costObject -> costObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(materialCollection = (MulBasedataDynamicObjectCollection)this.getModel().getValue("fmaterial")))) {
            calcResultParam.setMaterialIds(materialCollection.stream().map(material -> material.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(submaterialCollection = (MulBasedataDynamicObjectCollection)this.getModel().getValue(FSUBMATERIAL)))) {
            calcResultParam.setSubMaterialIds(submaterialCollection.stream().map(t -> t.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet()));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(subelementCollection = (MulBasedataDynamicObjectCollection)this.getModel().getValue(FSUBELEMENT)))) {
            calcResultParam.setSubelementIds(subelementCollection.stream().map(t -> t.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet()));
        }
        boolean mergeSame = dataEntity.getBoolean("mergesame");
        calcResultParam.setMergeSame(mergeSame);
        calcResultParam.setViewSubitem(dataEntity.getBoolean(VIEWSUBITEM));
        calcResultParam.setClosestatus(dataEntity.getString("closestatus"));
        calcResultParam.setViewtotal(dataEntity.getBoolean("viewtotal"));
        return calcResultParam;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"CalcResultRptFormPlugin_4", (String)"macc-aca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u6210\u672c\u8ba1\u7b97\u5355\u67e5\u8be2", (String)"CalcResultRptFormPlugin_5", (String)"macc-aca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"aca_calcresultnew", (IDataModel)this.getModel());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        if (("exportexcel".equals(operateKey) || "syncexportexcel".equals(operateKey)) && !PermItemCheckHelper.isPerm((String)this.getBillEntityId(), (String)"47150e89000000ac", (Long)org.getLong("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6210\u672c\u8ba1\u7b97\u5355\u201d\u7684\u201c\u5bfc\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CalcResultRptFormPlugin_13", (String)"macc-aca-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        if (!this.getModel().getDataEntity(true).getBoolean("mergesame")) {
            return;
        }
        Set<String> selectSet = ReportRptHelper.getSelectKeyHashSet(this.getModel().getDataEntity().getString("showkeycols"));
        ReportConf reportConf = ReportDataHandle.loadReportConf((String)this.getBillEntityId());
        if (reportConf != null) {
            List<String> confs = CalcResultRptFormPlugin.filterBigtableCols(reportConf, null);
            ArrayList<String> needClearCols = new ArrayList<String>(10);
            boolean isDown = false;
            for (String conf : confs) {
                if (conf.contains("element")) {
                    isDown = true;
                }
                if (isDown || !selectSet.contains(conf)) continue;
                needClearCols.add(conf);
            }
            if (!needClearCols.isEmpty()) {
                for (String field : CalcResultRptConstants.ADD_NUM_FIELDS) {
                    if (!needClearCols.contains(field)) continue;
                    needClearCols.add(field + "number");
                }
                if (needClearCols.contains("material")) {
                    needClearCols.add("unit");
                }
                ReportUtils.clearFileNameValue((String[])needClearCols.toArray(new String[0]), (DynamicObjectCollection)rowData, (String[])needClearCols.toArray(new String[0]));
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        String fieldName = null;
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if (this.filterGrid(fieldName)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private boolean filterGrid(String fieldName) {
        String[] split = fieldName.split("\\.");
        for (String key : FILTER_NOTCONTAIN_FIELDS) {
            if (!fieldName.startsWith(key)) continue;
            return true;
        }
        return false;
    }
}

