/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.calc.function;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.aca.algox.utils.BigDecimalUtil;
import kd.macc.aca.report.calc.model.CalcResultRptConstants;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CalcResultRptCalcSubTotalFunction
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private int pricePrecision;
    private Set<String> showQtyFields;

    public CalcResultRptCalcSubTotalFunction(int pricePrecision, Set<String> showQtyFields) {
        this.pricePrecision = pricePrecision;
        this.showQtyFields = showQtyFields;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        ArrayList listRows = Lists.newArrayList();
        RowX compRow = null;
        for (RowX row : iterable) {
            if ("1".equals(row.getString(this.sourceRowMeta.getFieldIndex("datatype")))) {
                compRow = row;
                continue;
            }
            listRows.add(row);
        }
        if (compRow == null) {
            compRow = ((RowX)listRows.get(0)).copy();
            for (String col : CalcResultRptConstants.QTY_FIELDS) {
                compRow.set(this.sourceRowMeta.getFieldIndex(col), (Object)BigDecimal.ZERO);
            }
        }
        HashSet<String> amtQtys = new HashSet<String>(this.showQtyFields);
        amtQtys.removeAll(CalcResultRptConstants.QTY_FIELDS);
        for (RowX row : listRows) {
            for (String col : amtQtys) {
                int index = this.sourceRowMeta.getFieldIndex(col, false);
                if (index < 0) continue;
                BigDecimal amt = BigDecimalUtil.getOrZero((Object)compRow.getBigDecimal(index));
                compRow.set(index, (Object)amt.add(BigDecimalUtil.getOrZero((Object)row.getBigDecimal(index))));
            }
        }
        this.calcUnitCost(listRows, compRow, "currcomunitcost", "currcomamount", "currcomqty");
        this.calcUnitCost(listRows, compRow, "totalcomunitcost", "totalcomamount", "totalcomqty");
        this.calcUnitCost(listRows, compRow, "yeartotalcomunitcost", "yeartotalcomamount", "yeartotalcomqty");
        this.calcUnitUse(listRows, compRow, "currcomuse", "currcomqty");
        this.calcUnitUse(listRows, compRow, "sumcomuse", "totalcomqty");
        this.calcUnitUse(listRows, compRow, "yearsumcomuse", "yeartotalcomqty");
        for (RowX row : listRows) {
            if (this.isZeroRow(row)) continue;
            collector.collect(row);
        }
        collector.collect(compRow);
    }

    private boolean isZeroRow(RowX row) {
        for (String field : this.showQtyFields) {
            BigDecimal val = row.getBigDecimal(this.sourceRowMeta.getFieldIndex(field));
            if (val == null || val.compareTo(BigDecimal.ZERO) == 0) continue;
            return false;
        }
        return true;
    }

    private void calcUnitCost(List<RowX> rows, RowX compRow, String unitCostField, String finAmtField, String finAtyField) {
        int compuseIndex = this.sourceRowMeta.getFieldIndex(unitCostField, false);
        int matIndex = this.getResultRowMeta().getFieldIndex("submaterial", false);
        if (compuseIndex >= 0) {
            for (RowX row : rows) {
                row.set(compuseIndex, (Object)BigDecimal.ZERO);
            }
            compRow.set(compuseIndex, (Object)BigDecimal.ZERO);
        }
        int finamtIndex = this.sourceRowMeta.getFieldIndex(finAmtField, false);
        int finqtyIndex = this.sourceRowMeta.getFieldIndex(finAtyField, false);
        if (finamtIndex >= 0 && finqtyIndex >= 0) {
            BigDecimal comFinQty = BigDecimalUtil.getOrZero((Object)compRow.getBigDecimal(finqtyIndex));
            BigDecimal comFinAmt = BigDecimalUtil.getOrZero((Object)compRow.getBigDecimal(finamtIndex));
            if (comFinAmt.compareTo(BigDecimal.ZERO) != 0 && comFinQty.compareTo(BigDecimal.ZERO) != 0) {
                compRow.set(compuseIndex, (Object)this.setUnitCost(comFinAmt.divide(comFinQty, this.pricePrecision, 4)));
            }
            for (RowX row : rows) {
                Long matId;
                BigDecimal finQty = row.getBigDecimal(finqtyIndex);
                BigDecimal finAmt = BigDecimalUtil.getOrZero((Object)row.getBigDecimal(finamtIndex));
                if (finAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                if (finQty.compareTo(BigDecimal.ZERO) != 0) {
                    row.set(compuseIndex, (Object)this.setUnitCost(finAmt.divide(finQty, this.pricePrecision, 4)));
                    continue;
                }
                if (matIndex < 0 || !CadEmptyUtils.isEmpty((Long)(matId = row.getLong(matIndex))) || comFinQty.compareTo(BigDecimal.ZERO) == 0) continue;
                row.set(compuseIndex, (Object)this.setUnitCost(finAmt.divide(comFinQty, this.pricePrecision, 4)));
            }
        }
    }

    private BigDecimal setUnitCost(BigDecimal unitcost) {
        if (unitcost == null || unitcost.compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimal.ZERO;
        }
        return unitcost;
    }

    private void calcUnitUse(List<RowX> rows, RowX compRow, String unitUseField, String finQtyField) {
        BigDecimal comFinQty;
        int finqtyIndex;
        int compuseIndex = this.sourceRowMeta.getFieldIndex(unitUseField, false);
        if (compuseIndex >= 0) {
            for (RowX row : rows) {
                row.set(compuseIndex, (Object)BigDecimal.ZERO);
            }
            compRow.set(compuseIndex, (Object)BigDecimal.ZERO);
        }
        if ((finqtyIndex = this.sourceRowMeta.getFieldIndex(finQtyField, false)) >= 0 && (comFinQty = BigDecimalUtil.getOrZero((Object)compRow.getBigDecimal(finqtyIndex))).compareTo(BigDecimal.ZERO) != 0) {
            for (RowX row : rows) {
                BigDecimal finQty = BigDecimalUtil.getOrZero((Object)row.getBigDecimal(finqtyIndex));
                row.set(compuseIndex, (Object)finQty.divide(comFinQty, 10, 4));
            }
        }
    }
}

