/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.calc.function;

import java.math.BigDecimal;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.macc.aca.algox.utils.BigDecimalUtil;

public class CalcResultRptTotalUnitAmtFunction
extends MapFunction {
    private static final long serialVersionUID = 1L;
    private int pricePrecision = 4;

    public CalcResultRptTotalUnitAmtFunction(int pricePrecision) {
        this.pricePrecision = pricePrecision;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public RowX map(RowX row) {
        this.calcUnitCost(row, "currcomunitcost", "currcomamount", "currcomqty");
        this.calcUnitCost(row, "totalcomunitcost", "totalcomamount", "totalcomqty");
        this.calcUnitCost(row, "yeartotalcomunitcost", "yeartotalcomamount", "yeartotalcomqty");
        return row;
    }

    private void calcUnitCost(RowX compRow, String unitCostField, String finAmtField, String finAtyField) {
        int compuseIndex = this.sourceRowMeta.getFieldIndex(unitCostField, false);
        if (compuseIndex >= 0) {
            compRow.set(compuseIndex, (Object)BigDecimal.ZERO);
        }
        int finamtIndex = this.sourceRowMeta.getFieldIndex(finAmtField, false);
        int finqtyIndex = this.sourceRowMeta.getFieldIndex(finAtyField, false);
        if (finamtIndex >= 0 && finqtyIndex >= 0) {
            BigDecimal comFinQty = BigDecimalUtil.getOrZero((Object)compRow.getBigDecimal(finqtyIndex));
            BigDecimal comFinAmt = BigDecimalUtil.getOrZero((Object)compRow.getBigDecimal(finamtIndex));
            if (comFinAmt.compareTo(BigDecimal.ZERO) != 0 && comFinQty.compareTo(BigDecimal.ZERO) != 0) {
                compRow.set(compuseIndex, (Object)this.setUnitCost(comFinAmt.divide(comFinQty, this.pricePrecision, 4)));
            }
        }
    }

    private BigDecimal setUnitCost(BigDecimal unitcost) {
        if (unitcost == null || unitcost.compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimal.ZERO;
        }
        return unitcost;
    }
}

