/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.calc.handle;

import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.aca.algox.costcalc.common.ActCalcHelper;
import kd.macc.aca.algox.utils.DataSetXHelper;
import kd.macc.aca.report.calc.function.CalcResultRptDealSubItemFunction;
import kd.macc.aca.report.calc.function.CalcResultRptDealSumInputFunction;
import kd.macc.aca.report.calc.function.CommonSetMatFunction;
import kd.macc.aca.report.calc.model.CalcResultParam;
import kd.macc.aca.report.calc.model.CalcResultRptConstants;
import kd.macc.aca.report.helper.ReportRptHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang.StringUtils;

public class CalcResultRptHandleFinalRow
implements IDataXTransform {
    private ReportDataCtx ctx;
    private CalcResultParam reportParam;
    private List<String> yearPeriodFields;

    public CalcResultRptHandleFinalRow(CalcResultParam calcResultParam, ReportDataCtx ctx, List<String> yearPeriodFields) {
        this.ctx = ctx;
        this.reportParam = calcResultParam;
        this.yearPeriodFields = yearPeriodFields;
    }

    public DataSetX doTransform(DataSetX srcData) {
        if (this.reportParam.isViewSubitem()) {
            srcData = srcData.map((MapFunction)new CalcResultRptDealSubItemFunction());
        }
        srcData = this.dealViewTotal(srcData);
        srcData = this.dealCloseStatus(srcData);
        srcData = this.dealMatField(srcData);
        srcData = this.dealSubItemData(srcData);
        return srcData;
    }

    private DataSetX dealViewTotal(DataSetX srcData) {
        if (this.reportParam.isViewtotal() && !this.reportParam.isDimContainCostobject()) {
            DataSetX curSrcData = srcData.filter("period in (" + StringUtils.join((Object[])this.reportParam.getPeriodIds().toArray(), (char)',') + ")");
            curSrcData = curSrcData.map((MapFunction)new CalcResultRptDealSumInputFunction(this.yearPeriodFields));
            HashSet groupCols = new HashSet(16);
            Set showKeyCols = this.ctx.getShowKeyCols();
            groupCols.addAll(showKeyCols);
            groupCols.remove("period");
            DataSetX periodX = null;
            for (Map.Entry<Long, Set<Long>> entry : this.reportParam.getPeriodYearMap().entrySet()) {
                if (CadEmptyUtils.isEmpty(entry.getValue())) continue;
                DataSetX yearData = srcData.filter("period in (" + StringUtils.join((Object[])entry.getValue().toArray(), (char)',') + ")").groupBy(groupCols.toArray(new String[0])).sum("pdcurrqty", "yearpdsumqty").sum("pdcurramount", "yearpdsumamount").sum("currcomqty", "yeartotalcomqty").sum("currcomuse", "yearsumcomuse").sum("currcomunitcost", "yeartotalcomunitcost").sum("currcomamount", "yeartotalcomamount").addFields(new Field[]{new Field("period", (DataType)DataType.LongType)}, new Object[]{entry.getKey()});
                if (periodX == null) {
                    periodX = yearData;
                    continue;
                }
                periodX = periodX.union(yearData);
            }
            if (periodX != null) {
                curSrcData = DataSetXHelper.unionIfRowDiff((DataSetX)curSrcData, periodX);
                curSrcData = ReportRptHelper.groupSumAndMaxDeal(curSrcData, this.ctx.getShowKeyCols().toArray(new String[0]), this.ctx.getShowQtyCols().toArray(new String[0]), null);
            }
            srcData = curSrcData;
        }
        return srcData;
    }

    private DataSetX dealSubItemData(DataSetX srcData) {
        if (this.reportParam.isViewSubitem() && !CadEmptyUtils.isEmpty(this.reportParam.getSubelementIds())) {
            final Set<Long> subElementIds = this.reportParam.getSubelementIds();
            srcData = srcData.filter(new FilterFunction(){

                public boolean test(RowX row) {
                    Long subelement = row.getLong(this.sourceRowMeta.getFieldIndex("subelement"));
                    String type = row.getString(this.sourceRowMeta.getFieldIndex("type"));
                    return "finalResult".equals(type) || subElementIds.contains(subelement);
                }
            });
        }
        return srcData;
    }

    private DataSetX dealMatField(DataSetX srcData) {
        Set selectKeyCols = this.ctx.getShowKeyCols();
        if (ReportRptHelper.containKeys(selectKeyCols, CalcResultRptConstants.MAT_RELA_FIELDS) || ReportRptHelper.containKeys(selectKeyCols, CalcResultRptConstants.SUBMAT_RELA_FIELDS)) {
            HashSet<String> fieldNames;
            QFilter filter = this.getCommonFilter("1");
            if (!ReportRptHelper.containKeys(selectKeyCols, CalcResultRptConstants.SUBMAT_RELA_FIELDS)) {
                filter.and("entryentity.type", "=", (Object)"finalResult");
            } else if (!CadEmptyUtils.isEmpty(this.reportParam.getSubMaterialIds())) {
                filter.and(new QFilter("entryentity.submaterial", "in", this.reportParam.getSubMaterialIds()).or("entryentity.type", "=", (Object)"finalResult"));
            }
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ACA_CALCRESULT", (String)"aca_calcresult", (String)"entryentity.relacostobject.material material,entryentity.submaterial submaterial", (QFilter[])filter.toArray(), null);
            dataSet = dataSet.distinct();
            HashSet materialIds = Sets.newHashSetWithExpectedSize((int)10);
            for (Row row : dataSet) {
                Long material = row.getLong("material");
                Long submaterial = row.getLong("submaterial");
                if (!CadEmptyUtils.isEmpty((Long)material)) {
                    materialIds.add(material);
                }
                if (CadEmptyUtils.isEmpty((Long)submaterial)) continue;
                materialIds.add(submaterial);
            }
            QFilter matFilter = new QFilter("id", "in", (Object)materialIds);
            OrmInput matDataSet = new OrmInput("BD_MATERIAL", "bd_material", "id mat_id,number mat_number,modelnum mat_modelnum,baseunit mat_baseunit", matFilter.toArray());
            DataSetX matDataSetX = this.ctx.getCurrentJob().fromInput((Input)matDataSet);
            if (ReportRptHelper.containKeys(selectKeyCols, CalcResultRptConstants.MAT_RELA_FIELDS)) {
                fieldNames = new HashSet<String>(Arrays.asList(srcData.getRowMeta().getFieldNames()));
                srcData = srcData.leftJoin(matDataSetX).on("material", "mat_id").select(fieldNames.toArray(new String[0]), CalcResultRptConstants.MAT_FIELDS.toArray(new String[0]));
                srcData = srcData.map((MapFunction)new CommonSetMatFunction(CalcResultRptConstants.MAT_RELA_FIELDS, CalcResultRptConstants.MAT_TOSOURCEFIELD_MAP));
                fieldNames.removeAll(CalcResultRptConstants.MAT_FIELDS);
            }
            if (ReportRptHelper.containKeys(selectKeyCols, CalcResultRptConstants.SUBMAT_RELA_FIELDS)) {
                fieldNames = new HashSet<String>(Arrays.asList(srcData.getRowMeta().getFieldNames()));
                fieldNames.removeAll(CalcResultRptConstants.MAT_FIELDS);
                srcData = srcData.leftJoin(matDataSetX).on("submaterial", "mat_id").select(fieldNames.toArray(new String[0]), CalcResultRptConstants.MAT_FIELDS.toArray(new String[0]));
                srcData = srcData.map((MapFunction)new CommonSetMatFunction(CalcResultRptConstants.SUBMAT_RELA_FIELDS, CalcResultRptConstants.SUBMAT_TOSOURCEFIELD_MAP));
            }
        }
        return srcData;
    }

    private DataSetX dealCloseStatus(DataSetX srcData) {
        Set selectKeyCols = this.ctx.getShowKeyCols();
        boolean isQuery = "A".equals(this.reportParam.getClosestatus()) || "B".equals(this.reportParam.getClosestatus());
        boolean isKeyCol = selectKeyCols.contains("closestatus");
        if (isQuery || isKeyCol) {
            QFilter filter = this.getCommonFilter("0");
            filter.and("entryentity.type", "=", (Object)"finalResult");
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"costobject", (String)"aca_calcresult", (String)"entryentity.relacostobject costobject", (QFilter[])filter.toArray(), null);
            Set costobjectIds = ActCalcHelper.getLongIdSetFromDs((DataSet)dataSet, (String)"costobject", (boolean)false);
            QFilter planFilter = new QFilter("accountorg", "=", (Object)this.reportParam.getOrgId());
            planFilter.and("costobject", "in", (Object)costobjectIds);
            planFilter.and("closestatu", "=", (Object)true);
            OrmInput planDataSet = new OrmInput("plan", "cad_plannedoutputbill", "costobject,closestatu,closedatetime", planFilter.toArray());
            DataSetX planDataSetX = this.ctx.getCurrentJob().fromInput((Input)planDataSet);
            planDataSetX = planDataSetX.groupBy(new String[]{"costobject", "closestatu"}).max("closedatetime");
            HashSet<String> fieldNames = new HashSet<String>(Arrays.asList(srcData.getRowMeta().getFieldNames()));
            srcData = srcData.leftJoin(planDataSetX).on("costobject", "costobject").select(fieldNames.toArray(new String[0]), new String[]{"closestatu", "closedatetime"});
            if (isQuery) {
                srcData = "A".equals(this.reportParam.getClosestatus()) ? srcData.filter("closestatu=true") : srcData.filter("closestatu<>true");
            }
            if (isKeyCol) {
                srcData = srcData.map(new MapFunction(){

                    public RowMeta getResultRowMeta() {
                        return this.sourceRowMeta;
                    }

                    public RowX map(RowX row) {
                        Boolean closestatu = row.getBoolean(this.sourceRowMeta.getFieldIndex("closestatu"));
                        Date closedatetime = row.getDate(this.sourceRowMeta.getFieldIndex("closedatetime"));
                        if (closestatu != null && closestatu.booleanValue()) {
                            row.set(this.sourceRowMeta.getFieldIndex("closestatus"), (Object)"A");
                        } else {
                            row.set(this.sourceRowMeta.getFieldIndex("closestatus"), (Object)"B");
                        }
                        if (closedatetime != null) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            String date = sdf.format(closedatetime);
                            row.set(this.sourceRowMeta.getFieldIndex("closedate"), (Object)date);
                        }
                        return row;
                    }
                });
            }
        }
        return srcData;
    }

    private QFilter getCommonFilter(String type) {
        List<Long> costCenterIds;
        QFilter filter = new QFilter("org", "=", (Object)this.reportParam.getOrgId());
        filter.and("costaccount", "=", (Object)this.reportParam.getCostAccountId());
        if ("1".equals(type)) {
            filter.and("period", "in", this.reportParam.getQueryPeriodIds());
        } else {
            filter.and("period", "in", this.reportParam.getPeriodIds());
        }
        List<Long> manuOrgIds = this.reportParam.getManuOrgIds();
        if (!CadEmptyUtils.isEmpty(manuOrgIds)) {
            filter.and("costobject.manuorg", "in", manuOrgIds);
        }
        if (!CadEmptyUtils.isEmpty(costCenterIds = this.reportParam.getCostCenterIds())) {
            filter.and("costcenter", "in", costCenterIds);
        }
        if (this.reportParam.getMainCostObjectIds() != null) {
            filter.and("costobject", "in", this.reportParam.getMainCostObjectIds());
        }
        return filter;
    }
}

