/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.calc.handle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.Grouper;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.aca.algox.utils.DataSetXHelper;
import kd.macc.aca.report.calc.function.CalcResultRptTotalUnitAmtFunction;
import kd.macc.aca.report.calc.model.CalcResultParam;
import kd.macc.aca.report.calc.model.CalcResultRptConstants;
import kd.macc.aca.report.helper.ReportRptHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CalcResultRptHandleSumRow
implements IDataXTransform {
    private ReportDataCtx ctx;
    private CalcResultParam reportParam;

    public CalcResultRptHandleSumRow(CalcResultParam calcResultParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.reportParam = calcResultParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        srcData = srcData.addFields(new Field[]{new Field("costobjectnumo", (DataType)DataType.IntegerType), new Field("costcenternumo", (DataType)DataType.IntegerType), new Field("periodnumo", (DataType)DataType.IntegerType), new Field("allo", (DataType)DataType.IntegerType), new Field("currencyfield", (DataType)DataType.LongType)}, new Object[]{0, 0, 0, 0, this.reportParam.getCurrencyId()});
        srcData = srcData.map(new MapFunction(){
            private static final long serialVersionUID = 1L;

            public RowMeta getResultRowMeta() {
                return this.sourceRowMeta;
            }

            public RowX map(RowX paramRowX) {
                String datatype = paramRowX.getString(this.sourceRowMeta.getFieldIndex("datatype"));
                if (!"6".equals(datatype)) {
                    paramRowX.set(this.sourceRowMeta.getFieldIndex("costobjectnumo"), (Object)1);
                }
                return paramRowX;
            }
        });
        DataSetX totalAllDsx = null;
        DataSetX compDataDsx = null;
        compDataDsx = this.reportParam.isShowDetail() ? srcData.filter("datatype='1'") : srcData;
        this.ctx.getShowKeyCols().add("currencyfield");
        HashSet<String> groupCols = new HashSet<String>(this.ctx.getShowKeyCols());
        DataSetX costcenterDsx = null;
        if (groupCols.contains("costcenter")) {
            List<String> inKeys = ReportRptHelper.getDownKeyCols("costcenter", "number", this.reportParam.getAllKeyCols());
            groupCols.removeAll(inKeys);
            totalAllDsx = costcenterDsx = this.groupSumQtyField(compDataDsx, groupCols, this.ctx.getShowQtyCols(), "7", 0, 1, 0, 0);
        }
        DataSetX periodDsx = null;
        if (groupCols.contains("period")) {
            List<String> inKeys = ReportRptHelper.getDownKeyCols("period", "number", this.reportParam.getAllKeyCols());
            groupCols.removeAll(inKeys);
            periodDsx = costcenterDsx != null ? this.groupSumQtyField(costcenterDsx, groupCols, this.ctx.getShowQtyCols(), "8", 0, 0, 1, 0) : this.groupSumQtyField(compDataDsx, groupCols, this.ctx.getShowQtyCols(), "8", 0, 0, 1, 0);
            totalAllDsx = totalAllDsx != null ? DataSetXHelper.unionIfRowDiff((DataSetX)totalAllDsx, (DataSetX)periodDsx) : periodDsx;
        }
        DataSetX totalDsx = null;
        totalDsx = periodDsx != null ? periodDsx : (costcenterDsx != null ? costcenterDsx : compDataDsx);
        HashSet<String> groupFields = new HashSet<String>(16);
        groupFields.add("currencyfield");
        totalDsx = this.groupSumQtyField(totalDsx, groupFields, this.ctx.getShowQtyCols(), "9", 0, 0, 0, 1);
        totalAllDsx = totalAllDsx != null ? DataSetXHelper.unionIfRowDiff((DataSetX)totalAllDsx, (DataSetX)totalDsx) : totalDsx;
        totalAllDsx = totalAllDsx.map((MapFunction)new CalcResultRptTotalUnitAmtFunction(this.reportParam.getPricePrecision()));
        srcData = DataSetXHelper.unionIfRowDiff((DataSetX)srcData, (DataSetX)totalAllDsx);
        if (this.ctx.getShowKeyCols().contains("unit") && this.ctx.getShowKeyCols().contains("submatunit")) {
            srcData = srcData.map(new MapFunction(){

                public RowMeta getResultRowMeta() {
                    return this.sourceRowMeta;
                }

                public RowX map(RowX row) {
                    Long submatunit = row.getLong(this.sourceRowMeta.getFieldIndex("submatunit"));
                    if (!CadEmptyUtils.isEmpty((Long)submatunit)) {
                        row.set(this.sourceRowMeta.getFieldIndex("unit"), (Object)submatunit);
                    }
                    return row;
                }
            });
            srcData = srcData.removeFields(new String[]{"submatunit"});
        }
        List<String> orderFields = this.getSortField();
        return srcData.orderBy(orderFields.toArray(new String[0]));
    }

    private List<String> getSortField() {
        List<String> inKeys = ReportRptHelper.getUpKeyCols("element", "number", this.reportParam.getAllKeyCols());
        ArrayList<String> orderFields = new ArrayList<String>(10);
        orderFields.add("allo asc");
        List<String> notSortField = Arrays.asList("currencyfield", "datatype", "unit", "closestatus", "closedate");
        List<String> hasOrderField = Arrays.asList("period", "costcenter");
        List<String> descField = Collections.singletonList("producttype");
        for (String key : inKeys) {
            if (!this.ctx.getShowKeyCols().contains(key) || notSortField.contains(key)) continue;
            if (!CalcResultRptConstants.ADD_NUM_FIELDS.contains(key)) {
                if (descField.contains(key)) {
                    orderFields.add(key + " desc");
                } else {
                    orderFields.add(key + " asc");
                }
            }
            if (!hasOrderField.contains(key)) continue;
            orderFields.add(key + "numo asc");
        }
        orderFields.add("costobjectnumo desc");
        if (this.reportParam.isShowDetail()) {
            if (this.ctx.getShowKeyCols().contains("materialnumber")) {
                orderFields.add("materialnumber asc");
            }
            if (this.ctx.getShowKeyCols().contains("elementnumber")) {
                orderFields.add("elementnumber asc");
            }
            if (this.ctx.getShowKeyCols().contains("subelementnumer")) {
                orderFields.add("subelementnumer asc");
            }
            if (this.ctx.getShowKeyCols().contains("submaterialnumber")) {
                orderFields.add("submaterialnumber asc");
            }
        }
        return orderFields;
    }

    private DataSetX groupSumQtyField(DataSetX srcDsx, Set<String> groupFields, Set<String> qtyFields, String datatype, int costobjectnumo, int costcenternumo, int periodnumo, int allo) {
        DataSetX sumDsx = null;
        Grouper grouper = srcDsx.groupBy(groupFields.toArray(new String[0]));
        for (String showQtyCol : qtyFields) {
            if (sumDsx == null) {
                sumDsx = grouper.sum(showQtyCol);
                continue;
            }
            sumDsx = sumDsx.sum(showQtyCol);
        }
        if (sumDsx == null) {
            sumDsx = srcDsx.filter("1!=1");
        }
        return sumDsx.addFields(new Field[]{new Field("datatype", (DataType)DataType.StringType), new Field("costobjectnumo", (DataType)DataType.IntegerType), new Field("costcenternumo", (DataType)DataType.IntegerType), new Field("periodnumo", (DataType)DataType.IntegerType), new Field("allo", (DataType)DataType.IntegerType)}, new Object[]{datatype, costobjectnumo, costcenternumo, periodnumo, allo});
    }
}

