/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.cost;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.macc.aca.algox.report.ProCostBehaviorAnalRptAlgoxService;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ProCostBehaviorAnalRptQueryPlugin
extends AbstractReportListDataPlugin {
    private Long cost_type_id = 0L;
    private String calRecordName;
    private Boolean onlyMaterialType = Boolean.FALSE;

    public DataSet query(ReportQueryParam param, Object object) throws Throwable {
        FilterInfo filterInfo = param.getFilter();
        List<QFilter> queryFilter = this.getQueryFilter(filterInfo);
        DynamicObject materialGrpStd = filterInfo.getDynamicObject("materialgrpstd");
        DynamicObjectCollection mulMaterialGroup = filterInfo.getDynamicObjectCollection("mulmaterialgroup");
        DataSet dataSetResult = this.getService().getDataSetResult(queryFilter, this.onlyMaterialType, this.cost_type_id, materialGrpStd, mulMaterialGroup, this.getViewSubitem(), this.calRecordName);
        long currency = filterInfo.getLong("currency");
        if (!CadEmptyUtils.isEmpty((Long)currency)) {
            dataSetResult = dataSetResult.addField(String.valueOf(currency), "entrycurrency");
        }
        return dataSetResult;
    }

    protected String getAlgoKey(String methodName) {
        return ((Object)((Object)this)).getClass().getName() + "." + methodName;
    }

    private ProCostBehaviorAnalRptAlgoxService getService() {
        return new ProCostBehaviorAnalRptAlgoxService();
    }

    private boolean getViewSubitem() {
        return this.getQueryParam().getFilter().getBoolean("viewsubitem");
    }

    private List<QFilter> getQueryFilter(FilterInfo filterInfo) {
        DynamicObject costType;
        DynamicObjectCollection products;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        DynamicObjectCollection costAccounts = filterInfo.getDynamicObjectCollection("costaccounts");
        List costAccountIds = costAccounts.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        qFilters.add(new QFilter("costaccount", "in", costAccountIds));
        Set calorg = costAccounts.stream().map(r -> r.getLong("calorg.id")).collect(Collectors.toSet());
        qFilters.add(new QFilter("org", "in", calorg));
        DynamicObject startPeriod = filterInfo.getDynamicObject("startperiod");
        DynamicObject endPeriod = filterInfo.getDynamicObject("endperiod");
        List startToEndPeriodIds = PeriodHelper.getStart2EndAllPeriodIds((DynamicObject)startPeriod, (DynamicObject)endPeriod);
        qFilters.add(new QFilter("period", "in", (Object)startToEndPeriodIds));
        DynamicObject costCenter = filterInfo.getDynamicObject("costcenter");
        if (costCenter != null) {
            qFilters.add(new QFilter("costcenter", "=", (Object)costCenter.getLong("id")));
        }
        if ((products = filterInfo.getDynamicObjectCollection("products")) != null) {
            List productIds = products.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            qFilters.add(new QFilter("inventoryentryentity.invcostobject.material.id", "in", productIds));
        }
        if ((costType = filterInfo.getDynamicObject("costtype")) != null) {
            this.cost_type_id = costType.getLong("id");
        }
        this.onlyMaterialType = filterInfo.getBoolean("onlymaterialtype");
        this.calRecordName = filterInfo.getString("calcrecord");
        return qFilters;
    }
}

