/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.cost;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.report.ProSumCostQueryRptAlgoxService;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ProSumCostQueryPlugin
extends AbstractReportListDataPlugin {
    private static final String DYNAMIC_PREFIX = "range";
    private String reportContent = "";
    private TreeMap<String, Tuple> rangeKeyMap = new TreeMap();
    private List<Long> emptyDynamicIds = new ArrayList<Long>(10);

    public DataSet query(ReportQueryParam param, Object object) throws Throwable {
        String algoKey;
        FilterInfo filterInfo = param.getFilter();
        List<QFilter> queryFilter = this.getQueryFilter(filterInfo);
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("onlyMaterialType", filterInfo.getBoolean("onlymaterialtype"));
        params.put("reportcontent", filterInfo.getString("reportcontent"));
        params.put("elementlevel", filterInfo.getString("elementlevel"));
        params.put("level", filterInfo.getInt("level"));
        boolean viewsubitem = filterInfo.getBoolean("viewsubitem");
        params.put("viewsubitem", viewsubitem);
        DynamicObject org = filterInfo.getDynamicObject("org");
        params.put("orgId", org.getLong("id"));
        DynamicObject materialGrpStd = filterInfo.getDynamicObject("materialgrpstd");
        String elementlevel = filterInfo.getString("elementlevel");
        this.rangeKeyMap = new TreeMap();
        if ("A".equals(elementlevel)) {
            String selectFields;
            HashSet<Long> elementIds = new HashSet<Long>(16);
            algoKey = ((Object)((Object)this)).getClass().getName() + ".query";
            Set<Object> selectElementIds = new HashSet(16);
            ArrayList<QFilter> filter = new ArrayList<QFilter>(10);
            filter.addAll(queryFilter);
            DynamicObjectCollection elements = filterInfo.getDynamicObjectCollection("elements");
            if (elements != null) {
                selectElementIds = elements.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
            }
            DataSet elementDs = null;
            if (viewsubitem) {
                selectFields = "entryentity.element AS element, entryentity.element.number AS elementnumber, entryentity.element.name AS elementname,entryentity.subdetail.selement AS selement, entryentity.subdetail.selement.number AS selementnumber, entryentity.subdetail.selement.name AS selementname";
                elementDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"aca_calcresult", (String)selectFields, (QFilter[])filter.toArray(new QFilter[0]), null);
                elementDs = elementDs.select("case when selement>0 then selement else element end as element,case when selement>0 then selementnumber else elementnumber end as elementnumber,case when selement>0 then selementname else elementname end as elementname");
            } else {
                selectFields = "entryentity.element AS element, entryentity.element.number AS elementnumber, entryentity.element.name AS elementname";
                elementDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"aca_calcresult", (String)selectFields, (QFilter[])filter.toArray(new QFilter[0]), null);
            }
            elementDs = elementDs.distinct().orderBy(new String[]{"elementnumber ASC"});
            for (Row row : elementDs) {
                long elementId = row.getLong("element");
                if (elementIds.contains(elementId) || CadEmptyUtils.isEmpty((Long)elementId) || !selectElementIds.isEmpty() && !selectElementIds.contains(elementId)) continue;
                String elementNumber = row.getString("elementnumber");
                elementIds.add(elementId);
                String rangeName = String.format("%s/%s", elementNumber, row.getString("elementname"));
                Tuple twoTuple = new Tuple((Object)elementId, (Object)rangeName);
                this.rangeKeyMap.put(elementNumber, twoTuple);
            }
            params.put("selectElementOrSubIds", selectElementIds);
            params.put("rangeKeys", elementIds);
        } else {
            String selectFields;
            HashSet<Long> subElementIds = new HashSet<Long>(16);
            algoKey = ((Object)((Object)this)).getClass().getName() + ".query";
            Set<Object> selectSubElementIds = new HashSet(16);
            ArrayList<QFilter> filter = new ArrayList<QFilter>(10);
            filter.addAll(queryFilter);
            DynamicObjectCollection subElements = filterInfo.getDynamicObjectCollection("subelements");
            if (subElements != null) {
                selectSubElementIds = subElements.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
            }
            DataSet elementDs = null;
            if (viewsubitem) {
                selectFields = "entryentity.subelement AS subelement,entryentity.subelement.number AS subelementnumber,entryentity.subelement.name AS subelementname,entryentity.subdetail.ssubelement AS ssubelement,entryentity.subdetail.ssubelement.number AS ssubelementnumber, entryentity.subdetail.ssubelement.name AS ssubelementname";
                elementDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"aca_calcresult", (String)selectFields, (QFilter[])filter.toArray(new QFilter[0]), null);
                elementDs = elementDs.select("case when ssubelement>0 then ssubelement else subelement end as subelement,case when ssubelement>0 then ssubelementnumber else subelementnumber end as subelementnumber,case when ssubelement>0 then ssubelementname else subelementname end as subelementname");
            } else {
                selectFields = "entryentity.subelement AS subelement,entryentity.subelement.number AS subelementnumber,entryentity.subelement.name AS subelementname";
                elementDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"aca_calcresult", (String)selectFields, (QFilter[])filter.toArray(new QFilter[0]), null);
            }
            elementDs = elementDs.distinct().orderBy(new String[]{"subelementnumber ASC"});
            selectFields = "billno, entryentity.subelement AS subelement,entryentity.subelement.number AS subelementnumber,entryentity.subelement.name AS subelementname";
            for (Row row : elementDs) {
                long subElementId = row.getLong("subelement");
                if (subElementIds.contains(subElementId) || CadEmptyUtils.isEmpty((Long)subElementId) || !selectSubElementIds.isEmpty() && !selectSubElementIds.contains(subElementId)) continue;
                String subElementNumber = row.getString("subelementnumber");
                subElementIds.add(subElementId);
                String rangeName = String.format("%s/%s", subElementNumber, row.getString("subelementname"));
                Tuple twoTuple = new Tuple((Object)subElementId, (Object)rangeName);
                this.rangeKeyMap.put(subElementNumber, twoTuple);
            }
            params.put("selectElementOrSubIds", selectSubElementIds);
            params.put("rangeKeys", subElementIds);
        }
        DynamicObjectCollection mulMaterialGroup = filterInfo.getDynamicObjectCollection("mulmaterialgroup");
        DataSet dataSetResult = this.getService().getDataSetResult(queryFilter, materialGrpStd, mulMaterialGroup, params);
        long currency = filterInfo.getLong("currency");
        if (!CadEmptyUtils.isEmpty((Long)currency)) {
            dataSetResult = dataSetResult.addField(String.valueOf(currency), "entrycurrency");
        }
        this.hideEmptyDymColumn(params, dataSetResult.copy());
        return dataSetResult;
    }

    private void hideEmptyDymColumn(Map<String, Object> params, DataSet dataSetResult) {
        Set rangeKeys = (Set)params.get("rangeKeys");
        if (CadEmptyUtils.isEmpty((Set)rangeKeys)) {
            return;
        }
        this.emptyDynamicIds.addAll(rangeKeys);
        for (Row row : dataSetResult) {
            for (int i = this.emptyDynamicIds.size() - 1; i >= 0; --i) {
                String rangeKey = DYNAMIC_PREFIX + this.emptyDynamicIds.get(i);
                if (CadEmptyUtils.isEmpty((BigDecimal)row.getBigDecimal(rangeKey))) continue;
                this.emptyDynamicIds.remove(i);
            }
        }
    }

    private ProSumCostQueryRptAlgoxService getService() {
        return new ProSumCostQueryRptAlgoxService();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        this.createProInfo(cols);
        return cols;
    }

    private void createProInfo(List<AbstractReportColumn> cols) {
        ReportColumnGroup groupCol = new ReportColumnGroup();
        groupCol.setCaption(new LocaleString(this.getReportContent()));
        groupCol.setFieldKey("reportContent");
        for (Map.Entry<String, Tuple> entry : this.rangeKeyMap.entrySet()) {
            Tuple tuple = entry.getValue();
            if (tuple == null || this.emptyDynamicIds.contains((Long)tuple.item1)) continue;
            ReportColumn actualAmount = new ReportColumn();
            actualAmount.setCaption(new LocaleString((String)tuple.item2));
            actualAmount.setWidth(new LocaleString("100px"));
            actualAmount.setFieldKey(DYNAMIC_PREFIX + tuple.item1);
            actualAmount.setFieldType("amount");
            actualAmount.setZeroShow(false);
            actualAmount.setCurrencyField("entrycurrency");
            actualAmount.setHideSingleColumnRow(false);
            groupCol.getChildren().add(actualAmount);
        }
        cols.add((AbstractReportColumn)groupCol);
    }

    private String getReportContent() {
        String resultReport = ResManager.loadKDString((String)"\u672c\u671f\u5b8c\u5de5", (String)"ProSumCostQueryPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]);
        switch (this.reportContent) {
            case "A": {
                resultReport = ResManager.loadKDString((String)"\u672c\u671f\u5b8c\u5de5", (String)"ProSumCostQueryPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]);
                break;
            }
            case "B": {
                resultReport = ResManager.loadKDString((String)"\u671f\u521d\u5728\u4ea7\u54c1", (String)"ProSumCostQueryPlugin_1", (String)"macc-aca-report", (Object[])new Object[0]);
                break;
            }
            case "C": {
                resultReport = ResManager.loadKDString((String)"\u671f\u521d\u5728\u4ea7\u54c1\u8c03\u6574", (String)"ProSumCostQueryPlugin_2", (String)"macc-aca-report", (Object[])new Object[0]);
                break;
            }
            case "D": {
                resultReport = ResManager.loadKDString((String)"\u672c\u671f\u6295\u5165", (String)"ProSumCostQueryPlugin_3", (String)"macc-aca-report", (Object[])new Object[0]);
                break;
            }
            case "E": {
                resultReport = ResManager.loadKDString((String)"\u7d2f\u8ba1\u6295\u5165", (String)"ProSumCostQueryPlugin_4", (String)"macc-aca-report", (Object[])new Object[0]);
                break;
            }
            case "F": {
                resultReport = ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u6295\u5165", (String)"ProSumCostQueryPlugin_5", (String)"macc-aca-report", (Object[])new Object[0]);
                break;
            }
            case "G": {
                resultReport = ResManager.loadKDString((String)"\u671f\u672b\u5728\u4ea7\u54c1", (String)"ProSumCostQueryPlugin_6", (String)"macc-aca-report", (Object[])new Object[0]);
                break;
            }
            case "H": {
                resultReport = ResManager.loadKDString((String)"\u671f\u672b\u5728\u4ea7\u54c1\u8c03\u6574", (String)"ProSumCostQueryPlugin_7", (String)"macc-aca-report", (Object[])new Object[0]);
                break;
            }
            case "I": {
                resultReport = ResManager.loadKDString((String)"\u7d2f\u8ba1\u5b8c\u5de5", (String)"ProSumCostQueryPlugin_8", (String)"macc-aca-report", (Object[])new Object[0]);
                break;
            }
        }
        return resultReport;
    }

    private List<QFilter> getQueryFilter(FilterInfo filterInfo) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        DynamicObject org = filterInfo.getDynamicObject("org");
        qFilters.add(new QFilter("org", "=", (Object)org.getLong("id")));
        DynamicObject costAccount = filterInfo.getDynamicObject("costaccount");
        qFilters.add(new QFilter("costaccount", "=", (Object)costAccount.getLong("id")));
        long currency = filterInfo.getLong("currency");
        qFilters.add(new QFilter("currency", "=", (Object)currency));
        DynamicObject startPeriod = filterInfo.getDynamicObject("startperiod");
        DynamicObject endPeriod = filterInfo.getDynamicObject("endperiod");
        List startToEndPeriodIds = PeriodHelper.getStart2EndAllPeriodIds((DynamicObject)startPeriod, (DynamicObject)endPeriod);
        qFilters.add(new QFilter("period", "in", (Object)startToEndPeriodIds));
        DynamicObjectCollection mulCostCenter = filterInfo.getDynamicObjectCollection("mulcostcenter");
        if (mulCostCenter != null) {
            List costCenterIds = mulCostCenter.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            qFilters.add(new QFilter("costcenter", "in", costCenterIds));
        }
        this.reportContent = filterInfo.getString("reportcontent");
        DynamicObjectCollection products = filterInfo.getDynamicObjectCollection("products");
        if (products != null) {
            List productIds = products.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            qFilters.add(new QFilter("entryentity.relacostobject.material", "in", productIds));
        }
        return qFilters;
    }
}

