/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.cost;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.aca.algox.utils.CostaccountHelper;
import kd.macc.aca.algox.utils.MaterialGroupHelper;
import kd.macc.aca.common.helper.AcaCostAccountHelper;
import kd.macc.aca.common.helper.MatBaseDataFilterHelper;
import kd.macc.aca.common.helper.PermItemCheckHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ReportUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import org.apache.commons.collections.CollectionUtils;

public class ProSumCostRptPlugin
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static String[] CLEAR_STR_MAT = new String[]{"period"};
    private static String[] CLEAR_STR_ARR = new String[]{"material", "auxpty", "matversion"};
    private static String[] PUDUCT_FILEDS = new String[]{"material", "productname", "unit", "modelnum", "auxpty", "matversion"};

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgInput = (BasedataEdit)this.getControl("org");
        orgInput.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            QFilter qfId = new QFilter("id", "in", (Object)orgIds);
            filterParameter.getQFilters().add(qfId);
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProSumCostRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            Long acctOrgId = org.getLong("id");
            qFilters.add(StartCostHelper.getEnabledCostAccountIdsFilter((Long)acctOrgId, (String)"aca"));
        });
        BasedataEdit costcenter = (BasedataEdit)this.getControl("costcenter");
        costcenter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProSumCostRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter showOrgDutyFilter = new QFilter("orgduty", "=", (Object)4L);
            QFilter calorgsFilter = new QFilter("accountorg", "=", (Object)org.getLong("id"));
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(showOrgDutyFilter);
            qFilters.add(calorgsFilter);
        });
        MulBasedataEdit mulcostcenter = (MulBasedataEdit)this.getControl("mulcostcenter");
        mulcostcenter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProSumCostRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter showOrgDutyFilter = new QFilter("orgduty", "=", (Object)4L);
            QFilter calorgsFilter = new QFilter("accountorg", "=", (Object)org.getLong("id"));
            ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(showOrgDutyFilter);
            qFilters.add(calorgsFilter);
        });
        BasedataEdit startPeriod = (BasedataEdit)this.getControl("startperiod");
        startPeriod.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costAccountDy = (DynamicObject)this.getModel().getValue("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccountDy)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"ProSumCostRptPlugin_1", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)org.getLong("id"), (Long)costAccountObj.getLong("id")));
        });
        BasedataEdit endPeriod = (BasedataEdit)this.getControl("endperiod");
        endPeriod.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject startPer = (DynamicObject)this.getModel().getValue("startPeriod");
            if (CadEmptyUtils.isEmpty((DynamicObject)startPer)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f00\u59cb\u671f\u95f4\u3002", (String)"ProSumCostRptPlugin_2", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(new QFilter("id", ">=", startPer.get("id")));
            qFilters.add(StartCostHelper.getPeriodTypeFilter((String)this.getView().getFormShowParameter().getAppId(), (Long)org.getLong("id"), (Long)costAccountObj.getLong("id")));
        });
        BasedataEdit materialgrpstd = (BasedataEdit)this.getControl("materialgrpstd");
        materialgrpstd.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProSumCostRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(org.getLong("id"));
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, Boolean.TRUE});
            QFilter idFilter = new QFilter("id", "in", (Object)ids);
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(idFilter);
        });
        MulBasedataEdit mulmaterialgroup = (MulBasedataEdit)this.getControl("mulmaterialgroup");
        mulmaterialgroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject materialgrpstdObj = (DynamicObject)this.getModel().getValue("materialgrpstd");
            if (materialgrpstdObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"ProSumCostRptPlugin_3", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProSumCostRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(org.getLong("id"));
            QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialgrpstdObj.getPkValue(), false});
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(serviceResponse);
            HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>(2);
            params.put("useOrgs", createOrgIds);
            listShowParameter.setCustomParams(params);
            listShowParameter.setCustomParam("groupStandard", materialgrpstdObj.getPkValue());
            listShowParameter.setF7ClickByFilter(false);
        });
        BasedataEdit products = (BasedataEdit)this.getControl("products");
        products.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ProSumCostRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            HashSet<Long> orgSet = new HashSet<Long>(16);
            orgSet.add(org.getLong("id"));
            DynamicObjectCollection mulmaterialGroup = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup");
            DynamicObject materialGroupStandard = (DynamicObject)this.getModel().getValue("materialgrpstd");
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(MatBaseDataFilterHelper.getBaseFilter(new ArrayList(orgSet)));
            if (!CollectionUtils.isEmpty((Collection)mulmaterialGroup) || materialGroupStandard.getLong("id") != 730148448254487552L) {
                qFilters.add(MaterialGroupHelper.getClassifiedMaterialIdFilter((DynamicObjectCollection)mulmaterialGroup, (boolean)false, (DynamicObject)materialGroupStandard));
            }
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        if (("exportexcel".equals(operateKey) || "syncexportexcel".equals(operateKey)) && !PermItemCheckHelper.isPerm((String)"aca_prosumcostquery", (String)"47150e89000000ac", (Long)org.getLong("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4ea7\u54c1\u6210\u672c\u6c47\u603b\u8868\uff08\u6a2a\u5411\uff09\u67e5\u8be2\u201d\u7684\u201c\u5f15\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ProSumCostRptPlugin_4", (String)"macc-aca-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "org": {
                this.setOther();
                this.setCostAccount();
                break;
            }
            case "costaccount": {
                this.setPeriodAndCurrency();
                this.setViewSubItem();
                break;
            }
            case "startperiod": {
                DynamicObject startPeriodDy = this.getModel().getDataEntity().getDynamicObject("startperiod");
                DynamicObject endPeriodDy = this.getModel().getDataEntity().getDynamicObject("endperiod");
                if (startPeriodDy == null || endPeriodDy == null) {
                    return;
                }
                if (PeriodHelper.compare2period((DynamicObject)startPeriodDy, (DynamicObject)endPeriodDy) <= 0) break;
                this.getModel().setValue("endperiod", (Object)startPeriodDy);
                break;
            }
            case "endperiod": {
                DynamicObject startPeriod = this.getModel().getDataEntity().getDynamicObject("startperiod");
                DynamicObject endPeriod = this.getModel().getDataEntity().getDynamicObject("endperiod");
                if (startPeriod == null || endPeriod == null) {
                    return;
                }
                if (PeriodHelper.compare2period((DynamicObject)startPeriod, (DynamicObject)endPeriod) <= 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u8981\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"ProSumCostRptPlugin_5", (String)"macc-aca-report", (Object[])new Object[0]));
                return;
            }
            case "materialgrpstd": {
                this.getModel().setValue("mulmaterialgroup", null);
                break;
            }
            case "mulmaterialgroup": {
                this.getModel().setValue("products", null);
                DynamicObjectCollection mulmaterialGroup = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup");
                if (mulmaterialGroup != null && mulmaterialGroup.size() > 1) {
                    this.getModel().setValue("level", null);
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"level"});
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"level"});
                break;
            }
            case "elementlevel": {
                this.setDynamicContent();
                break;
            }
            case "level": {
                DynamicObjectCollection mulmaterialGroupObj = (DynamicObjectCollection)this.getModel().getValue("mulmaterialgroup");
                Integer level = (Integer)this.getModel().getValue("level");
                if (mulmaterialGroupObj == null || mulmaterialGroupObj.size() <= 1 || level == 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b\u591a\u9009\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u5206\u7c7b\u7ea7\u6b21\u3002", (String)"ProSumCostRptPlugin_9", (String)"macc-aca-report", (Object[])new Object[0]));
                this.getModel().setValue("level", null);
                return;
            }
        }
    }

    private void setOther() {
        this.getModel().setValue("mulcostcenter", null);
        this.getModel().setValue("costaccount", null);
        this.getModel().setValue("startperiod", null);
        this.getModel().setValue("endperiod", null);
        this.getModel().setValue("products", null);
        this.getModel().setValue("currency", null);
        this.getModel().setValue("mulmaterialgroup", null);
    }

    private void setPeriodAndCurrency() {
        DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
        if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
            this.getModel().setValue("startperiod", null);
            this.getModel().setValue("endperiod", null);
            this.getModel().setValue("currency", null);
        } else {
            Long costAccountId = costAccountObj.getLong("id");
            DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
            this.getModel().setValue("startperiod", (Object)curPeriod);
            this.getModel().setValue("endperiod", (Object)curPeriod);
            this.getModel().setValue("currency", (Object)CurrencyHelper.getCurrency((DynamicObject)costAccountObj));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setOrg();
        Object costaccount = this.getModel().getValue("costaccount");
        if (costaccount == null) {
            this.setCostAccount();
            this.setPeriodAndCurrency();
            this.setDynamicContent();
        }
        this.setViewSubItem();
    }

    private void setViewSubItem() {
        boolean viewSubitem = false;
        DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccountObj != null) {
            Long costAccountId = costAccountObj.getLong("id");
            viewSubitem = CostaccountHelper.getCostElementByCostAccount((long)costAccountId);
        }
        if (!viewSubitem) {
            this.getModel().getDataEntity().set("viewsubitem", (Object)false);
        }
        this.getView().setVisible(Boolean.valueOf(viewSubitem), new String[]{"viewsubitem"});
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        super.formatDisplayFilterField(evt);
        String str = evt.getFormatedFilterString();
        boolean viewsubitem = this.getModel().getDataEntity().getBoolean("viewsubitem");
        if (viewsubitem) {
            str = str.concat(ResManager.loadKDString((String)"; \u663e\u793a\u5206\u9879\u6570\u636e\uff1a\u662f", (String)"ProSumCostRptPlugin_10", (String)"macc-aca-report", (Object[])new Object[0]));
        }
        evt.setFormatedFilterString(str);
    }

    private void setDynamicContent() {
        String elementLevel = (String)this.getModel().getValue("elementlevel");
        boolean isShowElement = "A".equals(elementLevel);
        this.getModel().setValue("elements", null);
        this.getModel().setValue("subelements", null);
        this.getView().setVisible(Boolean.valueOf(isShowElement), new String[]{"elements"});
        this.getView().setVisible(Boolean.valueOf(!isShowElement), new String[]{"subelements"});
    }

    private void setCostAccount() {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        long mainBookId = AcaCostAccountHelper.getCostAccountByAccoutOrg((Long)((DynamicObject)org).getLong("id"), (String)"aca");
        if (!CadEmptyUtils.isEmpty((Long)mainBookId)) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
        }
        this.getView().updateView("costaccount");
    }

    private void setOrg() {
        if (this.getModel().getValue("org") == null) {
            Long orgId = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
            if (!isAccounting) {
                return;
            }
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (orgIds.contains(orgId)) {
                this.getModel().setValue("org", (Object)orgId);
                this.getView().updateView("org");
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        ArrayList pros = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "startperiod", "endperiod", "materialgrpstd"});
        boolean isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, (List)pros);
        if (!isPass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"ProSumCostRptPlugin_6", (String)"macc-aca-report", (Object[])new Object[0]));
            return false;
        }
        Long startPeriod = this.getModel().getDataEntity().getDynamicObject("startperiod").getLong("id");
        Long endPeriod = this.getModel().getDataEntity().getDynamicObject("endperiod").getLong("id");
        if (startPeriod > endPeriod) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u8981\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"ProSumCostRptPlugin_5", (String)"macc-aca-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        ReportUtils.clearFileNameValue((String[])CLEAR_STR_MAT, (DynamicObjectCollection)rowData, (String[])CLEAR_STR_MAT);
        ReportUtils.clearFileNameValue((String[])CLEAR_STR_ARR, (DynamicObjectCollection)rowData, (String[])CLEAR_STR_ARR);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"ProSumCostRptPlugin_7", (String)"macc-aca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u4ea7\u54c1\u6210\u672c\u6c47\u603b\u8868\uff08\u6a2a\u5411\uff09\u67e5\u8be2", (String)"ProSumCostRptPlugin_8", (String)"macc-aca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"aca_prosumcostquery", (IDataModel)this.getModel());
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        Boolean onlyMaterialType = this.getModel().getDataEntity().getBoolean("onlymaterialtype");
        ArrayList<String> proHideFields = new ArrayList<String>(16);
        if (onlyMaterialType.booleanValue()) {
            proHideFields.addAll(Arrays.asList(PUDUCT_FILEDS));
        }
        while (it.hasNext()) {
            ReportColumn reportColumn;
            String key;
            Object obj = it.next();
            if (!(obj instanceof ReportColumn) || !proHideFields.contains(key = (reportColumn = (ReportColumn)obj).getFieldKey())) continue;
            reportColumn.setHide(true);
        }
        this.getView().updateView("reportlistap");
    }
}

