/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.cost;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.report.ProUnitCostComRptAlgoxService;
import kd.macc.aca.algox.utils.MaterialGroupHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ProUnitCostComRptQueryPlugin
extends AbstractReportListDataPlugin {
    private Map<String, String> dynamicColumnMap;
    private Boolean isShowSubElement = Boolean.FALSE;
    private Boolean isShowMaterialDetail = Boolean.FALSE;
    private Boolean onlyMaterialType = Boolean.FALSE;
    private Integer level = 0;
    private Long orgId = 0L;

    public DataSet query(ReportQueryParam param, Object object) throws Throwable {
        this.dynamicColumnMap = new LinkedHashMap<String, String>(50);
        FilterInfo filterInfo = param.getFilter();
        List<QFilter> queryFilter = this.getQueryFilter(filterInfo);
        List<QFilter> baseFilter = this.getPeriodFilter(queryFilter, filterInfo, Boolean.TRUE);
        List<QFilter> cmpFilter = this.getPeriodFilter(queryFilter, filterInfo, Boolean.FALSE);
        QFilter matQFilter = this.getMatQFilter(filterInfo);
        if (matQFilter != null) {
            baseFilter.add(matQFilter);
            cmpFilter.add(matQFilter);
        }
        DynamicObjectCollection mulMaterialGroup = filterInfo.getDynamicObjectCollection("mulmaterialgroup");
        DynamicObject materialGroup = filterInfo.getDynamicObject("materialgroup");
        DynamicObject materialGrpStd = filterInfo.getDynamicObject("materialgrpstd");
        int showCount = filterInfo.getInt("showcount") == 0 ? 50 : filterInfo.getInt("showcount");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("baseFilter", baseFilter);
        params.put("cmpFilter", cmpFilter);
        params.put("isShowSubElement", this.isShowSubElement);
        params.put("isShowMaterialDetail", this.isShowMaterialDetail);
        params.put("onlyMaterialType", this.onlyMaterialType);
        params.put("level", this.level);
        params.put("orgId", this.orgId);
        params.put("showCount", showCount);
        DataSet dataSetResult = this.getService().getDataSetResult(mulMaterialGroup, materialGrpStd, this.dynamicColumnMap, params, materialGroup);
        return dataSetResult;
    }

    private List<QFilter> getPeriodFilter(List<QFilter> filters, FilterInfo filterInfo, Boolean basePeriod) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.addAll(filters);
        String periodQueryStr = basePeriod != false ? "baseperiod" : "cmpperiod";
        DynamicObjectCollection periods = filterInfo.getDynamicObjectCollection(periodQueryStr);
        List periodIds = periods.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        qFilters.add(new QFilter("period", "in", periodIds));
        return qFilters;
    }

    private QFilter getMatQFilter(FilterInfo filterInfo) {
        int showCount;
        QFilter matQFilter = null;
        DynamicObject org = filterInfo.getDynamicObject("org");
        DynamicObject costAccount = filterInfo.getDynamicObject("costaccount");
        DynamicObject costCenter = filterInfo.getDynamicObject("costcenter");
        int n = showCount = filterInfo.getInt("showcount") == 0 ? 50 : filterInfo.getInt("showcount");
        if (!this.onlyMaterialType.booleanValue()) {
            DynamicObjectCollection products = filterInfo.getDynamicObjectCollection("products");
            if (products == null || products.isEmpty()) {
                QFilter filter = new QFilter("org", "=", (Object)org.getLong("id"));
                filter.and(new QFilter("costaccount", "=", (Object)costAccount.getLong("id")));
                DynamicObjectCollection baseperiods = filterInfo.getDynamicObjectCollection("baseperiod");
                List baseperiodIds = baseperiods.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
                DynamicObjectCollection cmpperiods = filterInfo.getDynamicObjectCollection("cmpperiod");
                List cmpperiodIds = cmpperiods.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
                baseperiodIds.addAll(cmpperiodIds);
                filter.and(new QFilter("period", "in", baseperiodIds));
                if (costCenter != null) {
                    filter.and(new QFilter("costcenter", "=", (Object)costCenter.getLong("id")));
                }
                DynamicObjectCollection mulMaterialGroup = filterInfo.getDynamicObjectCollection("mulmaterialgroup");
                DynamicObject materialGrpStd = filterInfo.getDynamicObject("materialgrpstd");
                filter.and(new QFilter("entryentity.currcomamount", ">", (Object)0));
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"aca_calcresult", (String)"entryentity.material.number,entryentity.material.id as matid", (QFilter[])filter.toArray(), (String)"entryentity.material.number asc");
                HashSet<Long> ids = new HashSet<Long>(50);
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)dynamicObjects)) {
                    Set materialIds = MaterialGroupHelper.getClassifiedMaterialId((DynamicObjectCollection)mulMaterialGroup, (DynamicObject)materialGrpStd);
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        Long matId = dynamicObject.getLong("matid");
                        if (!materialIds.contains(matId)) continue;
                        ids.add(matId);
                        if (ids.size() != showCount) continue;
                        break;
                    }
                }
                matQFilter = new QFilter("entryentity.relacostobject.material", "in", ids);
            } else {
                List productIds = products.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
                matQFilter = new QFilter("entryentity.relacostobject.material", "in", productIds);
            }
        }
        return matQFilter;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        this.createProInfo(this.dynamicColumnMap, cols);
        return cols;
    }

    private void createProInfo(Map<String, String> dynamicColumnMap, List<AbstractReportColumn> cols) {
        for (Map.Entry<String, String> entry : dynamicColumnMap.entrySet()) {
            ReportColumnGroup group = new ReportColumnGroup();
            group.setCaption(new LocaleString(entry.getKey()));
            group.setFieldKey(entry.getValue());
            ReportColumn unitCountColumn = new ReportColumn();
            unitCountColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u57fa\u51c6\u5355\u4f4d\u7528\u91cf", (String)"ProUnitCostComRptQueryPlugin_2", (String)"macc-aca-report", (Object[])new Object[0])));
            unitCountColumn.setWidth(new LocaleString("150px"));
            unitCountColumn.setFieldKey("count" + entry.getValue());
            unitCountColumn.setFieldType("qty");
            unitCountColumn.setMeasureUnitField("hidebaseunit");
            group.getChildren().add(unitCountColumn);
            ReportColumn cmpUnitCountColumn = new ReportColumn();
            cmpUnitCountColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5bf9\u6bd4\u5355\u4f4d\u7528\u91cf", (String)"ProUnitCostComRptQueryPlugin_3", (String)"macc-aca-report", (Object[])new Object[0])));
            cmpUnitCountColumn.setWidth(new LocaleString("150px"));
            cmpUnitCountColumn.setFieldKey("cmpcount" + entry.getValue());
            cmpUnitCountColumn.setFieldType("qty");
            cmpUnitCountColumn.setMeasureUnitField("hidebaseunit");
            group.getChildren().add(cmpUnitCountColumn);
            ReportColumn unitCostColumn = new ReportColumn();
            unitCostColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u57fa\u51c6\u5355\u4f4d\u6210\u672c", (String)"ProUnitCostComRptQueryPlugin_4", (String)"macc-aca-report", (Object[])new Object[0])));
            unitCostColumn.setWidth(new LocaleString("150px"));
            unitCostColumn.setFieldKey("cost" + entry.getValue());
            unitCostColumn.setFieldType("price");
            unitCostColumn.setCurrencyField("subcurrency");
            group.getChildren().add(unitCostColumn);
            ReportColumn cmpUnitCostColumn = new ReportColumn();
            cmpUnitCostColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5bf9\u6bd4\u5355\u4f4d\u6210\u672c", (String)"ProUnitCostComRptQueryPlugin_5", (String)"macc-aca-report", (Object[])new Object[0])));
            cmpUnitCostColumn.setWidth(new LocaleString("150px"));
            cmpUnitCostColumn.setFieldKey("cmpcost" + entry.getValue());
            cmpUnitCostColumn.setFieldType("price");
            cmpUnitCostColumn.setCurrencyField("subcurrency");
            group.getChildren().add(cmpUnitCostColumn);
            cols.add((AbstractReportColumn)group);
        }
    }

    private ProUnitCostComRptAlgoxService getService() {
        return new ProUnitCostComRptAlgoxService();
    }

    private List<QFilter> getQueryFilter(FilterInfo filterInfo) {
        DynamicObjectCollection subElements;
        DynamicObjectCollection elements;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        DynamicObject org = filterInfo.getDynamicObject("org");
        this.orgId = org.getLong("id");
        qFilters.add(new QFilter("org", "=", (Object)this.orgId));
        DynamicObject costAccount = filterInfo.getDynamicObject("costaccount");
        qFilters.add(new QFilter("costaccount", "=", (Object)costAccount.getLong("id")));
        DynamicObject costCenter = filterInfo.getDynamicObject("costcenter");
        if (costCenter != null) {
            qFilters.add(new QFilter("costcenter", "=", (Object)costCenter.getLong("id")));
        }
        if ((elements = filterInfo.getDynamicObjectCollection("elements")) != null) {
            List elementsIds = elements.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            elementsIds.add(0L);
            qFilters.add(new QFilter("entryentity.element", "in", elementsIds));
        }
        if ((subElements = filterInfo.getDynamicObjectCollection("subelements")) != null) {
            List subElementsIds = subElements.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
            subElementsIds.add(0L);
            qFilters.add(new QFilter("entryentity.subelement", "in", subElementsIds));
        }
        this.isShowSubElement = filterInfo.getBoolean("isshowsubelement");
        this.isShowMaterialDetail = filterInfo.getBoolean("isshowmaterialdetail");
        this.onlyMaterialType = filterInfo.getBoolean("onlymaterialtype");
        if (this.onlyMaterialType.booleanValue()) {
            this.level = filterInfo.getInt("level");
        }
        return qFilters;
    }
}

