/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.cost;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.aca.common.helper.PermItemCheckHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import org.apache.commons.collections4.CollectionUtils;

public class SellOrderCostRpt
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final String SHOWORDER_COST = "showordercost";
    private static final String SHOWSUBELEMENT = "showsubelement";
    private static final String SHOWMATERIAL_DETAIL = "showmaterialdetail";
    private List<String> orderCostHideColumns = Lists.newArrayList((Object[])new String[]{"manuorg", "probillno", "prorowseq", "configcode", "tracknum", "bizstatus", "promat", "promatname", "modelnum", "proauxpty", "probaseunit", "probaseqty", "transmittime", "endworktime", "subelement", "submat", "submatname", "submatv", "subauxpty", "inputqty", "inputamt", "finishqty", "finishAmt", "pdendqty", "pdendamount", "procostgroup"});
    private List<String> subElementHideColumns = Lists.newArrayList((Object[])new String[]{"element", "elementname", "subelement", "subelementname"});
    private List<String> subMatHideColumns = Lists.newArrayList((Object[])new String[]{"submat", "submatname", "submatmodel", "submatauxpty"});

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId()).getHasPermOrgs();
            List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"10");
            if (!CollectionUtils.isEmpty((Collection)permOrgIds) || !CollectionUtils.isEmpty((Collection)orgIds)) {
                qFilters.add(new QFilter("id", "in", (Object)orgIds));
            }
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            QFilter costAccountFilter = this.getCostAccountFilter();
            if (costAccountFilter == null) {
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = listShowParameter.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(costAccountFilter);
        });
        BasedataEdit saleOrg = (BasedataEdit)this.getControl("fsaleorg");
        saleOrg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId()).getHasPermOrgs();
            List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"03");
            if (!CollectionUtils.isEmpty((Collection)permOrgIds) || !CollectionUtils.isEmpty((Collection)orgIds)) {
                qFilters.add(new QFilter("id", "in", (Object)orgIds));
            }
        });
        BasedataEdit trackNumber = (BasedataEdit)this.getControl("ftracknumber");
        trackNumber.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            DynamicObject saleOrgDy = (DynamicObject)this.getModel().getValue("fsaleorg");
            if (!CadEmptyUtils.isEmpty((DynamicObject)saleOrgDy)) {
                List<Long> saleTrackNumbers = this.filterTrackNumber(saleOrgDy.getLong("id"));
                if (!CadEmptyUtils.isEmpty(saleTrackNumbers)) {
                    qFilters.add(new QFilter("id", "in", saleTrackNumbers));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u9500\u552e\u7ec4\u7ec7\u201d\u3002", (String)"SellOrderCostRpt_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
        });
        BasedataEdit saleBillNo = (BasedataEdit)this.getControl("fsalebillno");
        saleBillNo.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            DynamicObject saleOrgDy = (DynamicObject)this.getModel().getValue("fsaleorg");
            if (!CadEmptyUtils.isEmpty((DynamicObject)saleOrgDy)) {
                Set<Long> ids = this.filterSaleBillNoBySaleOrg(saleOrgDy.getLong("id"));
                if (!CadEmptyUtils.isEmpty(ids)) {
                    qFilters.add(new QFilter("id", "in", ids));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u9500\u552e\u7ec4\u7ec7\u201d\u3002", (String)"SellOrderCostRpt_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
        });
        BasedataEdit saleMat = (BasedataEdit)this.getControl("fsalemat");
        saleMat.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            DynamicObject saleOrgDy = (DynamicObject)this.getModel().getValue("fsaleorg");
            if (saleOrgDy == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u9500\u552e\u7ec4\u7ec7\u201d\u3002", (String)"SellOrderCostRpt_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            } else {
                DynamicObjectCollection fSaleBillNos = (DynamicObjectCollection)this.getModel().getValue("fsalebillno");
                List<Long> ids = this.filterSaleMat(saleOrgDy, fSaleBillNos);
                if (!CadEmptyUtils.isEmpty(ids)) {
                    qFilters.add(new QFilter("masterid", "in", ids));
                }
            }
        });
        BasedataEdit manuOrg = (BasedataEdit)this.getControl("fmanuorg");
        manuOrg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId()).getHasPermOrgs();
            List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"04");
            if (!CollectionUtils.isEmpty((Collection)permOrgIds) || !CollectionUtils.isEmpty((Collection)orgIds)) {
                qFilters.add(new QFilter("id", "in", (Object)orgIds));
            }
        });
        BasedataEdit fproBillNo = (BasedataEdit)this.getControl("fprobillno");
        fproBillNo.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            DynamicObjectCollection ftracknumbers = (DynamicObjectCollection)this.getModel().getValue("ftracknumber");
            if (ftracknumbers == null || ftracknumbers.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u8ddf\u8e2a\u53f7\u201d\u3002", (String)"SellOrderCostRpt_1", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            } else {
                Set<Long> proBillIds = this.filterProBill();
                if (!CadEmptyUtils.isEmpty(proBillIds)) {
                    qFilters.add(new QFilter("id", "in", proBillIds));
                } else {
                    qFilters.add(new QFilter("id", "=", (Object)-1));
                }
            }
        });
        BasedataEdit fMaterial = (BasedataEdit)this.getControl("fmaterial");
        fMaterial.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            Set<Long> matIds = this.filterProBillMaterial();
            if (!CadEmptyUtils.isEmpty(matIds)) {
                qFilters.add(new QFilter("id", "in", matIds));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u751f\u4ea7\u5de5\u5355\u3002", (String)"SellOrderCostRpt_2", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
        });
    }

    private Set<Long> filterProBillMaterial() {
        DynamicObjectCollection proBills;
        DynamicObjectCollection proBillNos;
        List manuOrgIds = null;
        DynamicObject fmanuOrg = (DynamicObject)this.getModel().getValue("fmanuorg");
        if (CadEmptyUtils.isEmpty((DynamicObject)fmanuOrg)) {
            List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId()).getHasPermOrgs();
            List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"04");
            if (!CollectionUtils.isEmpty((Collection)permOrgIds) || !CollectionUtils.isEmpty((Collection)orgIds)) {
                manuOrgIds = orgIds;
            }
        } else {
            manuOrgIds = Lists.newArrayList((Object[])new Long[]{fmanuOrg.getLong("id")});
        }
        QFilter qFilter = new QFilter("treeentryentity.taskstatus", "!=", (Object)"A");
        if (this.getModel().getValue("ftracknumber") != null) {
            DynamicObjectCollection trackNumbers = (DynamicObjectCollection)this.getModel().getValue("ftracknumber");
            Set trackNumIds = trackNumbers.stream().map(trackNumber -> trackNumber.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
            qFilter.and("treeentryentity.tracknumber", "in", trackNumIds);
        } else {
            qFilter.and("treeentryentity.tracknumber", "!=", (Object)0L);
        }
        if (!CadEmptyUtils.isEmpty((List)manuOrgIds)) {
            qFilter.and("org", "in", (Object)manuOrgIds);
        }
        Date proStartDate = (Date)this.getModel().getValue("prostartdate");
        Date proEndDate = (Date)this.getModel().getValue("proenddate");
        if (proStartDate != null && proEndDate != null) {
            qFilter.and("billdate", ">=", (Object)proStartDate);
            qFilter.and("billdate", "<=", (Object)proEndDate);
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(proBillNos = (DynamicObjectCollection)this.getModel().getValue("fprobillno")))) {
            qFilter.and("treeentryentity.id", "in", proBillNos.stream().map(proBillEntry -> proBillEntry.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet()));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(proBills = QueryServiceHelper.query((String)"pom_mftorder", (String)"treeentryentity.material", (QFilter[])new QFilter[]{qFilter})))) {
            return proBills.stream().map(proBill -> proBill.getLong("treeentryentity.material")).collect(Collectors.toSet());
        }
        return null;
    }

    private Set<Long> filterProBill() {
        DynamicObjectCollection proBills;
        List manuOrgIds = null;
        DynamicObject fmanuOrg = (DynamicObject)this.getModel().getValue("fmanuorg");
        if (CadEmptyUtils.isEmpty((DynamicObject)fmanuOrg)) {
            List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId()).getHasPermOrgs();
            List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"04");
            if (!CollectionUtils.isEmpty((Collection)permOrgIds) || !CollectionUtils.isEmpty((Collection)orgIds)) {
                manuOrgIds = orgIds;
            }
        } else {
            manuOrgIds = Lists.newArrayList((Object[])new Long[]{fmanuOrg.getLong("id")});
        }
        QFilter qFilter = new QFilter("treeentryentity.taskstatus", "!=", (Object)"A");
        Object ftracknumber = this.getModel().getValue("ftracknumber");
        if (ftracknumber != null) {
            DynamicObjectCollection trackNumbers = (DynamicObjectCollection)this.getModel().getValue("ftracknumber");
            if (trackNumbers != null && trackNumbers.size() > 0) {
                Set trackNumIds = trackNumbers.stream().map(trackNumber -> trackNumber.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
                qFilter.and("treeentryentity.tracknumber", "in", trackNumIds);
            }
        } else {
            qFilter.and("treeentryentity.tracknumber", "!=", (Object)0L);
        }
        if (!CadEmptyUtils.isEmpty((List)manuOrgIds)) {
            qFilter.and("org", "in", (Object)manuOrgIds);
        }
        Date proStartDate = (Date)this.getModel().getValue("prostartdate");
        Date proEndDate = (Date)this.getModel().getValue("proenddate");
        if (proStartDate != null && proEndDate != null) {
            qFilter.and("billdate", ">=", (Object)proStartDate);
            qFilter.and("billdate", "<=", (Object)proEndDate);
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(proBills = QueryServiceHelper.query((String)"pom_mftorder", (String)"treeentryentity.id", (QFilter[])new QFilter[]{qFilter})))) {
            return proBills.stream().map(proBill -> proBill.getLong("treeentryentity.id")).collect(Collectors.toSet());
        }
        return null;
    }

    private List<Long> filterSaleMat(DynamicObject saleOrgDy, DynamicObjectCollection fSaleBillNos) {
        QFilter qFilter = new QFilter("org", "=", (Object)saleOrgDy.getLong("id"));
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)fSaleBillNos)) {
            qFilter.and("id", "in", fSaleBillNos.stream().map(saleBill -> saleBill.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
        }
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("billentry.tracknumber", "!=", (Object)0L);
        DynamicObjectCollection saleList = QueryServiceHelper.query((String)"sm_salorder", (String)"billentry.materialmasterid", (QFilter[])new QFilter[]{qFilter});
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)saleList)) {
            return saleList.stream().map(sale -> sale.getLong("billentry.materialmasterid")).collect(Collectors.toList());
        }
        return null;
    }

    private Set<Long> filterSaleBillNoBySaleOrg(Long saleOrg) {
        DynamicObjectCollection saleList = QueryServiceHelper.query((String)"sm_salorder", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)saleOrg), new QFilter("billentry.tracknumber", "!=", (Object)0L), new QFilter("billstatus", "=", (Object)"C")});
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)saleList)) {
            return saleList.stream().map(sale -> sale.getLong("id")).collect(Collectors.toSet());
        }
        return null;
    }

    private List<Long> filterTrackNumber(Long saleOrg) {
        DynamicObjectCollection saleList;
        QFilter qFilter = new QFilter("org", "=", (Object)saleOrg);
        qFilter.and("billentry.tracknumber", "!=", (Object)0L);
        qFilter.and("billstatus", "=", (Object)"C");
        DynamicObjectCollection fSaleBillNos = (DynamicObjectCollection)this.getModel().getValue("fsalebillno");
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)fSaleBillNos)) {
            qFilter.and("id", "in", fSaleBillNos.stream().map(saleBill -> saleBill.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toList()));
        }
        Date saleStartDate = (Date)this.getModel().getValue("salestartdate");
        Date saleEndDate = (Date)this.getModel().getValue("saleenddate");
        if (saleStartDate != null && saleEndDate != null) {
            qFilter.and("bizdate", ">=", (Object)saleStartDate);
            qFilter.and("bizdate", "<", (Object)saleEndDate);
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(saleList = QueryServiceHelper.query((String)"sm_salorder", (String)"billentry.tracknumber", (QFilter[])new QFilter[]{qFilter})))) {
            return saleList.stream().map(sale -> sale.getLong("billentry.tracknumber")).collect(Collectors.toList());
        }
        return null;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setOrg();
        Object costaccount = this.getModel().getValue("costaccount");
        if (costaccount == null) {
            this.setCostAccount();
        }
        this.setCurrency();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        switch (propertyName = e.getProperty().getName()) {
            case "org": {
                this.setCostAccount();
                this.getModel().setValue("manuorg", null);
                break;
            }
            case "costaccount": {
                this.setCurrency();
                break;
            }
            case "showordercost": {
                Boolean showOrderCost = (Boolean)this.getModel().getValue(SHOWORDER_COST);
                if (showOrderCost.booleanValue()) break;
                this.getModel().setValue(SHOWSUBELEMENT, (Object)false);
                this.getModel().setValue(SHOWMATERIAL_DETAIL, (Object)false);
                this.getView().updateView(SHOWSUBELEMENT);
                this.getView().updateView(SHOWMATERIAL_DETAIL);
                break;
            }
            case "fsaleorg": {
                this.getModel().setValue("fsalebillno", null);
                this.getModel().setValue("fsalemat", null);
                this.getModel().setValue("ftracknumber", null);
                break;
            }
            case "showmaterialdetail": {
                Boolean showMaterialDetail = (Boolean)this.getModel().getValue(SHOWMATERIAL_DETAIL);
                if (!showMaterialDetail.booleanValue()) break;
                this.getModel().setValue(SHOWSUBELEMENT, (Object)true);
                this.getModel().setValue(SHOWORDER_COST, (Object)true);
                this.getView().updateView(SHOWSUBELEMENT);
                this.getView().updateView(SHOWORDER_COST);
                break;
            }
            case "showsubelement": {
                Boolean showSubElement = (Boolean)this.getModel().getValue(SHOWSUBELEMENT);
                if (showSubElement.booleanValue()) {
                    this.getModel().setValue(SHOWORDER_COST, (Object)true);
                    this.getView().updateView(SHOWORDER_COST);
                    break;
                }
                this.getModel().setValue(SHOWMATERIAL_DETAIL, (Object)false);
                this.getView().updateView(SHOWMATERIAL_DETAIL);
                break;
            }
            case "fmanuorg": {
                this.getModel().setValue("fprobillno", null);
                this.getModel().setValue("fmaterial", null);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        Object org = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"SellOrderCostRpt_3", (String)"macc-aca-report", (Object[])new Object[0]));
            return false;
        }
        Object costAccount = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"costaccount");
        if (costAccount == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"SellOrderCostRpt_4", (String)"macc-aca-report", (Object[])new Object[0]));
            return false;
        }
        Object trackNumber = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"ftracknumber");
        if (trackNumber == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ddf\u8e2a\u53f7\u3002", (String)"SellOrderCostRpt_5", (String)"macc-aca-report", (Object[])new Object[0]));
            return false;
        }
        Object saleOrg = CalcRptHelper.getFilterItemValue((FilterInfo)filterInfo, (String)"fsaleorg");
        if (saleOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SellOrderCostRpt_6", (String)"macc-aca-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setOrg() {
        IDataModel model = this.getModel();
        Object org = this.getModel().getValue("org");
        if (org != null) {
            return;
        }
        IReportView view = this.getView();
        Long orgId = RequestContext.get().getOrgId();
        boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
        if (!isAccounting) {
            return;
        }
        model.setValue("org", (Object)orgId);
        view.updateView("org");
    }

    private void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
        this.getView().updateView("currency");
    }

    private QFilter getCostAccountFilter() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"SellOrderCostRpt_7", (String)"macc-aca-report", (Object[])new Object[0]));
            return null;
        }
        List orgUseCostAccountIds = CostAccountHelper.getOrgStdCostAccount((Long)((Long)org.getPkValue()), (String)"aca");
        return new QFilter("id", "in", (Object)orgUseCostAccountIds);
    }

    private void setCostAccount() {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Long mainBookId = this.getCostAccountByAccoutOrg(((DynamicObject)org).getLong("id"), "aca");
        if (mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
        }
        this.getView().updateView("costaccount");
    }

    private Long getCostAccountByAccoutOrg(Long accountOrgId, String appnum) {
        List useActualCostAccountIds = CostAccountHelper.getOrgUseStdCostAccount((Long)accountOrgId, (String)"aca");
        if (useActualCostAccountIds.size() == 0) {
            return 0L;
        }
        if (useActualCostAccountIds.size() == 1) {
            return (Long)useActualCostAccountIds.get(0);
        }
        Long mainCostAccountId = CostAccountHelper.getMainCostAccount((Long)accountOrgId, (String)appnum);
        if (CadEmptyUtils.isEmpty((Long)mainCostAccountId)) {
            return 0L;
        }
        for (Long costAccount : useActualCostAccountIds) {
            if (!costAccount.equals(mainCostAccountId)) continue;
            return costAccount;
        }
        return 0L;
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        List showColumns = event.getColumns();
        boolean showOrderCost = this.getModel().getDataEntity().getBoolean(SHOWORDER_COST);
        boolean showSubElement = this.getModel().getDataEntity().getBoolean(SHOWSUBELEMENT);
        boolean showMaterialDetail = this.getModel().getDataEntity().getBoolean(SHOWMATERIAL_DETAIL);
        Iterator iterator = showColumns.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof ReportColumn) {
                ReportColumn reportColumn = (ReportColumn)obj;
                String key = reportColumn.getFieldKey();
                if (!showOrderCost && this.orderCostHideColumns.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (!showSubElement && this.subElementHideColumns.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (showMaterialDetail || !this.subMatHideColumns.contains(key)) continue;
                reportColumn.setHide(true);
                continue;
            }
            if (!(obj instanceof ReportColumnGroup)) continue;
            ReportColumnGroup reportColumnGroup = (ReportColumnGroup)obj;
            String groupFieldKey = reportColumnGroup.getFieldKey();
            if (!showOrderCost && this.orderCostHideColumns.contains(groupFieldKey)) {
                iterator.remove();
                continue;
            }
            List reportColumns = reportColumnGroup.getChildren();
            for (int index = 0; index < reportColumns.size(); ++index) {
                Object column = reportColumns.get(index);
                if (!(column instanceof ReportColumn)) continue;
                ReportColumn col = (ReportColumn)column;
                String key = col.getFieldKey();
                if (!showOrderCost && this.orderCostHideColumns.contains(key)) {
                    col.setHide(true);
                }
                if (!showSubElement && this.subElementHideColumns.contains(key)) {
                    col.setHide(true);
                }
                if (showMaterialDetail || !this.subMatHideColumns.contains(key)) continue;
                col.setHide(true);
            }
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        String rowSeq;
        String saleBillNo;
        super.processRowData(gridPK, rowData, queryParam);
        ArrayList compareList = Lists.newArrayList();
        for (DynamicObject row : rowData) {
            saleBillNo = row.getString("salebillno");
            rowSeq = row.getString("rowseq");
            String proBillNo = row.getString("probillno");
            String prorowSeq = row.getString("prorowseq");
            String key = saleBillNo.concat("-").concat(rowSeq).concat("-").concat(proBillNo).concat("-").concat(prorowSeq);
            if (compareList.contains(key)) {
                this.clearRowData(row, Lists.newArrayList((Object[])new String[]{"manuorg", "probillno", "prorowseq", "configcode", "tracknum", "bizstatus", "promat", "hiddenpromat", "proauxpty", "transmittime", "endworktime"}));
                continue;
            }
            compareList.add(key);
        }
        compareList.clear();
        for (DynamicObject row : rowData) {
            saleBillNo = row.getString("salebillno");
            rowSeq = row.getString("rowseq");
            String key = saleBillNo.concat("-").concat(rowSeq);
            if (compareList.contains(key)) {
                this.clearRowData(row, Lists.newArrayList((Object[])new String[]{"saleorg", "salebillno", "rowseq", "configuredcode", "tracknumber", "salemat", "hiddenmaterial", "auxpty", "unit", "qty", "baseunit", "baseqty", "ordercost"}));
                continue;
            }
            compareList.add(key);
        }
    }

    private void clearRowData(DynamicObject row, List<String> clearRowName) {
        for (String rowName : clearRowName) {
            row.set(rowName, null);
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"SellOrderCostRpt_8", (String)"macc-aca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355\u6210\u672c\u5206\u6790\u67e5\u8be2(MTO)", (String)"SellOrderCostRpt_9", (String)"macc-aca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"aca_orderquery", (IDataModel)this.getModel());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        if (("exportexcel".equals(operateKey) || "syncexportexcel".equals(operateKey)) && !PermItemCheckHelper.isPerm((String)"aca_orderquery", (String)"47150e89000000ac", (Long)org.getLong("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u9500\u552e\u8ba2\u5355\u6210\u672c\u5206\u6790\u67e5\u8be2\u201d\u7684\u201c\u5bfc\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SellOrderCostRpt_10", (String)"macc-aca-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }
}

