/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.costsum;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.macc.aca.report.costsum.CostSumParam;
import kd.macc.aca.report.costsum.CostSunAddColParam;
import kd.macc.aca.report.costsum.DiyTotalRow;
import kd.macc.aca.report.costsum.HandleFinalRow;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostSumRptSourceCf
implements IReportDataHandle {
    private final Log logger = LogFactory.getLog(CostSumRptSourceCf.class);
    private Set<String> hideProps = Sets.newHashSet((Object[])new String[]{"period", "currency", "element", "subelement", "subelementname", "subelementnum", "subelementtype", "submaterialnum", "submaterial", "submaterialname", "submatunit", "type", "pdstartqty", "pdstartamount", "startadjqty", "startadjamt", "pdcurrqty", "pdcurramount", "pdsumqty", "pdsumamount", "yearpdsumqty", "yearpdsumamount", "pdendqty", "pdendamount", "endadjqty", "endadjamt", "currcomqty", "currcomuse", "currcomunitcost", "currcomamount", "totalcomqty", "sumcomuse", "totalcomunitcost", "totalcomamount", "yeartotalcomqty", "yearsumcomuse", "yeartotalcomunitcost", "yeartotalcomamount", "convsrcbillentry"});
    private CostSumParam costSumParam;
    private Map<String, CostSunAddColParam> paramMap = new LinkedHashMap<String, CostSunAddColParam>(64);

    public void setupCtx(ReportDataCtx ctx) {
        this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
        this.costSumParam = (CostSumParam)ctx.getParam(CostSumParam.class.getName());
        ctx.setShowBlockEntity(false);
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getFixedFilter());
        } else {
            fixedFs.addAll(this.getFixedFilter());
        }
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        this.logger.info("\u4fee\u6539\u56fa\u5b9a\u6570\u636e\u5757");
        Iterator<SrcBlockConf> selectBlockOr = blockCollector.iterator();
        List<Long> subMaterialIds = this.costSumParam.getSubMaterialIds();
        while (selectBlockOr.hasNext()) {
            SrcBlockConf blockConf = selectBlockOr.next();
            String srcEntity = blockConf.getSrcEntity();
            QFilter dataFs = blockConf.getDataFs();
            if ("aca_calcresult".equals(srcEntity) && dataFs != null) {
                Object value = dataFs.getValue();
                if ("finalResult".equals(value)) continue;
                if ("detail".equals(value) && !CadEmptyUtils.isEmpty(subMaterialIds)) {
                    QFilter qFilter = new QFilter("entryentity.submaterial", "in", subMaterialIds);
                    dataFs = dataFs == null ? qFilter : dataFs.and(qFilter);
                }
            }
            blockConf.setDataFs(dataFs);
        }
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        ctx.logInfo((Object)ResManager.loadKDString((String)"\u5904\u7406\u6570\u636e\u5757\u6570\u636e", (String)"CostSumRptSourceCf_0", (String)"macc-aca-report", (Object[])new Object[0]));
        transCollector.add(new HandleFinalRow(this.costSumParam, this.paramMap, ctx));
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        ctx.setGroupPlans(null);
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("group\u5b8c\u6210\u540e\u6267\u884c\u6570\u636e\u8f6c\u6362");
    }

    public void beforeAddSumRow(ReportDataCtx ctx) {
        this.logger.info("\u5728\u6dfb\u52a0\u6c47\u603b\u884c\u524d\u8bbe\u7f6e\u6c47\u603b\u65b9\u6848\uff0c\u6216\u8005\u5176\u4ed6\u4e0a\u4e0b\u6587\u8bbe\u7f6e");
        ctx.setSumPlans(new ArrayList());
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("\u6dfb\u52a0\u5b8c\u6c47\u603b\u884c\u540e\u6267\u884c\u7684\u6570\u636e\u8f6c\u6362");
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("\u751f\u6210\u6700\u7ec8\u7684\u6570\u636e\u5305\u540e\uff0c\u6267\u884c\u7684\u6570\u636e\u8f6c\u6362");
        transCollector.add(new DiyTotalRow(this.costSumParam, this.paramMap));
    }

    private List<QFilter> getFixedFilter() {
        List<Long> costObjectIds;
        List<Long> materialIds;
        ArrayList<QFilter> commonFilters = new ArrayList<QFilter>(10);
        Long orgId = this.costSumParam.getOrgId();
        commonFilters.add(new QFilter("org", "=", (Object)orgId));
        Long costAccountId = this.costSumParam.getCostAccountId();
        commonFilters.add(new QFilter("costaccount", "=", (Object)costAccountId));
        Long currency = this.costSumParam.getCurrencyId();
        commonFilters.add(new QFilter("currency", "=", (Object)currency));
        List<Object> periodIds = this.costSumParam.getPeriodIds();
        commonFilters.add(periodIds.size() == 1 ? new QFilter("period", "=", periodIds.get(0)) : new QFilter("period", "in", periodIds));
        List<Long> costCenterId = this.costSumParam.getCostCenterId();
        if (!CadEmptyUtils.isEmpty(costCenterId)) {
            commonFilters.add(new QFilter("costcenter", "in", costCenterId));
        }
        if (!CadEmptyUtils.isEmpty(materialIds = this.costSumParam.getMaterialIds())) {
            commonFilters.add(materialIds.size() == 1 ? new QFilter("costobject.material", "=", (Object)materialIds.get(0)) : new QFilter("costobject.material", "in", materialIds));
        }
        if (!CadEmptyUtils.isEmpty(costObjectIds = this.costSumParam.getCostObjectIds())) {
            commonFilters.add(costObjectIds.size() == 1 ? new QFilter("costobject", "=", (Object)costObjectIds.get(0)) : new QFilter("costobject", "in", costObjectIds));
        }
        return commonFilters;
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        this.logger.info("\u914d\u7f6e\u5217\u662f\u5426\u663e\u793a");
        Iterator<AbstractReportColumn> iterator = cols.iterator();
        ReportColumnGroup total = new ReportColumnGroup();
        total.setFieldKey("totalkey");
        String caption = this.getCaption();
        total.setCaption(new LocaleString(caption));
        List totalChildren = total.getChildren();
        while (iterator.hasNext()) {
            ReportColumn repCol = (ReportColumn)iterator.next();
            String fieldKey = repCol.getFieldKey();
            if (this.hideProps.contains(fieldKey)) {
                repCol.setHide(true);
                continue;
            }
            if ("baseqty".equals(fieldKey)) {
                repCol.setFieldType("qty");
                repCol.setZeroShow(false);
                repCol.setNoDisplayScaleZero(false);
                repCol.setMeasureUnitField("unit");
                totalChildren.add(repCol);
                iterator.remove();
                continue;
            }
            if ("amount".equals(fieldKey)) {
                repCol.setFieldType("amount");
                repCol.setZeroShow(false);
                repCol.setNoDisplayScaleZero(false);
                repCol.setCurrencyField("currency");
                totalChildren.add(repCol);
                iterator.remove();
                continue;
            }
            if (!"price".equals(fieldKey)) continue;
            repCol.setFieldType("price");
            repCol.setZeroShow(false);
            repCol.setNoDisplayScaleZero(false);
            repCol.setCurrencyField("currency");
            totalChildren.add(repCol);
            iterator.remove();
        }
        for (Map.Entry<String, CostSunAddColParam> entry : this.paramMap.entrySet()) {
            String key = entry.getKey();
            CostSunAddColParam costSunAddColParam = entry.getValue();
            ReportColumnGroup subMatGroup = new ReportColumnGroup();
            subMatGroup.setFieldKey(key);
            subMatGroup.setCaption(new LocaleString(costSunAddColParam.getColName()));
            List children = subMatGroup.getChildren();
            Boolean isAddQtyCol = costSunAddColParam.getShowQty();
            if (isAddQtyCol.booleanValue()) {
                String keyUnit = key + "unit";
                ReportColumn actualUnit = new ReportColumn();
                actualUnit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5355\u4f4d", (String)"CostSumRptSourceCf_1", (String)"macc-aca-report", (Object[])new Object[0])));
                actualUnit.setWidth(new LocaleString("100px"));
                actualUnit.setFieldKey(keyUnit);
                actualUnit.setFieldType("basedata");
                actualUnit.setEntityId("bd_measureunits");
                actualUnit.setHide(true);
                children.add(actualUnit);
                ReportColumn actualQty = new ReportColumn();
                actualQty.setCaption(new LocaleString(ResManager.loadKDString((String)"\u57fa\u672c\u6570\u91cf", (String)"CostSumRptSourceCf_2", (String)"macc-aca-report", (Object[])new Object[0])));
                actualQty.setWidth(new LocaleString("100px"));
                actualQty.setFieldKey(key + "qty");
                actualQty.setFieldType("qty");
                actualQty.setNoDisplayScaleZero(false);
                actualQty.setZeroShow(false);
                actualQty.setMeasureUnitField(keyUnit);
                children.add(actualQty);
            }
            ReportColumn actualAmount = new ReportColumn();
            actualAmount.setCaption(new LocaleString(ResManager.loadKDString((String)"\u91d1\u989d", (String)"CostSumRptSourceCf_3", (String)"macc-aca-report", (Object[])new Object[0])));
            actualAmount.setWidth(new LocaleString("100px"));
            actualAmount.setFieldKey(key + "amount");
            actualAmount.setFieldType("amount");
            actualAmount.setZeroShow(false);
            actualAmount.setNoDisplayScaleZero(false);
            actualAmount.setCurrencyField("currency");
            children.add(actualAmount);
            totalChildren.add(subMatGroup);
        }
        cols.add((AbstractReportColumn)total);
        return cols;
    }

    private String getCaption() {
        String reportContent;
        switch (reportContent = this.costSumParam.getReportContent()) {
            case "A": {
                reportContent = ResManager.loadKDString((String)"\u672c\u671f\u5b8c\u5de5", (String)"CostSumRptSourceCf_4", (String)"macc-aca-report", (Object[])new Object[0]);
                break;
            }
            case "D": {
                reportContent = ResManager.loadKDString((String)"\u672c\u671f\u6295\u5165", (String)"CostSumRptSourceCf_5", (String)"macc-aca-report", (Object[])new Object[0]);
                break;
            }
            default: {
                reportContent = ResManager.loadKDString((String)"\u6295\u5165", (String)"CostSumRptSourceCf_6", (String)"macc-aca-report", (Object[])new Object[0]);
            }
        }
        return reportContent;
    }
}

