/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.costsum;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.macc.aca.report.costsum.CostSumParam;
import kd.macc.aca.report.costsum.CostSunAddColParam;
import kd.macc.cad.common.utils.DataSetUtils;

public class DiyTotalRow
implements IDataTransform {
    private Map<String, CostSunAddColParam> paramMap;

    public DiyTotalRow(CostSumParam costSumParam, Map<String, CostSunAddColParam> paramMap) {
        this.paramMap = paramMap;
    }

    public DataSet doTransform(DataSet srcData) {
        ArrayList<String> groupUnit = new ArrayList<String>();
        groupUnit.add("currency");
        String[] unitFile = groupUnit.toArray(new String[0]);
        groupUnit.add("period");
        GroupbyDataSet smallGroupbyDataSet = srcData.groupBy(groupUnit.toArray(new String[0])).sum("amount").sum("baseqty");
        for (Map.Entry<String, CostSunAddColParam> entry : this.paramMap.entrySet()) {
            String key = entry.getKey();
            if (entry.getValue().getShowQty().booleanValue()) {
                String keyQty = key + "qty";
                smallGroupbyDataSet = smallGroupbyDataSet.sum(keyQty);
            }
            String amountKey = key + "amount";
            smallGroupbyDataSet = smallGroupbyDataSet.sum(amountKey);
        }
        DataSet smallDataSet = smallGroupbyDataSet.finish().addField(ResManager.loadKDString((String)"'\u671f\u95f4\u5c0f\u8ba1'", (String)"DiyTotalRow_0", (String)"macc-aca-report", (Object[])new Object[0]), "periodname").addField("'1'", "linetype");
        List<String> leftSelectFileName = this.getLeftSelectFileName(srcData.getRowMeta().getFieldNames(), smallDataSet.getRowMeta().getFieldNames());
        smallDataSet = smallDataSet.addNullField(leftSelectFileName.toArray(new String[0]));
        srcData = DataSetUtils.union((DataSet)srcData, (DataSet)smallDataSet);
        srcData = srcData.orderBy(new String[]{"period desc", "linetype", "costcenter", "costobject", "group", "material"});
        GroupbyDataSet totalGroupbyDataSet = smallDataSet.groupBy(unitFile).sum("amount").sum("baseqty");
        for (Map.Entry entry : this.paramMap.entrySet()) {
            String key = (String)entry.getKey();
            if (((CostSunAddColParam)entry.getValue()).getShowQty().booleanValue()) {
                totalGroupbyDataSet = totalGroupbyDataSet.sum(key + "qty");
            }
            totalGroupbyDataSet = totalGroupbyDataSet.sum(key + "amount");
        }
        DataSet totalDataSet = totalGroupbyDataSet.finish().addField("'2'", "linetype").addField(ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"DiyTotalRow_3", (String)"macc-aca-report", (Object[])new Object[0]), "periodname");
        leftSelectFileName = this.getLeftSelectFileName(srcData.getRowMeta().getFieldNames(), totalDataSet.getRowMeta().getFieldNames());
        totalDataSet = totalDataSet.addNullField(leftSelectFileName.toArray(new String[0]));
        srcData = DataSetUtils.union((DataSet)srcData, (DataSet)totalDataSet);
        srcData = srcData.removeFields(new String[]{"linetype"});
        return srcData;
    }

    private List<String> getLeftSelectFileName(String[] leftFieldNames, String[] rightFileNames) {
        Boolean containFlag = false;
        ArrayList<String> selectFileNameList = new ArrayList<String>();
        for (String leftFieldName : leftFieldNames) {
            containFlag = false;
            for (String rightFileName : rightFileNames) {
                if (!rightFileName.equals(leftFieldName)) continue;
                containFlag = true;
                break;
            }
            if (containFlag.booleanValue()) continue;
            selectFileNameList.add(leftFieldName);
        }
        return selectFileNameList;
    }
}

