/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.costsum;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.macc.aca.algox.utils.AcaAlgoxEmptyOrZeroUtils;
import kd.macc.aca.algox.utils.DataSetXHelper;
import kd.macc.aca.algox.utils.MaterialGroupHelper;
import kd.macc.aca.report.costsum.CostSumCalDataFunction;
import kd.macc.aca.report.costsum.CostSumParam;
import kd.macc.aca.report.costsum.CostSunAddColParam;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class HandleFinalRow
implements IDataXTransform {
    private static final String DYNAMIC_PREFIX = "range";
    private ReportDataCtx ctx;
    private CostSumParam costSumParam;
    private Map<String, CostSunAddColParam> paramMap;
    private String[] rightFileNames = new String[]{"biztype", "material", "materialname", "modelnum", "matversion", "auxpty", "relaproducttype", "unit"};

    public HandleFinalRow(CostSumParam costSumParam, Map<String, CostSunAddColParam> paramMap, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.costSumParam = costSumParam;
        this.paramMap = paramMap;
    }

    public DataSetX doTransform(DataSetX srcData) {
        OrmInput materialgroup;
        String reportContent = this.costSumParam.getReportContent();
        ArrayList qFilters = Lists.newArrayList();
        Long orgId = this.costSumParam.getOrgId();
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        qFilters.add(orgQf);
        OrmInput ormInput = new OrmInput("HandleFinalRow", "cad_costobject", "id,biztype,material,material.name as materialname, material.modelnum as modelnum,bomversion matversion,auxpty,producttype as relaproducttype,material.baseunit unit", qFilters.toArray(new QFilter[0]));
        DataSetX costObjectData = this.ctx.getCurrentJob().fromInput((Input)ormInput);
        String[] leftFieldNames = srcData.getRowMeta().getFieldNames();
        List<String> leftSelectFileList = this.getLeftSelectFileName(leftFieldNames, this.rightFileNames);
        boolean isCompleted = "A".equals(reportContent);
        DataSetX finalResultData = srcData.filter("type = 'finalResult'");
        DataSetX detailResultData = srcData.filter("type = 'detail'").filter("material != 0");
        finalResultData = finalResultData.leftJoin(costObjectData).on("costobject", "id").select(leftSelectFileList.toArray(new String[0]), this.rightFileNames);
        srcData = DataSetXHelper.unionIfRowDiff((DataSetX)finalResultData, (DataSetX)detailResultData);
        List<Long> mulMaterialGroupId = this.costSumParam.getMulMaterialGroupId();
        QFilter filter = new QFilter("standard", "=", (Object)this.costSumParam.getMaterialGrpStdId());
        if (!AcaAlgoxEmptyOrZeroUtils.isEmpty(mulMaterialGroupId)) {
            materialgroup = QueryServiceHelper.query((String)"bd_materialgroup", (String)"longnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", mulMaterialGroupId)});
            filter.and(MaterialGroupHelper.getGroupFilter((DynamicObjectCollection)materialgroup, (boolean)true, (String)"group.longnumber"));
        }
        materialgroup = new OrmInput(HandleFinalRow.class.getName(), "bd_materialgroupdetail", "group,group.number as materialgroupnumber,group.name as groupname,material,material.number as materialnumber,material.materialtype as materialtype", filter.toArray());
        DataSetX materialGroupDataSetX = this.ctx.getCurrentJob().fromInput((Input)materialgroup);
        this.rightFileNames = new String[]{"group", "groupname"};
        leftSelectFileList = this.getLeftSelectFileName(srcData.getRowMeta().getFieldNames(), this.rightFileNames);
        srcData = srcData.leftJoin(materialGroupDataSetX).on("material", "material").select(leftSelectFileList.toArray(new String[0]), this.rightFileNames);
        JobSession currentJob = this.ctx.getCurrentJob();
        DataSetOutput dataSetOutput = new DataSetOutput(srcData.getRowMeta());
        String resultId = dataSetOutput.getId();
        srcData.output((Output)dataSetOutput);
        currentJob.commit(60, TimeUnit.MINUTES);
        DataSet resultDs = currentJob.readDataSet(resultId);
        this.putFileName(reportContent);
        ArrayList<String> valueList = new ArrayList<String>();
        List<String> colKeyList = this.getAddColsStrings(resultDs.copy(), valueList);
        if (colKeyList.size() > 0) {
            resultDs = resultDs.addFields(valueList.toArray(new String[0]), colKeyList.toArray(new String[0]));
        }
        DataSetInput resultDsInput = new DataSetInput(resultDs);
        srcData = currentJob.fromInput((Input)resultDsInput);
        CostSumCalDataFunction function = new CostSumCalDataFunction(srcData.getRowMeta(), this.paramMap, this.costSumParam);
        srcData = srcData.groupBy(new String[]{"period", "currency", "group", "material", "matversion", "auxpty", "relaproducttype", "costobject"}).reduceGroup((GroupReduceFunction)function).filter("amount != 0 or baseqty != 0");
        return srcData;
    }

    private List<String> getAddColsStrings(DataSet copy, ArrayList<String> valueList) {
        String amountFileName = this.costSumParam.getAmountFileName();
        String qtyFileName = this.costSumParam.getQtyFileName();
        int showCount = this.costSumParam.getShowCount();
        copy = copy.filter("type !='finalResult'").groupBy(new String[]{"period", "currency", "group", "material", "matversion", "auxpty", "subelement", "subelementnum", "subelementname", "subelementtype", "submaterial", "submaterialnum", "submaterialname", "submatunit"}).sum(amountFileName).sum(qtyFileName).finish();
        StringBuilder keyBuilder = new StringBuilder();
        String subEle01 = "001";
        String subEle02 = "002";
        String otherColKey = "rangeother";
        HashMap<String, CostSunAddColParam> addColMap = new HashMap<String, CostSunAddColParam>();
        HashMap notShowQtyColMap = new HashMap();
        HashMap<String, CostSunAddColParam> dataMap = null;
        while (copy.hasNext()) {
            Row row = copy.next();
            Long subElementId = row.getLong("subelement");
            Long submaterial = row.getLong("submaterial");
            Long submaterialunit = 0L;
            Object submaterialunitObj = row.get("submatunit");
            if (submaterialunitObj != null) {
                submaterialunit = (Long)submaterialunitObj;
            }
            String subelementnum = row.getString("subelementnum");
            String subelementname = row.getString("subelementname");
            String subelementtype = row.getString("subelementtype");
            Boolean showQty = subEle01.equals(subelementtype) || subEle02.equals(subelementtype);
            String submaterialnum = row.getString("submaterialnum");
            String submaterialname = row.getString("submaterialname");
            BigDecimal amount = row.getBigDecimal(amountFileName);
            BigDecimal qty = row.getBigDecimal(qtyFileName);
            if (CadEmptyUtils.isEmpty((Long)subElementId) && CadEmptyUtils.isEmpty((Long)submaterial)) continue;
            keyBuilder.setLength(0);
            if (showQty.booleanValue()) {
                keyBuilder = keyBuilder.append(subelementname);
                if (StringUtils.isNotEmpty((CharSequence)submaterialnum)) {
                    keyBuilder = keyBuilder.append('/').append(submaterialnum).append('/').append(submaterialname);
                }
                dataMap = addColMap;
                if (this.isEmpty(qty) && this.isEmpty(amount)) {
                    continue;
                }
            } else {
                if (this.isEmpty(amount)) continue;
                keyBuilder = keyBuilder.append(subelementnum).append('/').append(subelementname);
                dataMap = notShowQtyColMap;
            }
            String colName = keyBuilder.toString();
            keyBuilder.setLength(0);
            String colKey = keyBuilder.append(DYNAMIC_PREFIX).append(subElementId).append(submaterial).toString();
            CostSunAddColParam costSunAddColParam = (CostSunAddColParam)dataMap.get(colKey);
            if (costSunAddColParam == null) {
                if (subelementname == null) {
                    subelementname = "";
                }
                dataMap.put(colKey, new CostSunAddColParam(colKey, colName, showQty, amount, submaterialunit, subelementnum, subelementtype, submaterialname));
                continue;
            }
            BigDecimal sumAmount = costSunAddColParam.getSumAmount();
            costSunAddColParam.setSumAmount(sumAmount.add(amount));
            if (CadEmptyUtils.isEmpty((Long)submaterialunit)) continue;
            costSunAddColParam.setSubMatUnit(submaterialunit);
        }
        List<Map.Entry<String, CostSunAddColParam>> entriesList = new ArrayList(addColMap.entrySet());
        Collections.sort(entriesList, new Comparator<Map.Entry<String, CostSunAddColParam>>(){

            @Override
            public int compare(Map.Entry<String, CostSunAddColParam> o1, Map.Entry<String, CostSunAddColParam> o2) {
                return o2.getValue().getSumAmount().compareTo(o1.getValue().getSumAmount());
            }
        });
        int size = entriesList.size();
        Boolean addOtherCol = size > showCount;
        if (addOtherCol.booleanValue()) {
            entriesList = entriesList.subList(0, showCount);
        }
        Comparator<Map.Entry<String, CostSunAddColParam>> comparator = new Comparator<Map.Entry<String, CostSunAddColParam>>(){

            @Override
            public int compare(Map.Entry<String, CostSunAddColParam> o1, Map.Entry<String, CostSunAddColParam> o2) {
                String subEleType1 = o1.getValue().getSubEleType();
                String subEleType2 = o2.getValue().getSubEleType();
                if (CadEmptyUtils.isEmpty((String)subEleType1)) {
                    return -1;
                }
                if (CadEmptyUtils.isEmpty((String)subEleType2)) {
                    return 1;
                }
                int result = subEleType1.compareTo(subEleType2);
                if (result == 0) {
                    String subEleNum1 = o1.getValue().getSubEleNum();
                    String subEleNum2 = o2.getValue().getSubEleNum();
                    if (CadEmptyUtils.isEmpty((String)subEleNum1)) {
                        return -1;
                    }
                    if (CadEmptyUtils.isEmpty((String)subEleNum2)) {
                        return 1;
                    }
                    result = subEleNum1.compareTo(subEleNum2);
                    if (result == 0) {
                        result = o1.getValue().getSubMatNum().compareTo(o2.getValue().getSubMatNum());
                    }
                }
                return result;
            }
        };
        entriesList.sort(comparator);
        List<String> colKeyList = this.getColKeyList(valueList, entriesList);
        if (addOtherCol.booleanValue()) {
            this.paramMap.put(otherColKey, new CostSunAddColParam(otherColKey, ResManager.loadKDString((String)"\u5176\u4ed6", (String)"HandleFinalRow_0", (String)"macc-aca-report", (Object[])new Object[0]), false, BigDecimal.ZERO, 0L, null, null, null));
            colKeyList.add(otherColKey + "amount");
            valueList.add("0.0");
        }
        if (notShowQtyColMap.size() > 0) {
            ArrayList<Map.Entry<String, CostSunAddColParam>> notShowQtyList = new ArrayList<Map.Entry<String, CostSunAddColParam>>(notShowQtyColMap.entrySet());
            Collections.sort(notShowQtyList, comparator);
            List<String> addKeyList = this.getColKeyList(valueList, notShowQtyList);
            colKeyList.addAll(addKeyList);
        }
        return colKeyList;
    }

    private List<String> getColKeyList(List<String> valueList, List<Map.Entry<String, CostSunAddColParam>> entriesList) {
        ArrayList<String> colKeyList = new ArrayList<String>(entriesList.size() * 2);
        for (Map.Entry<String, CostSunAddColParam> entry : entriesList) {
            String colKey = entry.getKey();
            CostSunAddColParam costSunAddColParam = entry.getValue();
            this.paramMap.put(colKey, costSunAddColParam);
            colKeyList.add(colKey + "amount");
            valueList.add("0.0");
            if (!costSunAddColParam.getShowQty().booleanValue()) continue;
            colKeyList.add(colKey + "unit");
            valueList.add(costSunAddColParam.getSubMatUnit() + "L");
            colKeyList.add(colKey + "qty");
            valueList.add("0.0");
        }
        return colKeyList;
    }

    private void putFileName(String reportContent) {
        String qtyFileName = "";
        String amountFileName = "";
        switch (reportContent) {
            case "A": {
                qtyFileName = "currcomqty";
                amountFileName = "currcomamount";
                break;
            }
            case "B": {
                qtyFileName = "pdstartqty";
                amountFileName = "pdstartamount";
                break;
            }
            case "C": {
                qtyFileName = "startadjqty";
                amountFileName = "startadjamt";
                break;
            }
            case "D": {
                qtyFileName = "pdcurrqty";
                amountFileName = "pdcurramount";
                break;
            }
            case "E": {
                qtyFileName = "pdsumqty";
                amountFileName = "pdsumamount";
                break;
            }
            case "F": {
                qtyFileName = "yearpdsumqty";
                amountFileName = "yearpdsumamount";
                break;
            }
            case "G": {
                qtyFileName = "pdendqty";
                amountFileName = "pdendamount";
                break;
            }
            case "H": {
                qtyFileName = "endadjqty";
                amountFileName = "endadjamt";
                break;
            }
            case "I": {
                qtyFileName = "totalcomqty";
                amountFileName = "totalcomamount";
                break;
            }
            default: {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6570\u9519\u8bef\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u201c\u62a5\u8868\u5185\u5bb9\u201d\u5b57\u6bb5\u9009\u9879\u3002", (String)"HandleFinalRow_1", (String)"macc-aca-report", (Object[])new Object[0]));
            }
        }
        this.costSumParam.setQtyFileName(qtyFileName);
        this.costSumParam.setAmountFileName(amountFileName);
    }

    private List<String> getLeftSelectFileName(String[] leftFieldNames, String[] rightFileNames) {
        Boolean containFlag = false;
        ArrayList<String> selectFileNameList = new ArrayList<String>();
        for (String leftFieldName : leftFieldNames) {
            containFlag = false;
            for (String rightFileName : rightFileNames) {
                if (!rightFileName.equals(leftFieldName)) continue;
                containFlag = true;
                break;
            }
            if (containFlag.booleanValue()) continue;
            selectFileNameList.add(leftFieldName);
        }
        return selectFileNameList;
    }

    private boolean isEmpty(BigDecimal object) {
        return object == null || object.doubleValue() == 0.0 || "0E-10".equals(object.toString());
    }
}

