/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.feealloc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.aca.common.helper.AcaCostAccountHelper;
import kd.macc.aca.common.helper.PermItemCheckHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;

public class CostCalResultRpt
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final Integer SINGLE_MAX_FILTER_STR = 10000;
    private static final String CAL_FPERIOD = "fperiod";
    private static final String IS_SHOWMATERIAL_DETAIL = "isshowmaterialdetail";
    private static final String IS_SHOWSUBELEMENT = "isshowsubelement";
    protected static final String[] eleStr = new String[]{"element", "elementname", "subelement", "subelementname", "currcomuse", "totalcomuse"};
    protected static final String[] detailStr = new String[]{"submaterial", "submaterialname", "submaterialtype", "submatunit", "submatversion", "submatauxpty"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costCenter = (BasedataEdit)this.getControl("fcostcenter");
        BasedataEdit costObject = (BasedataEdit)this.getControl("fcostobject");
        costCenter.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                Object orgDy = CostCalResultRpt.this.getModel().getValue("org");
                if (orgDy == null) {
                    CostCalResultRpt.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostCalResultRpt_0", (String)"macc-aca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter[] costCenterFilter = CostCalResultRpt.this.getCostCenterFilter();
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter filterParameter = listShowParameter.getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                qFilters.addAll(Arrays.asList(costCenterFilter));
            }
        });
        costObject.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                Object orgDy = CostCalResultRpt.this.getModel().getValue("org");
                if (orgDy == null) {
                    CostCalResultRpt.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostCalResultRpt_0", (String)"macc-aca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                List costObjectFilter = CostCalResultRpt.this.getCostObjectFilter();
                ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
                List qFilters = listFilterParameter.getQFilters();
                qFilters.addAll(costObjectFilter);
            }
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                Object orgDy = CostCalResultRpt.this.getModel().getValue("org");
                if (orgDy == null) {
                    CostCalResultRpt.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostCalResultRpt_0", (String)"macc-aca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter costAccountFilter = CostCalResultRpt.this.getCostAccountFilter();
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter filterParameter = listShowParameter.getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                qFilters.add(costAccountFilter);
            }
        });
        BasedataEdit calPeriod = (BasedataEdit)this.getControl(CAL_FPERIOD);
        calPeriod.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                Object costAccount = CostCalResultRpt.this.getModel().getValue("costaccount");
                if (costAccount == null) {
                    CostCalResultRpt.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostCalResultRpt_1", (String)"macc-aca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter periodFilter = CostCalResultRpt.this.getPeriodFilter();
                if (periodFilter != null) {
                    ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
                    List qFilters = listFilterParameter.getQFilters();
                    qFilters.add(periodFilter);
                }
            }
        });
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
                List qFilters = listFilterParameter.getQFilters();
                List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId()).getHasPermOrgs();
                List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"10");
                if (!CollectionUtils.isEmpty((Collection)permOrgIds) || !CollectionUtils.isEmpty((Collection)orgIds)) {
                    qFilters.add(new QFilter("id", "in", (Object)orgIds));
                }
            }
        });
        BasedataEdit manuOrg = (BasedataEdit)this.getControl("manuorg");
        manuOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostCalResultRpt_0", (String)"macc-aca-report", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        List manuOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)((Long)org.getPkValue()), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (CollectionUtils.isNotEmpty((Collection)manuOrg)) {
            QFilter filter = new QFilter("id", "in", (Object)manuOrg);
            listShowParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyname) {
            case "org": {
                this.setCostAccount(newValue);
                this.getModel().setValue("manuorg", null);
                this.getModel().setValue("fcostcenter", null);
                this.setManuOrg();
                break;
            }
            case "costaccount": {
                this.setCurrencyAndPeriod(newValue);
                break;
            }
            case "isshowmaterialdetail": {
                Boolean isshowmaterialdetail = (Boolean)this.getModel().getValue(IS_SHOWMATERIAL_DETAIL);
                if (!isshowmaterialdetail.booleanValue()) break;
                this.getModel().setValue(IS_SHOWSUBELEMENT, (Object)true);
                this.getView().updateView(IS_SHOWSUBELEMENT);
                break;
            }
            case "isshowsubelement": {
                Boolean isshowsubelement = (Boolean)this.getModel().getValue(IS_SHOWSUBELEMENT);
                if (isshowsubelement.booleanValue()) break;
                this.getModel().setValue(IS_SHOWMATERIAL_DETAIL, (Object)false);
                this.getView().updateView(IS_SHOWMATERIAL_DETAIL);
            }
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"CostCalResultRpt_2", (String)"macc-aca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u6210\u672c\u8ba1\u7b97\u5355\u67e5\u8be2", (String)"CostCalResultRpt_3", (String)"macc-aca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"aca_calcresultrpt", (IDataModel)this.getModel());
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ReportShowParameter reportShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        String customParams = (String)reportShowParameter.getCustomParams().get("custparam");
        if (customParams != null && !CadEmptyUtils.isEmpty((String)customParams)) {
            JSONObject calcParamJs = JSONObject.fromObject((Object)customParams);
            this.assignQueryValAndSearch(calcParamJs);
            return;
        }
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org != null) {
            return;
        }
        this.initQueryInfo();
        this.getView().updateView("reportcommfilterpanelap");
    }

    private void initQueryInfo() {
        Long accountOrgId = this.getDefaultOrg();
        this.getModel().setValue("org", (Object)accountOrgId);
        this.setManuOrg();
        if (accountOrgId != null) {
            Long costAccountId = AcaCostAccountHelper.getCostAccountsByOrgId((Long)accountOrgId, (String)this.getView().getFormShowParameter().getAppId());
            if (costAccountId != 0L) {
                this.getModel().setValue("costaccount", (Object)costAccountId);
            } else {
                this.getModel().setValue("costaccount", null);
            }
            this.setCurrencyAndPeriod(this.getModel().getDataEntity().getDynamicObject("costaccount"));
        }
    }

    private void setManuOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        boolean enableMultiFactory = false;
        if (org != null) {
            enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)((Long)org.getPkValue()));
        }
        BasedataEdit manuOrgEdit = (BasedataEdit)this.getControl("manuorg");
        manuOrgEdit.setMustInput(enableMultiFactory);
        this.getView().setEnable(Boolean.valueOf(enableMultiFactory), new String[]{"manuorg"});
    }

    private Long getDefaultOrg() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return org.getLong("masterid");
        }
        Long currentOrgId = RequestContext.getOrCreate().getOrgId();
        List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getHasPermOrgIdsByOrgViewType((String)"10");
        if (!CadEmptyUtils.isEmpty((List)hasPermOrgIdsByOrgViewType) && hasPermOrgIdsByOrgViewType.contains(currentOrgId)) {
            return currentOrgId;
        }
        return 0L;
    }

    private void assignQueryValAndSearch(JSONObject customParams) {
        Object costAccount;
        this.getModel().beginInit();
        Object org = customParams.get("orgId");
        if (org != null && org != JSONNull.getInstance()) {
            this.getModel().setValue("org", org);
        }
        if ((costAccount = customParams.get("costAccountId")) != null) {
            this.getModel().setValue("costaccount", costAccount);
        }
        this.setCurrencyAndPeriod(this.getModel().getDataEntity().getDynamicObject("costaccount"));
        this.getView().updateView("reportfilterap");
        this.getModel().endInit();
        ReportFilter reportFilter = (ReportFilter)this.getControl("reportfilterap");
        reportFilter.search();
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        List<String> eleHideFiles = this.getHideLists(eleStr);
        List<String> detailHideFields = this.getHideLists(detailStr);
        Boolean isShowSubElement = this.getModel().getDataEntity().getBoolean(IS_SHOWSUBELEMENT);
        Boolean isShowMaterialDetail = this.getModel().getDataEntity().getBoolean(IS_SHOWMATERIAL_DETAIL);
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof ReportColumn) {
                ReportColumn reportColumn = (ReportColumn)obj;
                String key = reportColumn.getFieldKey();
                if (!isShowSubElement.booleanValue() && eleHideFiles.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (isShowMaterialDetail.booleanValue() || !detailHideFields.contains(key)) continue;
                reportColumn.setHide(true);
                continue;
            }
            if (!(obj instanceof ReportColumnGroup)) continue;
            ReportColumnGroup reportColumnGroup = (ReportColumnGroup)obj;
            List reportColumns = reportColumnGroup.getChildren();
            for (int index = 0; index < reportColumns.size(); ++index) {
                Object column = reportColumns.get(index);
                if (!(column instanceof ReportColumn)) continue;
                ReportColumn col = (ReportColumn)column;
                String key = col.getFieldKey();
                if (!isShowSubElement.booleanValue() && eleHideFiles.contains(key)) {
                    col.setHide(true);
                }
                if (isShowMaterialDetail.booleanValue() || !detailHideFields.contains(key)) continue;
                col.setHide(true);
            }
        }
        this.getView().updateView("reportlistap");
    }

    public void afterDoOperation(AfterDoOperationEventArgs evts) {
        String key;
        super.afterDoOperation(evts);
        switch (key = evts.getOperateKey()) {
            case "reset": {
                this.getModel().setValue(CAL_FPERIOD, null);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        boolean isPass;
        boolean enableMultiFactory;
        ArrayList pros = null;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null && (enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)((Long)org.getPkValue())))) {
            pros = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "currency", CAL_FPERIOD, "manuorg"});
        }
        if (pros == null) {
            pros = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "currency", CAL_FPERIOD});
        }
        if (!(isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, pros))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"CostCalResultRpt_4", (String)"macc-aca-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        Object currency = this.getModel().getValue("currency");
        for (DynamicObject rowDatum : rowData) {
            if (rowDatum.get("subelement") == null) {
                rowDatum.set("colourrule", (Object)"Y");
            }
            rowDatum.set("currencyfield", currency);
        }
    }

    private void setCostAccount(Object org) {
        if (org == null) {
            return;
        }
        DynamicObject orgDO = (DynamicObject)org;
        Long mainBookId = OrgHelper.getCostAccountByAccoutOrg((Long)orgDO.getLong("id"));
        if (mainBookId != null && mainBookId != 0L) {
            boolean isnit = StartCostHelper.isInit((Long)mainBookId, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
            if (isnit) {
                this.getModel().setValue("costaccount", (Object)mainBookId);
            }
        } else {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue(CAL_FPERIOD, null);
        }
    }

    private void setCurrencyAndPeriod(Object costAccount) {
        if (costAccount == null) {
            return;
        }
        DynamicObject costAccountDO = (DynamicObject)costAccount;
        Long currency = CalcRptHelper.getCurrency((DynamicObject)costAccountDO);
        this.getModel().setValue("currency", (Object)currency);
        this.setPeriod();
    }

    private void setPeriod() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        DynamicObject costaccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        if (org == null || costaccount == null) {
            return;
        }
        long orgId = org.getLong("id");
        long costaccountId = costaccount.getLong("id");
        Long currPeriod = CalcRptHelper.getCurrPeriod((Long)orgId, (Long)costaccountId);
        if (currPeriod != null && currPeriod != 0L) {
            this.getModel().setValue(CAL_FPERIOD, (Object)new Object[]{currPeriod});
        }
    }

    private QFilter[] getCostCenterFilter() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        QFilter orgFilter = new QFilter("accountorg", "=", org.getPkValue());
        QFilter orgdutyFilter = new QFilter("orgduty", "=", (Object)4L);
        orgdutyFilter.and("enable", "=", (Object)"1");
        return new QFilter[]{orgFilter, orgdutyFilter};
    }

    private List<QFilter> getCostObjectFilter() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        DynamicObjectCollection rows = (DynamicObjectCollection)this.getModel().getValue("fcostcenter");
        HashSet<Long> costcenterIds = new HashSet<Long>();
        for (DynamicObject row : rows) {
            DynamicObject costcenter = row.getDynamicObject("fbasedataid");
            costcenterIds.add((Long)costcenter.getPkValue());
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (org != null) {
            QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
            filters.add(orgFilter);
        }
        if (!CadEmptyUtils.isEmpty(costcenterIds)) {
            QFilter costcenterFilter = new QFilter("costcenter", "in", costcenterIds);
            filters.add(costcenterFilter);
        }
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        return filters;
    }

    private QFilter getCostAccountFilter() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        List orgUseCostAccountIds = CostAccountHelper.getOrgUseStdCostAccount((Long)((Long)org.getPkValue()), (String)"aca");
        QFilter costAccountFilter = new QFilter("id", "in", (Object)orgUseCostAccountIds.toArray());
        return costAccountFilter;
    }

    private QFilter getPeriodFilter() {
        DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null || costAccount == null) {
            return null;
        }
        long orgId = org.getLong("id");
        long costAccountId = costAccount.getLong("id");
        QFilter periodFilter = StartCostHelper.getPeriodTypeFilter((String)"aca", (Long)orgId, (Long)costAccountId);
        return periodFilter;
    }

    private List<String> getHideLists(String[] strings) {
        ArrayList<String> hideFiles = new ArrayList<String>(10);
        for (int i = 0; i < strings.length; ++i) {
            hideFiles.add(strings[i]);
        }
        return hideFiles;
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        super.formatDisplayFilterField(evt);
        String formatedFilterString = evt.getFormatedFilterString();
        int costObjIndex = formatedFilterString.indexOf(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\uff1a", (String)"CostCalResultRpt_5", (String)"macc-aca-report", (Object[])new Object[0]));
        int subElementIndex = formatedFilterString.indexOf(ResManager.loadKDString((String)" \u663e\u793a\u6210\u672c\u5b50\u8981\u7d20", (String)"CostCalResultRpt_6", (String)"macc-aca-report", (Object[])new Object[0]));
        if (costObjIndex != -1 && subElementIndex != -1) {
            String substring = formatedFilterString.substring(costObjIndex + 7, subElementIndex);
            int length = substring.length();
            if (length > SINGLE_MAX_FILTER_STR) {
                substring = substring.substring(0, SINGLE_MAX_FILTER_STR - 6);
                substring = substring + "\u2026\u2026";
            }
            String prefixStr = formatedFilterString.substring(0, costObjIndex + 7);
            String suffixStr = formatedFilterString.substring(subElementIndex);
            evt.setFormatedFilterString(prefixStr + substring + suffixStr);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        if (("exportexcel".equals(operateKey) || "syncexportexcel".equals(operateKey)) && !PermItemCheckHelper.isPerm((String)"aca_calcresultrpt", (String)"47150e89000000ac", (Long)org.getLong("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6210\u672c\u8ba1\u7b97\u5355\u201d\u7684\u201c\u5bfc\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostCalResultRpt_7", (String)"macc-aca-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }
}

