/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.feealloc;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.aca.common.helper.AcaCostAccountHelper;
import kd.macc.aca.common.helper.MatBaseDataFilterHelper;
import kd.macc.aca.common.helper.PermItemCheckHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;

public class FinishStockMgrCostRpt
extends AbstractReportFormPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final String CAL_FPERIOD = "fperiod";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costCenter = (BasedataEdit)this.getControl("fcostcenter");
        costCenter.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                Object orgDy = FinishStockMgrCostRpt.this.getModel().getValue("org");
                if (orgDy == null) {
                    FinishStockMgrCostRpt.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FinishStockMgrCostRpt_0", (String)"macc-aca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter[] costCenterFilter = FinishStockMgrCostRpt.this.getCostCenterFilter();
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter filterParameter = listShowParameter.getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                qFilters.addAll(Arrays.asList(costCenterFilter));
            }
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                Object orgDy = FinishStockMgrCostRpt.this.getModel().getValue("org");
                if (orgDy == null) {
                    FinishStockMgrCostRpt.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FinishStockMgrCostRpt_0", (String)"macc-aca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter costAccountFilter = FinishStockMgrCostRpt.this.getCostAccountFilter();
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                ListFilterParameter filterParameter = listShowParameter.getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                qFilters.add(costAccountFilter);
            }
        });
        BasedataEdit calPeriod = (BasedataEdit)this.getControl(CAL_FPERIOD);
        calPeriod.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                Object costAccount = FinishStockMgrCostRpt.this.getModel().getValue("costaccount");
                if (costAccount == null) {
                    FinishStockMgrCostRpt.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"FinishStockMgrCostRpt_1", (String)"macc-aca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter periodFilter = FinishStockMgrCostRpt.this.getPeriodFilter();
                if (periodFilter != null) {
                    ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
                    List qFilters = listFilterParameter.getQFilters();
                    qFilters.add(periodFilter);
                }
            }
        });
        BasedataEdit manuorg = (BasedataEdit)this.getControl("manuorg");
        manuorg.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                DynamicObject org = (DynamicObject)FinishStockMgrCostRpt.this.getModel().getValue("org");
                if (org == null) {
                    FinishStockMgrCostRpt.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FinishStockMgrCostRpt_2", (String)"macc-aca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                List manuOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)((Long)org.getPkValue()), (String)FinishStockMgrCostRpt.this.getBillEntityId(), (String)FinishStockMgrCostRpt.this.getView().getFormShowParameter().getAppId());
                if (CollectionUtils.isNotEmpty((Collection)manuOrg)) {
                    QFilter filter = new QFilter("id", "in", (Object)manuOrg);
                    ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
                    List qFilters = listFilterParameter.getQFilters();
                    qFilters.add(filter);
                }
            }
        });
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
                List qFilters = listFilterParameter.getQFilters();
                List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)RequestContext.get().getCurrUserId()).getHasPermOrgs();
                List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"10");
                if (!CollectionUtils.isEmpty((Collection)permOrgIds) || !CollectionUtils.isEmpty((Collection)orgIds)) {
                    qFilters.add(new QFilter("id", "in", (Object)orgIds));
                }
            }
        });
        BasedataEdit material = (BasedataEdit)this.getControl("fmaterial");
        material.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                DynamicObject org = (DynamicObject)FinishStockMgrCostRpt.this.getModel().getValue("org");
                if (org == null) {
                    FinishStockMgrCostRpt.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FinishStockMgrCostRpt_2", (String)"macc-aca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
                List qFilters = listFilterParameter.getQFilters();
                qFilters.add(MatBaseDataFilterHelper.getBaseFilter((List)Lists.newArrayList((Object[])new Long[]{org.getLong("id")})));
            }
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyname) {
            case "org": {
                this.setCostAccount(newValue);
                this.getModel().setValue("manuorg", null);
                if (newValue == null) break;
                this.setManuOrg((Long)((DynamicObject)newValue).getPkValue());
                break;
            }
            case "costaccount": {
                this.setCurrencyAndPeriod(newValue);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ReportShowParameter reportShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        String customParams = (String)reportShowParameter.getCustomParams().get("custparam");
        if (customParams != null && !CadEmptyUtils.isEmpty((String)customParams)) {
            JSONObject calcParamJs = JSONObject.fromObject((Object)customParams);
            this.assignQueryValAndSearch(calcParamJs);
            return;
        }
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org != null) {
            return;
        }
        this.initQueryInfo();
    }

    private void initQueryInfo() {
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        if (isaccount) {
            this.getModel().setValue("org", (Object)currentOrgId);
            this.setManuOrg(currentOrgId);
            Long costAccountId = AcaCostAccountHelper.getCostAccountsByOrgId((Long)currentOrgId, (String)this.getView().getFormShowParameter().getAppId());
            if (costAccountId != 0L) {
                this.getModel().setValue("costaccount", (Object)costAccountId);
            } else {
                this.getModel().setValue("costaccount", null);
            }
            this.setCurrencyAndPeriod(this.getModel().getDataEntity().getDynamicObject("costaccount"));
            this.getView().updateView();
        }
    }

    private void setManuOrg(long currentOrgId) {
        boolean enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)currentOrgId);
        BasedataEdit manuOrgEdit = (BasedataEdit)this.getControl("manuorg");
        manuOrgEdit.setMustInput(enableMultiFactory);
        this.getView().setEnable(Boolean.valueOf(enableMultiFactory), new String[]{"manuorg"});
    }

    private void assignQueryValAndSearch(JSONObject customParams) {
        Object costAccount;
        this.getModel().beginInit();
        Object org = customParams.get("orgId");
        if (org != null) {
            this.getModel().setValue("org", org);
        }
        if ((costAccount = customParams.get("costAccountId")) != null) {
            this.getModel().setValue("costaccount", costAccount);
        }
        this.setCurrencyAndPeriod(this.getModel().getDataEntity().getDynamicObject("costaccount"));
        this.getView().updateView("reportfilterap");
        this.getModel().endInit();
        ReportFilter reportFilter = (ReportFilter)this.getControl("reportfilterap");
        reportFilter.search();
    }

    public void afterDoOperation(AfterDoOperationEventArgs evts) {
        String key;
        super.afterDoOperation(evts);
        switch (key = evts.getOperateKey()) {
            case "reset": {
                this.getModel().setValue(CAL_FPERIOD, null);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        boolean isPass;
        boolean enableMultiFactory;
        ArrayList pros = null;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null && (enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)((Long)org.getPkValue())))) {
            pros = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "currency", CAL_FPERIOD, "manuorg"});
        }
        if (pros == null) {
            pros = Lists.newArrayList((Object[])new String[]{"org", "costaccount", "currency", CAL_FPERIOD});
        }
        if (!(isPass = CalcRptHelper.verifyMustInput((ReportQueryParam)queryParam, pros))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"FinishStockMgrCostRpt_3", (String)"macc-aca-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        Object currency = this.getModel().getValue("currency");
        for (DynamicObject rowDatum : rowData) {
            BigDecimal qty = rowDatum.getBigDecimal("qty");
            BigDecimal amount = rowDatum.getBigDecimal("amount");
            BigDecimal price = rowDatum.getBigDecimal("price");
            if ((price == null || price.compareTo(BigDecimal.ZERO) <= 0) && qty != null && qty.compareTo(BigDecimal.ZERO) != 0 && amount != null) {
                rowDatum.set("price", (Object)amount.divide(qty, 23, 4));
            }
            rowDatum.set("currencyfield", currency);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        if ("exportexcel".equals(operateKey) && !PermItemCheckHelper.isPerm((String)"aca_finishstockcostrpt", (String)"47150e89000000ac", (Long)org.getLong("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5b8c\u5de5\u5165\u5e93\u6210\u672c\u67e5\u8be2\u201d\u7684\u201c\u5f15\u51fa\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FinishStockMgrCostRpt_4", (String)"macc-aca-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    private void setCostAccount(Object org) {
        if (org == null) {
            return;
        }
        DynamicObject orgDO = (DynamicObject)org;
        Long mainBookId = AcaCostAccountHelper.getCostAccountByAccoutOrg((Long)orgDO.getLong("id"), (String)"aca");
        if (mainBookId != null && mainBookId != 0L) {
            boolean isnit = StartCostHelper.isInit((Long)mainBookId, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
            if (isnit) {
                this.getModel().setValue("costaccount", (Object)mainBookId);
            }
        } else {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue(CAL_FPERIOD, null);
        }
    }

    private void setCurrencyAndPeriod(Object costAccount) {
        if (costAccount == null) {
            return;
        }
        DynamicObject costAccountDO = (DynamicObject)costAccount;
        Long currency = CalcRptHelper.getCurrency((DynamicObject)costAccountDO);
        this.getModel().setValue("currency", (Object)currency);
        this.setPeriod();
    }

    private void setPeriod() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        DynamicObject costaccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        if (org == null || costaccount == null) {
            return;
        }
        long orgId = org.getLong("id");
        long costaccountId = costaccount.getLong("id");
        Long currPeriod = CalcRptHelper.getCurrPeriod((Long)orgId, (Long)costaccountId);
        if (currPeriod != null && currPeriod != 0L) {
            this.getModel().setValue(CAL_FPERIOD, (Object)new Object[]{currPeriod});
        }
    }

    private QFilter[] getCostCenterFilter() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        QFilter orgFilter = new QFilter("accountorg", "=", org.getPkValue());
        QFilter orgdutyFilter = new QFilter("orgduty", "=", (Object)4L);
        orgdutyFilter.and("enable", "=", (Object)"1");
        return new QFilter[]{orgFilter, orgdutyFilter};
    }

    private QFilter getPeriodFilter() {
        DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null || costAccount == null) {
            return null;
        }
        long orgId = org.getLong("id");
        long costAccountId = costAccount.getLong("id");
        QFilter periodFilter = StartCostHelper.getPeriodTypeFilter((String)"aca", (Long)orgId, (Long)costAccountId);
        return periodFilter;
    }

    private QFilter getCostAccountFilter() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        List orgUseCostAccountIds = CostAccountHelper.getOrgStdCostAccount((Long)((Long)org.getPkValue()), (String)"aca");
        QFilter costAccountFilter = new QFilter("id", "in", (Object)orgUseCostAccountIds.toArray());
        return costAccountFilter;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"FinishStockMgrCostRpt_5", (String)"macc-aca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u5b8c\u5de5\u5165\u5e93\u6210\u672c\u67e5\u8be2", (String)"FinishStockMgrCostRpt_6", (String)"macc-aca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"aca_finishstockcostrpt", (IDataModel)this.getModel());
    }
}

