/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.feealloc;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.DataSetUtils;

public class FinishStockMgrCostRptQuery
extends AbstractReportListDataPlugin {
    private static final String PERIOD = "fperiod";
    private static final String MATERIAL = "fmaterial";
    private static final String COSTCENTER = "fcostcenter";
    private static final String QUERY_FACT_BILL_SEQ = "factQuerySeq";
    private static final Log logger = LogFactory.getLog(FinishStockMgrCostRptQuery.class);

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        QFilter filter = this.getQfilter(reportQueryParam);
        ORM orm = ORM.create();
        String algoKey = ((Object)((Object)this)).getClass().getName() + ".query";
        logger.info("\u8fc7\u6ee4\u6761\u4ef6\u4e3a", (Object)filter);
        filter.and("inventoryentryentity.id", ">", (Object)0L);
        filter.and("inventoryentryentity.carrytype", "!=", (Object)"B");
        String queryFileds = "period AS periodid,period.name AS period,costcenter AS costcenter,inventoryentryentity.invcostobject.material.id AS material,inventoryentryentity.invcostobject.srcbillnumber AS sourcebillnum,inventoryentryentity.invcostobject.srcbillrow AS sourcebillrow,inventoryentryentity.invcostobject.bomversion AS matversion,inventoryentryentity.sourcebill AS sourcebill,inventoryentryentity.sourcebillentry AS sourcebillentry,inventoryentryentity.inventoryqty AS qty,inventoryentryentity.inventoryamount AS amount";
        DataSet calResultDataSet = orm.queryDataSet(algoKey, "aca_calcresult", queryFileds, new QFilter[]{filter});
        Set<Long> srcBillEntryIds = this.getBizEntryIds(calResultDataSet.copy());
        DataSet costRecordDs = this.getCostRecordDs(reportQueryParam, srcBillEntryIds);
        calResultDataSet = calResultDataSet.groupBy(new String[]{"periodid", "period", "costcenter", "material", "matversion", "sourcebillnum", "sourcebillrow", "sourcebill", "sourcebillentry"}).max("qty").sum("amount").finish();
        String sumName = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"FinishStockMgrCostRptQuery_0", (String)"macc-aca-report", (Object[])new Object[0]);
        DataSet sumPeriodDs = calResultDataSet.groupBy().sum("amount").finish().select("'" + sumName + "' period,' ' as billrow,' ' as sourcebillrow,amount");
        DataSet resultDs = calResultDataSet.leftJoin(costRecordDs).on("sourcebill", "id").on("sourcebillentry", "entryid").select(calResultDataSet.getRowMeta().getFieldNames(), costRecordDs.getRowMeta().getFieldNames()).finish();
        ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(resultDs.getRowMeta().getFieldNames()));
        fieldNames.removeAll(Arrays.asList("billrow", "sourcebillrow"));
        fieldNames.add("cast(billrow as String) as billrow");
        fieldNames.add("cast(sourcebillrow as String) as sourcebillrow");
        resultDs = resultDs.select(fieldNames.toArray(new String[0])).orderBy(new String[]{"period ASC", "costcenter ASC", "billnum ASC"});
        return DataSetUtils.unionIfRowDiff((DataSet)resultDs, (DataSet)sumPeriodDs);
    }

    private DataSet getCostRecordDs(ReportQueryParam reportQueryParam, Set<Long> srcBillEntryIds) {
        String param = CadBgParamUtils.getCadBgParamForString((String)QUERY_FACT_BILL_SEQ, (String)"0");
        QFilter filter = new QFilter("entry.bizbillentryid", "in", srcBillEntryIds);
        filter.and("costaccount", "=", this.getFilterItemValue(reportQueryParam.getFilter(), "costaccount"));
        filter.and("period", "in", this.getFilterItemValue(reportQueryParam.getFilter(), PERIOD));
        filter.and("calorg", "=", this.getFilterItemValue(reportQueryParam.getFilter(), "org"));
        filter.and("calbilltype", "=", (Object)"IN");
        String selectField = "bizbillid id,storageorgunit stockorg,biztype,invscheme,entry.bizbillentryid as entryid,entry.project project,entry.owner owner,entry.ownertype ownertype,entry.invstatus invstatus,entry.invtype invtype,entry.location location,entry.warehouse warehouse,entry.baseunit unit,entry.lot lot,entry.assist matauxpty,bookdate,billnumber billnum" + ("0".equals(param) ? ",entry.seq billrow" : "");
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"getCalCostRecord", (String)"cal_costrecord_subentity", (String)selectField, (QFilter[])filter.toArray(), null);
        if ("1".equals(param)) {
            DataSet seqDs = this.queryBillRowData(srcBillEntryIds);
            resultDs = resultDs.leftJoin(seqDs).on("id", "id").on("entryid", "entryid").select(resultDs.getRowMeta().getFieldNames(), new String[]{"billrow"}).finish();
        }
        return resultDs;
    }

    private DataSet queryBillRowData(Set<Long> srcBillEntryIds) {
        String selectSql = "id,billentry.id entryid,billentry.seq billrow";
        QFilter filter = new QFilter("billentry.id", "in", srcBillEntryIds);
        DataSet inTypeData = QueryServiceHelper.queryDataSet((String)"queryOtherData", (String)"im_mdc_mftmanuinbill", (String)selectSql, (QFilter[])filter.toArray(), null);
        DataSet productBillData = QueryServiceHelper.queryDataSet((String)"queryOtherData", (String)"im_productinbill", (String)selectSql, (QFilter[])filter.toArray(), null);
        DataSet omBillData = QueryServiceHelper.queryDataSet((String)"queryOtherData", (String)"im_mdc_omcmplinbill", (String)selectSql, (QFilter[])filter.toArray(), null);
        return inTypeData.union(new DataSet[]{omBillData, productBillData});
    }

    private Set<Long> getBizEntryIds(DataSet calResultDataSet) {
        Iterator iterator = calResultDataSet.iterator();
        HashSet srcBillEntryIds = Sets.newHashSetWithExpectedSize((int)32);
        while (iterator.hasNext()) {
            Row calcResultData = (Row)iterator.next();
            long srcBillEntryId = calcResultData.getLong("sourcebillentry");
            srcBillEntryIds.add(srcBillEntryId);
        }
        return srcBillEntryIds;
    }

    private QFilter getQfilter(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        Object value = null;
        value = this.getFilterItemValue(filterInfo, "org");
        QFilter filter = new QFilter("org", "=", value);
        value = this.getFilterItemValue(filterInfo, "costaccount");
        filter.and(new QFilter("costaccount", "=", value));
        value = this.getFilterItemValue(filterInfo, "manuorg");
        if (value != null) {
            filter.and(new QFilter("costobject.manuorg", "in", value));
        }
        value = this.getFilterItemValue(filterInfo, "currency");
        filter.and(new QFilter("currency", "in", value));
        value = this.getFilterItemValue(filterInfo, PERIOD);
        filter.and(new QFilter("period", "in", value));
        value = this.getFilterItemValue(filterInfo, COSTCENTER);
        if (value != null) {
            filter.and(new QFilter("costcenter", "in", value));
        }
        if ((value = this.getFilterItemValue(filterInfo, MATERIAL)) != null) {
            filter.and(new QFilter("inventoryentryentity.invcostobject.material", "in", value));
        }
        return filter;
    }

    private Object getFilterItemValue(FilterInfo filterInfo, String propName) {
        FilterItemInfo filterItem = filterInfo.getFilterItem(propName);
        if (filterItem != null && filterItem.getValue() != null) {
            Object value = filterItem.getValue();
            if (value instanceof DynamicObject) {
                return ((DynamicObject)value).getPkValue();
            }
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection values = (DynamicObjectCollection)value;
                return values.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            }
            return value;
        }
        return null;
    }
}

