/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.helper;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algox.DataSetX;
import kd.bos.algox.Grouper;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.plugin.support.util.ReflectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterSchemeService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.IReportView;
import kd.bos.report.filter.ReportFilter;
import kd.bos.util.StringUtils;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.tpl.IFilter;

public class ReportRptHelper {
    private static final Log logger = LogFactory.getLog(ReportRptHelper.class);

    public static DataSetX groupDeal(DataSetX srcDataSetX, String[] groupArr, int oper, String[] operArr) {
        if (groupArr.length == 0) {
            throw new KDBizException("group field is null");
        }
        DataSetX dataDsx = null;
        Grouper detailGrouper = srcDataSetX.groupBy(groupArr);
        for (String showQtyCol : operArr) {
            if (oper == 1) {
                if (dataDsx == null) {
                    dataDsx = detailGrouper.sum(showQtyCol);
                    continue;
                }
                dataDsx = dataDsx.sum(showQtyCol);
                continue;
            }
            dataDsx = dataDsx == null ? detailGrouper.max(showQtyCol) : dataDsx.max(showQtyCol);
        }
        if (dataDsx == null) {
            return srcDataSetX;
        }
        return dataDsx;
    }

    public static DataSetX groupSumAndMaxDeal(DataSetX srcDataSetX, String[] groupArr, String[] sumArr, String[] maxArr) {
        if (groupArr.length == 0) {
            throw new KDBizException("group field is null");
        }
        DataSetX dataDsx = null;
        Grouper detailGrouper = srcDataSetX.groupBy(groupArr);
        if (sumArr != null) {
            for (String showQtyCol : sumArr) {
                dataDsx = dataDsx == null ? detailGrouper.sum(showQtyCol) : dataDsx.sum(showQtyCol);
            }
        }
        if (maxArr != null) {
            for (String showQtyCol : maxArr) {
                dataDsx = dataDsx == null ? detailGrouper.max(showQtyCol) : dataDsx.max(showQtyCol);
            }
        }
        if (dataDsx == null) {
            return srcDataSetX;
        }
        return dataDsx;
    }

    public static List<String> filterBigtableCols(ReportConf conf, IFilter<BigTableColConf> filter) {
        List bigTableColConf = conf.getBigTableColConf();
        ArrayList<String> fsCol = new ArrayList<String>(10);
        for (BigTableColConf colConf : bigTableColConf) {
            if (filter == null) {
                fsCol.add(colConf.getCol());
                continue;
            }
            if (!filter.filter((Object)colConf)) continue;
            fsCol.add(colConf.getCol());
        }
        return fsCol;
    }

    public static Set<String> getSelectKeyHashSet(String selectKey) {
        HashSet<String> selectSet = null;
        if (!StringUtils.isEmpty((String)selectKey)) {
            selectSet = new HashSet<String>(Arrays.asList(selectKey.split(",")));
            selectSet.remove("");
        } else {
            selectSet = new HashSet<String>(10);
        }
        return selectSet;
    }

    public static boolean containKeys(Set<String> sourceKeys, Collection<String> cKeys) {
        for (String key : cKeys) {
            if (!sourceKeys.contains(key)) continue;
            return true;
        }
        return false;
    }

    public static List<String> fieldsAddPreToList(String[] fields, String keyPre) {
        ArrayList<String> list = new ArrayList<String>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            list.add(keyPre + fields[i]);
        }
        return list;
    }

    public static DataSetX addBigDecimalFields(DataSetX srcDataSetX, String[] fields) {
        if (fields == null || fields.length == 0) {
            return srcDataSetX;
        }
        int length = fields.length;
        Field[] dsfields = new Field[length];
        Object[] defaultValues = new Object[length];
        for (int i = 0; i < fields.length; ++i) {
            dsfields[i] = new Field(fields[i], (DataType)DataType.BigDecimalType);
            defaultValues[i] = BigDecimal.ZERO;
        }
        return srcDataSetX.addFields(dsfields, defaultValues);
    }

    public static List<String> getDownKeyCols(String inkey, String numKeyPre, List<String> allkeyCols) {
        boolean isNeedJd = false;
        ArrayList<String> inKeys = new ArrayList<String>(10);
        String numKey = inkey + numKeyPre;
        for (String col : allkeyCols) {
            if (inkey.equals(col) || numKey.equals(col)) {
                isNeedJd = true;
                continue;
            }
            if (!isNeedJd) continue;
            inKeys.add(col);
        }
        return inKeys;
    }

    public static List<String> getUpKeyCols(String inkey, String numKeyPre, List<String> allkeyCols) {
        boolean isNeedJd = false;
        ArrayList<String> inKeys = new ArrayList<String>(10);
        String numKey = inkey + numKeyPre;
        for (String col : allkeyCols) {
            if (inkey.equals(col) || numKey.equals(col)) {
                isNeedJd = true;
                continue;
            }
            if (isNeedJd) continue;
            inKeys.add(col);
        }
        return inKeys;
    }

    public static FilterScheme getDefaultfilterScheme(IReportView view) {
        try {
            ReportFilter custCont = ((ReportView)view).getCustomFilterContainer();
            Method privateMethod = ReflectionUtils.findMethod(ReportFilter.class, (String)"getSchemeList");
            if (privateMethod == null) {
                return null;
            }
            AccessibleObject.setAccessible(new AccessibleObject[]{privateMethod}, true);
            List schemeList = (List)privateMethod.invoke((Object)custCont, new Object[0]);
            return FilterSchemeService.getDefaultSchemeFromAll((List)schemeList);
        }
        catch (Exception ex) {
            logger.error("getDefaultfilterScheme error -> {}", (Object)ex.getMessage());
            return null;
        }
    }
}

