/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.inout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.costcalc.ActCostCalcDataInputFactory;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class InputOutputRptQuery
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(InputOutputRptQuery.class);

    public DataSet query(ReportQueryParam reportQueryParam, Object ob) throws Throwable {
        FilterInfo queryParam = reportQueryParam.getFilter();
        Long org = queryParam.getLong("org");
        Long manuorg = queryParam.getLong("manuorgf");
        Long costaccount = queryParam.getLong("costaccount");
        DynamicObjectCollection mulperiod = queryParam.getDynamicObjectCollection("mulperiod");
        DynamicObjectCollection costcenterf = queryParam.getDynamicObjectCollection("costcenterf");
        HashSet<Long> costCenterSet = costcenterf == null ? new HashSet<Long>(16) : costcenterf.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection costobjectf = queryParam.getDynamicObjectCollection("costobjectf");
        HashSet<Long> costObjectSet = costobjectf == null ? new HashSet(16) : costobjectf.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
        ActCostCalcDataInputFactory datainputFactory = new ActCostCalcDataInputFactory();
        DataSet mainJoinSideCostobjectDs = datainputFactory.getMainJoinSideCostobjDsFromMainId(org, costObjectSet, new String[]{"C", "A", "B"});
        costObjectSet = datainputFactory.getLongIdSetFromDs(mainJoinSideCostobjectDs, "costObjectId", true);
        ArrayList<DataSet> resultList = new ArrayList<DataSet>();
        for (DynamicObject period : mulperiod) {
            DataSet tmp = this.loadDataByCondition(org, manuorg, costaccount, costCenterSet, period, costObjectSet);
            if ((tmp = tmp.select(org + "L as accountorg," + period.getLong("id") + "L as period,manuorg,costcenter,costobject,cobillno,material,auxpty,startnum,startchangenum,currentinput,currentfinish,endproductchange")) == null) continue;
            resultList.add(tmp);
        }
        DataSet result = null;
        if (resultList.isEmpty()) {
            return null;
        }
        if (resultList.size() == 1) {
            result = (DataSet)resultList.get(0);
        } else {
            result = (DataSet)resultList.remove(0);
            result = result.union(resultList.toArray(new DataSet[0]));
        }
        result = result.select("accountorg,period,manuorg,costcenter,costobject,cobillno,material,auxpty,case when startnum=null then 0 else startnum end startnum,case when startchangenum=null then 0 else startchangenum end startchangenum,case when currentinput=null then 0 else currentinput end currentinput,case when currentfinish=null then 0 else currentfinish end currentfinish,case when endproductchange=null then 0 else endproductchange end endproductchange");
        result = result.select("accountorg,period,manuorg,costcenter,costobject,cobillno,material,auxpty,startnum,startchangenum,currentinput,currentfinish,endproductchange,startnum+startchangenum+currentinput-currentfinish as pdendqty");
        result = result.select("accountorg,period,manuorg,costcenter,costobject,cobillno,material,auxpty,startnum,startchangenum,currentinput,currentfinish,endproductchange,pdendqty,pdendqty+endproductchange as checknumTemp");
        QFilter wipCheckFilter = new QFilter("org", "=", (Object)org);
        wipCheckFilter.and("costaccount", "=", (Object)costaccount);
        if (!costCenterSet.isEmpty()) {
            wipCheckFilter.and("costcenter", "in", costCenterSet);
        }
        if (!costObjectSet.isEmpty()) {
            wipCheckFilter.and("costobject", "in", costObjectSet);
        }
        DataSet wipCheckData = QueryServiceHelper.queryDataSet((String)"ww", (String)"aca_wipcostchecksave", (String)"org,manuorg,costobject.costcenter costcenter,costaccount,period,costobject,checknum,modifier,modifytime,finadjustqty", (QFilter[])wipCheckFilter.toArray(), null);
        result = result.leftJoin(wipCheckData).on("accountorg", "org").on("costcenter", "costcenter").on("manuorg", "manuorg").on("period", "period").on("costobject", "costobject").select(result.getRowMeta().getFieldNames(), new String[]{"checknum", "modifier", "modifytime", "finadjustqty"}).finish();
        result = result.select("accountorg,period,manuorg,costcenter,costobject,cobillno,material,auxpty,startnum,startchangenum,currentinput,currentfinish,endproductchange,pdendqty,checknumTemp,case when checknum=null then checknumTemp else checknum end checknum,modifier,modifytime,finadjustqty");
        result = result.select("accountorg,period,manuorg,costcenter,costobject,cobillno,material productnum,auxpty,startnum,startchangenum,currentinput,currentfinish,endproductchange,pdendqty,checknum,modifier,modifytime,finadjustqty,checknum-checknumTemp as profitnum,currentfinish+finadjustqty as fincheckqty").filter("!(startnum=0 and startchangenum=0 and currentinput=0 and currentfinish=0 and endproductchange=0 and pdendqty=0 and checknum=0 and (finadjustqty is null or finadjustqty=0))");
        return result.orderBy(new String[]{"period desc", "accountorg", "manuorg", "costcenter", "cobillno desc"});
    }

    public DataSet loadDataByCondition(Long orgId, Long manuorgfId, Long costaccountId, Set<Long> costcenterfId, DynamicObject period, Set<Long> costObjectSet) {
        if (CadEmptyUtils.isEmpty((Long)orgId) || CadEmptyUtils.isEmpty((Long)costaccountId)) {
            logger.info("WipCostCheckService \u4f20\u5165\u53c2\u6570\u6838\u7b97\u7ec4\u7ec7\u6216\u8005\u6210\u672c\u8d26\u7c3f\u4e3a\u7a7a");
            return null;
        }
        if (period == null) {
            logger.info("WipCostCheckService \u672a\u627e\u5230\u5f53\u524d\u671f\u95f4");
            return null;
        }
        Date begindate = period.getDate("begindate");
        Date enddate = period.getDate("enddate");
        if (begindate == null || enddate == null) {
            logger.info("WipCostCheckService \u5f53\u524d\u671f\u95f4\u5f00\u59cb\u548c\u7ed3\u675f\u65e5\u671f\u672a\u7ef4\u62a4");
            return null;
        }
        Boolean orgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
        if (!orgEnableMultiFactory.booleanValue() && !CadEmptyUtils.isEmpty((Long)manuorgfId)) {
            manuorgfId = 0L;
            logger.error("\u6570\u636e\u9519\u8bef,{}\u672a\u5f00\u542f\u591a\u5de5\u5382\u8bf7\u52ff\u586b\u5199\u751f\u4ea7\u7ec4\u7ec7", (Object)orgId);
        }
        DataSet calcResult = this.getCalcResult(orgId, costaccountId, costcenterfId, period, orgEnableMultiFactory, costObjectSet);
        DataSet wipAdjustBill = this.getWipAdjustBill(orgId, manuorgfId, costaccountId, costcenterfId, period, orgEnableMultiFactory, costObjectSet);
        DataSet startDataSet = wipAdjustBill.filter("adjustType = 'START'").select("manuorg ,costcenter,costobject,cobillno,adjustqty as startchangenum,material,auxpty");
        DataSet endDataSet = wipAdjustBill.filter("adjustType = 'END'").select("manuorg ,costcenter,costobject,cobillno,adjustqty as endproductchange,material,auxpty");
        DataSet plannedOutPutBill = this.getPlannedOutPutBill(orgId, manuorgfId, costcenterfId, period, orgEnableMultiFactory, costObjectSet);
        DataSet factnedoutputbill = this.getFactnedOutputBill(orgId, manuorgfId, costcenterfId, period, orgEnableMultiFactory, costObjectSet);
        DataSet fullDataSet = this.fullJoinDataSet(calcResult, startDataSet);
        fullDataSet = this.fullJoinDataSet(fullDataSet, endDataSet);
        fullDataSet = this.fullJoinDataSet(fullDataSet, plannedOutPutBill);
        return this.fullJoinDataSet(fullDataSet, factnedoutputbill);
    }

    private DataSet getCalcResult(Long orgId, Long costaccountId, Set<Long> costcenterfId, DynamicObject period, Boolean orgEnableMultiFactory, Set<Long> costObjectSet) {
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQf = new QFilter("costaccount", "=", (Object)costaccountId);
        long prePeriodId = 0L;
        DynamicObject prePeriodDyn = PeriodHelper.getPreviousPeriod((Object)period.getLong("id"));
        if (prePeriodDyn != null) {
            prePeriodId = prePeriodDyn.getLong("id");
        }
        QFilter periodQf = new QFilter("period", "=", (Object)prePeriodId);
        QFilter typeQf = new QFilter("entryentity.type", "=", (Object)"finalResult");
        if (!CadEmptyUtils.isEmpty(costcenterfId)) {
            orgQf.and(new QFilter("costcenter", "in", costcenterfId));
        }
        if (!CadEmptyUtils.isEmpty(costObjectSet)) {
            orgQf.and(new QFilter("costobject", "in", costObjectSet));
        }
        String selectFile = orgEnableMultiFactory != false ? "costobject.manuorg as manuorg ,entryentity.relacostobject.costcenter costcenter,entryentity.relacostobject costobject,entryentity.relacostobject.billno cobillno,entryentity.pdendqty+entryentity.endadjqty as startnum, entryentity.relacostobject.material as material,entryentity.relacostobject.auxpty as auxpty" : "0L as manuorg ,entryentity.relacostobject.costcenter costcenter,entryentity.relacostobject costobject,entryentity.relacostobject.billno cobillno,entryentity.pdendqty+entryentity.endadjqty as startnum, entryentity.relacostobject.material as material,entryentity.relacostobject.auxpty as auxpty";
        DataSet cad_plannedoutputbill = QueryServiceHelper.queryDataSet((String)"getCalcResult", (String)"aca_calcresult", (String)selectFile, (QFilter[])new QFilter[]{orgQf, costaccountQf, periodQf, typeQf}, null);
        DataSet qtyDataSet = cad_plannedoutputbill.groupBy(new String[]{"manuorg", "costcenter", "costobject", "cobillno", "material", "auxpty"}).sum("startnum").finish();
        return qtyDataSet;
    }

    private DataSet getFactnedOutputBill(Long orgId, Long manuorgfId, Set<Long> costcenterfId, DynamicObject period, Boolean orgEnableMultiFactory, Set<Long> costObjectSet) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("org", "=", (Object)orgId));
        qFilters.add(new QFilter("bookdate", ">=", (Object)period.getDate("begindate")));
        qFilters.add(new QFilter("bookdate", "<=", (Object)period.getDate("enddate")));
        qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        if (!CadEmptyUtils.isEmpty((Long)manuorgfId)) {
            qFilters.add(new QFilter("manuorg", "=", (Object)manuorgfId));
        }
        if (!CadEmptyUtils.isEmpty(costcenterfId)) {
            qFilters.add(new QFilter("entryentity.costobject.costcenter", "in", costcenterfId));
        }
        if (!CadEmptyUtils.isEmpty(costObjectSet)) {
            qFilters.add(new QFilter("entryentity.costobject", "in", costObjectSet));
        }
        qFilters.add(new QFilter("appnum", "=", (Object)"aca"));
        String selectFile = orgEnableMultiFactory != false ? "manuorg,entryentity.costobject.costcenter costcenter,entryentity.costobject as costobject,entryentity.costobject.billno cobillno,entryentity.qty as currentfinish,entryentity.costobject.material as material,entryentity.costobject.auxpty as auxpty" : "0L manuorg,entryentity.costobject.costcenter costcenter,entryentity.costobject as costobject,entryentity.costobject.billno cobillno,entryentity.qty as currentfinish,entryentity.costobject.material as material,entryentity.costobject.auxpty as auxpty";
        DataSet cad_plannedoutputbill = QueryServiceHelper.queryDataSet((String)"", (String)"cad_factnedoutputbill", (String)selectFile, (QFilter[])qFilters.toArray(new QFilter[0]), null);
        DataSet qtyDataSet = cad_plannedoutputbill.groupBy(new String[]{"manuorg", "costcenter", "costobject", "cobillno", "material", "auxpty"}).sum("currentfinish").finish();
        return qtyDataSet;
    }

    private DataSet getWipAdjustBill(Long orgId, Long manuorgfId, Long costaccountId, Set<Long> costcenterfId, DynamicObject period, Boolean orgEnableMultiFactory, Set<Long> costObjectSet) {
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQf = new QFilter("costaccount", "=", (Object)costaccountId);
        QFilter periodQf = new QFilter("period", "=", (Object)period.getLong("id"));
        if (!CadEmptyUtils.isEmpty(costcenterfId)) {
            orgQf.and(new QFilter("costcenter", "in", costcenterfId));
        }
        if (!CadEmptyUtils.isEmpty((Long)manuorgfId)) {
            orgQf.and(new QFilter("manuorg", "=", (Object)manuorgfId));
        }
        if (!CadEmptyUtils.isEmpty(costObjectSet)) {
            orgQf.and(new QFilter("costobject", "in", costObjectSet));
        }
        QFilter statusQf = new QFilter("billstatus", "=", (Object)"C");
        String selectFile = orgEnableMultiFactory != false ? "manuorg ,costcenter,costobject,costobject.billno cobillno,adjustqty,adjustType,costobject.material as material,costobject.auxpty as auxpty" : "0L manuorg ,costcenter,costobject,costobject.billno cobillno,adjustqty,adjustType,costobject.material as material,costobject.auxpty as auxpty";
        DataSet cad_plannedoutputbill = QueryServiceHelper.queryDataSet((String)"getWipAdjustBill", (String)"aca_wipadjustbill", (String)selectFile, (QFilter[])new QFilter[]{orgQf, costaccountQf, periodQf, statusQf}, null);
        DataSet qtyDataSet = cad_plannedoutputbill.groupBy(new String[]{"manuorg", "costcenter", "costobject", "cobillno", "adjustType", "material", "auxpty"}).sum("adjustqty").finish();
        return qtyDataSet;
    }

    private DataSet getPlannedOutPutBill(Long orgId, Long manuorgfId, Set<Long> costcenterfId, DynamicObject period, Boolean orgEnableMultiFactory, Set<Long> costObjectSet) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("accountorg", "=", (Object)orgId));
        qFilters.add(new QFilter("bizdate", ">=", (Object)period.getDate("begindate")));
        qFilters.add(new QFilter("bizdate", "<=", (Object)period.getDate("enddate")));
        qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        if (!CadEmptyUtils.isEmpty((Long)manuorgfId)) {
            qFilters.add(new QFilter("manuorg", "=", (Object)manuorgfId));
        }
        if (!CadEmptyUtils.isEmpty(costcenterfId)) {
            qFilters.add(new QFilter("costobject.costcenter", "in", costcenterfId));
        }
        if (!CadEmptyUtils.isEmpty(costObjectSet)) {
            qFilters.add(new QFilter("costobject", "in", costObjectSet));
        }
        qFilters.add(new QFilter("appnum", "=", (Object)"aca"));
        String selectFile = orgEnableMultiFactory != false ? "manuorg,costobject.costcenter costcenter,costobject,costobject.billno cobillno,qty as currentinput,costobject.material as material,costobject.auxpty as auxpty" : "0L manuorg,costobject.costcenter costcenter,costobject,costobject.billno cobillno,qty as currentinput,costobject.material as material,costobject.auxpty as auxpty";
        DataSet cad_plannedoutputbill = QueryServiceHelper.queryDataSet((String)"getPlannedOutPutBill", (String)"cad_plannedoutputbill", (String)selectFile, (QFilter[])qFilters.toArray(new QFilter[0]), null);
        DataSet qtyDataSet = cad_plannedoutputbill.groupBy(new String[]{"manuorg", "costcenter", "costobject", "cobillno", "material", "auxpty"}).sum("currentinput").finish();
        logger.info("cad_plannedoutputbill\u53d6\u503c\u6761\u4ef6" + qFilters);
        return qtyDataSet;
    }

    private DataSet fullJoinDataSet(DataSet fullDataSet, DataSet startDataSet) {
        if (fullDataSet == null) {
            return startDataSet;
        }
        String[] fieldNames = startDataSet.getRowMeta().getFieldNames();
        ArrayList<String> fileNameList = new ArrayList<String>(10);
        StringBuilder sqlBuilder = new StringBuilder();
        for (String fieldName : fieldNames) {
            if ("manuorg".equals(fieldName)) {
                fileNameList.add("manuorg as manuorgr");
                continue;
            }
            if ("costcenter".equals(fieldName)) {
                fileNameList.add("costcenter as costcenterr");
                continue;
            }
            if ("costobject".equals(fieldName)) {
                fileNameList.add("costobject as costobjectr");
                continue;
            }
            if ("cobillno".equals(fieldName)) {
                fileNameList.add("cobillno as cobillnor");
                continue;
            }
            if ("material".equals(fieldName)) {
                fileNameList.add("material as materialr");
                continue;
            }
            if ("auxpty".equals(fieldName)) {
                fileNameList.add("auxpty as auxptyr");
                continue;
            }
            fileNameList.add(fieldName);
            sqlBuilder.append(fieldName).append(',');
        }
        String[] fullFieldNames = fullDataSet.getRowMeta().getFieldNames();
        Arrays.stream(fullFieldNames).forEach(o -> {
            if (!("manuorg".equals(o) || "costcenter".equals(o) || "costobject".equals(o) || "cobillno".equals(o) || "material".equals(o) || "auxpty".equals(o))) {
                sqlBuilder.append((String)o).append(',');
            }
        });
        String sql = "case when costobject is null then costobjectr else costobject end costobject , case when cobillno is null then cobillnor else cobillno end cobillno , case when manuorg is null then manuorgr else manuorg end manuorg, case when material is null then materialr else material end material, case when auxpty is null then auxptyr else auxpty end auxpty, case when costcenter is null then costcenterr else costcenter end costcenter";
        sqlBuilder.append(sql);
        return fullDataSet.fullJoin(startDataSet).on("manuorg", "manuorg").on("costcenter", "costcenter").on("costobject", "costobject").on("cobillno", "cobillno").on("material", "material").on("auxpty", "auxpty").select(fullFieldNames, fileNameList.toArray(new String[0])).finish().select(sqlBuilder.toString());
    }
}

