/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.realtime;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.macc.aca.report.realtime.RealTimeCalcResultParam;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;

public class DiyTotalRow
implements IDataTransform {
    private RealTimeCalcResultParam calcResultParam;

    public DiyTotalRow(RealTimeCalcResultParam calcResultParam) {
        this.calcResultParam = calcResultParam;
    }

    public DataSet doTransform(DataSet srcData) {
        srcData = srcData.removeFields(new String[]{"srcbillentryidtext"});
        DataSet finalSrcData = srcData.filter("datatype = 'finalResult'");
        DataSet detailSrcData = srcData.filter("datatype != 'finalResult'");
        HashSet costObjectIds = new HashSet(128);
        finalSrcData.copy().forEach(s -> costObjectIds.add(s.getLong("costobject")));
        if (CadEmptyUtils.isEmpty(costObjectIds)) {
            return srcData;
        }
        DataSet costObjectInfoDs = null;
        QFilter qFilter = new QFilter("id", "in", costObjectIds);
        costObjectInfoDs = QueryServiceHelper.queryDataSet((String)"getCostObjectInfo", (String)"cad_costobject", (String)"id,bookdate as costobjectbookdate,probill,isoutsource", (QFilter[])qFilter.toArray(), null);
        HashSet proBillIds = new HashSet(128);
        HashSet omProBillIds = new HashSet(128);
        costObjectInfoDs.copy().forEach(s -> {
            if (s.getBoolean("isoutsource").booleanValue()) {
                omProBillIds.add(s.getLong("probill"));
            } else {
                proBillIds.add(s.getLong("probill"));
            }
        });
        QFilter idQFilter = new QFilter("treeentryentity.id", "in", proBillIds);
        DataSet pomDs = QueryServiceHelper.queryDataSet((String)"getPomInfo", (String)"pom_mftorder", (String)"treeentryentity.id as probillid,treeentryentity.beginbookdate beginbookdate,treeentryentity.bizstatus bizstatus", (QFilter[])idQFilter.toArray(), null);
        if (!CadEmptyUtils.isEmpty(omProBillIds)) {
            QFilter omIdQFilter = new QFilter("treeentryentity.id", "in", omProBillIds);
            DataSet omPomDs = QueryServiceHelper.queryDataSet((String)"getOmPomInfo", (String)"om_mftorder", (String)"treeentryentity.id as probillid,treeentryentity.beginbookdate beginbookdate,treeentryentity.bizstatus bizstatus", (QFilter[])omIdQFilter.toArray(), null);
            pomDs = pomDs.union(omPomDs);
        }
        costObjectInfoDs = costObjectInfoDs.leftJoin(pomDs).on("probill", "probillid").select(costObjectInfoDs.getRowMeta().getFieldNames(), new String[]{"bizstatus", "case when beginbookdate is not null then beginbookdate else costobjectbookdate end bookdate"}).finish();
        if (!this.calcResultParam.isShowMatDetail()) {
            finalSrcData = finalSrcData.orderBy(new String[]{"period", "costcenter", "costobject"});
            finalSrcData = finalSrcData.leftJoin(costObjectInfoDs).on("costobject", "id").select(detailSrcData.getRowMeta().getFieldNames(), new String[]{"bizstatus"}).finish();
            if ("C".equals(this.calcResultParam.getBizStatus())) {
                finalSrcData = finalSrcData.filter("bizstatus = 'C'");
            } else if ("A".equals(this.calcResultParam.getBizStatus())) {
                finalSrcData = finalSrcData.filter("bizstatus != 'C'");
            }
            return finalSrcData;
        }
        detailSrcData = DataSetUtils.union((DataSet)detailSrcData, (DataSet)finalSrcData);
        if (costObjectInfoDs != null) {
            detailSrcData = detailSrcData.removeFields(new String[]{"bookdate"});
            detailSrcData = detailSrcData.leftJoin(costObjectInfoDs).on("costobject", "id").select(detailSrcData.getRowMeta().getFieldNames(), new String[]{"bookdate", "bizstatus"}).finish();
        }
        detailSrcData = detailSrcData.addField("srcbillentryid", "srcbillentryidtext");
        detailSrcData = detailSrcData.removeFields(new String[]{"srcbillnorow"});
        Set<Long> srcBillEntryIds = this.getBizEntryIds(detailSrcData.copy());
        if (this.calcResultParam.isShowMatDetail()) {
            QFilter filter = new QFilter("costaccount", "=", (Object)this.calcResultParam.getCostAccountId());
            filter.and("period", "in", this.calcResultParam.getPeriodIds());
            filter.and("costobject", "in", costObjectIds);
            filter.and("entryentity.type", "=", (Object)"detail");
            filter.and("entryentity.srcbillid", "=", (Object)0L);
            DataSet resultDs = QueryServiceHelper.queryDataSet((String)"getrealtimecalcresult", (String)"aca_realtimecalcresult", (String)"period,entryentity.relacostobject costobject,entryentity.submaterial submaterial,entryentity.submaterial.number matresourcenumber,entryentity.submaterial.name matresource,entryentity.relaproducttype producttype,entryentity.type datatype,costcenter,entryentity.element element,entryentity.subelement subelement,entryentity.pdstartqty pdstartqty,entryentity.pdstartamount pdstartamount", (QFilter[])filter.toArray(), null);
            resultDs = resultDs.leftJoin(costObjectInfoDs).on("costobject", "id").select(resultDs.getRowMeta().getFieldNames(), new String[]{"bookdate", "bizstatus"}).finish();
            detailSrcData = DataSetUtils.unionIfRowDiff((DataSet)detailSrcData, (DataSet)resultDs);
        }
        if ("C".equals(this.calcResultParam.getBizStatus())) {
            detailSrcData = detailSrcData.filter("bizstatus = 'C'");
        } else if ("A".equals(this.calcResultParam.getBizStatus())) {
            detailSrcData = detailSrcData.filter("bizstatus != 'C'");
        }
        DataSet costRecordDs = this.getCostRecordDs(srcBillEntryIds);
        detailSrcData = detailSrcData.leftJoin(costRecordDs).on("srcbillentryid", "entryid").select(detailSrcData.getRowMeta().getFieldNames(), new String[]{"srcbillnorow"}).finish();
        detailSrcData = detailSrcData.orderBy(new String[]{"period", "costcenter", "costobject", "datatype desc", "syncauditdate", "srcbillno", "srcbillnorow"});
        return detailSrcData;
    }

    private DataSet getCostRecordDs(Set<Long> srcBillEntryIds) {
        QFilter filter = new QFilter("entry.bizbillentryid", "in", srcBillEntryIds);
        filter.and("costaccount", "=", (Object)this.calcResultParam.getCostAccountId());
        filter.and("period", "in", this.calcResultParam.getPeriodIds());
        filter.and("calorg", "=", (Object)this.calcResultParam.getOrgId());
        String selectField = "entry.bizbillentryid as entryid,entry.seq srcbillnorow";
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"getCalCostRecord", (String)"cal_costrecord_subentity", (String)selectField, (QFilter[])filter.toArray(), null);
        return resultDs;
    }

    private Set<Long> getBizEntryIds(DataSet calResultDataSet) {
        Iterator iterator = calResultDataSet.iterator();
        HashSet srcBillEntryIds = Sets.newHashSetWithExpectedSize((int)32);
        while (iterator.hasNext()) {
            Row calcResultData = (Row)iterator.next();
            long srcBillEntryId = calcResultData.getLong("srcbillentryid");
            srcBillEntryIds.add(srcBillEntryId);
        }
        return srcBillEntryIds;
    }
}

