/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.realtime;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.FormatShowFilterEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.aca.common.helper.MatBaseDataFilterHelper;
import kd.macc.aca.report.realtime.RealTimeCalcResultParam;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CalcRptHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CurrencyHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ReportUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;

public class RealTimeCalcResultRptFormPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final String PERIOD = "fperiod";
    private static final String SHOW_MAT_DETAIL = "isshowmaterialdetail";
    protected static final String[] hideStr = new String[]{"datatype", "srcbillid", "resource", "matnumber", "matname", "productnumber", "productname", "submaterial", "dealtype", "srcbillid", "srcbillentryid", "srcbillentryidtext"};
    protected static final String[] detailStr = new String[]{"syncauditdate", "srcbillno", "submaterial", "submaterialnumber", "submaterialtype", "submatunit", "submatversion", "submatauxpty"};
    private static String[] CLEAR_P = new String[]{"period", "costcenter", "costobject", "producttype", "bookdate"};
    private static String[] CLEAR_MAT_P = new String[]{"syncauditdate", "srcbillno", "subelement", "matresource"};

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        TextEdit numberText = (TextEdit)this.getView().getControl("pombillno");
        numberText.addClickListener((ClickListener)this);
        TextEdit omNumberText = (TextEdit)this.getView().getControl("ombillno");
        omNumberText.addClickListener((ClickListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            qFilters.add(new QFilter("id", "in", (Object)orgIds));
        });
        BasedataEdit costObject = (BasedataEdit)this.getControl("fcostobject");
        costObject.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject orgObj = this.getModel().getDataEntity().getDynamicObject("org");
            if (orgObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"RealTimeCalcResultRptFormPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            List<QFilter> costObjectFilter = this.getCostObjectFilter();
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.addAll(costObjectFilter);
        });
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject orgObj = this.getModel().getDataEntity().getDynamicObject("org");
            if (orgObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"RealTimeCalcResultRptFormPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter costAccountFilter = this.getCostAccountFilter();
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = listShowParameter.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.add(costAccountFilter);
        });
        BasedataEdit calPeriod = (BasedataEdit)this.getControl(PERIOD);
        calPeriod.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject costAccountObj = this.getModel().getDataEntity().getDynamicObject("costaccount");
            if (costAccountObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"RealTimeCalcResultRptFormPlugin_6", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter periodFilter = this.getPeriodFilter();
            if (periodFilter != null) {
                ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
                List qFilters = listFilterParameter.getQFilters();
                qFilters.add(periodFilter);
            }
        });
        BasedataEdit costCenter = (BasedataEdit)this.getControl("fcostcenter");
        costCenter.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject orgObj = this.getModel().getDataEntity().getDynamicObject("org");
            if (orgObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"RealTimeCalcResultRptFormPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter[] costCenterFilter = this.getCostCenterFilter();
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = listShowParameter.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            qFilters.addAll(Arrays.asList(costCenterFilter));
        });
        BasedataEdit products = (BasedataEdit)this.getControl("fmaterial");
        products.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject orgObj = this.getModel().getDataEntity().getDynamicObject("org");
            if (orgObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"RealTimeCalcResultRptFormPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            Long orgId = orgObj.getLong("id");
            ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(MatBaseDataFilterHelper.getBaseFilter(Collections.singletonList(orgId)));
        });
        ReportList control = (ReportList)this.getView().getControl("reportlistap");
        control.addHyperClickListener(new HyperLinkClickListener(){

            public void hyperLinkClick(HyperLinkClickEvent evt) {
                RealTimeCalcResultRptFormPlugin.this.hyperLinkBillNoClick(evt);
            }
        });
    }

    private QFilter getPeriodFilter() {
        DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null || costAccount == null) {
            return null;
        }
        long orgId = org.getLong("id");
        long costAccountId = costAccount.getLong("id");
        return StartCostHelper.getPeriodTypeFilter((String)"aca", (Long)orgId, (Long)costAccountId);
    }

    protected void hyperLinkBillNoClick(HyperLinkClickEvent evt) {
        DynamicObject costObject;
        DynamicObject row = evt.getRowData();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filterInfo = queryParam.getFilter();
        filterInfo.addFilterItem("org", (Object)org.getLong("id"), "=");
        filterInfo.addFilterItem("costaccount", (Object)costAccount.getLong("id"), "=");
        filterInfo.addFilterItem("currency", (Object)currency.getLong("id"), "=");
        DynamicObject period = row.getDynamicObject("period");
        if (period != null) {
            filterInfo.addFilterItem(PERIOD, (Object)period.getLong("id"), "=");
        }
        if ((costObject = row.getDynamicObject("costobject")) != null) {
            filterInfo.addFilterItem("fmaterial", (Object)costObject.getLong("material.id"), "=");
        }
        filterInfo.addFilterItem("mftbillno", (Object)row.getString("srcbillno"), "=");
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("aca_realtimefinishcostrpt");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setQueryParam(queryParam);
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void packageData(PackageDataEvent evt) {
        String dealType;
        super.packageData(evt);
        if (evt.getRowData() != null && evt.getRowData().containsProperty("dealtype") && !"2".equals(dealType = evt.getRowData().getString("dealtype"))) {
            evt.getNoLinkKey().add(((ReportColumn)evt.getSource()).getFieldKey());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"RealTimeCalcResultRptFormPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        List manuOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)((Long)org.getPkValue()), (String)"aca_calcresultnew", (String)this.getView().getFormShowParameter().getAppId());
        if (CollectionUtils.isNotEmpty((Collection)manuOrg)) {
            QFilter filter = new QFilter("id", "in", (Object)manuOrg);
            listShowParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setOrg();
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costAccount == null) {
            this.setCostAccount();
            this.setPeriodAndCurrency();
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        if ("pombillno".equals(fieldKey)) {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"RealTimeCalcResultRptFormPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                return;
            }
            QFilter orgqf = new QFilter("org", "=", (Object)org.getLong("id"));
            DataSet rows = QueryServiceHelper.queryDataSet((String)"getCostObjectInfo", (String)"cad_costobject", (String)"probill", (QFilter[])orgqf.toArray(), null);
            HashSet probills = new HashSet(16);
            rows.forEach(s -> probills.add(s.getLong("probill")));
            QFilter probillFilter = new QFilter("treeentryentity.id", "in", probills);
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pom_mftorder", (boolean)true, (int)0);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pombillno"));
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
            filters.add(probillFilter);
            this.getView().showForm((FormShowParameter)listShowParameter);
        } else if ("ombillno".equals(fieldKey)) {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"RealTimeCalcResultRptFormPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                return;
            }
            QFilter orgqf = new QFilter("org", "=", (Object)org.getLong("id"));
            DataSet rows = QueryServiceHelper.queryDataSet((String)"getCostObjectInfo", (String)"cad_costobject", (String)"probill", (QFilter[])orgqf.toArray(), null);
            HashSet omProbills = new HashSet(16);
            rows.forEach(s -> omProbills.add(s.getLong("probill")));
            QFilter probillFilter = new QFilter("treeentryentity.id", "in", omProbills);
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"om_mftorder", (boolean)true, (int)0);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "ombillno"));
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
            filters.add(probillFilter);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("pombillno".equals(e.getActionId())) {
            StringBuffer str = new StringBuffer();
            if (e.getReturnData() != null && e.getReturnData() instanceof ListSelectedRowCollection) {
                ListSelectedRowCollection col = (ListSelectedRowCollection)e.getReturnData();
                int rowIndex = 0;
                for (ListSelectedRow row : col) {
                    DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"pom_mftorder", (String)"billno");
                    str.append(obj.getString("billno"));
                    if (rowIndex + 1 < col.size()) {
                        str.append(";");
                    }
                    ++rowIndex;
                }
                this.getModel().setValue("pombillno", (Object)str);
            }
        } else if ("ombillno".equals(e.getActionId())) {
            StringBuffer str = new StringBuffer();
            if (e.getReturnData() != null && e.getReturnData() instanceof ListSelectedRowCollection) {
                ListSelectedRowCollection col = (ListSelectedRowCollection)e.getReturnData();
                int rowIndex = 0;
                for (ListSelectedRow row : col) {
                    DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"om_mftorder", (String)"billno");
                    str.append(obj.getString("billno"));
                    if (rowIndex + 1 < col.size()) {
                        str.append(";");
                    }
                    ++rowIndex;
                }
                this.getModel().setValue("ombillno", (Object)str);
            }
        }
    }

    private void setCostAccount() {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Long mainBookId = CostAccountHelper.getCostAccountByAccoutOrg((Long)((DynamicObject)org).getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
        if (mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
        }
        this.getView().updateView("costaccount");
    }

    private void setPeriodAndCurrency() {
        DynamicObject costAccountObj = (DynamicObject)this.getModel().getValue("costaccount");
        if (CadEmptyUtils.isEmpty((DynamicObject)costAccountObj)) {
            this.getModel().setValue("currency", null);
        } else {
            Long costAccountId = costAccountObj.getLong("id");
            DynamicObject curPeriod = PeriodHelper.getCurrentPeriod((Long)costAccountId);
            if (curPeriod == null) {
                this.getModel().setValue("currency", null);
            } else {
                this.getModel().setValue("currency", (Object)CurrencyHelper.getCurrency((DynamicObject)costAccountObj));
                this.getModel().setValue(PERIOD, (Object)new Object[]{curPeriod.getLong("id")});
            }
        }
    }

    private void setOrg() {
        if (this.getModel().getValue("org") == null) {
            Long orgId = RequestContext.get().getOrgId();
            boolean isAccounting = OrgUnitServiceHelper.checkOrgFunction((Long)orgId, (String)"10");
            if (!isAccounting) {
                return;
            }
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (orgIds.contains(orgId)) {
                this.getModel().setValue("org", (Object)orgId);
                this.getView().updateView("org");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "org": {
                this.setCostAccount(newValue);
                this.setOther();
                this.setCostAccount();
                break;
            }
            case "costaccount": {
                this.setPeriodAndCurrency();
            }
        }
    }

    private void setOther() {
        this.getModel().setValue("costaccount", null);
        this.getModel().setValue("currency", null);
        this.getModel().setValue("fcostcenter", null);
        this.getModel().setValue("fcostobject", null);
        this.getModel().setValue("pombillno", null);
        this.getModel().setValue("ombillno", null);
        this.getModel().setValue("fmaterial", null);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ReportShowParameter reportShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        String customParams = (String)reportShowParameter.getCustomParams().get("custparam");
        if (customParams != null && !CadEmptyUtils.isEmpty((String)customParams)) {
            JSONObject calcParamJs = JSONObject.fromObject((Object)customParams);
            this.assignQueryValAndSearch(calcParamJs);
            return;
        }
    }

    private void assignQueryValAndSearch(JSONObject customParams) {
        Object costAccount;
        this.getModel().beginInit();
        Object org = customParams.get("orgId");
        if (org != null) {
            this.getModel().setValue("org", org);
        }
        if ((costAccount = customParams.get("costAccountId")) != null) {
            this.getModel().setValue("costaccount", costAccount);
        }
        this.setCurrencyAndPeriod(this.getModel().getDataEntity().getDynamicObject("costaccount"));
        this.getView().updateView("reportfilterap");
        this.getModel().endInit();
        ReportFilter reportFilter = (ReportFilter)this.getControl("reportfilterap");
        reportFilter.search();
    }

    private QFilter[] getCostCenterFilter() {
        QFilter orgdutyFilter = new QFilter("orgduty", "=", (Object)4L);
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (org == null) {
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (!CollectionUtils.isEmpty((Collection)orgIds)) {
                orgdutyFilter.and(new QFilter("accountorg", "in", (Object)orgIds));
            }
        } else {
            orgdutyFilter.and(new QFilter("accountorg", "=", org.getPkValue()));
        }
        orgdutyFilter.and("enable", "=", (Object)"1");
        return new QFilter[]{orgdutyFilter};
    }

    private List<QFilter> getCostObjectFilter() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        DynamicObjectCollection rows = (DynamicObjectCollection)this.getModel().getValue("fcostcenter");
        HashSet<Long> costCenterIds = new HashSet<Long>(16);
        for (DynamicObject row : rows) {
            DynamicObject costCenter = row.getDynamicObject("fbasedataid");
            costCenterIds.add((Long)costCenter.getPkValue());
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        if (org != null) {
            QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
            filters.add(orgFilter);
        } else {
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (!CollectionUtils.isEmpty((Collection)orgIds)) {
                filters.add(new QFilter("org", "in", (Object)orgIds));
            }
        }
        if (!CadEmptyUtils.isEmpty(costCenterIds)) {
            QFilter costCenterFilter = new QFilter("costcenter", "in", costCenterIds);
            filters.add(costCenterFilter);
        }
        return filters;
    }

    private QFilter getCostAccountFilter() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        List orgUseCostAccountIds = CostAccountHelper.getOrgStdCostAccount((Long)((Long)org.getPkValue()), (String)this.getView().getFormShowParameter().getAppId());
        return new QFilter("id", "in", (Object)orgUseCostAccountIds.toArray());
    }

    private void setCostAccount(Object org) {
        if (org == null) {
            return;
        }
        DynamicObject orgDO = (DynamicObject)org;
        Long mainBookId = OrgHelper.getCostAccountByAccoutOrg((Long)orgDO.getLong("id"));
        if (mainBookId != null && mainBookId != 0L) {
            boolean isnit = StartCostHelper.isInit((Long)mainBookId, (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
            if (isnit) {
                this.getModel().setValue("costaccount", (Object)mainBookId);
            }
        } else {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue(PERIOD, null);
        }
    }

    private void setCurrencyAndPeriod(Object costAccount) {
        if (costAccount == null) {
            return;
        }
        DynamicObject costAccountDO = (DynamicObject)costAccount;
        Long currency = CalcRptHelper.getCurrency((DynamicObject)costAccountDO);
        this.getModel().setValue("currency", (Object)currency);
        this.setPeriod();
    }

    private void setPeriod() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        DynamicObject costaccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        if (org == null || costaccount == null) {
            return;
        }
        long orgId = org.getLong("id");
        long costAccountId = costaccount.getLong("id");
        Long currPeriod = CalcRptHelper.getCurrPeriod((Long)orgId, (Long)costAccountId);
        if (currPeriod != null && currPeriod != 0L) {
            this.getModel().setValue(PERIOD, (Object)new Object[]{currPeriod});
        }
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        super.afterCreateColumn(e);
        List cols = e.getColumns();
        Iterator it = cols.iterator();
        List<String> detailHideFields = this.getHideLists(detailStr);
        List<String> hideFields = this.getHideLists(hideStr);
        boolean isShowMaterialDetail = this.getModel().getDataEntity().getBoolean(SHOW_MAT_DETAIL);
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof ReportColumn) {
                ReportColumn reportColumn = (ReportColumn)obj;
                String key = reportColumn.getFieldKey();
                if (hideFields.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (!isShowMaterialDetail && detailHideFields.contains(key)) {
                    reportColumn.setHide(true);
                }
                if (key.equals("costobject_ref_name")) {
                    reportColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u540d\u79f0", (String)"RealTimeCalcResultRptFormPlugin_1", (String)"macc-aca-report", (Object[])new Object[0])));
                }
                if (!key.equals("costcenter_ref_name")) continue;
                reportColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u540d\u79f0", (String)"RealTimeCalcResultRptFormPlugin_2", (String)"macc-aca-report", (Object[])new Object[0])));
                continue;
            }
            if (!(obj instanceof ReportColumnGroup)) continue;
            ReportColumnGroup reportColumnGroup = (ReportColumnGroup)obj;
            List reportColumns = reportColumnGroup.getChildren();
            for (int index = 0; index < reportColumns.size(); ++index) {
                Object column = reportColumns.get(index);
                if (!(column instanceof ReportColumn)) continue;
                ReportColumn col = (ReportColumn)column;
                String key = col.getFieldKey();
                if (isShowMaterialDetail || !detailHideFields.contains(key)) continue;
                col.setHide(true);
            }
        }
        this.getView().updateView("reportlistap");
    }

    private List<String> getHideLists(String[] strings) {
        ArrayList<String> hideFiles = new ArrayList<String>(strings.length);
        hideFiles.addAll(Arrays.asList(strings));
        return hideFiles;
    }

    public void formatDisplayFilterField(FormatShowFilterEvent evt) {
        super.formatDisplayFilterField(evt);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        DynamicObject currency = dataEntity.getDynamicObject("currency");
        DynamicObjectCollection period = dataEntity.getDynamicObjectCollection(PERIOD);
        String pomBillNo = dataEntity.getString("pombillno");
        String omBillNo = dataEntity.getString("ombillno");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)period) && CadEmptyUtils.isEmpty((String)pomBillNo) && CadEmptyUtils.isEmpty((String)omBillNo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6838\u7b97\u671f\u95f4\u6216\u5de5\u5355\u7f16\u53f7\u3002", (String)"RealTimeCalcResultRptFormPlugin_7", (String)"macc-aca-report", (Object[])new Object[0]));
            return false;
        }
        if (!(CadEmptyUtils.isEmpty((DynamicObject)org) || CadEmptyUtils.isEmpty((DynamicObject)costAccount) || CadEmptyUtils.isEmpty((DynamicObject)currency))) {
            RealTimeCalcResultParam calcResultParam = this.buildCalcResultParam(dataEntity);
            this.getQueryParam().getCustomParam().put(RealTimeCalcResultParam.class.getName(), calcResultParam);
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5185\u5bb9\u672a\u586b\u5199\u3002", (String)"RealTimeCalcResultRptFormPlugin_3", (String)"macc-aca-report", (Object[])new Object[0]));
        return false;
    }

    private RealTimeCalcResultParam buildCalcResultParam(DynamicObject dataEntity) {
        MulBasedataDynamicObjectCollection materialCollection;
        MulBasedataDynamicObjectCollection costObjectCollection;
        MulBasedataDynamicObjectCollection costCenterCollection;
        MulBasedataDynamicObjectCollection periods;
        DynamicObject currency;
        DynamicObject costAccount;
        RealTimeCalcResultParam calcResultParam = new RealTimeCalcResultParam();
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
            calcResultParam.setOrgId(org.getLong("id"));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObject)(costAccount = dataEntity.getDynamicObject("costaccount")))) {
            calcResultParam.setCostAccountId(costAccount.getLong("id"));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObject)(currency = dataEntity.getDynamicObject("currency")))) {
            calcResultParam.setCurrencyId(currency.getLong("id"));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(periods = (MulBasedataDynamicObjectCollection)this.getModel().getValue(PERIOD)))) {
            calcResultParam.setPeriodIds(periods.stream().map(period -> period.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        String pomBillNo = dataEntity.getString("pombillno");
        String omBillNo = dataEntity.getString("ombillno");
        ArrayList<String> proBillNumbers = new ArrayList<String>();
        if (!CadEmptyUtils.isEmpty((String)pomBillNo)) {
            proBillNumbers.addAll(Arrays.asList(pomBillNo.split(";")));
        }
        if (!CadEmptyUtils.isEmpty((String)omBillNo)) {
            proBillNumbers.addAll(Arrays.asList(omBillNo.split(";")));
        }
        calcResultParam.setProBillNumbers(proBillNumbers);
        String bizStatus = (String)this.getModel().getValue("bizstatus");
        if (!CadEmptyUtils.isEmpty((String)bizStatus) && !"ALL".equalsIgnoreCase(bizStatus)) {
            calcResultParam.setBizStatus(bizStatus);
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(costCenterCollection = (MulBasedataDynamicObjectCollection)this.getModel().getValue("fcostcenter")))) {
            calcResultParam.setCostCenterIds(costCenterCollection.stream().map(costCenter -> costCenter.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(costObjectCollection = (MulBasedataDynamicObjectCollection)this.getModel().getValue("fcostobject")))) {
            calcResultParam.setCostObjectIds(costObjectCollection.stream().map(costObject -> costObject.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(materialCollection = (MulBasedataDynamicObjectCollection)this.getModel().getValue("fmaterial")))) {
            calcResultParam.setMaterialIds(materialCollection.stream().map(material -> material.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()));
        }
        boolean showMatDetail = dataEntity.getBoolean(SHOW_MAT_DETAIL);
        calcResultParam.setShowMatDetail(showMatDetail);
        boolean mergeSame = dataEntity.getBoolean("mergesame");
        calcResultParam.setMergeSame(mergeSame);
        return calcResultParam;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"RealTimeCalcResultRptFormPlugin_4", (String)"macc-aca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u6210\u672c\u8ba1\u7b97\u5355\u67e5\u8be2", (String)"RealTimeCalcResultRptFormPlugin_5", (String)"macc-aca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"aca_calcresultnew", (IDataModel)this.getModel());
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        HashMap finalCostObjectInfo = new HashMap(16);
        HashMap<Long, Map> totalCurrComQtyMap = new HashMap<Long, Map>(16);
        HashSet<Long> allCostObjectIds = new HashSet<Long>(16);
        for (DynamicObject rowDatum : rowData) {
            Object dataType = rowDatum.get("datatype");
            long costObjectId = rowDatum.getLong("costobject.id");
            allCostObjectIds.add(costObjectId);
            boolean isFinalRow = "finalResult".equals(dataType);
            if (isFinalRow) {
                BigDecimal pdCurrQty = rowDatum.getBigDecimal("pdcurrqty");
                BigDecimal pdStartQty = rowDatum.getBigDecimal("pdstartqty");
                BigDecimal pdStartAmount = rowDatum.getBigDecimal("pdstartamount");
                BigDecimal pdCurrAmount = rowDatum.getBigDecimal("pdcurramount");
                HashMap<BigDecimal, BigDecimal> pdCurrMap = new HashMap<BigDecimal, BigDecimal>(2);
                pdCurrMap.put(pdCurrQty.add(pdStartQty), pdCurrAmount.add(pdStartAmount));
                finalCostObjectInfo.put(costObjectId, pdCurrMap);
                continue;
            }
            Object dealType = rowDatum.get("dealtype");
            if (!"2".equals(dealType)) continue;
            Map finalPdCurrMap = (Map)finalCostObjectInfo.get(costObjectId);
            BigDecimal currcomQty = rowDatum.getBigDecimal("currcomqty");
            BigDecimal currcomAmount = rowDatum.getBigDecimal("currcomamount");
            if (CadEmptyUtils.isEmpty((Map)finalPdCurrMap)) continue;
            for (Map.Entry entry : finalPdCurrMap.entrySet()) {
                BigDecimal pdEndQty;
                long srcBillEntryId = rowDatum.getLong("srcbillentryidtext");
                Map currComQtyMap = totalCurrComQtyMap.computeIfAbsent(costObjectId, s -> new HashMap());
                BigDecimal pdEndAmt = ((BigDecimal)entry.getValue()).subtract(currcomAmount);
                if (currComQtyMap.containsKey(srcBillEntryId)) {
                    pdEndQty = (BigDecimal)entry.getKey();
                } else {
                    pdEndQty = ((BigDecimal)entry.getKey()).subtract(currcomQty);
                    currComQtyMap.put(srcBillEntryId, currcomQty);
                    totalCurrComQtyMap.put(costObjectId, currComQtyMap);
                }
                HashMap<BigDecimal, BigDecimal> pdCurrMap = new HashMap<BigDecimal, BigDecimal>(2);
                pdCurrMap.put(pdEndQty, pdEndAmt);
                finalCostObjectInfo.put(costObjectId, pdCurrMap);
                rowDatum.set("pdendqty", (Object)pdEndQty);
                rowDatum.set("pdendamount", (Object)pdEndAmt);
            }
        }
        if (!CadEmptyUtils.isEmpty(allCostObjectIds)) {
            HashSet closeCostObjectIds = new HashSet(16);
            QFilter qFilter = new QFilter("costobject", "in", allCostObjectIds);
            DataSet costCloseInfoDs = QueryServiceHelper.queryDataSet((String)"getCloseInfo", (String)"cad_plannedoutputbill", (String)"costobject,closestatu", (QFilter[])qFilter.toArray(), null);
            costCloseInfoDs.forEach(s -> {
                if (s.getBoolean("closestatu").booleanValue()) {
                    closeCostObjectIds.add(s.getLong("costobject"));
                }
            });
            if (!CadEmptyUtils.isEmpty(closeCostObjectIds)) {
                for (DynamicObject rowDatum : rowData) {
                    if (!closeCostObjectIds.contains(rowDatum.getLong("costobject.id"))) continue;
                    rowDatum.set("pdendqty", null);
                    rowDatum.set("pdendamount", null);
                }
            }
        }
        if (!this.getModel().getDataEntity(true).getBoolean("mergesame")) {
            return;
        }
        ReportUtils.clearFileNameValue((String[])CLEAR_P, (DynamicObjectCollection)rowData, (String[])CLEAR_P);
        ReportUtils.clearFileNameValue((String[])CLEAR_MAT_P, (DynamicObjectCollection)rowData, (String[])CLEAR_MAT_P);
    }
}

