/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.realtime;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.aca.algox.utils.DataSetHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;

public class RealTimeFinishCostRptQuery
extends AbstractReportListDataPlugin {
    private static final String PERIOD = "fperiod";
    private static final String MATERIAL = "fmaterial";
    private static final String COSTCENTER = "fcostcenter";
    private static String[] leftStr = new String[]{"period", "costcenter", "material", "bookdate", "sourcebillnum", "sourcebillrow", "unit", "amount", "matversion", "matauxpty", "price", "sourcebill", "sourcebillentry"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        QFilter commonQFilter = this.getQfilter(reportQueryParam);
        ORM orm = ORM.create();
        String algoKey = ((Object)((Object)this)).getClass().getName() + ".query";
        String queryFields = this.getQueryFileds();
        QFilter filter = new QFilter("inventoryentryentity.id", ">", (Object)0L);
        Object value = this.getFilterItemValue(reportQueryParam.getFilter(), MATERIAL);
        if (value != null) {
            filter.and(new QFilter("inventoryentryentity.invcostobject.material", "in", value));
        }
        if ((value = this.getFilterItemValue(reportQueryParam.getFilter(), "mftbillno")) != null && !CadEmptyUtils.isEmpty((String)String.valueOf(value))) {
            QFilter qFilter = new QFilter("costaccount", "=", this.getFilterItemValue(reportQueryParam.getFilter(), "costaccount"));
            qFilter.and("billno", "in", Arrays.asList(String.valueOf(value).split(",")));
            DataSet costRecordDs = QueryServiceHelper.queryDataSet((String)"calCostRecord", (String)"cal_costrecord_subentity", (String)"bizbillid", (QFilter[])qFilter.toArray(), null);
            HashSet mftBillIds = new HashSet(16);
            costRecordDs.forEach(s -> mftBillIds.add(s.getLong("bizbillid")));
            if (!CadEmptyUtils.isEmpty(mftBillIds)) {
                filter.and(new QFilter("inventoryentryentity.sourcebill", "in", mftBillIds));
            }
        }
        DataSet calResultDataSet = orm.queryDataSet(algoKey, "aca_realtimecalcresult", queryFields, new QFilter[]{commonQFilter, filter});
        calResultDataSet = calResultDataSet.groupBy(new String[]{"period", "costcenter", "material", "sourcebillnum", "sourcebillrow", "unit", "matversion", "sourcebill", "sourcebillentry"}).sum("amount").sum("price").max("qty").finish();
        HashSet<Long> srcBillEntryIds = new HashSet<Long>(128);
        DataSet completeDataSet = this.getCompleteData(calResultDataSet.copy(), srcBillEntryIds);
        String detailFields = "period.name AS period,costcenter AS costcenter,convsubmatentryentity.convcostobject.material.id AS material,convsubmatentryentity.convcostobject.material.baseunit AS unit,convsubmatentryentity.convsrcbill AS sourcebill,convsubmatentryentity.convsrcbillentry AS sourcebillentry,convsubmatentryentity.convelement AS element,convsubmatentryentity.convsubelement AS subelement,convsubmatentryentity.convsubmat AS submaterial,convsubmatentryentity.convsubresource AS subresource,convsubmatentryentity.convqty AS qty,convsubmatentryentity.convamt AS amount,'2' AS linetype";
        QFilter detailQFilter = new QFilter("convsubmatentryentity.convsrcbillentry", "in", srcBillEntryIds);
        DataSet calDetailResultDataSet = orm.queryDataSet(algoKey, "aca_realtimecalcresult", detailFields, new QFilter[]{commonQFilter, detailQFilter});
        calResultDataSet = calResultDataSet.leftJoin(completeDataSet).on("sourcebill", "sourcebill").on("sourcebillentry", "sourcebillentry").select(calResultDataSet.getRowMeta().getFieldNames(), new String[]{"bookdate", "matauxpty"}).finish();
        DataSet firstRowAndCount = this.getCompleteDataOtherInfo(calResultDataSet, srcBillEntryIds).addFields(new String[]{"'1'", "0L", "0L", "0L", "0L"}, new String[]{"linetype", "element", "subelement", "submaterial", "subresource"});
        firstRowAndCount = DataSetUtils.unionIfRowDiff((DataSet)firstRowAndCount, (DataSet)calDetailResultDataSet);
        firstRowAndCount = firstRowAndCount.orderBy(new String[]{"period", "costcenter", "material", "sourcebillentry"});
        firstRowAndCount = firstRowAndCount.orderBy(new String[]{"sourcebillentry asc"});
        return firstRowAndCount;
    }

    private DataSet getCompleteData(DataSet calResultDataSet, Set<Long> srcBillEntryIds) {
        Iterator iterator = calResultDataSet.iterator();
        HashSet srcBillIds = Sets.newHashSetWithExpectedSize((int)32);
        while (iterator.hasNext()) {
            Row calcResultData = (Row)iterator.next();
            long sourceBillId = calcResultData.getLong("sourcebill");
            long srcBillEntryId = calcResultData.getLong("sourcebillentry");
            srcBillIds.add(sourceBillId);
            srcBillEntryIds.add(srcBillEntryId);
        }
        QFilter srcBillIdQf = new QFilter("sourcebill", "in", (Object)srcBillIds);
        srcBillIdQf.and("appnum", "=", (Object)"aca");
        QFilter srcBillEntryQf = new QFilter("sourcebillentry", "in", srcBillEntryIds);
        return QueryServiceHelper.queryDataSet((String)"getCompleteData", (String)"cad_factnedoutputbill", (String)"sourcebill,sourcebillentry,bookdate,srcauxpty AS matauxpty", (QFilter[])new QFilter[]{srcBillIdQf, srcBillEntryQf}, null);
    }

    private DataSet getCompleteDataOtherInfo(DataSet calResultDataSet, Set<Long> srcBillEntryIds) {
        QFilter idQFilter = new QFilter("billentry.id", "in", srcBillEntryIds);
        String selectFields = "id,biztype,invscheme,org stockorg,billno billnum,billentry.id entryid,billentry.seq billrow,billentry.baseqty qty,billentry.invtype invtype,billentry.invstatus invstatus,billentry.warehouse warehouse,billentry.lotnumber lotnumber";
        DataSet inTypeData = QueryServiceHelper.queryDataSet((String)"getmftmanuinbill", (String)"im_mdc_mftmanuinbill", (String)selectFields, (QFilter[])idQFilter.toArray(), null);
        DataSet productBillData = QueryServiceHelper.queryDataSet((String)"getproductinbill", (String)"im_productinbill", (String)selectFields, (QFilter[])idQFilter.toArray(), null);
        DataSet omBillData = QueryServiceHelper.queryDataSet((String)"getomcmplinbill", (String)"im_mdc_omcmplinbill", (String)selectFields, (QFilter[])idQFilter.toArray(), null);
        inTypeData = DataSetHelper.union((DataSet)inTypeData, (DataSet)productBillData);
        inTypeData = DataSetHelper.union((DataSet)inTypeData, (DataSet)omBillData);
        calResultDataSet = calResultDataSet.leftJoin(inTypeData).on("sourcebill", "id").on("sourcebillentry", "entryid").select(leftStr, new String[]{"biztype", "invscheme", "stockorg", "billnum", "billrow", "qty", "invtype", "invstatus", "warehouse", "lotnumber"}).finish();
        return calResultDataSet;
    }

    private QFilter getQfilter(ReportQueryParam reportQueryParam) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        Object value = this.getFilterItemValue(filterInfo, "org");
        QFilter filter = new QFilter("org", "=", value);
        value = this.getFilterItemValue(filterInfo, "costaccount");
        filter.and(new QFilter("costaccount", "=", value));
        value = this.getFilterItemValue(filterInfo, "currency");
        filter.and(new QFilter("currency", "in", value));
        value = this.getFilterItemValue(filterInfo, PERIOD);
        filter.and(new QFilter("period", "in", value));
        value = this.getFilterItemValue(filterInfo, COSTCENTER);
        if (value != null) {
            filter.and(new QFilter("costcenter", "in", value));
        }
        return filter;
    }

    private Object getFilterItemValue(FilterInfo filterInfo, String propName) {
        FilterItemInfo filterItem = filterInfo.getFilterItem(propName);
        if (filterItem != null && filterItem.getValue() != null) {
            Object value = filterItem.getValue();
            if (value instanceof DynamicObject) {
                return ((DynamicObject)value).getPkValue();
            }
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection values = (DynamicObjectCollection)value;
                return values.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            }
            return value;
        }
        return null;
    }

    private String getQueryFileds() {
        return "id,billno,period AS periodid,period.name AS period,costcenter AS costcenter,inventoryentryentity.invcostobject.material.id AS material,inventoryentryentity.invcostobject.material.baseunit AS unit,inventoryentryentity.invcostobject.srcbillnumber AS sourcebillnum,inventoryentryentity.invcostobject.srcbillrow AS sourcebillrow,inventoryentryentity.invcostobject.bomversion AS matversion,0 AS biztype,0 AS invscheme,0 AS stockorg,0 AS billnum,0 AS billrow,0 AS invtype,0 AS invstatus,0 AS warehouse,'' lotnumber,inventoryentryentity.sourcebill AS sourcebill,inventoryentryentity.sourcebillentry AS sourcebillentry,inventoryentryentity.inventoryqty AS qty,0 AS price,inventoryentryentity.inventoryamount AS amount";
    }
}

