/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.aca.report.wipcostcheck;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.aca.algox.enums.TerminalWipMatEnum;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ReportUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class TerminalWipMatCheckRptPlugin
extends AbstractReportFormPlugin {
    private static final String[] clearFileName = new String[]{"periodcol", "orgcol", "costaccountcol", "costcenternum", "costcentername", "srcbillnumber"};
    private static Object[] primaryKeyValues;
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"billno"});
        BasedataEdit accountOrgBase = (BasedataEdit)this.getControl("accountorg");
        accountOrgBase.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List filters = filterParameter.getQFilters();
            List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            QFilter orgIdsFilter = new QFilter("id", "in", (Object)hasPermAccountOrgIds);
            filters.add(orgIdsFilter);
        });
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List filters = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("accountorg");
            if (accountorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"TerminalWipMatCheckRptPlugin_0", (String)"macc-aca-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            filters.add(StartCostHelper.getEnableQfilterByOrg((Long)Long.valueOf(accountorg.getPkValue().toString()), null, (String)this.getView().getFormShowParameter().getAppId()));
        });
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        this.getPeriod(period);
        BasedataEdit costcenter = (BasedataEdit)this.getControl("costcenter");
        costcenter.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject accountorg = (DynamicObject)this.getModel().getValue("accountorg");
            if (accountorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"TerminalWipMatCheckRptPlugin_1", (String)"macc-aca-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            qFilters.add(new QFilter("accountorg", "=", accountorg.getPkValue()));
            qFilters.add(new QFilter("orgduty", "=", (Object)4L));
        });
        BasedataEdit material = (BasedataEdit)this.getControl("materials");
        material.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject createorg = (DynamicObject)this.getModel().getValue("accountorg");
            if (createorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"TerminalWipMatCheckRptPlugin_2", (String)"macc-aca-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter qfMat = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)createorg.getLong("id"));
            qFilters.add(qfMat);
        });
        BasedataEdit costobjectf = (BasedataEdit)this.getControl("costobjectf");
        costobjectf.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject orgDy = (DynamicObject)this.getModel().getValue("accountorg");
            if (orgDy == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"TerminalWipMatCheckRptPlugin_2", (String)"macc-aca-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection costCenters = (DynamicObjectCollection)this.getModel().getValue("costcenter");
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)costCenters)) {
                HashSet<Long> costCenterSet = new HashSet<Long>();
                for (DynamicObject row : costCenters) {
                    DynamicObject costcenterDy = row.getDynamicObject("fbasedataid");
                    costCenterSet.add(costcenterDy.getLong("masterid"));
                }
                qFilters.add(new QFilter("costcenter", "in", costCenterSet));
            }
            qFilters.add(new QFilter("org", "=", orgDy.getPkValue()));
            QFilter producttypeQf = new QFilter("producttype", "=", (Object)"C");
            qFilters.add(producttypeQf);
        });
    }

    private void getPeriod(BasedataEdit beginperiod) {
        beginperiod.addBeforeF7SelectListener(evt -> {
            DynamicObject accountOrg = this.getModel().getDataEntity().getDynamicObject("accountorg");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountOrg)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"TerminalWipMatCheckRptPlugin_3", (String)"macc-aca-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"TerminalWipMatCheckRptPlugin_4", (String)"macc-aca-report", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            QFilter usePeriodFilter = this.getUsePeriodFilter(Long.valueOf(String.valueOf(accountOrg.getPkValue())), Long.valueOf(String.valueOf(costAccount.getPkValue())));
            filterParameter.getQFilters().add(usePeriodFilter);
            filterParameter.getQFilters().add(new QFilter("isadjustperiod", "=", (Object)false));
        });
    }

    public void afterBindData(EventObject e) {
        DynamicObject org;
        Long accountorg;
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object costaccount = customParams.get("costaccount");
        Object orgId = customParams.get("org");
        if (costaccount != null && orgId != null) {
            this.getModel().setValue("accountorg", orgId);
            this.getModel().setValue("costaccount", costaccount);
            this.setCurrency();
        }
        Long l = accountorg = (org = (DynamicObject)this.getModel().getValue("accountorg")) == null ? null : (Long)org.getPkValue();
        if (accountorg == null) {
            accountorg = RequestContext.get().getOrgId();
            if (!this.getHasPermAccountOrg(accountorg)) {
                return;
            }
            if (OrgUnitServiceHelper.checkOrgFunction((Long)accountorg, (String)"10")) {
                this.getModel().setValue("accountorg", (Object)accountorg);
            }
            this.changeAccountOrg(accountorg);
        }
        this.getView().updateView("accountorg");
        this.getView().updateView("costaccount");
    }

    private void changeAccountOrg(Long accountorg) {
        this.getModel().setValue("costaccount", null);
        this.getModel().setValue("costcenter", null);
        this.getModel().setValue("material", null);
        this.getModel().setValue("currency", null);
        this.getModel().setValue("period", null);
        if (accountorg != null) {
            Long costaccountId = this.getCostAccountByAccoutOrg(accountorg);
            this.getModel().setValue("costaccount", (Object)(costaccountId == null ? null : costaccountId));
            this.changeCostaccout();
            this.getView().updateView("costaccount");
        }
    }

    private Long getCostAccountByAccoutOrg(Long accountOrgId) {
        QFilter appNumQF;
        QFilter[] filters;
        DynamicObjectCollection result;
        String fields = "entryentity.costaccount.id id,entryentity.costaccount.name name,entryentity.costaccount.ismainaccount ismainaccount";
        QFilter orgFilter = new QFilter("org", "=", (Object)accountOrgId);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId())) {
            appId = "sca";
        }
        if ((result = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])(filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, enable, appNumQF = new QFilter("appnum", "=", (Object)appId)}), null)) == null || result.size() == 0) {
            return null;
        }
        if (result.size() == 1) {
            DynamicObject costaccount = (DynamicObject)result.get(0);
            return costaccount.getLong("id");
        }
        for (DynamicObject res : result) {
            if (!res.getBoolean("ismainaccount")) continue;
            return res.getLong("id");
        }
        return null;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object entryids = customParams.get("entryids");
        String num = this.getView().getPageCache().get("entryids");
        if (entryids != null && !"one".equals(num)) {
            queryParam.getCustomParam().put("entryids", entryids);
            this.getView().getPageCache().put("entryids", "one");
            QFilter entryQf = new QFilter("entryid", "in", entryids);
            this.getCheckType(entryQf);
            return true;
        }
        String billno = (String)this.getModel().getValue("billno");
        if (primaryKeyValues == null || CadEmptyUtils.isEmpty((String)billno)) {
            queryParam.getCustomParam().remove("ids");
        } else {
            queryParam.getCustomParam().put("ids", primaryKeyValues);
        }
        queryParam.getCustomParam().remove("entryids");
        String tips = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"TerminalWipMatCheckRptPlugin_5", (String)"macc-aca-report", (Object[])new Object[0]);
        if (this.checkFileNameisNull("accountorg", tips)) {
            return false;
        }
        tips = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u4e0d\u80fd\u4e3a\u7a7a", (String)"TerminalWipMatCheckRptPlugin_6", (String)"macc-aca-report", (Object[])new Object[0]);
        if (this.checkFileNameisNull("costaccount", tips)) {
            return false;
        }
        tips = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u201c\u6838\u7b97\u671f\u95f4\u201d\u3002", (String)"TerminalWipMatCheckRptPlugin_7", (String)"macc-aca-report", (Object[])new Object[0]);
        if (this.checkFileNameisNull("period", tips)) {
            return false;
        }
        tips = ResManager.loadKDString((String)"\u5e01\u522b\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u6210\u672c\u8d26\u7c3f\u662f\u5426\u5173\u8054\u5e01\u522b\u3002", (String)"TerminalWipMatCheckRptPlugin_8", (String)"macc-aca-report", (Object[])new Object[0]);
        if (this.checkFileNameisNull("currency", tips)) {
            return false;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("accountorg");
        DynamicObject period = (DynamicObject)this.getModel().getValue("period");
        QFilter orgQf = new QFilter("org", "=", org.getPkValue());
        QFilter periodQf = new QFilter("period", "=", period.getPkValue());
        orgQf.and(periodQf);
        this.getCheckType(orgQf);
        return true;
    }

    private void getCheckType(QFilter qFilter) {
        QFilter qtyQf = new QFilter("checktype", "=", (Object)TerminalWipMatEnum.CHECKTYPE_QTY.getValue());
        QFilter amountQf = new QFilter("checktype", "=", (Object)TerminalWipMatEnum.CHECKTYPE_AMOUNT.getValue());
        boolean qtyExists = QueryServiceHelper.exists((String)"aca_terminalwipmatallco", (QFilter[])new QFilter[]{qFilter, qtyQf});
        boolean amountExists = QueryServiceHelper.exists((String)"aca_terminalwipmatallco", (QFilter[])new QFilter[]{qFilter, amountQf});
        String checktype = TerminalWipMatEnum.CHECKTYPE_QTY.getValue();
        if (qtyExists && amountExists) {
            this.getView().getPageCache().put("hiddenFileName", "");
            return;
        }
        if (qtyExists) {
            checktype = TerminalWipMatEnum.CHECKTYPE_QTY.getValue();
        } else if (amountExists) {
            checktype = TerminalWipMatEnum.CHECKTYPE_AMOUNT.getValue();
        }
        String hiddenFileName = TerminalWipMatEnum.CHECKTYPE_AMOUNT.getValue().equals(checktype) ? "allocqty" : "allocamount";
        this.getView().getPageCache().put("hiddenFileName", hiddenFileName);
    }

    private boolean checkFileNameisNull(String fileName, String tips) {
        if (this.getModel().getValue(fileName) == null) {
            this.getView().showTipNotification(tips);
            return true;
        }
        return false;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (e.getProperty().getName()) {
            case "costaccount": {
                this.changeCostaccout();
                break;
            }
            case "accountorg": {
                Long accountorgId = newValue == null ? null : (Long)((DynamicObject)newValue).getPkValue();
                this.changeAccountOrg(accountorgId);
                break;
            }
            case "billno": {
                if (newValue != null) break;
                primaryKeyValues = null;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if ("billno".equals(c.getKey())) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("accountorg");
            DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
            if (org == null || costaccount == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6838\u7b97\u7ec4\u7ec7\u548c\u6210\u672c\u8d26\u7c3f\u3002", (String)"TerminalWipMatCheckRptPlugin_9", (String)"macc-aca-report", (Object[])new Object[0]));
                return;
            }
            ListShowParameter para = new ListShowParameter();
            para.setLookUp(true);
            para.setBillFormId("aca_terminalwipmatcheck");
            para.setFormId("bos_listf7");
            StyleCss css = new StyleCss();
            css.setWidth("1068");
            css.setHeight("648");
            para.getOpenStyle().setInlineStyleCss(css);
            para.getOpenStyle().setShowType(ShowType.Modal);
            para.setMultiSelect(true);
            para.setShowUsed(true);
            para.setShowTitle(false);
            para.setShowQuickFilter(true);
            para.setIsolationOrg(false);
            para.setCustomParam("formBill", (Object)"aca_terminalwipmatrpt");
            para.setCustomParam("org", org.getPkValue());
            para.setCustomParam("costaccount", costaccount.getPkValue());
            para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "terminalwipmatcheck"));
            this.getView().showForm((FormShowParameter)para);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        switch (e.getActionId()) {
            case "terminalwipmatcheck": {
                Object returnData = e.getReturnData();
                StringBuilder billNoBuilder = new StringBuilder();
                if (!(returnData instanceof ListSelectedRowCollection)) break;
                ListSelectedRowCollection returnRow = (ListSelectedRowCollection)returnData;
                primaryKeyValues = returnRow.getPrimaryKeyValues();
                for (ListSelectedRow listSelectedRow : returnRow) {
                    String billNo = listSelectedRow.getBillNo();
                    billNoBuilder.append(billNo).append(',');
                }
                if (billNoBuilder.length() > 2000) {
                    billNoBuilder.setLength(2000);
                } else if (billNoBuilder.length() > 0) {
                    billNoBuilder.setLength(billNoBuilder.length() - 1);
                }
                this.getModel().setValue("billno", (Object)billNoBuilder.toString());
                this.getView().updateView("billno");
            }
        }
    }

    public void afterCreateColumn(CreateColumnEvent e) {
        String hiddenFileName = this.getView().getPageCache().get("hiddenFileName");
        if (StringUtils.isNotEmpty((String)hiddenFileName)) {
            List cols = e.getColumns();
            for (Object obj : cols) {
                if (obj instanceof ReportColumn) {
                    ReportColumn reportColumn = (ReportColumn)obj;
                    String key = reportColumn.getFieldKey();
                    if (!hiddenFileName.equals(key)) continue;
                    reportColumn.setHide(true);
                    continue;
                }
                if (!(obj instanceof ReportColumnGroup)) continue;
                ReportColumnGroup reportColumnGroup = (ReportColumnGroup)obj;
                List reportColumns = reportColumnGroup.getChildren();
                for (int index = 0; index < reportColumns.size(); ++index) {
                    ReportColumn col;
                    String key;
                    Object column = reportColumns.get(index);
                    if (!(column instanceof ReportColumn) || !hiddenFileName.equals(key = (col = (ReportColumn)column).getFieldKey())) continue;
                    col.setHide(true);
                }
            }
            this.getView().updateView("reportlistap");
        }
        super.afterCreateColumn(e);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"TerminalWipMatCheckRptPlugin_10", (String)"macc-aca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u5728\u4ea7\u6750\u6599\u76d8\u70b9\u5206\u914d\u67e5\u8be2", (String)"TerminalWipMatCheckRptPlugin_11", (String)"macc-aca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"aca_terminalwipmatrpt", (IDataModel)this.getModel());
    }

    private void changeCostaccout() {
        this.getModel().setValue("currency", null);
        this.getModel().setValue("period", null);
        this.setCurrency();
        this.setPeriod();
    }

    protected void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
        this.getView().updateView("currency");
    }

    private void setPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("accountorg");
        if (org == null) {
            return;
        }
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            return;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        QFilter isInitFilter = new QFilter("entry.isenabled", "=", (Object)Character.valueOf('1'));
        DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, isInitFilter});
        if (res != null) {
            Long currentperiod = res.getLong("currentperiod");
            this.getModel().setValue("period", (Object)currentperiod);
            this.getView().updateView("period");
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        Boolean mergesame = (Boolean)this.getModel().getValue("mergesame");
        if (mergesame.booleanValue()) {
            ReportUtils.clearFileNameValue((String[])clearFileName, (DynamicObjectCollection)rowData, (String[])clearFileName);
        }
        for (DynamicObject rowDatum : rowData) {
            DynamicObject costobject;
            String orderby = rowDatum.getString("orderby");
            String checktype = rowDatum.getString("checktype");
            String fileName = TerminalWipMatEnum.CHECKTYPE_AMOUNT.getValue().equals(checktype) ? "allocamount" : "allocqty";
            rowDatum.set(fileName, rowDatum.get("calqty"));
            if ("1".equals(orderby)) {
                rowDatum.set("costcenternum", (Object)ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"TerminalWipMatCheckRptPlugin_12", (String)"macc-aca-report", (Object[])new Object[0]));
            } else if ("2".equals(orderby)) {
                rowDatum.set("costaccountcol", (Object)ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"TerminalWipMatCheckRptPlugin_12", (String)"macc-aca-report", (Object[])new Object[0]));
            } else if ("3".equals(orderby)) {
                rowDatum.set("periodcol", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"TerminalWipMatCheckRptPlugin_13", (String)"macc-aca-report", (Object[])new Object[0]));
            }
            if ((costobject = rowDatum.getDynamicObject("costobject")) == null) continue;
            rowDatum.set("costmaterial", costobject.get("material"));
            rowDatum.set("costauxpty", costobject.get("auxpty"));
        }
    }

    private boolean getHasPermAccountOrg(Long orgId) {
        String entityid = this.getView().getEntityId();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)this.getView().getFormShowParameter().getAppId(), (String)entityid, (String)"47150e89000000ac");
        if (rs.hasAllOrgPerm()) {
            return true;
        }
        return rs.getHasPermOrgs().contains(orgId);
    }

    private QFilter getUsePeriodFilter(Long orgId, Long costAccountId) {
        QFilter result = new QFilter("periodtype", ">", (Object)0L);
        QFilter periodfilter = new QFilter("org", "=", (Object)orgId);
        periodfilter.and(new QFilter("entry.costaccount", "=", (Object)costAccountId));
        DynamicObjectCollection cal_sysctrlentity = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"org.id orgid,entry.costaccount.id acctid,entry.calpolicy.periodtype periodtype,entry.startperiod.id startperiod,entry.currentperiod.id currentperiod", (QFilter[])periodfilter.toArray());
        if (cal_sysctrlentity.size() > 0) {
            DynamicObject periodDO = (DynamicObject)cal_sysctrlentity.get(0);
            result = new QFilter("periodtype", "=", (Object)periodDO.getLong("periodtype"));
            if (periodDO.get("startperiod") != null) {
                result.and(new QFilter("id", ">=", (Object)periodDO.getLong("startperiod")));
            }
        }
        return result;
    }
}

