/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.sca.common.helper.MatBaseDataFilterHelper;

public class CostAnalyzeByOrgRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void registerListener(EventObject e) {
        BasedataEdit costAccount = (BasedataEdit)this.getControl("costaccount");
        costAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit compareCostAccount = (BasedataEdit)this.getControl("comparecostaccount");
        compareCostAccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit startPeriod = (BasedataEdit)this.getControl("startperiod");
        startPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit endPeriod = (BasedataEdit)this.getControl("endperiod");
        endPeriod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulproduct = (MulBasedataEdit)this.getControl("mulproduct");
        mulproduct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialgrpstd = (BasedataEdit)this.getControl("materialgrpstd");
        materialgrpstd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulmaterialtype = (MulBasedataEdit)this.getControl("mulmaterialtype");
        mulmaterialtype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulmaterial = (MulBasedataEdit)this.getControl("mulmaterial");
        mulmaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.init();
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        String appId = AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView());
        filterInfo.addFilterItem("appnum", (Object)appId, "=");
        DynamicObject costaccount = filterInfo.getDynamicObject("costaccount");
        HashSet accSet = Sets.newHashSet();
        accSet.add(costaccount.getLong("id"));
        Set<Long> allCostaccountSet = this.getCostAccountF7Id(appId);
        accSet.removeAll(allCostaccountSet);
        if (!accSet.isEmpty()) {
            filterInfo.addFilterItem("notQuery", (Object)true, "=");
        }
        queryParam.setFilter(filterInfo);
    }

    private Set<Long> getCostAccountF7Id(String appNum) {
        List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        QFilter orgFilter = new QFilter("org", "in", (Object)permAccountOrgIds);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)appNum);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, appnumFilter};
        DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filters);
        if (!costAccountIds.isEmpty()) {
            return costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toSet());
        }
        return Sets.newHashSet();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List qFilters = listShowParameter.getListFilterParameter().getQFilters();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        DynamicObject compareorg = this.getModel().getDataEntity().getDynamicObject("compareorg");
        ArrayList<Long> createOrgIds = new ArrayList<Long>(10);
        if (org != null) {
            createOrgIds.add(org.getLong("id"));
        }
        if (compareorg != null) {
            createOrgIds.add(compareorg.getLong("id"));
        }
        switch (name) {
            case "costaccount": {
                List<Long> costAccountIds = this.getCostAccountF7By(null);
                qFilters.add(new QFilter("id", "in", costAccountIds));
                break;
            }
            case "comparecostaccount": {
                DynamicObject costaccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
                if (costaccount == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostAnalyzeByOrgRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                List<Long> costAccountIds = this.getCostAccountF7By(costaccount);
                qFilters.add(new QFilter("id", "in", costAccountIds));
                break;
            }
            case "startperiod": 
            case "endperiod": {
                DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
                if (costAccount == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostAnalyzeByOrgRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u5bf9\u5e94\u7684\u6838\u7b97\u7ec4\u7ec7\u672a\u7ef4\u62a4\u3002", (String)"CostAnalyzeByOrgRptPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObject compareCostAccount = this.getModel().getDataEntity().getDynamicObject("comparecostaccount");
                if (compareCostAccount == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6bd4\u8f83\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostAnalyzeByOrgRptPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if (compareorg == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bd4\u8f83\u6210\u672c\u8d26\u7c3f\u5bf9\u5e94\u7684\u6bd4\u8f83\u6838\u7b97\u7ec4\u7ec7\u672a\u7ef4\u62a4\u3002", (String)"CostAnalyzeByOrgRptPlugin_3", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter usePeriodFilter = StartCostHelper.getUsePeriodFilter((Long)Long.valueOf(String.valueOf(org.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccount.getPkValue())));
                QFilter usePeriodForCompFilter = StartCostHelper.getUsePeriodFilter((Long)Long.valueOf(String.valueOf(compareorg.getPkValue())), (Long)Long.valueOf(String.valueOf(compareCostAccount.getPkValue())));
                if (!CadEmptyUtils.isEmpty((Long)Long.parseLong(usePeriodForCompFilter.getValue().toString()))) {
                    usePeriodFilter = usePeriodFilter.or(usePeriodForCompFilter);
                }
                listShowParameter.getListFilterParameter().getQFilters().add(usePeriodFilter);
                break;
            }
            case "materialgrpstd": {
                Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, Boolean.TRUE});
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)ids));
                break;
            }
            case "mulmaterialtype": {
                DynamicObject materialgrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd");
                if (materialgrpstd == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"CostAnalyzeByOrgRptPlugin_4", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialgrpstd.getPkValue(), false});
                qFilters.add(serviceResponse);
                HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>(2);
                params.put("useOrgs", createOrgIds);
                listShowParameter.setCustomParams(params);
                listShowParameter.setCustomParam("groupStandard", materialgrpstd.getPkValue());
                listShowParameter.setF7ClickByFilter(false);
                break;
            }
            case "mulmaterial": {
                DynamicObject materialgrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd");
                if (materialgrpstd == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"CostAnalyzeByOrgRptPlugin_4", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostAnalyzeByOrgRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if (compareorg == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6bd4\u8f83\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostAnalyzeByOrgRptPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                qFilters.add(MatBaseDataFilterHelper.getBaseFilter(createOrgIds));
                DynamicObjectCollection mulmaterialtype = (DynamicObjectCollection)this.getModel().getValue("mulmaterialtype");
                if (!CollectionUtils.isEmpty((Collection)mulmaterialtype) || materialgrpstd.getLong("id") != 730148448254487552L) {
                    qFilters.add(MaterialGroupHelper.getClassifiedMaterialIdFilter((DynamicObjectCollection)mulmaterialtype, (boolean)false, (DynamicObject)materialgrpstd));
                }
                listShowParameter.setF7ClickByFilter(false);
                break;
            }
            case "mulproduct": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostAnalyzeByOrgRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if (compareorg == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6bd4\u8f83\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostAnalyzeByOrgRptPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter matOrgFilter = MatBaseDataFilterHelper.getBaseFilter(createOrgIds);
                qFilters.add(matOrgFilter);
                listShowParameter.setF7ClickByFilter(false);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyName) {
            case "costaccount": {
                this.setOrg(newValue, "org");
                this.setCurrency();
                this.getModel().setValue("comparecostaccount", newValue);
                break;
            }
            case "comparecostaccount": {
                this.setOrg(newValue, "compareorg");
                this.setStartAndEndPeriod();
                break;
            }
            case "startperiod": {
                this.adjustEndPeriodByStartPeriod(newValue);
                break;
            }
            case "endperiod": {
                this.adjustEndPeriodByEndPeriod(newValue);
                break;
            }
            case "materialgrpstd": {
                this.getModel().setValue("mulmaterialtype", null);
                this.getModel().setValue("mulmaterial", null);
                break;
            }
            case "mulmaterialtype": {
                this.getModel().setValue("mulmaterial", null);
                break;
            }
            case "onlysumrow": {
                if (!((Boolean)newValue).booleanValue()) break;
                this.getModel().setValue("sumbyperiod", (Object)false);
                break;
            }
            case "sumbyperiod": {
                if (!((Boolean)newValue).booleanValue()) break;
                this.getModel().setValue("onlysumrow", (Object)false);
            }
        }
    }

    private void setStartAndEndPeriod() {
        Object org = this.getModel().getValue("org");
        Object costAccount = this.getModel().getValue("costaccount");
        if (org == null || costAccount == null) {
            return;
        }
        long orgId = ((DynamicObject)org).getLong("id");
        long costAccountId = ((DynamicObject)costAccount).getLong("id");
        QFilter usePeriodFilter = StartCostHelper.getUsePeriodFilter((Long)orgId, (Long)costAccountId);
        Long endPeriod = (Long)((QFilter.QFilterNest)usePeriodFilter.getNests(true).get(1)).getFilter().getValue();
        Object temp_startPeriod = this.getModel().getValue("startperiod");
        Object temp_endPeriod = this.getModel().getValue("endperiod");
        Long temp_startPeriodId = temp_startPeriod == null ? 0L : ((DynamicObject)temp_startPeriod).getLong("id");
        Long temp_endPeriodId = temp_endPeriod == null ? 0L : ((DynamicObject)temp_endPeriod).getLong("id");
        if (temp_startPeriodId > 0L && temp_startPeriodId <= endPeriod && temp_endPeriodId > 0L && temp_endPeriodId <= endPeriod) {
            return;
        }
        Long curPeriod1 = this.getCalCurPeriod(orgId, costAccountId);
        if (!CadEmptyUtils.isEmpty((Long)curPeriod1)) {
            this.getModel().setValue("startperiod", (Object)curPeriod1);
            this.getModel().setValue("endperiod", (Object)curPeriod1);
        }
        this.getView().updateView("startperiod");
        this.getView().updateView("endperiod");
    }

    private Long getCalCurPeriod(Long org, Long costAccount) {
        QFilter periodfilter = new QFilter("org", "=", (Object)org);
        periodfilter.and(new QFilter("entry.costaccount", "=", (Object)costAccount));
        DynamicObject calSysctrlEntity = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod.id currentperiod", (QFilter[])periodfilter.toArray());
        return calSysctrlEntity == null ? 0L : calSysctrlEntity.getLong("currentperiod");
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        DynamicObject costAccount = filter.getDynamicObject("costaccount");
        if (costAccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostAnalyzeByOrgRptPlugin_5", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObject compareCostAccount = filter.getDynamicObject("comparecostaccount");
        if (compareCostAccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6bd4\u8f83\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostAnalyzeByOrgRptPlugin_6", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObject startPeriod = filter.getDynamicObject("startperiod");
        if (startPeriod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f00\u59cb\u671f\u95f4\u3002", (String)"CostAnalyzeByOrgRptPlugin_7", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObject endPeriod = filter.getDynamicObject("endperiod");
        if (endPeriod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u675f\u671f\u95f4\u3002", (String)"CostAnalyzeByOrgRptPlugin_8", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObjectCollection mulProduct = filter.getDynamicObjectCollection("mulproduct");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)mulProduct)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ea7\u54c1", (String)"CostAnalyzeByOrgRptPlugin_9", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObject currency = filter.getDynamicObject("currency");
        if (currency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u7ef4\u62a4\u5e01\u79cd\u3002", (String)"CostAnalyzeByOrgRptPlugin_10", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObject materialGrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd");
        if (materialGrpstd == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"CostAnalyzeByOrgRptPlugin_11", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        return super.verifyQuery(queryParam);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        List columns = event.getColumns();
        boolean onlymaterialtype = this.getModel().getDataEntity().getBoolean("onlymaterialtype");
        boolean sumbyperiod = this.getModel().getDataEntity().getBoolean("sumbyperiod");
        for (AbstractReportColumn col : columns) {
            if (!(col instanceof ReportColumn)) continue;
            ReportColumn reportColumn = (ReportColumn)col;
            String key = reportColumn.getFieldKey();
            if ("material".equals(key) || "materialbaseunit".equals(key) || "materialnumber".equals(key) || "materialname".equals(key) || "materialmodelnum".equals(key)) {
                reportColumn.setHide(onlymaterialtype);
            }
            if (!"entryperiod".equals(key)) continue;
            reportColumn.setHide(sumbyperiod);
        }
        super.afterCreateColumn(event);
    }

    private void setCostAccount(Object org, String appnum) {
        if (org == null) {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("currency", null);
            this.getModel().setValue("comparecostaccount", null);
            return;
        }
        Long mainBookId = this.getCostAccountByAccoutOrg(((DynamicObject)org).getLong("id"), appnum);
        if (mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
            this.getModel().setValue("comparecostaccount", (Object)mainBookId);
        } else {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("comparecostaccount", null);
            this.getModel().setValue("org", null);
            this.getModel().setValue("compareorg", null);
            this.getView().updateView("org");
            this.getView().updateView("compareorg");
        }
        this.getView().updateView("costaccount");
        this.getView().updateView("comparecostaccount");
    }

    private void setOrg(Object costAccount, String setField) {
        if (costAccount == null) {
            this.getModel().setValue(setField, null);
        } else {
            QFilter orgFilter = new QFilter("id", "=", (Object)((DynamicObject)costAccount).getLong("id"));
            DynamicObject sysparams = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (String)"calorg", (QFilter[])new QFilter[]{orgFilter});
            if (sysparams == null) {
                this.getModel().setValue(setField, null);
            } else {
                this.getModel().setValue(setField, (Object)sysparams.getDynamicObject("calorg").getLong("id"));
            }
        }
        this.getView().updateView(setField);
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    private List<Long> getCostAccountF7By(DynamicObject costAccount) {
        List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        QFilter orgFilter = new QFilter("org", "in", (Object)permAccountOrgIds);
        orgFilter.and(new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE));
        orgFilter.and(new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE));
        orgFilter.and(new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE));
        orgFilter.and(new QFilter("appnum", "=", (Object)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView())));
        List<Long> useStdCostAccountIds = this.getUseStdCostAccount(orgFilter);
        if (costAccount == null) {
            return useStdCostAccountIds;
        }
        QFilter costAccountFilter = new QFilter("entryentity.costaccount", "=", costAccount.getPkValue());
        DynamicObject startStdCost = QueryServiceHelper.queryOne((String)"sca_startstdcost", (String)"entryentity.calpolicy.currency currency,entryentity.calpolicy.periodtype periodtype", (QFilter[])new QFilter[]{orgFilter, costAccountFilter});
        if (startStdCost == null) {
            useStdCostAccountIds.clear();
            return useStdCostAccountIds;
        }
        orgFilter.and(new QFilter("entryentity.calpolicy.currency", "=", (Object)startStdCost.getLong("currency")));
        orgFilter.and(new QFilter("entryentity.calpolicy.periodtype", "=", (Object)startStdCost.getLong("periodtype")));
        return this.getUseStdCostAccount(orgFilter);
    }

    private Long getCostAccountByAccoutOrg(Long accountOrgId, String appnum) {
        QFilter orgFilter = new QFilter("org", "in", (Object)accountOrgId);
        orgFilter.and(new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE));
        orgFilter.and(new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE));
        orgFilter.and(new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE));
        orgFilter.and(new QFilter("appnum", "=", (Object)appnum));
        List<Long> useStdCostAccountIds = this.getUseStdCostAccount(orgFilter);
        if (useStdCostAccountIds.size() == 0) {
            return 0L;
        }
        if (useStdCostAccountIds.size() == 1) {
            return useStdCostAccountIds.get(0);
        }
        return 0L;
    }

    private List<Long> getUseStdCostAccount(QFilter filter) {
        DynamicObjectCollection results = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount.id id,entryentity.costaccount.ismainaccount ismainaccount", (QFilter[])new QFilter[]{filter});
        ArrayList<Long> useStdCostAccountIds = new ArrayList<Long>(100);
        results.forEach(p -> useStdCostAccountIds.add(p.getLong("id")));
        return useStdCostAccountIds;
    }

    public void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
        this.getView().updateView("currency");
    }

    private void adjustEndPeriodByStartPeriod(Object startPeriod) {
        if (startPeriod == null) {
            return;
        }
        DynamicObject endPeriod = this.getModel().getDataEntity().getDynamicObject("endperiod");
        if (endPeriod == null) {
            return;
        }
        long endPeriodId = endPeriod.getLong("id");
        long startPeriodId = ((DynamicObject)startPeriod).getLong("id");
        if (startPeriodId > endPeriodId) {
            this.getModel().setValue("endperiod", (Object)startPeriodId);
            this.getView().updateView("endperiod");
        }
    }

    private void adjustEndPeriodByEndPeriod(Object endPeriod) {
        if (endPeriod == null) {
            return;
        }
        DynamicObject startPeriod = this.getModel().getDataEntity().getDynamicObject("startperiod");
        if (startPeriod == null) {
            return;
        }
        long startPeriodId = startPeriod.getLong("id");
        long endPeriodId = ((DynamicObject)endPeriod).getLong("id");
        if (endPeriodId < startPeriodId) {
            this.getModel().setValue("endperiod", (Object)startPeriodId);
            this.getView().updateView("endperiod");
        }
    }

    private void init() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (isaccount && permAccountOrgIds.contains(currentOrgId)) {
            this.getModel().setValue("org", (Object)currentOrgId);
            this.getModel().setValue("compareorg", (Object)currentOrgId);
            this.getView().updateView("org");
            this.getView().updateView("compareorg");
        }
        org = this.getModel().getDataEntity().getDynamicObject("org");
        String appnum = AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView());
        this.setCostAccount(org, appnum);
        this.setCurrency();
        this.setStartAndEndPeriod();
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"CostAnalyzeByOrgRptPlugin_12", (String)"macc-sca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"CostAnalyzeByOrgRptPlugin_14", (String)"macc-sca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
    }
}

