/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang.StringUtils;

public class CostAnalyzeByOrgRptQuery
extends AbstractReportListDataPlugin {
    private static List<String> QTYS = Collections.unmodifiableList(Arrays.asList("curqty", "curqty1", "cursumqty", "cursumqty1"));
    private static List<String> AMTS = Collections.unmodifiableList(Arrays.asList("curprice", "curprice1", "curunitamt", "curunitamt1", "cursumamt", "cursumamt1"));
    private static String selectFileds = "entryperiod,productnum,auxprop,level,element,subelement,entrymaterialtype,material,submaterialauxprop,curqty,curprice,curunitamt,cursumqty,cursumamt,curqty1,curprice1,curunitamt1,cursumqty1,cursumamt1,sumheadqty,sumheadamount,sumheadqty1,sumheadamount1,entrycurrency,treepath,istop,datatype,qtydif,unitamtdif,unitamtdifrate,unitamtdifratio,affectdif";

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        FilterInfo filterInfo = reportQueryParam.getFilter();
        this.init(filterInfo, params);
        if (params.containsKey("notQuery")) {
            return Algo.create((String)"dataset").createDataSet(new ArrayList(10).iterator(), new RowMeta(new Field[]{new Field("entryperiod", (DataType)DataType.StringType)}));
        }
        DataSet dataSet = this.queryDataSet(filterInfo, params);
        if (dataSet.isEmpty()) {
            return Algo.create((String)"dataset").createDataSet(new ArrayList(10).iterator(), dataSet.getRowMeta());
        }
        Boolean onlySumRow = (Boolean)params.get("onlysumrow");
        Boolean onlyMaterialType = (Boolean)params.get("onlymaterialtype");
        int level = (Integer)params.get("level");
        Boolean sumByPeriod = (Boolean)params.get("sumbyperiod");
        if (!onlyMaterialType.booleanValue()) {
            dataSet = this.dealMaterialGroup(dataSet);
            dataSet = onlySumRow != false || level == 0 ? dataSet.orderBy(new String[]{"istop", "entryperiod", "datatype", "productnum"}) : (sumByPeriod != false ? dataSet.orderBy(new String[]{"istop", "datatype", "productnum", "auxprop", "treepath", "level"}) : dataSet.orderBy(new String[]{"istop", "entryperiod", "datatype", "productnum", "auxprop", "treepath", "level"}));
        }
        int pricePrecision = (Integer)params.get("priceprecision");
        return this.dealResultDataSet(dataSet, pricePrecision).select("entryperiod,productnum,auxprop,level,element,subelement,entrymaterialtype,material,submaterialauxprop,case when curqty = 0 then '' else cast(curqty as String) end curqty,cursumqty,curprice,curunitamt,cursumamt,case when curqty1 = 0 then '' else cast(curqty1 as String) end curqty1,cursumqty1,curprice1,curunitamt1,cursumamt1,entrycurrency,treepath,istop,case when qtydif = 0 then '' else cast(qtydif as String) end qtydif,case when unitamtdif = 0 then '' else cast(unitamtdif as String) end unitamtdif,cast(unitamtdifrate as String)+'%' as unitamtdifrate,cast(unitamtdifratio as String)+'%' as unitamtdifratio,cast(affectdif as String)+'%' as affectdif");
    }

    private DataSet dealMaterialGroup(DataSet resultDs) {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        DynamicObject materialgrpstd = filterInfo.getDynamicObject("materialgrpstd");
        if (materialgrpstd != null && materialgrpstd.getLong("id") != 730148448254487552L) {
            DataSet materialDataSet = MaterialGroupHelper.getClassifiedMaterialDataSet(null, (boolean)false, (DynamicObject)materialgrpstd);
            ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(resultDs.getRowMeta().getFieldNames()));
            fieldNames.remove("entrymaterialtype");
            fieldNames.add("case when materialgroup is null then entrymaterialtype else materialgroup end as entrymaterialtype");
            return resultDs.leftJoin(materialDataSet).on("material", "material").select(resultDs.getRowMeta().getFieldNames(), new String[]{"materialgroup"}).finish().select(fieldNames.toArray(new String[0]));
        }
        return resultDs;
    }

    private DataSet queryDataSet(FilterInfo filterInfo, Map<String, Object> params) {
        Boolean onlySumRow = (Boolean)params.get("onlysumrow");
        Boolean onlyMaterialType = (Boolean)params.get("onlymaterialtype");
        int level = (Integer)params.get("level");
        Boolean sumByPeriod = (Boolean)params.get("sumbyperiod");
        List<QFilter> qFilterList = this.getQFilter(filterInfo, Boolean.FALSE);
        List<QFilter> compQFilterList = this.getQFilter(filterInfo, Boolean.TRUE);
        DataSet mainProductDataSet = this.getProductDataSet(qFilterList, Boolean.FALSE);
        DataSet mainCompProductDataSet = this.getProductDataSet(compQFilterList, Boolean.TRUE);
        DataSet productDataSet = this.combineProdAndCompareProdDataSet(mainProductDataSet, mainCompProductDataSet);
        DataSet periodSumDataSet = this.getPeriodSumDataSet(productDataSet);
        DataSet totalSumDataSet = this.getTotalSumDataSet(periodSumDataSet);
        if (onlySumRow.booleanValue() || level == 0) {
            return productDataSet.union(periodSumDataSet).union(totalSumDataSet);
        }
        int displaylevel = filterInfo.getInt("displaylevel");
        if (displaylevel != 0) {
            QFilter levelFilter = new QFilter("entryentity.level", "<=", (Object)displaylevel);
            qFilterList.add(levelFilter);
            compQFilterList.add(levelFilter);
        }
        qFilterList.add(new QFilter("entryentity.level", ">", (Object)0));
        compQFilterList.add(new QFilter("entryentity.level", ">", (Object)0));
        DataSet normalProdDataSet = this.getNormalDataSet(qFilterList, Boolean.FALSE);
        DataSet normalCompProdDataSet = this.getNormalDataSet(compQFilterList, Boolean.TRUE);
        DataSet normalDataSet = this.combineProdAndCompareProdDataSet(normalProdDataSet, normalCompProdDataSet);
        if (onlyMaterialType.booleanValue()) {
            DataSet materialType = this.showWithMaterialType(normalDataSet);
            productDataSet = this.dealMaterialGroup(productDataSet);
            return materialType.union(productDataSet.select(materialType.getRowMeta().getFieldNames())).union(periodSumDataSet).union(totalSumDataSet).orderBy(new String[]{"istop", "entryperiod", "datatype", "productnum", "treepath", "level"});
        }
        if (sumByPeriod.booleanValue()) {
            DataSet resultDataSet = productDataSet.union(normalDataSet);
            DataSet sumDataSetByPeriod = this.getSumDataSetByPeriod(resultDataSet);
            totalSumDataSet = this.getTotalSumDataSet(sumDataSetByPeriod.copy().filter("level == '0'"));
            return sumDataSetByPeriod.union(totalSumDataSet);
        }
        return productDataSet.union(normalDataSet).union(periodSumDataSet).union(totalSumDataSet);
    }

    private DataSet getSumDataSetByPeriod(DataSet productDataSet) {
        DataSet total = productDataSet.copy().groupBy(new String[]{"productnum", "auxprop", "element", "subelement", "entrycurrency", "material", "submaterialauxprop", "entrymaterialtype", "level", "treepath", "istop", "datatype"}).sum("curqty").sum("curunitamt").sum("curqty1").sum("curunitamt1").sum("cursumqty").sum("cursumamt").sum("cursumqty1").sum("cursumamt1").sum("sumheadqty").sum("sumheadqty1").sum("sumheadamount").sum("sumheadamount1").finish().select(new String[]{"0 as entryperiod", "0 as entryprodorg", "productnum", "auxprop", "level", "element", "subelement", "material", "submaterialauxprop", "entrymaterialtype", "case when sumheadqty = 0 then 0 else cursumqty/sumheadqty end curqty", "case when cursumqty = 0 then 0 else cursumamt/cursumqty end curprice", "case when sumheadqty = 0 then 0 else cursumamt/sumheadqty end curunitamt", "cursumqty", "cursumamt", "case when sumheadqty1 = 0 then 0 else cursumqty1/sumheadqty1 end curqty1", "case when cursumqty1 = 0 then 0 else cursumamt1/cursumqty1 end curprice1", "case when sumheadqty1 = 0 then 0 else cursumamt1/sumheadqty1 end curunitamt1", "cursumqty1", "cursumamt1", "sumheadqty", "sumheadamount", "sumheadqty1", "sumheadamount1", "entrycurrency", "treepath", "istop", "datatype", "curunitamt-curunitamt as qtydif", "curunitamt-curunitamt as unitamtdif", "curunitamt-curunitamt as unitamtdifrate", "curunitamt-curunitamt as unitamtdifratio", "curunitamt-curunitamt as affectdif"});
        return total.groupBy(selectFileds.split(",")).finish();
    }

    private DataSet getPeriodSumDataSet(DataSet zeroLevel) {
        String sum = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CostAnalyzeByOrgRptQuery_1", (String)"macc-sca-report", (Object[])new Object[0]);
        DataSet total = zeroLevel.copy().groupBy(new String[]{"entryperiod", "entrycurrency"}).sum("cursumqty").sum("cursumqty1").sum("curunitamt").sum("curunitamt1").sum("cursumamt").sum("cursumamt1").finish().select(new String[]{"entryperiod", "0 as entryprodorg", "0 as productnum", "0 as auxprop", "'" + sum + "' as level", "'' as element", "'' as subelement", "0 as material", "0 as submaterialauxprop", "0 as entrymaterialtype", "0 as curqty", "0 as curprice", "curunitamt", "cursumqty", "cursumamt", "0 as curqty1", "0 as curprice1", "curunitamt1", "cursumqty1", "cursumamt1", "0 as sumheadqty", "0 as sumheadamount", "0 as sumheadqty1", "0 as sumheadamount1", "entrycurrency", "'' as treepath", "1 as istop", "'1' as datatype", "curunitamt-curunitamt as qtydif", "curunitamt-curunitamt as unitamtdif", "curunitamt-curunitamt as unitamtdifrate", "curunitamt-curunitamt as unitamtdifratio", "curunitamt-curunitamt as affectdif"});
        return total.groupBy(selectFileds.split(",")).finish();
    }

    private DataSet getTotalSumDataSet(DataSet zeroLevel) {
        String sum = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CostAnalyzeByOrgRptQuery_1", (String)"macc-sca-report", (Object[])new Object[0]);
        DataSet total = zeroLevel.copy().groupBy(new String[]{"entrycurrency"}).sum("cursumqty").sum("cursumqty1").sum("curunitamt").sum("curunitamt1").sum("cursumamt").sum("cursumamt1").finish().select(new String[]{"0 as entryperiod", "0 as entryprodorg", "0 as productnum", "0 as auxprop", "'" + sum + "' as level", "'' as element", "'' as subelement", "0 as material", "0 as submaterialauxprop", "0 as entrymaterialtype", "0 as curqty", "0 as curprice", "curunitamt", "cursumqty", "cursumamt", "0 as curqty1", "0 as curprice1", "curunitamt1", "cursumqty1", "cursumamt1", "0 as sumheadqty", "0 as sumheadamount", "0 as sumheadqty1", "0 as sumheadamount1", "entrycurrency", "'' as treepath", "2 as istop", "'2' as datatype", "curunitamt-curunitamt as qtydif", "curunitamt-curunitamt as unitamtdif", "curunitamt-curunitamt as unitamtdifrate", "curunitamt-curunitamt as unitamtdifratio", "curunitamt-curunitamt as affectdif"});
        return total.groupBy(selectFileds.split(",")).finish();
    }

    private DataSet combineProdAndCompareProdDataSet(DataSet productDataSet, DataSet compProductDataSet) {
        DataSet dataSet1 = productDataSet.join(compProductDataSet, JoinType.LEFT).on("entryperiod", "entryperiod").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").on("element", "element").on("subelement", "subelement").on("material", "material").on("submaterialver", "submaterialver").on("submaterialauxprop", "submaterialauxprop").on("entrymaterialtype", "entrymaterialtype").on("level", "level").on("treepath", "treepath").on("istop", "istop").on("datatype", "datatype").select(productDataSet.getRowMeta().getFieldNames(), new String[]{"curqty1", "curprice1", "curunitamt1", "cursumqty1", "cursumamt1", "sumheadqty1", "sumheadamount1", "curunitamt-curunitamt as qtydif", "curunitamt-curunitamt as unitamtdif", "curunitamt-curunitamt as unitamtdifrate", "curunitamt-curunitamt as unitamtdifratio", "curunitamt-curunitamt as affectdif"}).finish();
        DataSet dataSet2 = productDataSet.join(compProductDataSet, JoinType.RIGHT).on("entryperiod", "entryperiod").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").on("element", "element").on("subelement", "subelement").on("material", "material").on("submaterialver", "submaterialver").on("submaterialauxprop", "submaterialauxprop").on("entrymaterialtype", "entrymaterialtype").on("level", "level").on("treepath", "treepath").on("istop", "istop").on("datatype", "datatype").select(new String[]{"curqty", "curprice", "curunitamt", "cursumqty", "cursumamt", "sumheadqty", "sumheadamount", "curunitamt-curunitamt as qtydif", "curunitamt-curunitamt as unitamtdif", "curunitamt-curunitamt as unitamtdifrate", "curunitamt-curunitamt as unitamtdifratio", "curunitamt-curunitamt as affectdif"}, compProductDataSet.getRowMeta().getFieldNames()).finish();
        return dataSet1.select(selectFileds).union(dataSet2.select(selectFileds)).groupBy(selectFileds.split(",")).finish();
    }

    private DataSet dealResultDataSet(DataSet resultDataSet, int pricePrecision) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        RowMeta rowMeta = resultDataSet.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        int len = resultDataSet.getRowMeta().getFields().length;
        HashMap<String, BigDecimal> productAndUnitAmt = new HashMap<String, BigDecimal>(16);
        HashMap<Long, List<Long>> noUnitAmtForProduct = new HashMap<Long, List<Long>>(16);
        Map<Long, Integer> matAndPrecision = this.getMatAndPrecision(resultDataSet.copy(), productAndUnitAmt, noUnitAmtForProduct);
        String sum = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CostAnalyzeByOrgRptQuery_1", (String)"macc-sca-report", (Object[])new Object[0]);
        while (resultDataSet.hasNext()) {
            Row row = resultDataSet.next();
            if (row == null) continue;
            Long productNum = row.getLong("productnum");
            List noUnitAmtProductList = (List)noUnitAmtForProduct.get(row.getLong("entryperiod"));
            if (noUnitAmtProductList != null && noUnitAmtProductList.contains(productNum) || sum.equals(row.getString("level")) && CadEmptyUtils.isEmpty((BigDecimal)row.getBigDecimal("curunitamt")) && CadEmptyUtils.isEmpty((BigDecimal)row.getBigDecimal("curunitamt1"))) continue;
            String key = String.valueOf(productNum);
            if (row.getString("entryperiod") != null) {
                key = row.getString("entryperiod") + key;
            }
            BigDecimal curqty = row.getBigDecimal("curqty") == null ? BigDecimal.ZERO : row.getBigDecimal("curqty");
            BigDecimal curqty1 = row.getBigDecimal("curqty1") == null ? BigDecimal.ZERO : row.getBigDecimal("curqty1");
            BigDecimal curunitamt = row.getBigDecimal("curunitamt") == null ? BigDecimal.ZERO : row.getBigDecimal("curunitamt");
            BigDecimal curunitamt1 = row.getBigDecimal("curunitamt1") == null ? BigDecimal.ZERO : row.getBigDecimal("curunitamt1");
            BigDecimal productUnitAmt = productAndUnitAmt.get(key) == null || ((BigDecimal)productAndUnitAmt.get(key)).compareTo(BigDecimal.ZERO) == 0 ? curunitamt : (BigDecimal)productAndUnitAmt.get(key);
            BigDecimal qtydif = curqty.subtract(curqty1);
            BigDecimal unitamtdif = curunitamt.subtract(curunitamt1);
            productUnitAmt = productUnitAmt.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : productUnitAmt;
            BigDecimal unitamtdifrate = curunitamt.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : unitamtdif.divide(curunitamt, 4, RoundingMode.HALF_UP);
            BigDecimal unitamtdifratio = curunitamt.divide(productUnitAmt.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : productUnitAmt, pricePrecision, RoundingMode.HALF_UP);
            BigDecimal affectdif = unitamtdifrate.multiply(unitamtdifratio);
            int precision = !CadEmptyUtils.isEmpty((Long)row.getLong("material")) && matAndPrecision.get(row.getLong("material")) != null ? matAndPrecision.get(row.getLong("material")) : 10;
            Object[] obj = new Object[len];
            boolean isZero = true;
            for (int i = 0; i < len; ++i) {
                obj[i] = row.get(i);
                if (QTYS.contains(fieldNames[i]) && row.getBigDecimal(i) != null) {
                    obj[i] = row.getBigDecimal(i).setScale(precision, 4);
                    if (BigDecimal.ZERO.compareTo((BigDecimal)obj[i]) == 0) continue;
                    isZero = false;
                    continue;
                }
                if (AMTS.contains(fieldNames[i]) && row.getBigDecimal(i) != null && BigDecimal.ZERO.compareTo(row.getBigDecimal(i)) != 0) {
                    isZero = false;
                }
                if ("qtydif".equals(fieldNames[i])) {
                    obj[i] = qtydif.setScale(precision, 4).toPlainString();
                }
                if ("unitamtdif".equals(fieldNames[i])) {
                    obj[i] = unitamtdif;
                }
                if ("unitamtdifrate".equals(fieldNames[i])) {
                    obj[i] = unitamtdifrate.multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP);
                }
                if ("unitamtdifratio".equals(fieldNames[i])) {
                    obj[i] = unitamtdifratio.multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP);
                }
                if (!"affectdif".equals(fieldNames[i])) continue;
                obj[i] = affectdif.multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP);
            }
            if (isZero) continue;
            dataList.add(obj);
        }
        return Algo.create((String)"macc.sca.rpt").createDataSet(dataList.iterator(), rowMeta);
    }

    private DataSet getNormalDataSet(List<QFilter> qFilterList, Boolean isCompareProdOrg) {
        String curqty = "curqty";
        String curprice = "curprice";
        String curunitamt = "curunitamt";
        String cursumqty = "cursumqty";
        String cursumamt = "cursumamt";
        String sumheadqty = "sumheadqty";
        String sumheadamount = "sumheadamount";
        if (isCompareProdOrg.booleanValue()) {
            curqty = "curqty1";
            curprice = "curprice1";
            curunitamt = "curunitamt1";
            cursumqty = "cursumqty1";
            cursumamt = "cursumamt1";
            sumheadqty = "sumheadqty1";
            sumheadamount = "sumheadamount1";
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.report.CostAnalyzeRptQuery#getNormalDataSet", (String)"sca_costrecovry", (String)("id,period as entryperiod,org,material as productnum,materialver as materialver,auxprop,concat('',entryentity.level) as level,entryentity.element.name as element,entryentity.subelement.name as subelement,entryentity.submaterial as material,entryentity.submaterialver as submaterialver,entryentity.submaterialauxprop as submaterialauxprop,entryentity.submaterial.group as entrymaterialtype,headqty as " + sumheadqty + ",headamount as " + sumheadamount + ",entryentity.qty as " + cursumqty + ",entryentity.amount as " + cursumamt + ",currency as entrycurrency,entryentity.treepath as treepath,1 as istop,'0' as datatype"), (QFilter[])qFilterList.toArray(new QFilter[0]), null);
        DataSet headQtySet = dataSet.copy().groupBy(new String[]{"id", "entryperiod", "productnum", "materialver", "auxprop", sumheadqty, sumheadamount}).finish().groupBy(new String[]{"entryperiod", "productnum", "materialver", "auxprop"}).sum(sumheadqty).sum(sumheadamount).finish();
        dataSet = dataSet.groupBy(new String[]{"entryperiod", "productnum", "materialver", "auxprop", "level", "element", "subelement", "material", "submaterialver", "submaterialauxprop", "entrymaterialtype", "entrycurrency", "treepath", "istop", "datatype"}).sum(cursumqty).sum(cursumamt).finish();
        dataSet = dataSet.leftJoin(headQtySet).on("entryperiod", "entryperiod").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").select(dataSet.getRowMeta().getFieldNames(), new String[]{sumheadqty, sumheadamount}).finish();
        String selectFields = "entryperiod,productnum,materialver,auxprop,level,element,subelement,material,submaterialver,submaterialauxprop,case when " + sumheadqty + " = 0 then 0 else " + cursumqty + "/" + sumheadqty + " end " + curqty + ",case when " + cursumqty + " = 0 then 0 else " + cursumamt + "/" + cursumqty + " end " + curprice + ",case when " + sumheadqty + " = 0 then 0 else " + cursumamt + "/" + sumheadqty + " end " + curunitamt + "," + cursumqty + "," + cursumamt + "," + sumheadqty + "," + sumheadamount + ",entrymaterialtype,entrycurrency,treepath,istop,datatype";
        return dataSet.select(selectFields);
    }

    private DataSet getProductDataSet(List<QFilter> qFilterList, Boolean isCompareProdOrg) {
        String curqty = "curqty";
        String curprice = "curprice";
        String curunitamt = "curunitamt";
        String cursumqty = "cursumqty";
        String cursumamt = "cursumamt";
        String sumheadqty = "sumheadqty";
        String sumheadamount = "sumheadamount";
        if (isCompareProdOrg.booleanValue()) {
            curqty = "curqty1";
            curprice = "curprice1";
            curunitamt = "curunitamt1";
            cursumqty = "cursumqty1";
            cursumamt = "cursumamt1";
            sumheadqty = "sumheadqty1";
            sumheadamount = "sumheadamount1";
        }
        String mat = ResManager.loadKDString((String)"\u7269\u6599", (String)"CostAnalyzeByOrgRptQuery_3", (String)"macc-sca-report", (Object[])new Object[0]);
        String pro = ResManager.loadKDString((String)"\u4ea7\u54c1\u7ea7", (String)"CostAnalyzeByOrgRptQuery_4", (String)"macc-sca-report", (Object[])new Object[0]);
        DataSet curSum = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.report.CostAnalyzeByMOrgRptQuery#getProductDataSet", (String)"sca_costrecovry", (String)("id,period as entryperiod,org,material as productnum,materialver as materialver,auxprop,'0' as level,'" + mat + "' as element,'" + pro + "' as subelement,material as material,materialver as submaterialver,auxprop as submaterialauxprop,material.group as entrymaterialtype,headqty as " + sumheadqty + ",headamount as " + sumheadamount + ",headqty as " + cursumqty + ",headamount as " + cursumamt + ",currency as entrycurrency,'' as treepath,1 as istop,'0' as datatype"), (QFilter[])qFilterList.toArray(new QFilter[0]), null);
        String selectFields = "entryperiod,productnum,materialver,auxprop,level,element,subelement,material,submaterialver,submaterialauxprop,case when " + sumheadqty + " = 0 then 0 else " + cursumqty + "/" + sumheadqty + " end " + curqty + ",case when " + cursumqty + " = 0 then 0 else " + cursumamt + "/" + cursumqty + " end " + curprice + ",case when " + sumheadqty + " = 0 then 0 else " + cursumamt + "/" + sumheadqty + " end " + curunitamt + "," + cursumqty + "," + cursumamt + "," + sumheadqty + "," + sumheadamount + ",entrymaterialtype,entrycurrency,treepath,istop,datatype";
        return curSum.groupBy(new String[]{"entryperiod", "productnum", "materialver", "auxprop", "level", "element", "subelement", "material", "submaterialver", "submaterialauxprop", "entrymaterialtype", "entrycurrency", "treepath", "istop", "datatype"}).sum(cursumqty).sum(cursumamt).sum(sumheadqty).sum(sumheadamount).finish().select(selectFields);
    }

    private Map<Long, Integer> getMatAndPrecision(DataSet resultDataSet, Map<String, BigDecimal> productAndUnitAmt, Map<Long, List<Long>> noUnitAmtForProduct) {
        HashSet<Long> matIds = new HashSet<Long>(10);
        while (resultDataSet.hasNext()) {
            Row row = resultDataSet.next();
            if (row == null) continue;
            matIds.add(row.getLong("material"));
            if ("0".equals(row.getString("level")) && CadEmptyUtils.isEmpty((BigDecimal)row.getBigDecimal("curunitamt")) && CadEmptyUtils.isEmpty((BigDecimal)row.getBigDecimal("curunitamt1"))) {
                noUnitAmtForProduct.computeIfAbsent(row.getLong("entryperiod"), p -> new ArrayList()).add(row.getLong("productnum"));
                continue;
            }
            if (!"0".equals(row.getString("level")) || CadEmptyUtils.isEmpty((Long)row.getLong("productnum"))) continue;
            String entryperiod = row.getString("entryperiod");
            if (entryperiod != null) {
                productAndUnitAmt.put(row.getString("entryperiod") + row.getString("productnum"), row.getBigDecimal("curunitamt"));
                continue;
            }
            productAndUnitAmt.put(row.getString("productnum"), row.getBigDecimal("curunitamt"));
        }
        QFilter matFilter = new QFilter("masterid", "in", matIds);
        DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)"macc.sca.rpt", (String)"bd_material", (String)"masterid as materialid,baseunit as unitid,baseunit.name as unit", (QFilter[])new QFilter[]{matFilter}, null);
        DataSet unitDataSet = QueryServiceHelper.queryDataSet((String)"macc.sca.rpt", (String)"bd_measureunits", (String)"id as unitid,precision", null, null);
        DataSet dataSet = materialDataSet.join(unitDataSet, JoinType.INNER).on("unitid", "unitid").select(new String[]{"materialid", "precision"}).finish();
        HashMap<Long, Integer> matAndPrecision = new HashMap<Long, Integer>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (row == null || matAndPrecision.get(row.getLong("materialid")) != null) continue;
            matAndPrecision.put(row.getLong("materialid"), row.getInteger("precision"));
        }
        return matAndPrecision;
    }

    private DataSet showWithMaterialType(DataSet normalDataRow) {
        DataSet normalDataSet = this.dealMaterialGroup(normalDataRow);
        DataSet matsDataSet = normalDataSet.copy();
        int len = normalDataSet.getRowMeta().getFields().length;
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        HashMap<String, String> matAndTypes = new HashMap<String, String>(16);
        while (matsDataSet.hasNext()) {
            Row row = matsDataSet.next();
            if (row == null || CadEmptyUtils.isEmpty((Long)row.getLong("material"))) continue;
            matAndTypes.put(row.getString("material"), row.getString("entrymaterialtype"));
        }
        String appnum = this.getQueryParam().getFilter().getString("appnum");
        while (normalDataSet.hasNext()) {
            Row row = normalDataSet.next();
            Object[] dataRow = new Object[len];
            for (int i = 0; i < len; ++i) {
                if ("treepath".equals(normalDataSet.getRowMeta().getField(i).getName()) && row.getString("treepath") != null) {
                    String treePath = row.getString("treepath");
                    Object[] split = treePath.split("@");
                    int end = split.length;
                    boolean isResurce = false;
                    if (end >= 2 && "0".equals(split[end - 2])) {
                        isResurce = true;
                    }
                    for (int j = 0; j < split.length; ++j) {
                        split[j] = matAndTypes.containsKey(split[j]) ? (String)matAndTypes.get(split[j]) : "0";
                    }
                    String newPath = StringUtils.join((Object[])split, (String)"@", (int)0, (int)end);
                    if (isResurce) {
                        newPath = StringUtils.join((Object[])split, (String)"@", (int)0, (int)(end - 1));
                    }
                    dataRow[i] = newPath;
                    continue;
                }
                dataRow[i] = row.get(i);
            }
            dataList.add(dataRow);
        }
        DataSet dataSet = Algo.create((String)"macc.sca.rpt").createDataSet(dataList.iterator(), normalDataSet.getRowMeta()).groupBy(new String[]{"entryperiod", "productnum", "auxprop", "level", "element", "subelement", "entrymaterialtype", "entrycurrency", "treepath", "istop", "datatype"}).sum("curqty").sum("curunitamt").sum("curqty1").sum("curunitamt1").sum("cursumqty").sum("cursumamt").sum("cursumqty1").sum("cursumamt1").max("sumheadqty").max("sumheadqty1").max("sumheadamount").max("sumheadamount1").finish().select(new String[]{"entryperiod", "productnum", "auxprop", "level", "element", "subelement", "0 material", "0 submaterialauxprop", "entrymaterialtype", "case when sumheadqty = 0 then 0 else cursumqty/sumheadqty end curqty", "case when cursumqty = 0 then 0 else cursumamt/cursumqty end curprice", "case when sumheadqty = 0 then 0 else cursumamt/sumheadqty end curunitamt", "cursumqty", "cursumamt", "case when sumheadqty1 = 0 then 0 else cursumqty1/sumheadqty1 end curqty1", "case when cursumqty1 = 0 then 0 else cursumamt1/cursumqty1 end curprice1", "case when sumheadqty1 = 0 then 0 else cursumamt1/sumheadqty1 end curunitamt1", "cursumqty1", "cursumamt1", "sumheadqty", "sumheadamount", "sumheadqty1", "sumheadamount1", "entrycurrency", "treepath", "istop", "datatype", "curunitamt-curunitamt as qtydif", "curunitamt-curunitamt as unitamtdif", "curunitamt-curunitamt as unitamtdifrate", "curunitamt-curunitamt as unitamtdifratio", "curunitamt-curunitamt as affectdif"});
        return dataSet.select(selectFileds);
    }

    private List<QFilter> getQFilter(FilterInfo filterInfo, Boolean isCompareProdOrg) {
        List<QFilter> filterList = this.getCommonQFilter(filterInfo);
        if (isCompareProdOrg.booleanValue()) {
            filterList.addAll(this.getCompareProdOrgDataQFilter(filterInfo));
        } else {
            filterList.addAll(this.getProdOrgDataQFilter(filterInfo));
        }
        return filterList;
    }

    private List<QFilter> getProdOrgDataQFilter(FilterInfo filterInfo) {
        DynamicObject costaccount;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        DynamicObject org = filterInfo.getDynamicObject("org");
        if (org != null) {
            qFilterList.add(new QFilter("org", "=", (Object)((Long)org.getPkValue())));
        }
        if ((costaccount = filterInfo.getDynamicObject("costaccount")) != null) {
            qFilterList.add(new QFilter("costaccount", "=", (Object)((Long)costaccount.getPkValue())));
        }
        return qFilterList;
    }

    private List<QFilter> getCompareProdOrgDataQFilter(FilterInfo filterInfo) {
        DynamicObject compareCostAccount;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        DynamicObject compareOrg = filterInfo.getDynamicObject("compareorg");
        if (compareOrg != null) {
            qFilterList.add(new QFilter("org", "=", (Object)((Long)compareOrg.getPkValue())));
        }
        if ((compareCostAccount = filterInfo.getDynamicObject("comparecostaccount")) != null) {
            qFilterList.add(new QFilter("costaccount", "=", (Object)((Long)compareCostAccount.getPkValue())));
        }
        return qFilterList;
    }

    private List<QFilter> getCommonQFilter(FilterInfo filterInfo) {
        DynamicObjectCollection mulmaterial;
        DynamicObjectCollection mulproduct;
        DynamicObject endperiod;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        DynamicObject startperiod = filterInfo.getDynamicObject("startperiod");
        if (startperiod != null) {
            qFilterList.add(new QFilter("period", ">=", (Object)((Long)startperiod.getPkValue())));
        }
        if ((endperiod = filterInfo.getDynamicObject("endperiod")) != null) {
            qFilterList.add(new QFilter("period", "<=", (Object)((Long)endperiod.getPkValue())));
        }
        if ((mulproduct = filterInfo.getDynamicObjectCollection("mulproduct")) != null && mulproduct.size() > 0) {
            Set collect = mulproduct.stream().map(a -> (Long)a.getPkValue()).collect(Collectors.toSet());
            qFilterList.add(new QFilter("material", "in", collect));
        }
        if ((mulmaterial = filterInfo.getDynamicObjectCollection("mulmaterial")) != null && mulmaterial.size() > 0) {
            Set collect = mulmaterial.stream().map(a -> (Long)a.getPkValue()).collect(Collectors.toSet());
            qFilterList.add(new QFilter("entryentity.submaterial", "in", collect));
        } else {
            DynamicObjectCollection materialtype = filterInfo.getDynamicObjectCollection("mulmaterialtype");
            DynamicObject materialgrpstd = filterInfo.getDynamicObject("materialgrpstd");
            if (materialtype != null || materialgrpstd != null && materialgrpstd.getLong("id") != 730148448254487552L) {
                Set materialIds = MaterialGroupHelper.getClassifiedMaterialId((DynamicObjectCollection)materialtype, (boolean)false, (DynamicObject)materialgrpstd, (boolean)true);
                qFilterList.add(InFilterHelper.getQFilterByBachSize((String)"entryentity.submaterial", new ArrayList(materialIds), (String)"in", (int)20000));
            }
        }
        return qFilterList;
    }

    private void init(FilterInfo filterInfo, Map<String, Object> params) {
        params.put("onlysumrow", filterInfo.getBoolean("onlysumrow"));
        params.put("onlymaterialtype", filterInfo.getBoolean("onlymaterialtype"));
        params.put("sumbyperiod", filterInfo.getBoolean("sumbyperiod"));
        params.put("priceprecision", filterInfo.getDynamicObject("currency").getInt("priceprecision"));
        params.put("level", filterInfo.getInt("displaylevel"));
        if (filterInfo.containProp("notQuery")) {
            params.put("notQuery", "true");
        }
    }
}

