/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class CostAnalyzeRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void registerListener(EventObject e) {
        BasedataEdit costaccount = (BasedataEdit)this.getControl("costaccount");
        costaccount.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit period = (BasedataEdit)this.getControl("period");
        period.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit queryperiod = (BasedataEdit)this.getControl("queryperiod");
        queryperiod.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialgrpstd = (BasedataEdit)this.getControl("materialgrpstd");
        materialgrpstd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit mulproduct = (MulBasedataEdit)this.getControl("mulproduct");
        mulproduct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costtype = (BasedataEdit)this.getControl("costtype");
        costtype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit prodorg = (BasedataEdit)this.getControl("prodorg");
        prodorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"calcrecord"});
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        String appId = AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView());
        filterInfo.addFilterItem("appnum", (Object)appId, "=");
        DynamicObject costaccount = filterInfo.getDynamicObject("costaccount");
        HashSet accSet = Sets.newHashSet();
        accSet.add(costaccount.getLong("id"));
        Set<Long> allCostaccountSet = this.getCostAccountF7Id(appId);
        accSet.removeAll(allCostaccountSet);
        if (!accSet.isEmpty()) {
            filterInfo.addFilterItem("notQuery", (Object)true, "=");
        }
        queryParam.setFilter(filterInfo);
    }

    private Set<Long> getCostAccountF7Id(String appNum) {
        List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        QFilter orgFilter = new QFilter("org", "in", (Object)permAccountOrgIds);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)appNum);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, appnumFilter};
        DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filters);
        if (!costAccountIds.isEmpty()) {
            return costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toSet());
        }
        return Sets.newHashSet();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!"sca".equals(AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"querydate", "queryperiod"});
            this.getModel().setValue("querydate", null);
            this.getView().setVisible(Boolean.TRUE, new String[]{"costtype"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"costtype", "calcrecord"});
        }
        this.displayProdOrg(false);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"org"});
        if (this.getModel().getValue("prodorg") != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"prodorg"});
            this.getPageCache().put("prdorg_mustInput", "Y");
            BasedataEdit prodorg = (BasedataEdit)this.getControl("prodorg");
            prodorg.setMustInput(true);
            return;
        }
        this.init();
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        ArrayList<Long> createOrgIds = new ArrayList<Long>(10);
        if (org != null) {
            createOrgIds.add(org.getLong("id"));
        }
        DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
        switch (name) {
            case "org": {
                List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
                QFilter idFilter = new QFilter("id", "in", (Object)permAccountOrgIds);
                listShowParameter.getListFilterParameter().getQFilters().add(idFilter);
                break;
            }
            case "costaccount": {
                listShowParameter.getListFilterParameter().getQFilters().add(this.getCostAccountF7QFilter(AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView())));
                break;
            }
            case "period": {
                if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostAnalyzeRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if (org == null) break;
                listShowParameter.getListFilterParameter().getQFilters().add(StartCostHelper.getUsePeriodFilter((Long)Long.valueOf(String.valueOf(org.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccount.getPkValue()))));
                break;
            }
            case "queryperiod": {
                costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
                if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostAnalyzeRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                if (org == null) break;
                listShowParameter.getListFilterParameter().getQFilters().add(CostUpdateHelper.getRptPeriodQFilter((Long)Long.valueOf(String.valueOf(org.getPkValue())), (Long)Long.valueOf(String.valueOf(costAccount.getPkValue()))));
                break;
            }
            case "materialgrpstd": {
                Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, Boolean.TRUE});
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)ids));
                break;
            }
            case "mulproduct": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6253\u5f00\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostAnalyzeRptPlugin_1", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                QFilter matOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)org.getLong("id"));
                listShowParameter.getListFilterParameter().getQFilters().add(matOrgFilter);
                listShowParameter.setF7ClickByFilter(false);
                break;
            }
            case "costtype": {
                if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostAnalyzeRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObject currencyObj = (DynamicObject)this.getModel().getValue("currency");
                ListFilterParameter filterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
                QFilter filter = new QFilter("type", "=", (Object)"1");
                filter.and(new QFilter("currency", "=", currencyObj.get("id")));
                filterParameter.setFilter(filter);
                break;
            }
            case "prodorg": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostAnalyzeRptPlugin_0", (String)"macc-sca-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                List productOrgs = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org.getLong("id"), (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)productOrgs));
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        DynamicObject costtype;
        DynamicObject currency;
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("org");
        DynamicObject costaccount = filter.getDynamicObject("costaccount");
        if (costaccount == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostAnalyzeRptPlugin_2", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObject period = filter.getDynamicObject("period");
        if (period == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u671f\u95f4", (String)"CostAnalyzeRptPlugin_3", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObjectCollection mulproduct = filter.getDynamicObjectCollection("mulproduct");
        if (CollectionUtils.isEmpty((Collection)mulproduct)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ea7\u54c1", (String)"CostAnalyzeRptPlugin_4", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        if ("sca".equals(AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()))) {
            Boolean isUpdateByPeriod = CostUpdateHelper.isUpdateByPeriod((Long)org.getLong("id"), (Long)costaccount.getLong("id"));
            if (Boolean.TRUE.equals(isUpdateByPeriod) && filter.getDynamicObject("queryperiod") == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u671f\u95f4\u3002", (String)"CostAnalyzeRptPlugin_5", (String)"macc-sca-report", (Object[])new Object[0]));
            }
            if (Boolean.FALSE.equals(isUpdateByPeriod) && filter.getDate("querydate") == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u65f6\u95f4\u3002", (String)"CostAnalyzeRptPlugin_6", (String)"macc-sca-report", (Object[])new Object[0]));
            }
        }
        if ((currency = filter.getDynamicObject("currency")) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6210\u672c\u8d26\u7c3f\u7684\u5e01\u79cd\u3002", (String)"CostAnalyzeRptPlugin_7", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObject mulprodorg = (DynamicObject)this.getModel().getValue("prodorg");
        String needPrdorgCache = this.getPageCache().get("prdorg_mustInput");
        if ("Y".equals(needPrdorgCache) && CadEmptyUtils.isEmpty((DynamicObject)mulprodorg)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"CostAnalyzeRptPlugin_8", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        DynamicObject materialgrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd");
        if (materialgrpstd == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"CostAnalyzeRptPlugin_9", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        if (!"sca".equals(AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView())) && (costtype = (DynamicObject)this.getModel().getValue("costtype")) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u7c7b\u578b\u3002", (String)"CostAnalyzeRptPlugin_10", (String)"macc-sca-report", (Object[])new Object[0]));
        }
        return super.verifyQuery(queryParam);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        List columns = event.getColumns();
        boolean onlymaterialtype = this.getModel().getDataEntity().getBoolean("onlymaterialtype");
        String prdorgMustInput = this.getPageCache().get("prdorg_mustInput");
        for (AbstractReportColumn col : columns) {
            if (!(col instanceof ReportColumn)) continue;
            ReportColumn reportColumn = (ReportColumn)col;
            String key = reportColumn.getFieldKey();
            if ("material".equals(key) || "materialname".equals(key) || "materialbaseunit".equals(key)) {
                reportColumn.setHide(onlymaterialtype);
            }
            if (!"entryprodorg".equals(key) && !"entryprodorgname".equals(key) || !"N".equals(prdorgMustInput)) continue;
            reportColumn.setHide(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyname = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propertyname) {
            case "org": {
                break;
            }
            case "costaccount": {
                this.setOrg();
                this.setCurrency();
                this.setPeriod();
                this.displayProdOrg(true);
                this.dealQueryPeriod();
            }
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        String opType = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"CostAnalyzeRptPlugin_11", (String)"macc-sca-report", (Object[])new Object[0]);
        String checkType = ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"CostAnalyzeRptPlugin_13", (String)"macc-sca-report", (Object[])new Object[0]);
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
    }

    private void init() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
            return;
        }
        long currentOrgId = RequestContext.getOrCreate().getOrgId();
        boolean isaccount = OrgUnitServiceHelper.checkOrgFunction((Long)currentOrgId, (String)"10");
        List permAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (isaccount && permAccountOrgIds.contains(currentOrgId)) {
            this.getModel().setValue("org", (Object)currentOrgId);
            this.getView().updateView("org");
        }
        org = this.getModel().getDataEntity().getDynamicObject("org");
        this.setCostAccount(org);
        this.displayProdOrg(true);
        this.getModel().setValue("querydate", (Object)TimeServiceHelper.now());
        this.getView().updateView("querydate");
        this.dealQueryPeriod();
    }

    public void click(EventObject evt) {
        TextEdit textEdit;
        String key;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit && "calcrecord".equals(key = (textEdit = (TextEdit)source).getKey())) {
            this.showSelectPage(key);
        }
    }

    private void showSelectPage(String actionId) {
        List materialIds;
        DynamicObject costtype = this.getModel().getDataEntity().getDynamicObject("costtype");
        if (costtype == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u7c7b\u578b\u3002", (String)"CostAnalyzeRptPlugin_14", (String)"macc-sca-report", (Object[])new Object[0]));
            return;
        }
        ArrayList mulmaterial = Lists.newArrayList();
        DynamicObjectCollection mulMaterial = this.getModel().getDataEntity().getDynamicObjectCollection("mulproduct");
        if (mulMaterial != null && mulMaterial.size() > 0 && !CadEmptyUtils.isEmpty(materialIds = mulMaterial.stream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()))) {
            mulmaterial.addAll(materialIds);
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("cad_stdcalcrecord_text");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("costTypeId", costtype.get("id"));
        fsp.setCustomParam("materialIds", (Object)mulmaterial);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (returnDataObj instanceof Map) {
            Map returnData = (Map)returnDataObj;
            String value = String.valueOf(returnData.get("content"));
            String operateType = String.valueOf(returnData.get("operateType"));
            if ("btnok".equals(operateType)) {
                value = value.replaceAll("\n", ",");
                this.getModel().setValue(actionId, (Object)value);
            }
        } else if (returnDataObj instanceof String) {
            String value = (String)returnDataObj;
            this.getModel().setValue(actionId, (Object)value);
        }
    }

    private void displayProdOrg(boolean isClearProdOrg) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (isClearProdOrg) {
            this.getModel().setValue("prodorg", null);
        }
        if (org == null) {
            return;
        }
        BasedataEdit mulprodorg = (BasedataEdit)this.getControl("prodorg");
        DynamicObject costaccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("prodorg", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"prodorg"});
            mulprodorg.setMustInput(false);
            return;
        }
        QFilter filter = new QFilter("org", "=", org.getPkValue());
        filter.and(new QFilter("costaccount", "=", costaccount.getPkValue()));
        DynamicObject one = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)"id,restoredimension", (QFilter[])filter.toArray());
        if (one != null) {
            String restoredimension = one.getString("restoredimension");
            if ("A".equals(restoredimension)) {
                this.getModel().setValue("prodorg", null);
                this.getView().setVisible(Boolean.FALSE, new String[]{"prodorg"});
                this.getPageCache().put("prdorg_mustInput", "N");
                mulprodorg.setMustInput(false);
            } else if ("B".equals(restoredimension)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"prodorg"});
                this.getPageCache().put("prdorg_mustInput", "Y");
                mulprodorg.setMustInput(true);
            }
            this.getView().updateView("prodorg");
        } else {
            this.getModel().setValue("prodorg", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"prodorg"});
            this.getPageCache().put("prdorg_mustInput", "N");
            mulprodorg.setMustInput(false);
        }
    }

    private void setCostAccount(Object org) {
        if (org == null) {
            this.getModel().setValue("costaccount", null);
            this.getModel().setValue("period", null);
            this.getModel().setValue("currency", null);
            return;
        }
        Long mainBookId = this.getCostAccountByAccoutOrg(((DynamicObject)org).getLong("id"));
        if (mainBookId != 0L) {
            this.getModel().setValue("costaccount", (Object)mainBookId);
            this.getView().updateView("costaccount");
            this.setCurrency();
            this.setPeriod();
            return;
        }
        this.getModel().setValue("org", null);
        this.getModel().setValue("costaccount", null);
        this.getModel().setValue("period", null);
    }

    private Long getCostAccountByAccoutOrg(Long accountOrgId) {
        QFilter appNumQF;
        QFilter enable;
        String fields = "entryentity.costaccount.id id,entryentity.costaccount.name name,entryentity.costaccount.ismainaccount ismainaccount";
        QFilter orgFilter = new QFilter("org", "=", (Object)accountOrgId);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE), appNumQF = new QFilter("appnum", "=", (Object)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()))};
        DynamicObjectCollection result = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])filters, null);
        if (result == null || result.size() == 0) {
            return 0L;
        }
        if (result.size() == 1) {
            DynamicObject costaccount = (DynamicObject)result.get(0);
            return costaccount.getLong("id");
        }
        for (DynamicObject res : result) {
            if (!res.getBoolean("ismainaccount")) continue;
            return res.getLong("id");
        }
        return 0L;
    }

    private QFilter getCostAccountF7QFilter(String appNum) {
        List orgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        QFilter orgFilter = new QFilter("org", "in", (Object)orgIds);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)appNum);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, appnumFilter};
        DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filters);
        if (costAccountIds.size() > 0) {
            Set costAccountIdList = costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toSet());
            return new QFilter("id", "in", costAccountIdList);
        }
        return new QFilter("id", "=", (Object)0);
    }

    public void setOrg() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("org", null);
            return;
        }
        this.getModel().setValue("org", (Object)costaccount.getLong("calorg.id"));
    }

    public void setCurrency() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject costaccount = dataEntity.getDynamicObject("costaccount");
        if (costaccount == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            this.getModel().setValue("currency", null);
            return;
        }
        Long currency = result.getLong("currency");
        this.getModel().setValue("currency", (Object)currency);
        this.getView().updateView("currency");
    }

    private void setPeriod() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (org == null) {
            return;
        }
        DynamicObject costAccount = dataEntity.getDynamicObject("costaccount");
        if (costAccount == null) {
            this.getModel().setValue("period", null);
            return;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        DynamicObject res = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod currentperiod", (QFilter[])new QFilter[]{qfOrg, qfCostAccount});
        if (res != null) {
            Long currentperiod = res.getLong("currentperiod");
            this.getModel().setValue("period", (Object)currentperiod);
            this.getView().updateView("period");
        }
    }

    private void dealQueryPeriod() {
        if (!"sca".equals(AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()))) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject costAccount = (DynamicObject)this.getModel().getValue("costaccount");
        if (org == null || costAccount == null) {
            this.setQueryVisible(Boolean.FALSE, null, null);
            return;
        }
        Long orgId = org.getLong("id");
        Long costAccountId = costAccount.getLong("id");
        Boolean isUpdateByPeriod = CostUpdateHelper.isUpdateByPeriod((Long)orgId, (Long)costAccountId);
        this.setQueryVisible(isUpdateByPeriod, orgId, costAccountId);
    }

    private void setQueryVisible(Boolean isShow, Long orgId, Long costAccountId) {
        this.getView().setVisible(isShow, new String[]{"queryperiod"});
        BasedataEdit queryPeriod = (BasedataEdit)this.getControl("queryperiod");
        queryPeriod.setMustInput(isShow.booleanValue());
        if (Boolean.TRUE.equals(isShow)) {
            List periodIds = CostUpdateHelper.getPeriodIds((Long)orgId, (Long)costAccountId);
            this.getModel().setValue("queryperiod", periodIds.isEmpty() ? null : periodIds.get(0));
        } else {
            this.getModel().setValue("queryperiod", null);
        }
        this.getView().setVisible(Boolean.valueOf(isShow == false), new String[]{"querydate"});
        DateTimeEdit queryDate = (DateTimeEdit)this.getControl("querydate");
        queryDate.setMustInput(isShow == false);
        this.getModel().setValue("querydate", (Object)(Boolean.TRUE.equals(isShow == false) ? TimeServiceHelper.now() : null));
    }
}

