/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostUpdateHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class CostAnalyzeRptQuery
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(CostAnalyzeRptQuery.class);
    private static final String CUR_PERIOD = "0";
    private static final String PRE_PERIOD = "1";
    private static final String PRE_YEAR = "2";
    private static final String ALL_PERIOD = "3";
    private static final String PRE_ALL_PERIOD = "4";
    private static String[] curPeriod = new String[]{"curqty", "curprice", "curunitamt"};
    private static String[] prePeriod = new String[]{"preqty", "preprice", "preunitamt"};
    private static String[] preYearSamePeriod = new String[]{"preyearqty", "preyearprice", "preyearunitamt"};
    private static String[] curYearSumPeriod = new String[]{"curyearqty", "curyearavgprice", "curyearavgunitamt"};
    private static String[] preYearSumPeriod = new String[]{"preyearallqty", "preyearallavgprice", "preyearallavgunitamt"};
    private static List<String> QTYS = Collections.unmodifiableList(Arrays.asList("stdqty", "curqty", "preqty", "presumqty", "preyearqty", "preyearsumqty", "curyearqty", "curyearavgqty", "cursumqty", "curyearsumqty", "preyearallqty", "preyearallavgqty", "preyearallsumqty"));
    private static List<String> qtyAndAmts = Collections.unmodifiableList(Arrays.asList("stdqty", "curqty", "preqty", "presumqty", "preyearqty", "preyearsumqty", "curyearqty", "curyearavgqty", "cursumqty", "curyearsumqty", "curyearavgunitamt", "preyearallqty", "preyearallavgqty", "preyearallavgunitamt", "preyearallsumqty"));
    private static List<String> AMTS = Collections.unmodifiableList(Arrays.asList("curprice", "cursumamt", "preprice", "presumamt", "preyearprice", "preyearsumamt", "curyearavgprice", "curyearsumamt", "stdprice", "preyearallsumamt", "preyearallavgprice"));
    private static String[] groupStr = new String[]{"id", "settleorg", "entrycostaccount", "entryprodorg", "productnum", "materialver", "auxprop", "level", "element", "subelement", "material", "submaterialver", "submaterialauxprop", "entrymaterialtype", "entrycurrency", "treepath", "datatype", "istop"};
    private static String[] fields = new String[]{"level", "path", "root"};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        FilterInfo filterInfo = reportQueryParam.getFilter();
        this.init(filterInfo, params);
        if (params.containsKey("notQuery")) {
            return Algo.create((String)"dataset").createDataSet(new ArrayList(10).iterator(), new RowMeta(new Field[]{new Field("entryperiod", (DataType)DataType.StringType)}));
        }
        DataSet resultDataSet = this.queryDataSet(filterInfo, params);
        Boolean onlySumRow = (Boolean)params.get("onlysumrow");
        Boolean onlyMaterialType = (Boolean)params.get("onlymaterialtype");
        Boolean isShowProdOrg = (Boolean)params.get("isShowProdOrg");
        if (resultDataSet.isEmpty()) {
            return Algo.create((String)"dataset").createDataSet(new ArrayList(10).iterator(), resultDataSet.getRowMeta());
        }
        if (!onlyMaterialType.booleanValue()) {
            resultDataSet = this.dealMaterialGroup(resultDataSet);
            resultDataSet = onlySumRow.booleanValue() ? (isShowProdOrg.booleanValue() ? resultDataSet.orderBy(new String[]{"istop asc", "settleorg", "entrycostaccount", "entryprodorg", "productnum"}) : resultDataSet.orderBy(new String[]{"istop asc", "settleorg", "entrycostaccount", "productnum"})) : (isShowProdOrg != false ? resultDataSet.orderBy(new String[]{"istop asc", "settleorg", "entrycostaccount", "entryprodorg", "productnum", "materialver", "auxprop", "treepath", "datatype", "level"}) : resultDataSet.orderBy(new String[]{"istop asc", "settleorg", "entrycostaccount", "productnum", "materialver", "auxprop", "treepath", "datatype", "level"}));
        }
        Set product = (Set)params.get("product");
        DataSet dataSet = this.dealResultDataSet(resultDataSet, product);
        String selectFields = "id,settleorg,entrycostaccount,entryprodorg,productnum,materialver,auxprop,level,element,subelement,material,submaterialver,submaterialauxprop,entrymaterialtype,case when curqty = 0 then '' else cast(curqty as String) end curqty,curprice,curunitamt,case when cursumqty = 0 then '' else cast(cursumqty as String) end cursumqty,cursumamt,entrycurrency,treepath,datatype,case when preqty = 0 then '' else cast(preqty as String) end preqty,case when presumqty = 0 then '' else cast(presumqty as String) end presumqty,preprice,preunitamt,presumamt,case when preyearqty = 0 then '' else cast(preyearqty as String) end preyearqty,case when preyearsumqty = 0 then '' else cast(preyearsumqty as String) end preyearsumqty,preyearprice,preyearunitamt,preyearsumamt,case when curyearqty = 0 then '' else cast(curyearqty as String) end curyearqty,case when curyearavgqty = 0 then '' else cast(curyearavgqty as String) end curyearavgqty,case when curyearsumqty = 0 then '' else cast(curyearsumqty as String) end curyearsumqty,curyearavgprice,curyearavgunitamt,curyearsumamt,case when preyearallqty = 0 then '' else cast(preyearallqty as String) end preyearallqty,case when preyearallavgqty = 0 then '' else cast(preyearallavgqty as String) end preyearallavgqty,case when preyearallsumqty = 0 then '' else cast(preyearallsumqty as String) end preyearallsumqty,preyearallavgprice,preyearallavgunitamt,preyearallsumamt,istop,case when stdqty = 0 then '' else cast(stdqty as String) end stdqty,case when stdqty = 0 then 0 else stdunitamt/stdqty end stdprice,stdunitamt";
        return dataSet.select(selectFields);
    }

    private DataSet dealMaterialGroup(DataSet resultDs) {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        DynamicObject materialgrpstd = filterInfo.getDynamicObject("materialgrpstd");
        if (materialgrpstd != null && materialgrpstd.getLong("id") != 730148448254487552L) {
            DataSet materialDataSet = MaterialGroupHelper.getClassifiedMaterialDataSet(null, (boolean)false, (DynamicObject)materialgrpstd);
            ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(resultDs.getRowMeta().getFieldNames()));
            fieldNames.remove("entrymaterialtype");
            fieldNames.add("case when materialgroup is null then entrymaterialtype else materialgroup end as entrymaterialtype");
            return resultDs.leftJoin(materialDataSet).on("material", "material").select(resultDs.getRowMeta().getFieldNames(), new String[]{"materialgroup"}).finish().select(fieldNames.toArray(new String[0]));
        }
        return resultDs;
    }

    private DataSet queryDataSet(FilterInfo filterInfo, Map<String, Object> params) {
        Boolean onlySumRow = (Boolean)params.get("onlysumrow");
        Boolean onlyMaterialType = (Boolean)params.get("onlymaterialtype");
        Boolean isShowProdOrg = (Boolean)params.get("isShowProdOrg");
        DataSet standardCostDataRow = this.getStandardCostDataRow(filterInfo, params);
        DataSet outlayCostsDataRow = this.getOutlayCostsNormalDataRow(filterInfo);
        DataSet normalDataRow = this.getNormalDataRow(standardCostDataRow, outlayCostsDataRow);
        HashSet<Long> product = new HashSet<Long>(10);
        DataSet productDataRow = this.getProductDataRow(standardCostDataRow, filterInfo, product);
        params.put("product", product);
        DataSet totalDataRow = this.getTotalDataRow(productDataRow);
        String groupQtyAndPrice = "id,settleorg,entrycostaccount,entryprodorg,productnum,materialver,auxprop,level,element,subelement,material,submaterialver,submaterialauxprop,entrymaterialtype,entrycurrency,treepath,datatype,istop,curqty,curprice,curunitamt,cursumqty,cursumamt,preqty,preprice,preunitamt,presumqty,presumamt,preyearqty,preyearprice,preyearunitamt,preyearsumqty,preyearsumamt,curyearavgqty,curyearavgprice,curyearavgunitamt,curyearsumqty,curyearsumamt,curyearqty,curyearunitamt,preyearallqty,preyearallavgqty,preyearallavgprice,preyearallavgunitamt,preyearallsumqty,preyearallsumamt,stdqty,stdprice,stdunitamt";
        if (onlySumRow.booleanValue()) {
            return DataSetUtils.union((DataSet)productDataRow, (DataSet)totalDataRow).groupBy(groupQtyAndPrice.split(",")).finish().orderBy(new String[]{"istop asc", "settleorg", "entrycostaccount", "productnum", "treepath", "datatype"});
        }
        if (onlyMaterialType.booleanValue()) {
            DataSet materialType = this.showWithMaterialType(normalDataRow);
            productDataRow = this.dealMaterialGroup(productDataRow);
            DataSet dataSet = DataSetUtils.union((DataSet)DataSetUtils.union((DataSet)materialType, (DataSet)productDataRow), (DataSet)totalDataRow).select("id,settleorg,entrycostaccount,entryprodorg,productnum,materialver,auxprop,level,element,subelement,0 material,0 submaterialver,0 submaterialauxprop,entrymaterialtype,curqty,curprice,curunitamt,cursumqty,cursumamt,entrycurrency,treepath,datatype,preqty,preprice,preunitamt,presumqty,presumamt,preyearqty,preyearprice,preyearunitamt,preyearsumqty,preyearsumamt,curyearavgqty,curyearavgprice,curyearavgunitamt,curyearsumqty,curyearsumamt,preyearallqty,preyearallavgqty,preyearallavgprice,preyearallavgunitamt,preyearallsumqty,preyearallsumamt,istop,curyearqty,curyearunitamt,stdqty,stdprice,stdunitamt");
            DataSet result = dataSet.groupBy(groupQtyAndPrice.split(",")).finish();
            if (isShowProdOrg.booleanValue()) {
                return result.orderBy(new String[]{"istop asc", "settleorg", "entrycostaccount", "entryprodorg", "productnum", "treepath", "datatype"});
            }
            return result.orderBy(new String[]{"istop asc", "settleorg", "entrycostaccount", "productnum", "treepath", "datatype"});
        }
        return DataSetUtils.union((DataSet)DataSetUtils.union((DataSet)normalDataRow, (DataSet)productDataRow), (DataSet)totalDataRow).groupBy(groupQtyAndPrice.split(",")).finish().filter("level is not null");
    }

    private DataSet showWithMaterialType(DataSet normalDataRow) {
        Row row;
        DataSet normalDataSet = this.dealMaterialGroup(normalDataRow);
        DataSet matsDataSet = normalDataSet.copy();
        int len = normalDataSet.getRowMeta().getFields().length;
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        HashMap<String, String> matAndTypes = new HashMap<String, String>(16);
        while (matsDataSet.hasNext()) {
            row = matsDataSet.next();
            if (row == null || CadEmptyUtils.isEmpty((Long)row.getLong("material"))) continue;
            matAndTypes.put(row.getString("material"), row.getString("entrymaterialtype"));
        }
        while (normalDataSet.hasNext()) {
            row = normalDataSet.next();
            Object[] dataRow = new Object[len];
            for (int i = 0; i < len; ++i) {
                if ("treepath".equals(normalDataSet.getRowMeta().getField(i).getName()) && row.getString("treepath") != null) {
                    String treePath = row.getString("treepath");
                    Object[] split = treePath.split("@");
                    int end = split.length;
                    boolean isResurce = false;
                    if (end >= 2 && CUR_PERIOD.equals(split[end - 2])) {
                        isResurce = true;
                    }
                    for (int j = 0; j < split.length; ++j) {
                        split[j] = matAndTypes.containsKey(split[j]) ? (String)matAndTypes.get(split[j]) : CUR_PERIOD;
                    }
                    String newPath = StringUtils.join((Object[])split, (String)"@", (int)0, (int)end);
                    if (isResurce) {
                        newPath = StringUtils.join((Object[])split, (String)"@", (int)0, (int)(end - 1));
                    }
                    dataRow[i] = newPath;
                    continue;
                }
                dataRow[i] = row.get(i);
            }
            dataList.add(dataRow);
        }
        DataSet dataSet = Algo.create((String)"macc.sca.rpt").createDataSet(dataList.iterator(), normalDataSet.getRowMeta());
        return dataSet.groupBy(new String[]{"settleorg", "entrycostaccount", "entryprodorg", "productnum", "materialver", "auxprop", "level", "element", "subelement", "entrymaterialtype", "entrycurrency", "treepath", "datatype", "istop"}).sum("stdqty").sum("stdunitamt").sum("curqty").sum("curunitamt").sum("cursumqty").sum("cursumamt").sum("preqty").sum("preunitamt").sum("presumqty").sum("presumamt").sum("preyearqty").sum("preyearunitamt").sum("preyearsumqty").sum("preyearsumamt").sum("curyearqty").sum("curyearunitamt").sum("curyearavgqty").sum("curyearavgunitamt").sum("curyearsumqty").sum("curyearsumamt").sum("preyearallqty").sum("preyearallavgqty").sum("preyearallavgunitamt").sum("preyearallsumqty").sum("preyearallsumamt").finish().select("0 id,settleorg,entrycostaccount,entryprodorg,productnum,materialver,auxprop,level,element,subelement,0 material,0 submaterialver,0 submaterialauxprop,entrymaterialtype,curqty,case when cursumqty=0 then 0 else cursumamt/cursumqty end curprice,curunitamt,cursumqty,cursumamt,entrycurrency,treepath,datatype,preqty,case when presumqty=0 then 0 else presumamt/presumqty end preprice,preunitamt,presumqty,presumamt,preyearqty,case when preyearsumqty=0 then 0 else preyearsumamt/preyearsumqty end preyearprice,preyearunitamt,preyearsumqty,preyearsumamt,curyearavgqty,case when curyearsumqty=0 then 0 else curyearsumamt/curyearsumqty end curyearavgprice,curyearavgunitamt,curyearsumqty,curyearsumamt,preyearallqty,preyearallavgqty,case when preyearallsumqty=0 then 0 else preyearallsumamt/preyearallsumqty end preyearallavgprice,preyearallavgunitamt,preyearallsumqty,preyearallsumamt,istop,curyearqty,curyearunitamt,stdqty,case when stdqty=0 then 0 else stdunitamt/stdqty end stdprice,stdunitamt");
    }

    private DataSet dealResultDataSet(DataSet resultDataSet, Set<Long> product) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        RowMeta rowMeta = resultDataSet.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        int len = resultDataSet.getRowMeta().getFields().length;
        HashMap<Long, BigDecimal> productAndQty = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> preProductAndQty = new HashMap<Long, BigDecimal>(16);
        Map<Long, Integer> matAndPrecision = this.getMatAndPrecision(resultDataSet.copy(), productAndQty, preProductAndQty);
        boolean isHasProduct = false;
        while (resultDataSet.hasNext()) {
            Row row = resultDataSet.next();
            if (row == null || product.contains(row.getLong("productnum"))) continue;
            boolean isZero = true;
            if (!isHasProduct && !CadEmptyUtils.isEmpty((Long)row.getLong("productnum"))) {
                isHasProduct = true;
            }
            Object[] obj = new Object[len];
            for (int i = 0; i < len; ++i) {
                BigDecimal preProductQty;
                Long productNum;
                BigDecimal productQty;
                if (!qtyAndAmts.contains(fieldNames[i])) {
                    obj[i] = row.get(i);
                    if (!AMTS.contains(fieldNames[i]) || obj[i] == null || BigDecimal.ZERO.compareTo((BigDecimal)obj[i]) == 0) continue;
                    isZero = false;
                    continue;
                }
                int precision = 10;
                if (!CadEmptyUtils.isEmpty((Long)row.getLong("material")) && matAndPrecision.get(row.getLong("material")) != null) {
                    precision = matAndPrecision.get(row.getLong("material"));
                }
                if (QTYS.contains(fieldNames[i]) && row.getBigDecimal(i) != null) {
                    obj[i] = row.getBigDecimal(i).setScale(precision, 4);
                    if (BigDecimal.ZERO.compareTo((BigDecimal)obj[i]) != 0) {
                        isZero = false;
                    }
                }
                BigDecimal bigDecimal = productQty = preProductAndQty.get(productNum = row.getLong("productnum")) == null || ((BigDecimal)preProductAndQty.get(productNum)).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : (BigDecimal)preProductAndQty.get(productNum);
                if ("curyearavgqty".equals(fieldNames[i]) && !CUR_PERIOD.equals(row.getString("level")) && !ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CostAnalyzeRptQuery_0", (String)"macc-sca-report", (Object[])new Object[0]).equals(row.getString("level"))) {
                    Object object = obj[i] = row.getBigDecimal(i) == null ? row.getBigDecimal(i) : row.getBigDecimal(i).divide(productQty, precision, 4);
                }
                if ("curyearavgunitamt".equals(fieldNames[i])) {
                    obj[i] = row.get(i);
                }
                BigDecimal bigDecimal2 = preProductQty = productAndQty.get(productNum) == null || ((BigDecimal)productAndQty.get(productNum)).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : (BigDecimal)productAndQty.get(productNum);
                if ("preyearallavgqty".equals(fieldNames[i]) && !CUR_PERIOD.equals(row.getString("level")) && !ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CostAnalyzeRptQuery_0", (String)"macc-sca-report", (Object[])new Object[0]).equals(row.getString("level"))) {
                    Object object = obj[i] = row.getBigDecimal(i) == null ? row.getBigDecimal(i) : row.getBigDecimal(i).divide(preProductQty, precision, 4);
                }
                if (!"preyearallavgunitamt".equals(fieldNames[i])) continue;
                obj[i] = row.get(i);
            }
            if (isZero) continue;
            dataList.add(obj);
        }
        logger.info("\u6210\u672c\u5206\u6790\u8868\u67e5\u8be2-\u603b\u884c\u6570={},product={},ishasProduct={}", new Object[]{dataList.size(), product, String.valueOf(isHasProduct)});
        if (!isHasProduct) {
            return Algo.create((String)"macc.sca.rpt").createDataSet(new ArrayList().iterator(), rowMeta);
        }
        return Algo.create((String)"macc.sca.rpt").createDataSet(dataList.iterator(), rowMeta);
    }

    private Map<Long, Integer> getMatAndPrecision(DataSet resultDataSet, Map<Long, BigDecimal> productAndQty, Map<Long, BigDecimal> preProductAndQty) {
        HashSet<Long> matIds = new HashSet<Long>(10);
        while (resultDataSet.hasNext()) {
            Row row = resultDataSet.next();
            if (row == null) continue;
            matIds.add(row.getLong("material"));
            if (!CUR_PERIOD.equals(row.getString("level")) || CadEmptyUtils.isEmpty((Long)row.getLong("productnum"))) continue;
            if (productAndQty.get(row.getLong("productnum")) == null) {
                productAndQty.put(row.getLong("productnum"), row.getBigDecimal("curyearsumqty"));
            }
            if (preProductAndQty.get(row.getLong("productnum")) != null) continue;
            preProductAndQty.put(row.getLong("productnum"), row.getBigDecimal("preyearallsumqty"));
        }
        QFilter matFilter = new QFilter("masterid", "in", matIds);
        DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)"macc.sca.rpt", (String)"bd_material", (String)"masterid as materialid,baseunit as unitid,baseunit.name as unit", (QFilter[])new QFilter[]{matFilter}, null);
        DataSet unitDataSet = QueryServiceHelper.queryDataSet((String)"macc.sca.rpt", (String)"bd_measureunits", (String)"id as unitid,precision", null, null);
        DataSet dataSet = materialDataSet.join(unitDataSet, JoinType.INNER).on("unitid", "unitid").select(new String[]{"materialid", "precision"}).finish();
        HashMap<Long, Integer> matAndPrecision = new HashMap<Long, Integer>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (row == null || matAndPrecision.get(row.getLong("materialid")) != null) continue;
            matAndPrecision.put(row.getLong("materialid"), row.getInteger("precision"));
        }
        return matAndPrecision;
    }

    private void init(FilterInfo filterInfo, Map<String, Object> params) {
        params.put("onlysumrow", filterInfo.getBoolean("onlysumrow"));
        params.put("onlymaterialtype", filterInfo.getBoolean("onlymaterialtype"));
        params.put("period", filterInfo.getDynamicObject("period").getLong("id"));
        params.put("currency", filterInfo.getDynamicObject("currency").getLong("id"));
        params.put("settleorg", filterInfo.getDynamicObject("org").getLong("id"));
        params.put("entrycostaccount", filterInfo.getDynamicObject("costaccount").getLong("id"));
        DynamicObject prodorg = filterInfo.getDynamicObject("prodorg");
        params.put("isShowProdOrg", Boolean.FALSE);
        if (prodorg != null) {
            params.put("isShowProdOrg", Boolean.TRUE);
            params.put("entryprodorg", prodorg.getLong("id"));
        } else {
            params.put("entryprodorg", 0L);
        }
        if (filterInfo.containProp("notQuery")) {
            params.put("notQuery", "true");
        }
    }

    private DataSet getTotalDataRow(DataSet zeroLevel) {
        String strSum = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CostAnalyzeRptQuery_0", (String)"macc-sca-report", (Object[])new Object[0]);
        DataSet total = zeroLevel.copy().groupBy(new String[]{"settleorg", "entrycostaccount", "productnum", "materialver", "auxprop", "entrycurrency"}).sum("stdunitamt").sum("curunitamt").sum("preunitamt").sum("preyearunitamt").sum("curyearavgunitamt").sum("cursumamt").sum("curyearsumamt").sum("presumamt").sum("preyearsumamt").sum("preyearallavgunitamt").sum("preyearallsumamt").finish();
        total = total.groupBy(new String[]{"settleorg", "entrycostaccount", "entrycurrency"}).sum("stdunitamt").sum("curunitamt").sum("preunitamt").sum("preyearunitamt").sum("curyearavgunitamt").sum("cursumamt").sum("curyearsumamt").sum("presumamt").sum("preyearsumamt").sum("preyearallavgunitamt").sum("preyearallsumamt").finish().select(new String[]{"0 as id", "settleorg", "entrycostaccount", "0 as entryprodorg", "0 as productnum", "0 as materialver", "0 as auxprop", "'" + strSum + "' as level", "'' as element", "'' as subelement", "0 as material", "0 as submaterialver", "0 as submaterialauxprop", "0 as entrymaterialtype", "0 as curqty", "0 as curprice", "curunitamt", "0 as cursumqty", "cursumamt", "entrycurrency", "'' as treepath", "'-2' as datatype", "0 as preqty", "0 as preprice", "preunitamt", "0 as presumqty", "presumamt", "0 as preyearqty", "0 as preyearprice", "preyearunitamt", "0 as preyearsumqty", "preyearsumamt", "0 as curyearavgqty", "0 as curyearavgprice", "curyearavgunitamt", "0 as curyearsumqty", "curyearsumamt", "2 as istop", "0 as preyearallqty", "0 as preyearallavgqty", "0 as preyearallavgprice", "preyearallavgunitamt", "0 as preyearallsumqty", "preyearallsumamt", "0 as curyearunitamt", "0 as curyearqty", "0 as stdqty", "0 as stdprice", "stdunitamt"});
        return total;
    }

    private DataSet getProductDataRow(DataSet standardCostDataRow, FilterInfo filterInfo, Set<Long> product) {
        String[] stringArray;
        List<QFilter> qFilters = this.getQFilters(filterInfo);
        QFilter periodFilter = this.getPeriodFilter(CUR_PERIOD);
        qFilters.add(periodFilter);
        DataSet curProductDataSet = this.getProductDataRowByPeriod(qFilters, curPeriod);
        qFilters.remove(periodFilter);
        periodFilter = this.getPeriodFilter(PRE_PERIOD);
        qFilters.add(periodFilter);
        DataSet preProductDataSet = this.getProductDataRowByPeriod(qFilters, prePeriod);
        qFilters.remove(periodFilter);
        periodFilter = this.getPeriodFilter(PRE_YEAR);
        qFilters.add(periodFilter);
        DataSet preYearProductDataSet = this.getProductDataRowByPeriod(qFilters, preYearSamePeriod);
        qFilters.remove(periodFilter);
        periodFilter = this.getPeriodFilter(ALL_PERIOD);
        qFilters.add(periodFilter);
        DataSet curYearProductDataSet = this.getProductDataRowByPeriod(qFilters, curYearSumPeriod);
        curYearProductDataSet = curYearProductDataSet.addFields(new String[]{PRE_PERIOD, "curyearavgunitamt"}, new String[]{"curyearavgqty", "curyearunitamt"});
        qFilters.remove(periodFilter);
        periodFilter = this.getPeriodFilter(PRE_ALL_PERIOD);
        qFilters.add(periodFilter);
        DataSet preYearAllProductDataSet = this.getProductDataRowByPeriod(qFilters, preYearSumPeriod);
        preYearAllProductDataSet = preYearAllProductDataSet.addFields(new String[]{PRE_PERIOD, "preyearallavgunitamt"}, new String[]{"preyearallavgqty", "preyearallunitamt"});
        DataSet curPerioAndCurYearDataSet = curYearProductDataSet.join(curProductDataSet, JoinType.LEFT).on("settleorg", "settleorg").on("entrycostaccount", "entrycostaccount").on("entryprodorg", "entryprodorg").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").on("level", "level").on("treepath", "treepath").select(curYearProductDataSet.getRowMeta().getFieldNames(), new String[]{"curqty", "curprice", "curunitamt", "cursumqty", "cursumamt"}).finish();
        DataSet curAndPrePerioAndCurYearDataSet = curPerioAndCurYearDataSet.join(preProductDataSet, JoinType.LEFT).on("settleorg", "settleorg").on("entrycostaccount", "entrycostaccount").on("entryprodorg", "entryprodorg").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").on("level", "level").on("treepath", "treepath").select(curPerioAndCurYearDataSet.getRowMeta().getFieldNames(), new String[]{"preqty", "preprice", "preunitamt", "presumqty", "presumamt"}).finish();
        DataSet cppy = curAndPrePerioAndCurYearDataSet.copy();
        DataSet prey = preYearProductDataSet.copy();
        boolean isNotCpdEmpty = !cppy.isEmpty() && cppy.count("id", false) >= prey.count("id", false);
        JoinDataSet joinDataSet = (isNotCpdEmpty ? curAndPrePerioAndCurYearDataSet : preYearProductDataSet).join(isNotCpdEmpty ? preYearProductDataSet : curAndPrePerioAndCurYearDataSet, JoinType.LEFT).on("settleorg", "settleorg").on("entrycostaccount", "entrycostaccount").on("entryprodorg", "entryprodorg").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").on("level", "level").on("treepath", "treepath");
        String[] stringArray2 = isNotCpdEmpty ? curAndPrePerioAndCurYearDataSet.getRowMeta().getFieldNames() : preYearProductDataSet.getRowMeta().getFieldNames();
        if (isNotCpdEmpty) {
            String[] stringArray3 = new String[5];
            stringArray3[0] = "preyearqty";
            stringArray3[1] = "preyearprice";
            stringArray3[2] = "preyearunitamt";
            stringArray3[3] = "preyearsumqty";
            stringArray = stringArray3;
            stringArray3[4] = "preyearsumamt";
        } else {
            String[] stringArray4 = new String[17];
            stringArray4[0] = "curqty";
            stringArray4[1] = "curprice";
            stringArray4[2] = "curunitamt";
            stringArray4[3] = "cursumqty";
            stringArray4[4] = "cursumamt";
            stringArray4[5] = "preqty";
            stringArray4[6] = "preprice";
            stringArray4[7] = "preunitamt";
            stringArray4[8] = "presumqty";
            stringArray4[9] = "presumamt";
            stringArray4[10] = "curyearqty";
            stringArray4[11] = "curyearunitamt";
            stringArray4[12] = "curyearavgqty";
            stringArray4[13] = "curyearsumqty";
            stringArray4[14] = "curyearsumamt";
            stringArray4[15] = "curyearavgprice";
            stringArray = stringArray4;
            stringArray4[16] = "curyearavgunitamt";
        }
        DataSet curAndPreYearPerioAndCurYearDataSet = joinDataSet.select(stringArray2, stringArray).finish();
        curAndPreYearPerioAndCurYearDataSet = curAndPreYearPerioAndCurYearDataSet.addField(PRE_PERIOD, "unpre");
        DataSet dataSetYearLeft = curAndPreYearPerioAndCurYearDataSet.join(preYearAllProductDataSet, JoinType.LEFT).on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").on("level", "level").on("treepath", "treepath").select(curAndPreYearPerioAndCurYearDataSet.getRowMeta().getFieldNames(), new String[]{"preyearallqty", "preyearallavgqty", "preyearallsumqty", "preyearallavgprice", "preyearallavgunitamt", "preyearallsumamt"}).finish();
        DataSet dataSetYearRight = curAndPreYearPerioAndCurYearDataSet.join(preYearAllProductDataSet, JoinType.RIGHT).on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").on("level", "level").on("treepath", "treepath").select(curAndPreYearPerioAndCurYearDataSet.getRowMeta().getFieldNames(), new String[]{"preyearallqty", "preyearallavgqty", "preyearallsumqty", "preyearallavgprice", "preyearallavgunitamt", "preyearallsumamt"}).finish().filter("unpre is null");
        DataSet dataSet = DataSetUtils.union((DataSet)dataSetYearLeft, (DataSet)dataSetYearRight);
        String selectFields = "id,settleorg,entrycostaccount,entryprodorg,productnum,materialver,auxprop,level,element,subelement,material,submaterialver,submaterialauxprop,entrymaterialtype,curqty,curprice,curunitamt,cursumqty,cursumamt,entrycurrency,treepath,datatype,preqty,preprice,preunitamt,presumqty,presumamt,preyearqty,preyearprice,preyearunitamt,preyearsumqty,preyearsumamt,curyearavgqty,curyearavgprice,curyearavgunitamt,curyearsumqty,curyearsumamt,istop,curyearqty,curyearunitamt,preyearallqty,preyearallavgqty,preyearallavgprice,preyearallavgunitamt,preyearallsumqty,preyearallsumamt";
        dataSet = dataSet.select(selectFields);
        DataSet productDataSet = dataSet.join(standardCostDataRow.filter("level1 = '0'"), JoinType.LEFT).on("productnum", "root").on("material", "submaterial1").on("submaterialver", "submatvers1").on("submaterialauxprop", "subauxproperty1").select(dataSet.getRowMeta().getFieldNames(), new String[]{"stdqty", "stdprice", "stdunitamt"}).finish();
        DataSet stdProductDataSet = dataSet.join(standardCostDataRow.filter("level1 = '0'"), JoinType.RIGHT).on("productnum", "root").on("material", "submaterial1").on("submaterialver", "submatvers1").on("submaterialauxprop", "subauxproperty1").select(new String[]{"id1", "settleorg1", "entrycostaccount1", "entryprodorg1", "material1", "matvers1", "auxproperty1", "element1", "subelement1", "submaterial1", "submatvers1", "subauxproperty1", "stdqty", "stdprice", "stdunitamt", "level1", "root", "path", "entrycurrency1", "entrymaterialtype1", "datatype1"}, dataSet.getRowMeta().getFieldNames()).finish();
        stdProductDataSet = stdProductDataSet.filter("id is null");
        while (stdProductDataSet.hasNext()) {
            Row row = stdProductDataSet.next();
            if (row == null) continue;
            product.add(row.getLong("root"));
        }
        return productDataSet.groupBy(productDataSet.getRowMeta().getFieldNames()).finish();
    }

    private DataSet getOutlayCostsNormalDataRow(FilterInfo filterInfo) {
        String[] stringArray;
        List<QFilter> qFilters = this.getQFilters(filterInfo);
        qFilters.add(new QFilter("entryentity.level", ">", (Object)0));
        QFilter periodFilter = this.getPeriodFilter(CUR_PERIOD);
        qFilters.add(periodFilter);
        DataSet curPeriodDataSet = this.getNormalDataSetByPeriods(qFilters, curPeriod, CUR_PERIOD);
        qFilters.remove(periodFilter);
        periodFilter = this.getPeriodFilter(PRE_PERIOD);
        qFilters.add(periodFilter);
        DataSet prePeriodDataSet = this.getNormalDataSetByPeriods(qFilters, prePeriod, PRE_PERIOD);
        qFilters.remove(periodFilter);
        periodFilter = this.getPeriodFilter(PRE_YEAR);
        qFilters.add(periodFilter);
        DataSet preYearPeriodDataSet = this.getNormalDataSetByPeriods(qFilters, preYearSamePeriod, PRE_YEAR);
        qFilters.remove(periodFilter);
        periodFilter = this.getPeriodFilter(ALL_PERIOD);
        qFilters.add(periodFilter);
        DataSet curYearDataSet = this.getNormalDataSetByPeriods(qFilters, curYearSumPeriod, ALL_PERIOD);
        curYearDataSet = curYearDataSet.addFields(new String[]{"curyearsumqty", "curyearavgunitamt"}, new String[]{"curyearavgqty", "curyearunitamt"});
        qFilters.remove(periodFilter);
        periodFilter = this.getPeriodFilter(PRE_ALL_PERIOD);
        qFilters.add(periodFilter);
        DataSet preYearDataSet = this.getNormalDataSetByPeriods(qFilters, preYearSumPeriod, PRE_ALL_PERIOD);
        preYearDataSet = preYearDataSet.addFields(new String[]{"preyearallsumqty", "preyearallavgunitamt"}, new String[]{"preyearallavgqty", "preyearallunitamt"});
        DataSet curPerioAndCurYearDataSet = curYearDataSet.join(curPeriodDataSet, JoinType.LEFT).on("entryprodorg", "entryprodorg").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").on("material", "material").on("submaterialver", "submaterialver").on("submaterialauxprop", "submaterialauxprop").on("element", "element").on("subelement", "subelement").on("level", "level").on("treepath", "treepath").select(curYearDataSet.getRowMeta().getFieldNames(), new String[]{"curqty", "curprice", "curunitamt", "cursumqty", "cursumamt"}).finish();
        DataSet curAndPrePerioAndCurYearDataSet = curPerioAndCurYearDataSet.join(prePeriodDataSet, JoinType.LEFT).on("entryprodorg", "entryprodorg").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").on("material", "material").on("submaterialver", "submaterialver").on("submaterialauxprop", "submaterialauxprop").on("element", "element").on("subelement", "subelement").on("level", "level").on("treepath", "treepath").select(curPerioAndCurYearDataSet.getRowMeta().getFieldNames(), new String[]{"preqty", "preprice", "preunitamt", "presumqty", "presumamt"}).finish();
        DataSet cppy = curAndPrePerioAndCurYearDataSet.copy();
        DataSet prey = preYearPeriodDataSet.copy();
        boolean isNotEmpty = !cppy.isEmpty() && cppy.count("id", false) >= prey.count("id", false);
        JoinDataSet joinDataSet = (isNotEmpty ? curAndPrePerioAndCurYearDataSet : preYearPeriodDataSet).join(isNotEmpty ? preYearPeriodDataSet : curAndPrePerioAndCurYearDataSet, JoinType.LEFT).on("entryprodorg", "entryprodorg").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").on("material", "material").on("submaterialver", "submaterialver").on("submaterialauxprop", "submaterialauxprop").on("element", "element").on("subelement", "subelement").on("level", "level");
        String[] stringArray2 = isNotEmpty ? curAndPrePerioAndCurYearDataSet.getRowMeta().getFieldNames() : preYearPeriodDataSet.getRowMeta().getFieldNames();
        if (isNotEmpty) {
            String[] stringArray3 = new String[5];
            stringArray3[0] = "preyearqty";
            stringArray3[1] = "preyearprice";
            stringArray3[2] = "preyearunitamt";
            stringArray3[3] = "preyearsumqty";
            stringArray = stringArray3;
            stringArray3[4] = "preyearsumamt";
        } else {
            String[] stringArray4 = new String[17];
            stringArray4[0] = "curqty";
            stringArray4[1] = "curprice";
            stringArray4[2] = "curunitamt";
            stringArray4[3] = "cursumqty";
            stringArray4[4] = "cursumamt";
            stringArray4[5] = "curyearsumqty";
            stringArray4[6] = "curyearsumamt";
            stringArray4[7] = "preqty";
            stringArray4[8] = "preprice";
            stringArray4[9] = "preunitamt";
            stringArray4[10] = "presumqty";
            stringArray4[11] = "presumamt";
            stringArray4[12] = "curyearqty";
            stringArray4[13] = "curyearunitamt";
            stringArray4[14] = "curyearavgqty";
            stringArray4[15] = "curyearavgprice";
            stringArray = stringArray4;
            stringArray4[16] = "curyearavgunitamt";
        }
        DataSet curAndPreYearPerioAndCurYearDataSet = joinDataSet.select(stringArray2, stringArray).finish();
        curAndPreYearPerioAndCurYearDataSet = curAndPreYearPerioAndCurYearDataSet.addField(PRE_PERIOD, "unpre");
        DataSet dataSetYearLeft = curAndPreYearPerioAndCurYearDataSet.join(preYearDataSet, JoinType.LEFT).on("entryprodorg", "entryprodorg").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").on("material", "material").on("submaterialver", "submaterialver").on("submaterialauxprop", "submaterialauxprop").on("element", "element").on("subelement", "subelement").on("level", "level").on("treepath", "treepath").select(curAndPreYearPerioAndCurYearDataSet.getRowMeta().getFieldNames(), new String[]{"preyearallavgqty", "preyearallqty", "preyearallsumqty", "preyearallavgprice", "preyearallavgunitamt", "preyearallsumamt"}).finish();
        DataSet dataSetYearRight = curAndPreYearPerioAndCurYearDataSet.join(preYearDataSet, JoinType.RIGHT).on("entryprodorg", "entryprodorg").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").on("material", "material").on("submaterialver", "submaterialver").on("submaterialauxprop", "submaterialauxprop").on("element", "element").on("subelement", "subelement").on("level", "level").on("treepath", "treepath").select(curAndPreYearPerioAndCurYearDataSet.getRowMeta().getFieldNames(), new String[]{"preyearallavgqty", "preyearallqty", "preyearallsumqty", "preyearallavgprice", "preyearallavgunitamt", "preyearallsumamt"}).finish().filter("unpre is null");
        DataSet dataSet = DataSetUtils.union((DataSet)dataSetYearLeft, (DataSet)dataSetYearRight);
        String selectFields = "id,settleorg,entrycostaccount,entryprodorg,productnum,materialver,auxprop,level,element,subelement,material,submaterialver,submaterialauxprop,entrymaterialtype,curqty,case when cursumqty = 0 then 0 else cursumamt/cursumqty end curprice,curunitamt,cursumqty,cursumamt,curyearqty,curyearunitamt,entrycurrency,treepath,datatype,preqty,case when presumqty = 0 then 0 else presumamt/presumqty end preprice,preunitamt,presumqty,presumamt,preyearqty,case when preyearsumqty = 0 then 0 else preyearsumamt/preyearsumqty end preyearprice,preyearunitamt,preyearsumqty,preyearsumamt,curyearavgqty,case when curyearsumqty = 0 then 0 else curyearsumamt/curyearsumqty end curyearavgprice,curyearavgunitamt,curyearsumqty,curyearsumamt,preyearallavgqty,preyearallqty,case when preyearallsumqty = 0 then 0 else preyearallsumamt/preyearallsumqty end preyearallavgprice,preyearallavgunitamt,preyearallsumqty,preyearallsumamt,istop";
        return dataSet.groupBy(groupStr).sum("curqty").sum("curunitamt").sum("cursumqty").sum("cursumamt").sum("preqty").sum("preunitamt").sum("presumqty").sum("presumamt").sum("preyearqty").sum("preyearunitamt").sum("preyearsumqty").sum("preyearsumamt").sum("curyearavgqty").sum("curyearavgprice").sum("curyearavgunitamt").sum("curyearsumqty").sum("curyearsumamt").sum("curyearqty").sum("curyearunitamt").sum("preyearallavgqty").sum("preyearallqty").sum("preyearallavgprice").sum("preyearallavgunitamt").sum("preyearallsumqty").sum("preyearallsumamt").finish().select(selectFields);
    }

    private DataSet getNormalDataRow(DataSet standardCostDataRow, DataSet outlayCostsDataRow) {
        DataSet normalDataRow = outlayCostsDataRow.join(standardCostDataRow.filter("level1 <> '0'"), JoinType.LEFT).on("productnum", "root").on("materialver", "matvers1").on("auxprop", "auxproperty1").on("material", "submaterial1").on("submaterialver", "submatvers1").on("submaterialauxprop", "subauxproperty1").on("element", "element1").on("subelement", "subelement1").on("datatype", "datatype1").on("level", "level1").on("treepath", "path").select(outlayCostsDataRow.getRowMeta().getFieldNames(), new String[]{"stdqty", "stdprice", "stdunitamt"}).finish();
        DataSet stdNormalDataRow = outlayCostsDataRow.join(standardCostDataRow.filter("level1 <> '0'"), JoinType.RIGHT).on("productnum", "root").on("materialver", "matvers1").on("auxprop", "auxproperty1").on("material", "submaterial1").on("submaterialver", "submatvers1").on("submaterialauxprop", "subauxproperty1").on("element", "element1").on("subelement", "subelement1").on("datatype", "datatype1").on("level", "level1").on("treepath", "path").select(new String[]{"id1", "settleorg1", "entrycostaccount1", "entryprodorg1", "material1", "matvers1", "auxproperty1", "element1", "subelement1", "submaterial1", "submatvers1", "subauxproperty1", "stdqty", "stdprice", "stdunitamt", "level1", "root", "path", "entrycurrency1", "entrymaterialtype1", "datatype1"}, outlayCostsDataRow.getRowMeta().getFieldNames()).finish();
        String selectFields = "0 as id,settleorg1 as settleorg,entrycostaccount1 as entrycostaccount,entryprodorg1 as entryprodorg,root as productnum,matvers1 as materialver,auxproperty1 as auxprop,level1 as level,element1 as element,subelement1 as subelement,submaterial1 as material,submatvers1 as submaterialver,subauxproperty1 as submaterialauxprop,entrymaterialtype1 as entrymaterialtype,0 as curqty,0 as curprice,0 as curunitamt,0 as cursumqty,0 as cursumamt,entrycurrency1 as entrycurrency,path as treepath,datatype1 as datatype,0 as preqty,0 as preprice,0 as preunitamt,0 as presumqty,0 as presumamt,0 as preyearqty,0 as preyearprice,0 as preyearunitamt,0 as preyearsumqty,0 as preyearsumamt,0 as curyearavgqty,0 as curyearavgprice,0 as curyearavgunitamt,0 as curyearsumqty,0 as curyearsumamt,1 as istop,0 as curyearqty,0 as curyearunitamt,0 as preyearallavgqty,0 as preyearallqty,0 as preyearallavgprice,0 as preyearallavgunitamt,0 as preyearallsumqty,0 as preyearallsumamt,stdqty,stdprice,stdunitamt";
        stdNormalDataRow = stdNormalDataRow.filter("id is null").select(selectFields).groupBy(normalDataRow.getRowMeta().getFieldNames()).finish();
        normalDataRow = normalDataRow.union(stdNormalDataRow);
        return normalDataRow;
    }

    private DataSet getNormalDataSetByPeriods(List<QFilter> filters, String[] fieldPeriods, String preYear) {
        String[] fields = new String[]{"", ""};
        if (fieldPeriods[0].equals("curqty")) {
            fields[0] = "cursumqty";
            fields[1] = "cursumamt";
        } else if (fieldPeriods[0].equals("preqty")) {
            fields[0] = "presumqty";
            fields[1] = "presumamt";
        } else if (fieldPeriods[0].equals("preyearqty")) {
            fields[0] = "preyearsumqty";
            fields[1] = "preyearsumamt";
        } else if (fieldPeriods[0].equals("curyearqty")) {
            fields[0] = "curyearsumqty";
            fields[1] = "curyearsumamt";
        } else if (fieldPeriods[0].equals("preyearallqty")) {
            fields[0] = "preyearallsumqty";
            fields[1] = "preyearallsumamt";
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.report.CostAnalyzeRptQuery#getNormalDataSetByPeriods", (String)"sca_costrecovry", (String)"0 as id, org as settleorg,costaccount as entrycostaccount,manuorg as entryprodorg,material as productnum,materialver as materialver,auxprop,concat('',entryentity.level) as level,entryentity.element.name as element,entryentity.subelement.name as subelement,entryentity.submaterial as material,entryentity.submaterialver as submaterialver,entryentity.submaterialauxprop as submaterialauxprop,entryentity.submaterial.group as entrymaterialtype ,headqty,entryentity.amount amount,entryentity.qty qty,currency as entrycurrency,entryentity.treepath as treepath,case when entryentity.subelement.type ='001' then '4' else '5' end datatype,1 as istop", (QFilter[])filters.toArray(new QFilter[0]), null);
        DataSet productqty = dataSet.groupBy("settleorg,entrycostaccount,entryprodorg,productnum,materialver,auxprop,headqty".split(",")).finish().groupBy("settleorg,entrycostaccount,entryprodorg,productnum,materialver,auxprop".split(",")).sum("headqty").finish();
        dataSet = dataSet.groupBy("id,settleorg,entrycostaccount,entryprodorg,productnum,materialver,auxprop,level,element,subelement,material,submaterialver,submaterialauxprop,entrymaterialtype,entrycurrency,treepath,datatype,istop".split(",")).sum("qty").sum("amount").finish();
        dataSet = dataSet.join(productqty, JoinType.LEFT).on("settleorg", "settleorg").on("entrycostaccount", "entrycostaccount").on("entryprodorg", "entryprodorg").on("productnum", "productnum").on("materialver", "materialver").on("auxprop", "auxprop").select(dataSet.getRowMeta().getFieldNames(), new String[]{"headqty"}).finish();
        dataSet = dataSet.select("id, settleorg,entrycostaccount,entryprodorg,productnum,materialver,auxprop,level,element,subelement,material,submaterialver,submaterialauxprop,entrymaterialtype,case when headqty = 0 then 0 else qty/headqty end " + fieldPeriods[0] + ",case when qty = 0  then 0 else amount/qty end " + fieldPeriods[1] + ",case when headqty = 0 then 0 else amount/headqty end " + fieldPeriods[2] + ",qty as " + fields[0] + ",amount as " + fields[1] + ",entrycurrency,treepath,datatype,istop");
        return dataSet;
    }

    private DataSet getNormalDataSetByCurYear(List<QFilter> filters) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.report.CostAnalyzeRptQuery#getCurYearTotalAvg", (String)"sca_costrecovry", (String)"0 as id ,org as settleorg,costaccount as entrycostaccount,manuorg as entryprodorg,material as productnum,materialver as materialver,auxprop,entryentity.element.name as element,entryentity.treepath as treepath,concat('',entryentity.level) as level,entryentity.submaterial.group as entrymaterialtype,entryentity.subelement.name as subelement,entryentity.submaterial as material,entryentity.submaterialver as submaterialver,entryentity.submaterialauxprop as submaterialauxprop,case when headqty = 0 then 0 else entryentity.qty/headqty end curyearqty,case when headqty = 0 then 0 else entryentity.amount/headqty end curyearunitamt,entryentity.qty as curyearsumqty,currency as entrycurrency,entryentity.amount as curyearsumamt,case when entryentity.subelement.type ='001' then '4' else '5' end datatype,1 as istop", (QFilter[])filters.toArray(new QFilter[0]), null);
        dataSet = dataSet.groupBy(new String[]{"id", "level", "entrymaterialtype", "settleorg", "entrycostaccount", "entryprodorg", "productnum", "materialver", "auxprop", "material", "submaterialver", "submaterialauxprop", "element", "subelement", "entrycurrency", "treepath", "datatype", "istop"}).sum("curyearsumqty").sum("curyearsumamt").sum("curyearqty").sum("curyearunitamt").sum("curyearsumqty", "curyearavgqty").sum("curyearsumamt", "curyearavgunitamt").finish();
        return dataSet;
    }

    private DataSet getNormalDataSetByPreYear(List<QFilter> filters) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.report.CostAnalyzeRptQuery#getPreYearTotalAvg", (String)"sca_costrecovry", (String)"0 as id ,org as settleorg,costaccount as entrycostaccount,manuorg as entryprodorg,material as productnum,materialver as materialver,auxprop,entryentity.element.name as element,entryentity.treepath as treepath,concat('',entryentity.level) as level,entryentity.submaterial.group as entrymaterialtype,entryentity.subelement.name as subelement,entryentity.submaterial as material,entryentity.submaterialver as submaterialver,entryentity.submaterialauxprop as submaterialauxprop,case when headqty = 0 then 0 else entryentity.qty/headqty end preyearallqty,case when headqty = 0 then 0 else entryentity.amount/headqty end preyearallunitamt,entryentity.qty as preyearallsumqty,currency as entrycurrency,entryentity.amount as preyearallsumamt,case when entryentity.subelement.type ='001' then '4' else '5' end datatype,1 as istop", (QFilter[])filters.toArray(new QFilter[0]), null);
        dataSet = dataSet.groupBy(new String[]{"id", "level", "entrymaterialtype", "settleorg", "entrycostaccount", "entryprodorg", "productnum", "materialver", "auxprop", "material", "submaterialver", "submaterialauxprop", "element", "subelement", "entrycurrency", "treepath", "datatype", "istop"}).sum("preyearallsumqty").sum("preyearallsumamt").sum("preyearallqty").sum("preyearallunitamt").sum("preyearallsumqty", "preyearallavgqty").sum("preyearallsumamt", "preyearallavgunitamt").finish();
        return dataSet;
    }

    private DataSet getProductDataRowByPeriod(List<QFilter> filters, String[] fieldPeriods) {
        String[] fields = new String[]{"", ""};
        if (fieldPeriods[0].equals("curqty")) {
            fields[0] = "cursumqty";
            fields[1] = "cursumamt";
        } else if (fieldPeriods[0].equals("preqty")) {
            fields[0] = "presumqty";
            fields[1] = "presumamt";
        } else if (fieldPeriods[0].equals("preyearqty")) {
            fields[0] = "preyearsumqty";
            fields[1] = "preyearsumamt";
        } else if (fieldPeriods[0].equals("curyearqty")) {
            fields[0] = "curyearsumqty";
            fields[1] = "curyearsumamt";
        } else if (fieldPeriods[0].equals("preyearallqty")) {
            fields[0] = "preyearallsumqty";
            fields[1] = "preyearallsumamt";
        }
        String mat = ResManager.loadKDString((String)"\u7269\u6599", (String)"CostAnalyzeRptQuery_7", (String)"macc-sca-report", (Object[])new Object[0]);
        String pro = ResManager.loadKDString((String)"\u4ea7\u54c1\u7ea7", (String)"CostAnalyzeRptQuery_8", (String)"macc-sca-report", (Object[])new Object[0]);
        DataSet curSum = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.report.CostAnalyzeRptQuery#getProductDataRowByPeriod", (String)"sca_costrecovry", (String)("0 as id,org as settleorg,costaccount as entrycostaccount,manuorg as entryprodorg,material as productnum,materialver as materialver,auxprop,'0' as level,'" + mat + "' as element,'" + pro + "' as subelement,material as material,materialver as submaterialver,auxprop as submaterialauxprop,material.group as entrymaterialtype,headqty,headamount,currency as entrycurrency,'' as treepath,'1' as datatype,1 as istop"), (QFilter[])filters.toArray(new QFilter[0]), null);
        curSum = curSum.groupBy("id,settleorg,entrycostaccount,entryprodorg,productnum,materialver,auxprop,level,element,subelement,material,submaterialver,submaterialauxprop,entrymaterialtype,entrycurrency,treepath,datatype,istop".split(",")).sum("headqty").sum("headamount").finish();
        curSum = curSum.select("id,settleorg,entrycostaccount,entryprodorg,productnum,materialver,auxprop,level,element,subelement,material,submaterialver,submaterialauxprop,entrymaterialtype,case when headqty = 0 then 0 else headqty/headqty end " + fieldPeriods[0] + ",case when headqty = 0 then 0 else headamount/headqty end " + fieldPeriods[1] + ",case when headqty = 0 then 0 else headamount/headqty end " + fieldPeriods[2] + ",headqty as " + fields[0] + ",headamount as " + fields[1] + ",entrycurrency,treepath,datatype,istop");
        return curSum.groupBy(new String[]{"id", "settleorg", "entrycostaccount", "entryprodorg", "productnum", "materialver", "auxprop", "level", "element", "subelement", "material", "submaterialver", "submaterialauxprop", "entrymaterialtype", fieldPeriods[0], fieldPeriods[1], fieldPeriods[2], fields[0], fields[1], "entrycurrency", "treepath", "datatype", "istop"}).finish();
    }

    private DataSet getProductDataRowByCurYear(List<QFilter> filters) {
        String mat = ResManager.loadKDString((String)"\u7269\u6599", (String)"CostAnalyzeRptQuery_7", (String)"macc-sca-report", (Object[])new Object[0]);
        String pro = ResManager.loadKDString((String)"\u4ea7\u54c1\u7ea7", (String)"CostAnalyzeRptQuery_8", (String)"macc-sca-report", (Object[])new Object[0]);
        DataSet totalSum = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.report.CostAnalyzeRptQuery#getProductDataRowByCurYear", (String)"sca_costrecovry", (String)("0 as id,id as billid,org as settleorg,costaccount as entrycostaccount,manuorg as entryprodorg,material.group as entrymaterialtype,'0' as level,'" + mat + "' as element, '" + pro + "' as subelement, material as productnum,materialver as materialver,auxprop,material as material,materialver as submaterialver,auxprop as submaterialauxprop,case when headqty = 0 then 0 else headqty/headqty end curyearqty,case when headqty = 0 then 0 else headamount/headqty end curyearunitamt,headamount as curyearsumamt,headqty as curyearsumqty,currency as entrycurrency,'' as treepath,'1' as datatype,1 as istop"), (QFilter[])filters.toArray(new QFilter[0]), null);
        totalSum = totalSum.groupBy(new String[]{"id", "billid", "level", "entrymaterialtype", "settleorg", "entrycostaccount", "entryprodorg", "productnum", "materialver", "auxprop", "curyearqty", "curyearunitamt", "curyearsumamt", "curyearsumqty", "material", "submaterialver", "submaterialauxprop", "element", "subelement", "entrycurrency", "treepath", "datatype", "istop"}).finish();
        totalSum = totalSum.filter("curyearsumqty != 0 and curyearsumqty is not null");
        totalSum = totalSum.groupBy(new String[]{"id", "level", "entrymaterialtype", "settleorg", "entrycostaccount", "entryprodorg", "productnum", "materialver", "auxprop", "material", "submaterialver", "submaterialauxprop", "element", "subelement", "entrycurrency", "treepath", "datatype", "istop"}).sum("curyearsumqty").sum("curyearsumamt").sum("curyearqty").sum("curyearunitamt").finish();
        totalSum = totalSum.select(totalSum.getRowMeta().getFieldNames()).addField("curyearsumqty/curyearsumqty", "curyearavgqty").addField("curyearsumamt/curyearsumqty", "curyearavgunitamt");
        return totalSum;
    }

    private DataSet getProductDataRowByPreYear(List<QFilter> filters) {
        String mat = ResManager.loadKDString((String)"\u7269\u6599", (String)"CostAnalyzeRptQuery_7", (String)"macc-sca-report", (Object[])new Object[0]);
        String pro = ResManager.loadKDString((String)"\u4ea7\u54c1\u7ea7", (String)"CostAnalyzeRptQuery_8", (String)"macc-sca-report", (Object[])new Object[0]);
        DataSet totalSum = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.report.CostAnalyzeRptQuery#getProductDataRowByCurYear", (String)"sca_costrecovry", (String)("0 as id,id as billid,org as settleorg,costaccount as entrycostaccount,manuorg as entryprodorg,material.group as entrymaterialtype,'0' as level,'" + mat + "' as element, '" + pro + "' as subelement, material as productnum,materialver as materialver,auxprop,material as material,materialver as submaterialver,auxprop as submaterialauxprop,case when headqty = 0 then 0 else headqty/headqty end preyearallqty,case when headqty = 0 then 0 else headamount/headqty end preyearallunitamt,headamount as preyearallsumamt,headqty as preyearallsumqty,currency as entrycurrency,'' as treepath,'1' as datatype,1 as istop"), (QFilter[])filters.toArray(new QFilter[0]), null);
        totalSum = totalSum.groupBy(new String[]{"id", "billid", "level", "entrymaterialtype", "settleorg", "entrycostaccount", "entryprodorg", "productnum", "materialver", "auxprop", "preyearallqty", "preyearallunitamt", "preyearallsumamt", "preyearallsumqty", "material", "submaterialver", "submaterialauxprop", "element", "subelement", "entrycurrency", "treepath", "datatype", "istop"}).finish();
        totalSum = totalSum.filter("preyearallsumqty != 0 and preyearallsumqty is not null");
        totalSum = totalSum.groupBy(new String[]{"id", "level", "entrymaterialtype", "settleorg", "entrycostaccount", "entryprodorg", "productnum", "materialver", "auxprop", "material", "submaterialver", "submaterialauxprop", "element", "subelement", "entrycurrency", "treepath", "datatype", "istop"}).sum("preyearallsumqty").sum("preyearallsumamt").sum("preyearallqty").sum("preyearallunitamt").finish();
        totalSum = totalSum.select(totalSum.getRowMeta().getFieldNames()).addField(PRE_PERIOD, "preyearallavgqty").addField("preyearallsumamt/preyearallsumqty", "preyearallavgunitamt");
        return totalSum;
    }

    private DataSet getStandardCostDataRow(FilterInfo filterInfo, Map<String, Object> params) {
        Long settleOrg = (Long)params.get("settleorg");
        Long entryCostAccount = (Long)params.get("entrycostaccount");
        Long entryProdOrg = (Long)params.get("entryprodorg");
        Long currency = (Long)params.get("currency");
        String calRecordName = filterInfo.getString("calcrecord");
        DynamicObjectCollection mulproduct = filterInfo.getDynamicObjectCollection("mulproduct");
        Set<Long> materialIds = mulproduct.stream().map(a -> (Long)a.getPkValue()).collect(Collectors.toSet());
        List<Node> list = new ArrayList<Node>();
        DataSet dataSet = this.getLevelDataSet(materialIds, 0, entryProdOrg, calRecordName).select(new String[]{"id", "material", "matvers", "auxproperty", "material as submaterial", "matvers as submatvers", "auxproperty as subauxproperty", "bomrate", "calcqty", "level", "path"});
        RowMeta rowMeta = dataSet.getRowMeta();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String parentKey = "root";
            String key = row.getLong("material") + "@" + row.getLong("matvers") + "@" + row.getLong("auxproperty");
            Node node = new Node(key, parentKey, row.getBigDecimal("bomrate"), this.parseRow(row, rowMeta));
            if (list.contains(node)) continue;
            list.add(node);
        }
        list = this.getLevelData(materialIds, 1, list, entryProdOrg, calRecordName);
        LinkedList<Node> resultList = new LinkedList<Node>();
        this.sortList(list, "root", BigDecimal.ONE, resultList, "root");
        List dataList = resultList.stream().map(a -> a.getData()).collect(Collectors.toList());
        DataSet bomStructure = Algo.create((String)"macc.sca.rpt").createDataSet(dataList.iterator(), rowMeta);
        DataSet calResultDataSet = this.getEffectResultDataSet(entryProdOrg, calRecordName);
        DataSet allDataSet = bomStructure.leftJoin(calResultDataSet).on("submaterial", "material").on("submatvers", "matvers").on("subauxproperty", "auxproperty").select(bomStructure.getRowMeta().getFieldNames(), new String[]{"modelnum", "bom", "element", "subelement", "qty", "price", "amount", "datatype", "dataresource", "0 entrycurrency", "material effmaterial", "matvers effmatvers", "auxproperty effauxproperty", "submaterial effsubmaterial", "submatvers effsubmatvers", "subauxproperty effsubauxproperty", "entrymaterialtype", "subelementtype"}).finish();
        DataSet selftCalcDataSet = allDataSet.filter("bom != null");
        DataSet zeroDataSet = selftCalcDataSet.filter("level = '1' and datatype = '1'");
        DataSet normalDataSet = selftCalcDataSet.filter("datatype != '1'");
        selftCalcDataSet = zeroDataSet.union(normalDataSet);
        Object[] objects1 = (String[])ArrayUtils.addAll((Object[])bomStructure.getRowMeta().getFieldNames(), (Object[])new String[]{"modelnum", "bom", "element", "subelement", "bomrate*qty as qty", "price", "qty*bomrate*price amount", "datatype", "dataresource", "effmaterial", "effmatvers", "effauxproperty", "effsubmaterial", "effsubmatvers", "effsubauxproperty", "entrymaterialtype", "subelementtype"});
        selftCalcDataSet = selftCalcDataSet.select(Arrays.toString(objects1).replace("[", "").replace("]", ""));
        DataSet calcDataSet = selftCalcDataSet.addField("0L", "root");
        DataSet resultDataSet = this.dealResourceDataSet(calcDataSet, filterInfo);
        String selectFields = "1 as id1," + settleOrg + " as settleorg1," + entryCostAccount + " as entrycostaccount1," + entryProdOrg + " as entryprodorg1,effmaterial as material1,effmatvers as matvers1,effauxproperty as auxproperty1,element as element1, subelement as subelement1,effsubmaterial as submaterial1,effsubmatvers as submatvers1,effsubauxproperty as subauxproperty1,qty as stdqty,price as stdprice,amount as stdunitamt,level as level1,root,path," + currency + " as entrycurrency1,entrymaterialtype as entrymaterialtype1,case when datatype='2' then '5' else datatype end datatype1";
        return resultDataSet.select(selectFields).groupBy(new String[]{"id1", "settleorg1", "entrycostaccount1", "entryprodorg1", "material1", "matvers1", "auxproperty1", "element1", "subelement1", "submaterial1", "submatvers1", "subauxproperty1", "stdprice", "level1", "root", "path", "entrycurrency1", "entrymaterialtype1", "datatype1"}).sum("stdqty").sum("stdunitamt").finish();
    }

    private DataSet dealResourceDataSet(DataSet dataSet, FilterInfo filterInfo) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        RowMeta rowMeta = dataSet.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        int len = dataSet.getRowMeta().getFields().length;
        while (dataSet.hasNext()) {
            int i;
            Row row = dataSet.next();
            if (row == null) continue;
            Object[] obj = new Object[len];
            String pathValue = "";
            String levelValue = "";
            for (i = 0; i < len; ++i) {
                String path;
                if (!Arrays.asList(fields).contains(fieldNames[i])) {
                    obj[i] = row.get(i);
                    continue;
                }
                if ("level".equals(fieldNames[i])) {
                    String level = PRE_PERIOD.equals(row.getString("datatype")) && PRE_PERIOD.equals(row.getString("level")) ? CUR_PERIOD : row.get(i) + "";
                    obj[i] = level;
                    levelValue = level;
                }
                if ("path".equals(fieldNames[i])) {
                    path = row.getString("path");
                    String newPath = this.changePath(path);
                    newPath = newPath.substring(0, newPath.lastIndexOf("@"));
                    newPath = "001".equals(row.getString("subelementtype")) ? newPath + "@" + row.getString("effsubmaterial") : newPath + "@0";
                    obj[i] = newPath;
                    pathValue = newPath;
                }
                if (!"root".equals(fieldNames[i])) continue;
                path = row.getString("path");
                String str = path.split("-")[1];
                obj[i] = Long.parseLong(str.split("@")[0]);
            }
            for (i = 0; i < len; ++i) {
                if (!"level".equals(fieldNames[i]) || "".equals(pathValue) || CUR_PERIOD.equals(levelValue)) continue;
                int sum = pathValue.split("@").length - 1;
                obj[i] = "" + sum;
            }
            dataList.add(obj);
        }
        return Algo.create((String)"macc.sca.rpt").createDataSet(dataList.iterator(), rowMeta);
    }

    private String changePath(String path) {
        String[] splits = path.split("-");
        StringBuilder temPath = new StringBuilder();
        for (int i = 0; i < splits.length; ++i) {
            if ("root".equals(splits[i])) continue;
            temPath.append(splits[i]);
            temPath.append("@");
        }
        String[] temPath1 = temPath.toString().split("@");
        StringBuilder newPath = new StringBuilder();
        for (int j = 0; j < temPath1.length; ++j) {
            if (CUR_PERIOD.equals(temPath1[j])) continue;
            newPath.append(temPath1[j]);
            newPath.append("@");
        }
        return newPath.toString();
    }

    private DataSet getLevelDataSet(Set<Long> materials, int level, Long entryProdOrg, String calRecordName) {
        List<QFilter> stdPriceQFilters = this.getStdPriceQFilters(materials, entryProdOrg);
        String entityName = "cad_calceffectiveresult";
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        String fields = "id,material,matvers,auxproperty,entryentity.submaterial as submaterial,entryentity.submatvers as submatvers,entryentity.subauxproperty as subauxproperty," + (level == 0 ? "entryentity.qty/entryentity.qty bomrate," : "entryentity.qty bomrate,") + (level == 0 ? "entryentity.qty/entryentity.qty calcqty," : "entryentity.qty calcqty,") + this.getLevelStr(level) + " level,'' path";
        if ("aca".equals(filterInfo.getString("appnum"))) {
            entityName = "cad_calcsimulationresult";
            if (!CadEmptyUtils.isEmpty((String)calRecordName)) {
                stdPriceQFilters.add(new QFilter("calcrecord.name", "=", (Object)calRecordName));
            } else {
                QFilter recordFilter = new QFilter("calcrecord", "is null", null).or(new QFilter("calcrecord", "<=", (Object)0L));
                stdPriceQFilters.add(recordFilter);
            }
        } else {
            fields = fields + ",effectdate";
        }
        DataSet calcEffectDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.report.CostAnalyzeRptQuery#getLevelDataSet", (String)entityName, (String)fields, (QFilter[])stdPriceQFilters.toArray(new QFilter[0]), null);
        if (Boolean.TRUE.equals(this.isQueryPeriod())) {
            String queryPeriodGroups = "material,matvers,auxproperty";
            String queryPeriodFields = queryPeriodGroups + ",effectdate";
            DataSet calcQueryPeriodDataSet = calcEffectDataSet.copy().select(queryPeriodFields.split(",")).groupBy(queryPeriodGroups.split(",")).max("effectdate").finish();
            calcEffectDataSet = calcEffectDataSet.join(calcQueryPeriodDataSet, JoinType.INNER).on("material", "material").on("matvers", "matvers").on("auxproperty", "auxproperty").on("effectdate", "effectdate").select(calcEffectDataSet.getRowMeta().getFieldNames(), null).finish();
        }
        if (!"aca".equals(filterInfo.getString("appnum"))) {
            calcEffectDataSet = calcEffectDataSet.removeFields(new String[]{"effectdate"});
        }
        return calcEffectDataSet;
    }

    private DataSet getEffectResultDataSet(Long entryProdOrg, String calcRecordName) {
        List<QFilter> stdPriceQFilters = this.getStdPriceQFilters(null, entryProdOrg);
        String entityName = "cad_calceffectiveresult";
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        String selfFields = "material,matvers,auxproperty,material.modelnum modelnum,bom,material.group as materialtype,entryentity.submaterial.group as entrymaterialtype,case when entryentity.submaterial=0 then material else entryentity.submaterial end submaterial,case when entryentity.submaterial=0 then matvers else entryentity.submatvers end submatvers,case when entryentity.submaterial=0 then auxproperty else entryentity.subauxproperty end subauxproperty,entryentity.element.name as element,entryentity.subelement.name as subelement,entryentity.qty qty,entryentity.price price ,entryentity.stdprice as amount,entryentity.datatype as datatype,'0' as dataresource,entryentity.subelement.type subelementtype";
        if ("aca".equals(filterInfo.getString("appnum"))) {
            entityName = "cad_calcsimulationresult";
            if (!CadEmptyUtils.isEmpty((String)calcRecordName)) {
                stdPriceQFilters.add(new QFilter("calcrecord.name", "=", (Object)calcRecordName));
            } else {
                QFilter recordFilter = new QFilter("calcrecord", "is null", null).or(new QFilter("calcrecord", "<=", (Object)0L));
                stdPriceQFilters.add(recordFilter);
            }
        } else {
            selfFields = selfFields + ",effectdate";
        }
        DataSet effectResult = QueryServiceHelper.queryDataSet((String)"calcDataQuery", (String)entityName, (String)selfFields, (QFilter[])stdPriceQFilters.toArray(new QFilter[0]), null);
        if (Boolean.TRUE.equals(this.isQueryPeriod())) {
            String queryPeriodGroups = "material,matvers,auxproperty";
            String queryPeriodFields = queryPeriodGroups + ",effectdate";
            DataSet queryPeriodDataSet = effectResult.copy().select(queryPeriodFields.split(",")).groupBy(queryPeriodGroups.split(",")).max("effectdate").finish();
            effectResult = effectResult.join(queryPeriodDataSet, JoinType.INNER).on("material", "material").on("matvers", "matvers").on("auxproperty", "auxproperty").on("effectdate", "effectdate").select(effectResult.getRowMeta().getFieldNames(), null).finish();
        }
        if (!"aca".equals(filterInfo.getString("appnum"))) {
            effectResult = effectResult.removeFields(new String[]{"effectdate"});
        }
        effectResult = effectResult.groupBy(new String[]{"bom", "element", "subelement", "material", "matvers", "auxproperty", "submaterial", "submatvers", "subauxproperty", "modelnum", "datatype", "dataresource", "materialtype", "entrymaterialtype", "subelementtype"}).sum("amount").sum("qty").finish();
        return effectResult.select(new String[]{"bom", "element", "subelement", "material", "matvers", "auxproperty", "submaterial", "submatvers", "subauxproperty", "modelnum", "datatype", "dataresource", "amount", "qty", "case when qty!= 0 then amount/qty else 0 end price", "materialtype", "case when entrymaterialtype is null then materialtype else entrymaterialtype end entrymaterialtype", "subelementtype"});
    }

    private List<Node> getLevelData(Set<Long> materials, int level, List<Node> list, Long entryProdOrg, String calRecordName) {
        DataSet dataSet = this.getLevelDataSet(materials, level, entryProdOrg, calRecordName);
        Set<Long> subMaterials = this.getMaterialSet(list, dataSet);
        if (subMaterials.size() > 0) {
            list = this.getLevelData(subMaterials, ++level, list, entryProdOrg, calRecordName);
        }
        return list;
    }

    private Set<Long> getMaterialSet(List<Node> list, DataSet dataSet) {
        RowMeta rowMeta = dataSet.getRowMeta();
        HashSet<Long> subMaterials = new HashSet<Long>(16);
        while (dataSet.hasNext()) {
            BigDecimal bomrate;
            Row row = dataSet.next();
            subMaterials.add(row.getLong("submaterial"));
            String parentKey = row.getLong("material") + "@" + row.getLong("matvers") + "@" + row.getLong("auxproperty");
            String key = row.getLong("submaterial") + "@" + row.getLong("submatvers") + "@" + row.getLong("subauxproperty");
            Node node = new Node(key, parentKey, bomrate = row.getBigDecimal("bomrate"), this.parseRow(row, rowMeta));
            if (list.contains(node)) continue;
            list.add(node);
        }
        return subMaterials;
    }

    public void sortList(List<Node> list, String id, BigDecimal qty, List<Node> resultList, String parentPath) {
        for (Node node : list) {
            if (!node.getPid().equals(id)) continue;
            String path = parentPath + "-" + node.getId();
            Node clone = node.clone();
            clone.setPath(path);
            BigDecimal multiply = clone.getBomrate().multiply(qty);
            clone.setBomrate(multiply);
            boolean has = false;
            for (Node rNode : resultList) {
                if (!path.equals(rNode.getPath())) continue;
                has = true;
                break;
            }
            if (!has) {
                resultList.add(clone);
            }
            this.sortList(list, clone.getId(), multiply, resultList, path);
        }
    }

    private List<QFilter> getStdPriceQFilters(Set<Long> matIds, Long entryProdOrg) {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        List<Object> qFilterList = new ArrayList<QFilter>(10);
        if ("sca".equals(filterInfo.getString("appnum"))) {
            DynamicObject costaccount = filterInfo.getDynamicObject("costaccount");
            DynamicObject org = filterInfo.getDynamicObject("org");
            DynamicObject costType = this.getCostType(org == null ? 0L : org.getLong("id"), costaccount == null ? 0L : costaccount.getLong("id"), entryProdOrg);
            if (costType == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u7ec4\u7ec7\u672a\u7ef4\u62a4\u6210\u672c\u7c7b\u578b\u4e0e\u7ec4\u7ec7\u5bf9\u5e94\u8868\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u67e5\u8be2\u3002", (String)"CostAnalyzeRptQuery_6", (String)"macc-sca-report", (Object[])new Object[0]));
            }
            qFilterList.add(new QFilter("costtype", "=", (Object)costType.getLong("costtype.id")));
        } else {
            DynamicObject costType = filterInfo.getDynamicObject("costtype");
            if (costType == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u7ec4\u7ec7\u672a\u7ef4\u62a4\u6210\u672c\u7c7b\u578b\u4e0e\u7ec4\u7ec7\u5bf9\u5e94\u8868\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u67e5\u8be2\u3002", (String)"CostAnalyzeRptQuery_6", (String)"macc-sca-report", (Object[])new Object[0]));
            }
            qFilterList.add(new QFilter("costtype", "=", (Object)costType.getLong("id")));
        }
        if (matIds != null) {
            qFilterList.add(new QFilter("material", "in", matIds));
            qFilterList.add(new QFilter("entryentity.datatype", "=", (Object)PRE_ALL_PERIOD));
        } else {
            qFilterList.add(new QFilter("entryentity.datatype", "in", (Object)new String[]{PRE_PERIOD, PRE_YEAR, PRE_ALL_PERIOD}));
        }
        qFilterList.add(new QFilter("ismaindata", "=", (Object)1L));
        if ("sca".equals(filterInfo.getString("appnum"))) {
            Date[] periodtime;
            Date queryDate = filterInfo.getDate("querydate");
            DynamicObject queryPeriod = filterInfo.getDynamicObject("queryperiod");
            Long queryPeriodId = 0L;
            if (queryPeriod != null) {
                queryPeriodId = queryPeriod.getLong("id");
            }
            if (queryDate != null) {
                qFilterList.add(new QFilter("effectdate", "<=", (Object)queryDate));
                qFilterList.add(new QFilter("expdate", ">", (Object)queryDate));
            } else if (queryPeriodId != null && queryPeriodId != 0L && (periodtime = PeriodHelper.getPeriodStartAndEndTime((Long)queryPeriodId)) != null) {
                qFilterList = CostUpdateHelper.getPeriodQFilter(qFilterList, (Date[])periodtime);
            }
        }
        return qFilterList;
    }

    private DynamicObject getCostType(Long org, Long costAccount, Long entryProdOrg) {
        boolean enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)costAccount);
        QFilter qFilter = new QFilter("costaccount", "=", (Object)costAccount);
        if (!enableMulFactory) {
            qFilter.and(new QFilter("calorg", "=", (Object)org));
        } else {
            qFilter.and(new QFilter("storageorgunit", "in", (Object)OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)entryProdOrg, (boolean)true)));
        }
        QFilter timeFilter = new QFilter("effectdate", "<=", (Object)TimeServiceHelper.now());
        timeFilter.and("invaliddate", ">", (Object)TimeServiceHelper.now());
        qFilter.and(timeFilter);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costtypeorg", (String)"costtype", (QFilter[])qFilter.toArray());
    }

    private List<QFilter> getQFilters(FilterInfo filterInfo) {
        DynamicObject materialgrpstd;
        DynamicObjectCollection mulproduct;
        DynamicObject prodorg;
        DynamicObject costaccount;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        DynamicObject org = filterInfo.getDynamicObject("org");
        if (org != null) {
            qFilterList.add(new QFilter("org", "=", (Object)((Long)org.getPkValue())));
        }
        if ((costaccount = filterInfo.getDynamicObject("costaccount")) != null) {
            qFilterList.add(new QFilter("costaccount", "=", (Object)((Long)costaccount.getPkValue())));
        }
        if ((prodorg = filterInfo.getDynamicObject("prodorg")) != null) {
            qFilterList.add(new QFilter("manuorg", "=", (Object)((Long)prodorg.getPkValue())));
        }
        if ((mulproduct = filterInfo.getDynamicObjectCollection("mulproduct")) != null && mulproduct.size() > 0) {
            Set collect = mulproduct.stream().map(a -> (Long)a.getPkValue()).collect(Collectors.toSet());
            qFilterList.add(new QFilter("material", "in", collect));
        }
        if ((materialgrpstd = filterInfo.getDynamicObject("materialgrpstd")) != null && materialgrpstd.getLong("id") != 730148448254487552L) {
            Set materialIds = MaterialGroupHelper.getClassifiedMaterialId(null, (boolean)false, (DynamicObject)materialgrpstd, (boolean)true);
            qFilterList.add(InFilterHelper.getQFilterByBachSize((String)"entryentity.submaterial", new ArrayList(materialIds), (String)"in", (int)20000));
        }
        return qFilterList;
    }

    private QFilter getPeriodFilter(String gainType) {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        DynamicObject costaccount = filterInfo.getDynamicObject("costaccount");
        DynamicObject org = filterInfo.getDynamicObject("org");
        DynamicObject period = filterInfo.getDynamicObject("period");
        if (CUR_PERIOD.equals(gainType)) {
            return new QFilter("period", "=", (Object)((Long)period.getPkValue()));
        }
        QFilter periodFilter = StartCostHelper.getPeriodTypeFilter((String)"sca", (Long)Long.valueOf(String.valueOf(org.getPkValue())), (Long)Long.valueOf(String.valueOf(costaccount.getPkValue())));
        int periodyear = period.getInt("periodyear");
        int periodnumber = period.getInt("periodnumber");
        if (PRE_PERIOD.equals(gainType)) {
            DynamicObject previousPeriod = PeriodHelper.getPreviousPeriod((Object)((Long)period.getPkValue()));
            periodFilter.and(new QFilter("id", "=", (Object)(previousPeriod == null ? -1L : previousPeriod.getLong("id"))));
        }
        if (PRE_YEAR.equals(gainType)) {
            periodFilter.and(new QFilter("periodyear", "=", (Object)(periodyear - 1 < 0 ? -1 : periodyear - 1)));
            periodFilter.and(new QFilter("periodnumber", "=", (Object)periodnumber));
        }
        if (ALL_PERIOD.equals(gainType)) {
            ArrayList<Integer> periodnums = new ArrayList<Integer>(10);
            for (int i = 1; i <= periodnumber; ++i) {
                periodnums.add(i);
            }
            periodFilter.and(new QFilter("periodyear", "=", (Object)periodyear));
            periodFilter.and(new QFilter("periodnumber", "in", periodnums));
        }
        if (PRE_ALL_PERIOD.equals(gainType)) {
            periodFilter.and(new QFilter("periodyear", "=", (Object)(periodyear - 1)));
        }
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])periodFilter.toArray());
        HashSet set = new HashSet();
        periods.forEach(p -> set.add(p.getLong("id")));
        return new QFilter("period", "in", set);
    }

    private String getLevelStr(int level) {
        String levelStr = "" + ++level;
        return "'" + levelStr + "'";
    }

    private Object[] parseRow(Row row, RowMeta rowMeta) {
        Field[] fields = rowMeta.getFields();
        Object[] rowData = new Object[fields.length];
        for (int j = 0; j < fields.length; ++j) {
            Object val;
            String name = fields[j].getName();
            rowData[j] = val = row.get(name);
        }
        return rowData;
    }

    private Boolean isQueryPeriod() {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        Date queryDate = filterInfo.getDate("querydate");
        if (queryDate != null) {
            return Boolean.FALSE;
        }
        DynamicObject queryPeriod = filterInfo.getDynamicObject("queryperiod");
        if (queryPeriod == null) {
            return Boolean.FALSE;
        }
        Long queryPeriodId = queryPeriod.getLong("id");
        if (queryPeriodId != 0L) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static class Node
    implements Cloneable {
        private String id;
        private String pid;
        private BigDecimal bomrate;
        private String path;
        private Object[] data;

        public Node(String id, String pid, BigDecimal bomrate, Object[] data) {
            this.id = id;
            this.pid = pid;
            this.data = data;
            this.bomrate = bomrate;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getPid() {
            return this.pid;
        }

        public void setPath(String path) {
            this.path = path;
            if (this.data != null) {
                this.data[this.data.length - 1] = path;
            }
        }

        public String getPath() {
            return this.path;
        }

        public void setPid(String pid) {
            this.pid = pid;
        }

        public Object[] getData() {
            return this.data;
        }

        public BigDecimal getBomrate() {
            return this.bomrate;
        }

        public void setBomrate(BigDecimal bomrate) {
            this.bomrate = bomrate;
            if (this.data != null) {
                this.data[this.data.length - 4] = bomrate;
            }
        }

        public String toString() {
            return "[ pid=" + this.pid + ", id= " + this.id + "]";
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return ("" + this.getPid() + this.getId()).equals("" + ((Node)obj).getPid() + ((Node)obj).getId());
        }

        public Node clone() {
            Node node = null;
            try {
                node = (Node)super.clone();
            }
            catch (CloneNotSupportedException e) {
                logger.info(e.getMessage());
            }
            if (node != null) {
                node.data = (Object[])this.data.clone();
            }
            return node;
        }
    }
}

