/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang.StringUtils;

public class HalfPrdStructureRptQuery
extends AbstractReportListDataPlugin {
    private boolean onlymaterialtype = false;
    private int level = 0;

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        long currency = filterInfo.getLong("currency");
        this.init(filterInfo);
        List<QFilter> qFilterList = this.getCommonQFilter(filterInfo);
        DataSet mainProductDataSet = this.getProductDataSet(qFilterList);
        if (mainProductDataSet.isEmpty()) {
            return Algo.create((String)"dataset").createDataSet(new ArrayList(10).iterator(), mainProductDataSet.getRowMeta());
        }
        mainProductDataSet = this.dealMaterialGroup(mainProductDataSet);
        DataSet normalProdDataSet = this.getNormalDataSet(qFilterList);
        if (normalProdDataSet.isEmpty()) {
            return Algo.create((String)"dataset").createDataSet(new ArrayList(10).iterator(), normalProdDataSet.getRowMeta());
        }
        normalProdDataSet = this.dealMaterialGroup(normalProdDataSet);
        if (this.onlymaterialtype) {
            normalProdDataSet = this.showWithMaterialType(normalProdDataSet);
        }
        mainProductDataSet = mainProductDataSet.select(this.getDataField());
        normalProdDataSet = normalProdDataSet.select(this.getDataField());
        DataSet periodSum = this.getPeriodSum(mainProductDataSet.copy()).select(this.getDataField());
        DataSet allSum = this.getAllSum(periodSum).select(this.getDataField());
        if (this.level == 0) {
            return mainProductDataSet.copy().select(this.getDataField()).union(new DataSet[]{periodSum, allSum}).orderBy(new String[]{"sort", "period", "periodname", "inveorg", "productnumber", "treepath", "element"});
        }
        DataSet resultData = mainProductDataSet.union(new DataSet[]{normalProdDataSet, periodSum, allSum});
        resultData = resultData.addField(currency + "L", "entrycurrency");
        return resultData.orderBy(new String[]{"sort", "period", "periodname", "inveorg", "productnumber", "treepath", "element"});
    }

    private List<QFilter> getCommonQFilter(FilterInfo filterInfo) {
        DynamicObjectCollection mulmaterial;
        DynamicObjectCollection mulproduct;
        Long endperiod;
        Long beginperiod;
        DynamicObjectCollection storageorgunitCol;
        DynamicObjectCollection headprdorgCol;
        Long costaccount;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        Long org = filterInfo.getLong("org");
        if (!CadEmptyUtils.isEmpty((Long)org)) {
            qFilterList.add(new QFilter("org", "=", (Object)org));
        }
        if (!CadEmptyUtils.isEmpty((Long)(costaccount = Long.valueOf(filterInfo.getLong("costaccount"))))) {
            qFilterList.add(new QFilter("costaccount", "=", (Object)costaccount));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(headprdorgCol = filterInfo.getDynamicObjectCollection("headprdorg")))) {
            Set prdSet = headprdorgCol.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
            qFilterList.add(new QFilter("prdorg", "in", prdSet));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(storageorgunitCol = filterInfo.getDynamicObjectCollection("headinveorg")))) {
            Set storgSet = storageorgunitCol.stream().map(r -> r.getLong("id")).collect(Collectors.toSet());
            qFilterList.add(new QFilter("storageorgunit", "in", storgSet));
        }
        if (!CadEmptyUtils.isEmpty((Long)(beginperiod = Long.valueOf(filterInfo.getLong("beginperiod"))))) {
            qFilterList.add(new QFilter("period", ">=", (Object)beginperiod));
        }
        if (!CadEmptyUtils.isEmpty((Long)(endperiod = Long.valueOf(filterInfo.getLong("endperiod"))))) {
            qFilterList.add(new QFilter("period", "<=", (Object)endperiod));
        }
        if ((mulproduct = filterInfo.getDynamicObjectCollection("mulproduct")) != null && mulproduct.size() > 0) {
            Set collect = mulproduct.stream().map(a -> (Long)a.getPkValue()).collect(Collectors.toSet());
            qFilterList.add(new QFilter("material", "in", collect));
        }
        if ((mulmaterial = filterInfo.getDynamicObjectCollection("mulmaterial")) != null) {
            Set collect = mulmaterial.stream().map(a -> (Long)a.getPkValue()).collect(Collectors.toSet());
            qFilterList.add(new QFilter("entryentity.submaterial", "in", collect));
        } else {
            DynamicObjectCollection materialtype = filterInfo.getDynamicObjectCollection("mulmaterialtype");
            DynamicObject materialgrpstd = filterInfo.getDynamicObject("materialgrpstd");
            if (materialtype != null || materialgrpstd != null && materialgrpstd.getLong("id") != 730148448254487552L) {
                Set materialIds = MaterialGroupHelper.getClassifiedMaterialId((DynamicObjectCollection)materialtype, (boolean)false, (DynamicObject)materialgrpstd, (boolean)true);
                qFilterList.add(InFilterHelper.getQFilterByBachSize((String)"entryentity.submaterial", new ArrayList(materialIds), (String)"in", (int)20000));
            }
        }
        if (filterInfo.getInt("displaylevel") != 0) {
            qFilterList.add(new QFilter("entryentity.level", "<=", (Object)filterInfo.getInt("displaylevel")));
        }
        if ("B".equals(filterInfo.getString("query"))) {
            qFilterList.add(new QFilter("entryentity.isleaf", "=", (Object)true));
        }
        return qFilterList;
    }

    private DataSet getProductDataSet(List<QFilter> qFilterList) {
        StringJoiner strJoiner = new StringJoiner(",");
        strJoiner.add("org");
        strJoiner.add("prdorg");
        strJoiner.add("storageorgunit inveorg");
        strJoiner.add("period");
        strJoiner.add("period.name periodname");
        strJoiner.add("material product");
        strJoiner.add("material.number productnumber");
        strJoiner.add("materialversion");
        strJoiner.add("auxprop");
        strJoiner.add("1L as headqty");
        strJoiner.add("totalamount");
        strJoiner.add("0L as element");
        strJoiner.add(ResManager.loadKDString((String)"'\u7269\u6599' as elementname", (String)"HalfPrdStructureRptQuery_0", (String)"macc-sca-report", (Object[])new Object[0]));
        strJoiner.add("0L as subelement");
        strJoiner.add(ResManager.loadKDString((String)"'\u4ea7\u54c1\u7ea7' as subelementname", (String)"HalfPrdStructureRptQuery_1", (String)"macc-sca-report", (Object[])new Object[0]));
        strJoiner.add("material as entrymaterial");
        strJoiner.add("material.group as entrymaterialtype");
        strJoiner.add("materialversion as entryversion");
        strJoiner.add("auxprop as entryauxprop");
        strJoiner.add("material.baseunit as baseunit");
        strJoiner.add("1L as qty");
        strJoiner.add("totalamount as amount");
        strJoiner.add(ResManager.loadKDString((String)"'\u4ea7\u54c1\u7ea7' as level", (String)"HalfPrdStructureRptQuery_2", (String)"macc-sca-report", (Object[])new Object[0]));
        strJoiner.add("'' as treepath");
        strJoiner.add("'A' as colour");
        strJoiner.add("1L as sort");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "#getProductDataSet()"), (String)"sca_halfprdhide", (String)strJoiner.toString(), (QFilter[])qFilterList.toArray(new QFilter[0]), null);
        return dataSet.groupBy(dataSet.getRowMeta().getFieldNames()).finish();
    }

    private DataSet getNormalDataSet(List<QFilter> qFilterList) {
        StringJoiner strJoiner = new StringJoiner(",");
        strJoiner.add("org");
        strJoiner.add("prdorg");
        strJoiner.add("storageorgunit inveorg");
        strJoiner.add("period");
        strJoiner.add("period.name periodname");
        strJoiner.add("material product");
        strJoiner.add("material.number productnumber");
        strJoiner.add("materialversion");
        strJoiner.add("auxprop");
        strJoiner.add("1L as headqty");
        strJoiner.add("totalamount");
        strJoiner.add("entryentity.element as element");
        strJoiner.add("entryentity.element.name as elementname");
        strJoiner.add("entryentity.subelement as subelement");
        strJoiner.add("entryentity.subelement.name as subelementname");
        strJoiner.add("entryentity.submaterial as entrymaterial");
        strJoiner.add("entryentity.submaterial.group as entrymaterialtype");
        strJoiner.add("entryentity.submaterialversion as entryversion");
        strJoiner.add("entryentity.submaterialauxprop as entryauxprop");
        strJoiner.add("entryentity.submaterial.baseunit.id as baseunit");
        strJoiner.add("entryentity.qty as qty");
        strJoiner.add("entryentity.amount as amount");
        strJoiner.add("entryentity.level as level");
        strJoiner.add("entryentity.treepath as treepath");
        strJoiner.add("'B' as colour");
        strJoiner.add("1L as sort");
        DataSet normalData = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "#getNormalDataSet"), (String)"sca_halfprdhide", (String)strJoiner.toString(), (QFilter[])qFilterList.toArray(new QFilter[0]), null);
        normalData = normalData.select("org,prdorg,inveorg,period,periodname,product,productnumber,materialversion,auxprop,headqty,totalamount,element,elementname,subelement,subelementname,entrymaterial,entrymaterialtype,entryversion,entryauxprop,baseunit,qty,amount,case when level=1 then concat('-',cast(level as String)) when level=2 then concat('--',cast(level as String)) when level=3 then concat('---',cast(level as String)) when level=4 then concat('----',cast(level as String)) when level=5 then concat('-----',cast(level as String)) when level=6 then concat('------',cast(level as String)) when level=7 then concat('--------',cast(level as String)) when level=8 then concat('--------',cast(level as String)) when level=9 then concat('---------',cast(level as String))  else concat('',cast(level as String)) end level,treepath,colour,sort");
        return normalData;
    }

    private void init(FilterInfo filterInfo) {
        this.onlymaterialtype = filterInfo.getBoolean("onlymaterialtype");
        this.level = filterInfo.getInt("displaylevel");
    }

    private DataSet dealMaterialGroup(DataSet resultDs) {
        FilterInfo filterInfo = this.getQueryParam().getFilter();
        DynamicObject materialgrpstd = filterInfo.getDynamicObject("materialgrpstd");
        if (!resultDs.isEmpty() && materialgrpstd != null && materialgrpstd.getLong("id") != 730148448254487552L) {
            DataSet materialDataSet = MaterialGroupHelper.getClassifiedMaterialDataSet(null, (boolean)false, (DynamicObject)materialgrpstd);
            ArrayList<String> fieldNames = new ArrayList<String>(Arrays.asList(resultDs.getRowMeta().getFieldNames()));
            fieldNames.remove("entrymaterialtype");
            fieldNames.add("case when materialgroup1 is null then 0L else materialgroup1 end as entrymaterialtype");
            return resultDs.leftJoin(materialDataSet).on("entrymaterial", "material").select(resultDs.getRowMeta().getFieldNames(), new String[]{"materialgroup materialgroup1"}).finish().select(fieldNames.toArray(new String[0]));
        }
        return resultDs;
    }

    private DataSet showWithMaterialType(DataSet normalProdDataSet) {
        RowMeta rowMeta = normalProdDataSet.getRowMeta();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        Field[] fields = rowMeta.getFields();
        HashMap<String, String> matToType = new HashMap<String, String>(16);
        DataSet copy = normalProdDataSet.copy();
        while (copy.hasNext()) {
            Row next = copy.next();
            matToType.put(next.getString("entrymaterial"), next.getString("entrymaterialtype"));
        }
        while (normalProdDataSet.hasNext()) {
            Row row = normalProdDataSet.next();
            Object[] rowData = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String name = fields[i].getName();
                Object val = row.get(name);
                if ("treepath".equals(name) && val != null) {
                    String val1 = (String)val;
                    Object[] split = val1.split("@");
                    int len = split.length;
                    boolean isResurce = false;
                    if (len >= 2 && split[len - 1].equals(split[len - 2])) {
                        isResurce = true;
                    }
                    for (int j = 0; j < len; ++j) {
                        if (!matToType.containsKey(split[j])) continue;
                        split[j] = (String)matToType.get(split[j]);
                    }
                    val = isResurce ? StringUtils.join((Object[])split, (String)"@", (int)0, (int)(len - 1)) : StringUtils.join((Object[])split, (String)"@", (int)0, (int)len);
                }
                rowData[i] = val;
            }
            dataList.add(rowData);
        }
        DataSet treepathDeal = Algo.create((String)"macc.sca.treepath").createDataSet(dataList.iterator(), rowMeta);
        String[] groupFields = this.getDataField().replace(",qty,amount,", ",").split(",");
        DataSet matType = treepathDeal.groupBy(groupFields).sum("qty").sum("amount").finish().select(this.getDataField());
        return matType;
    }

    private DataSet getPeriodSum(DataSet mainProductDataSet) {
        StringJoiner strJoiner = new StringJoiner(",");
        strJoiner.add("org");
        strJoiner.add("0L prdorg");
        strJoiner.add("0L inveorg");
        strJoiner.add("period");
        strJoiner.add(ResManager.loadKDString((String)"'\u5c0f\u8ba1' periodname", (String)"HalfPrdStructureRptQuery_3", (String)"macc-sca-report", (Object[])new Object[0]));
        strJoiner.add("0L product");
        strJoiner.add("'' productnumber");
        strJoiner.add("0L materialversion");
        strJoiner.add("0L auxprop");
        strJoiner.add("0L as headqty");
        strJoiner.add("0L totalamount");
        strJoiner.add("0L as element");
        strJoiner.add("'' as elementname");
        strJoiner.add("0L as subelement");
        strJoiner.add("'' as subelementname");
        strJoiner.add("0L entrymaterial");
        strJoiner.add("0L entrymaterialtype");
        strJoiner.add("0L entryversion");
        strJoiner.add("0L entryauxprop");
        strJoiner.add("0L baseunit");
        strJoiner.add("0L as qty");
        strJoiner.add("amount");
        strJoiner.add("'' as level");
        strJoiner.add("'' as treepath");
        strJoiner.add("'A' as colour");
        strJoiner.add("1L as sort");
        return mainProductDataSet.groupBy(new String[]{"org", "period"}).sum("amount").finish().select(strJoiner.toString());
    }

    private DataSet getAllSum(DataSet periodSum) {
        StringJoiner strJoiner = new StringJoiner(",");
        strJoiner.add("org");
        strJoiner.add("0L prdorg");
        strJoiner.add("0L inveorg");
        strJoiner.add("0L period");
        strJoiner.add(ResManager.loadKDString((String)"'\u5408\u8ba1' periodname", (String)"HalfPrdStructureRptQuery_4", (String)"macc-sca-report", (Object[])new Object[0]));
        strJoiner.add("0L product");
        strJoiner.add("'' productnumber");
        strJoiner.add("0L materialversion");
        strJoiner.add("0L auxprop");
        strJoiner.add("0L as headqty");
        strJoiner.add("0L totalamount");
        strJoiner.add("0L as element");
        strJoiner.add("'' as elementname");
        strJoiner.add("0L as subelement");
        strJoiner.add("'' as subelementname");
        strJoiner.add("0L entrymaterial");
        strJoiner.add("0L entrymaterialtype");
        strJoiner.add("0L entryversion");
        strJoiner.add("0L entryauxprop");
        strJoiner.add("0L baseunit");
        strJoiner.add("0L as qty");
        strJoiner.add("amount");
        strJoiner.add("'' as level");
        strJoiner.add("'' as treepath");
        strJoiner.add("'A' as colour");
        strJoiner.add("2L as sort");
        return periodSum.groupBy(new String[]{"org"}).sum("amount").finish().select(strJoiner.toString());
    }

    private String getDataField() {
        String selectFields = "org,prdorg,inveorg,period,periodname,product,productnumber,materialversion,auxprop,headqty,totalamount,element,elementname,subelement,subelementname,entrymaterial,entrymaterialtype,entryversion,entryauxprop,baseunit,qty,amount,level,treepath,colour,sort";
        if (this.onlymaterialtype) {
            return selectFields.replace(",entrymaterial,entrymaterialtype,entryversion,entryauxprop,baseunit,", ",entrymaterialtype,");
        }
        return selectFields;
    }
}

